// services/viz/privileged/mojom/gl/gpu_service.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/viz/privileged/mojom/gl/gpu_service.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "gpu/ipc/common/device_perf_info.mojom.h"
#include "gpu/ipc/common/dx_diag_node.mojom.h"
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "gpu/ipc/common/gpu_info.mojom.h"
#include "gpu/ipc/common/gpu_peak_memory.mojom.h"
#include "gpu/ipc/common/memory_stats.mojom.h"
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gl/mojom/gpu_preference.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_JUMBO_H_
#endif


namespace viz {
namespace mojom {


void GpuServiceInterceptorForTesting::EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool cache_shaders_on_disk, EstablishGpuChannelCallback callback) {
  GetForwardingInterface()->EstablishGpuChannel(std::move(client_id), std::move(client_tracing_id), std::move(is_gpu_host), std::move(cache_shaders_on_disk), std::move(callback));
}
void GpuServiceInterceptorForTesting::SetChannelClientPid(int32_t client_id, ::base::ProcessId client_pid) {
  GetForwardingInterface()->SetChannelClientPid(std::move(client_id), std::move(client_pid));
}
void GpuServiceInterceptorForTesting::CloseChannel(int32_t client_id) {
  GetForwardingInterface()->CloseChannel(std::move(client_id));
}
void GpuServiceInterceptorForTesting::CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) {
  GetForwardingInterface()->CreateVideoEncodeAcceleratorProvider(std::move(vea_provider));
}
void GpuServiceInterceptorForTesting::CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, int32_t client_id, ::gpu::SurfaceHandle surface_handle, CreateGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CreateGpuMemoryBuffer(std::move(id), std::move(size), std::move(format), std::move(usage), std::move(client_id), std::move(surface_handle), std::move(callback));
}
void GpuServiceInterceptorForTesting::DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, int32_t client_id, const ::gpu::SyncToken& sync_token) {
  GetForwardingInterface()->DestroyGpuMemoryBuffer(std::move(id), std::move(client_id), std::move(sync_token));
}
void GpuServiceInterceptorForTesting::CopyGpuMemoryBuffer(::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, CopyGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CopyGpuMemoryBuffer(std::move(buffer_handle), std::move(shared_memory), std::move(callback));
}
void GpuServiceInterceptorForTesting::GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) {
  GetForwardingInterface()->GetVideoMemoryUsageStats(std::move(callback));
}
void GpuServiceInterceptorForTesting::StartPeakMemoryMonitor(uint32_t sequence_num) {
  GetForwardingInterface()->StartPeakMemoryMonitor(std::move(sequence_num));
}
void GpuServiceInterceptorForTesting::GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) {
  GetForwardingInterface()->GetPeakMemoryUsage(std::move(sequence_num), std::move(callback));
}
void GpuServiceInterceptorForTesting::RequestHDRStatus(RequestHDRStatusCallback callback) {
  GetForwardingInterface()->RequestHDRStatus(std::move(callback));
}
void GpuServiceInterceptorForTesting::LoadedShader(int32_t client_id, const std::string& key, const std::string& data) {
  GetForwardingInterface()->LoadedShader(std::move(client_id), std::move(key), std::move(data));
}
void GpuServiceInterceptorForTesting::WakeUpGpu() {
  GetForwardingInterface()->WakeUpGpu();
}
void GpuServiceInterceptorForTesting::GpuSwitched(::gl::GpuPreference active_gpu_heuristic) {
  GetForwardingInterface()->GpuSwitched(std::move(active_gpu_heuristic));
}
void GpuServiceInterceptorForTesting::DisplayAdded() {
  GetForwardingInterface()->DisplayAdded();
}
void GpuServiceInterceptorForTesting::DisplayRemoved() {
  GetForwardingInterface()->DisplayRemoved();
}
void GpuServiceInterceptorForTesting::DisplayMetricsChanged() {
  GetForwardingInterface()->DisplayMetricsChanged();
}
void GpuServiceInterceptorForTesting::DestroyAllChannels() {
  GetForwardingInterface()->DestroyAllChannels();
}
void GpuServiceInterceptorForTesting::OnBackgroundCleanup() {
  GetForwardingInterface()->OnBackgroundCleanup();
}
void GpuServiceInterceptorForTesting::OnBackgrounded() {
  GetForwardingInterface()->OnBackgrounded();
}
void GpuServiceInterceptorForTesting::OnForegrounded() {
  GetForwardingInterface()->OnForegrounded();
}
void GpuServiceInterceptorForTesting::OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel level) {
  GetForwardingInterface()->OnMemoryPressure(std::move(level));
}
void GpuServiceInterceptorForTesting::GetDawnInfo(GetDawnInfoCallback callback) {
  GetForwardingInterface()->GetDawnInfo(std::move(callback));
}
void GpuServiceInterceptorForTesting::Crash() {
  GetForwardingInterface()->Crash();
}
void GpuServiceInterceptorForTesting::Hang() {
  GetForwardingInterface()->Hang();
}
void GpuServiceInterceptorForTesting::ThrowJavaException() {
  GetForwardingInterface()->ThrowJavaException();
}
GpuServiceAsyncWaiter::GpuServiceAsyncWaiter(
    GpuService* proxy) : proxy_(proxy) {}

GpuServiceAsyncWaiter::~GpuServiceAsyncWaiter() = default;

void GpuServiceAsyncWaiter::EstablishGpuChannel(
    int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool cache_shaders_on_disk, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info) {
  base::RunLoop loop;
  proxy_->EstablishGpuChannel(std::move(client_id),std::move(client_tracing_id),std::move(is_gpu_host),std::move(cache_shaders_on_disk),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedMessagePipeHandle* out_channel_handle
,
             ::gpu::GPUInfo* out_gpu_info
,
             ::gpu::GpuFeatureInfo* out_gpu_feature_info
,
             ::mojo::ScopedMessagePipeHandle channel_handle,
             const ::gpu::GPUInfo& gpu_info,
             const ::gpu::GpuFeatureInfo& gpu_feature_info) {*out_channel_handle = std::move(channel_handle);*out_gpu_info = std::move(gpu_info);*out_gpu_feature_info = std::move(gpu_feature_info);
            loop->Quit();
          },
          &loop,
          out_channel_handle,
          out_gpu_info,
          out_gpu_feature_info));
  loop.Run();
}
void GpuServiceAsyncWaiter::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, int32_t client_id, ::gpu::SurfaceHandle surface_handle, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) {
  base::RunLoop loop;
  proxy_->CreateGpuMemoryBuffer(std::move(id),std::move(size),std::move(format),std::move(usage),std::move(client_id),std::move(surface_handle),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::GpuMemoryBufferHandle* out_buffer_handle
,
             ::gfx::GpuMemoryBufferHandle buffer_handle) {*out_buffer_handle = std::move(buffer_handle);
            loop->Quit();
          },
          &loop,
          out_buffer_handle));
  loop.Run();
}
void GpuServiceAsyncWaiter::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, bool* out_success) {
  base::RunLoop loop;
  proxy_->CopyGpuMemoryBuffer(std::move(buffer_handle),std::move(shared_memory),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void GpuServiceAsyncWaiter::GetVideoMemoryUsageStats(
    ::gpu::VideoMemoryUsageStats* out_stats) {
  base::RunLoop loop;
  proxy_->GetVideoMemoryUsageStats(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::VideoMemoryUsageStats* out_stats
,
             const ::gpu::VideoMemoryUsageStats& stats) {*out_stats = std::move(stats);
            loop->Quit();
          },
          &loop,
          out_stats));
  loop.Run();
}
void GpuServiceAsyncWaiter::GetPeakMemoryUsage(
    uint32_t sequence_num, uint64_t* out_memory_usage, base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>* out_memory_per_allocation_source) {
  base::RunLoop loop;
  proxy_->GetPeakMemoryUsage(std::move(sequence_num),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_memory_usage
,
             base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>* out_memory_per_allocation_source
,
             uint64_t memory_usage,
             const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& memory_per_allocation_source) {*out_memory_usage = std::move(memory_usage);*out_memory_per_allocation_source = std::move(memory_per_allocation_source);
            loop->Quit();
          },
          &loop,
          out_memory_usage,
          out_memory_per_allocation_source));
  loop.Run();
}
void GpuServiceAsyncWaiter::RequestHDRStatus(
    bool* out_hdr_enabled) {
  base::RunLoop loop;
  proxy_->RequestHDRStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_hdr_enabled
,
             bool hdr_enabled) {*out_hdr_enabled = std::move(hdr_enabled);
            loop->Quit();
          },
          &loop,
          out_hdr_enabled));
  loop.Run();
}
void GpuServiceAsyncWaiter::GetDawnInfo(
    std::vector<std::string>* out_dawn_info_list) {
  base::RunLoop loop;
  proxy_->GetDawnInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_dawn_info_list
,
             const std::vector<std::string>& dawn_info_list) {*out_dawn_info_list = std::move(dawn_info_list);
            loop->Quit();
          },
          &loop,
          out_dawn_info_list));
  loop.Run();
}





}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif