// services/viz/public/mojom/gpu.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/viz/public/mojom/gpu.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "gpu/ipc/common/gpu_info.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_JUMBO_H_
#endif


namespace viz {
namespace mojom {


void GpuMemoryBufferFactoryInterceptorForTesting::CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, CreateGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CreateGpuMemoryBuffer(std::move(id), std::move(size), std::move(format), std::move(usage), std::move(callback));
}
void GpuMemoryBufferFactoryInterceptorForTesting::DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gpu::SyncToken& sync_token) {
  GetForwardingInterface()->DestroyGpuMemoryBuffer(std::move(id), std::move(sync_token));
}
void GpuMemoryBufferFactoryInterceptorForTesting::CopyGpuMemoryBuffer(::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, CopyGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CopyGpuMemoryBuffer(std::move(buffer_handle), std::move(shared_memory), std::move(callback));
}
GpuMemoryBufferFactoryAsyncWaiter::GpuMemoryBufferFactoryAsyncWaiter(
    GpuMemoryBufferFactory* proxy) : proxy_(proxy) {}

GpuMemoryBufferFactoryAsyncWaiter::~GpuMemoryBufferFactoryAsyncWaiter() = default;

void GpuMemoryBufferFactoryAsyncWaiter::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) {
  base::RunLoop loop;
  proxy_->CreateGpuMemoryBuffer(std::move(id),std::move(size),std::move(format),std::move(usage),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::GpuMemoryBufferHandle* out_buffer_handle
,
             ::gfx::GpuMemoryBufferHandle buffer_handle) {*out_buffer_handle = std::move(buffer_handle);
            loop->Quit();
          },
          &loop,
          out_buffer_handle));
  loop.Run();
}
void GpuMemoryBufferFactoryAsyncWaiter::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, bool* out_success) {
  base::RunLoop loop;
  proxy_->CopyGpuMemoryBuffer(std::move(buffer_handle),std::move(shared_memory),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}



void GpuInterceptorForTesting::CreateGpuMemoryBufferFactory(::mojo::PendingReceiver<GpuMemoryBufferFactory> receiver) {
  GetForwardingInterface()->CreateGpuMemoryBufferFactory(std::move(receiver));
}
void GpuInterceptorForTesting::EstablishGpuChannel(EstablishGpuChannelCallback callback) {
  GetForwardingInterface()->EstablishGpuChannel(std::move(callback));
}
void GpuInterceptorForTesting::CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) {
  GetForwardingInterface()->CreateVideoEncodeAcceleratorProvider(std::move(vea_provider));
}
GpuAsyncWaiter::GpuAsyncWaiter(
    Gpu* proxy) : proxy_(proxy) {}

GpuAsyncWaiter::~GpuAsyncWaiter() = default;

void GpuAsyncWaiter::EstablishGpuChannel(
    int32_t* out_client_id, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info) {
  base::RunLoop loop;
  proxy_->EstablishGpuChannel(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_client_id
,
             ::mojo::ScopedMessagePipeHandle* out_channel_handle
,
             ::gpu::GPUInfo* out_gpu_info
,
             ::gpu::GpuFeatureInfo* out_gpu_feature_info
,
             int32_t client_id,
             ::mojo::ScopedMessagePipeHandle channel_handle,
             const ::gpu::GPUInfo& gpu_info,
             const ::gpu::GpuFeatureInfo& gpu_feature_info) {*out_client_id = std::move(client_id);*out_channel_handle = std::move(channel_handle);*out_gpu_info = std::move(gpu_info);*out_gpu_feature_info = std::move(gpu_feature_info);
            loop->Quit();
          },
          &loop,
          out_client_id,
          out_channel_handle,
          out_gpu_info,
          out_gpu_feature_info));
  loop.Run();
}





}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif