// third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-params-data.h"
#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROADCASTCHANNEL_BROADCAST_CHANNEL_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROADCASTCHANNEL_BROADCAST_CHANNEL_MOJOM_JUMBO_H_
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
const char BroadcastChannelClient::Name_[] = "blink.mojom.BroadcastChannelClient";

BroadcastChannelClientProxy::BroadcastChannelClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BroadcastChannelClientProxy::OnMessage(
    ::blink::CloneableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BroadcastChannelClient::OnMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::CloneableMessage>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBroadcastChannelClient_OnMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BroadcastChannelClient_OnMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in BroadcastChannelClient.OnMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BroadcastChannelClient::Name_);
  message.set_method_name("OnMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BroadcastChannelClientStubDispatch::Accept(
    BroadcastChannelClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBroadcastChannelClient_OnMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BroadcastChannelClient::OnMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BroadcastChannelClient::OnMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BroadcastChannelClient_OnMessage_Params_Data* params =
          reinterpret_cast<internal::BroadcastChannelClient_OnMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::CloneableMessage p_message{};
      BroadcastChannelClient_OnMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BroadcastChannelClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessage(
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool BroadcastChannelClientStubDispatch::AcceptWithResponder(
    BroadcastChannelClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBroadcastChannelClient_OnMessage_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBroadcastChannelClientValidationInfo[] = {
    {internal::kBroadcastChannelClient_OnMessage_Name,
     {&internal::BroadcastChannelClient_OnMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BroadcastChannelClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BroadcastChannelClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBroadcastChannelClientValidationInfo);
}

const char BroadcastChannelProvider::Name_[] = "blink.mojom.BroadcastChannelProvider";

BroadcastChannelProviderProxy::BroadcastChannelProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BroadcastChannelProviderProxy::ConnectToChannel(
    const ::url::Origin& in_origin, const std::string& in_name, ::mojo::PendingAssociatedRemote<BroadcastChannelClient> in_receiver, ::mojo::PendingAssociatedReceiver<BroadcastChannelClient> in_sender) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BroadcastChannelProvider::ConnectToChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedRemote<BroadcastChannelClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sender"), in_sender,
                        "<value of type ::mojo::PendingAssociatedReceiver<BroadcastChannelClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBroadcastChannelProvider_ConnectToChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BroadcastChannelProvider_ConnectToChannel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in BroadcastChannelProvider.ConnectToChannel request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in BroadcastChannelProvider.ConnectToChannel request");
  mojo::internal::Serialize<::blink::mojom::BroadcastChannelClientAssociatedPtrInfoDataView>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in BroadcastChannelProvider.ConnectToChannel request");
  mojo::internal::Serialize<::blink::mojom::BroadcastChannelClientAssociatedRequestDataView>(
      in_sender, &params->sender, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->sender),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid sender in BroadcastChannelProvider.ConnectToChannel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BroadcastChannelProvider::Name_);
  message.set_method_name("ConnectToChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BroadcastChannelProviderStubDispatch::Accept(
    BroadcastChannelProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBroadcastChannelProvider_ConnectToChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BroadcastChannelProvider::ConnectToChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BroadcastChannelProvider::ConnectToChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BroadcastChannelProvider_ConnectToChannel_Params_Data* params =
          reinterpret_cast<internal::BroadcastChannelProvider_ConnectToChannel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      std::string p_name{};
      ::mojo::PendingAssociatedRemote<BroadcastChannelClient> p_receiver{};
      ::mojo::PendingAssociatedReceiver<BroadcastChannelClient> p_sender{};
      BroadcastChannelProvider_ConnectToChannel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_sender =
            input_data_view.TakeSender<decltype(p_sender)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BroadcastChannelProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToChannel(
std::move(p_origin), 
std::move(p_name), 
std::move(p_receiver), 
std::move(p_sender));
      return true;
    }
  }
  return false;
}

// static
bool BroadcastChannelProviderStubDispatch::AcceptWithResponder(
    BroadcastChannelProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBroadcastChannelProvider_ConnectToChannel_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBroadcastChannelProviderValidationInfo[] = {
    {internal::kBroadcastChannelProvider_ConnectToChannel_Name,
     {&internal::BroadcastChannelProvider_ConnectToChannel_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BroadcastChannelProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BroadcastChannelProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBroadcastChannelProviderValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif