// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
BucketPolicies::BucketPolicies()
    : persisted(),
      durability(),
      quota(),
      expires() {}

BucketPolicies::BucketPolicies(
    bool persisted_in,
    BucketDurability durability_in,
    int64_t quota_in,
    absl::optional<::base::Time> expires_in)
    : persisted(std::move(persisted_in)),
      durability(std::move(durability_in)),
      quota(std::move(quota_in)),
      expires(std::move(expires_in)) {}

BucketPolicies::~BucketPolicies() = default;

void BucketPolicies::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "persisted"), this->persisted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "durability"), this->durability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BucketDurability>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quota"), this->quota,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expires"), this->expires,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BucketPolicies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BucketHost::Name_[] = "blink.mojom.BucketHost";

class BucketHost_Persist_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Persist_ForwardToCallback(
      BucketHost::PersistCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::PersistCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketHost_Persist_ForwardToCallback);
};

class BucketHost_Persisted_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Persisted_ForwardToCallback(
      BucketHost::PersistedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::PersistedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketHost_Persisted_ForwardToCallback);
};

class BucketHost_Estimate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Estimate_ForwardToCallback(
      BucketHost::EstimateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::EstimateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketHost_Estimate_ForwardToCallback);
};

class BucketHost_Durability_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Durability_ForwardToCallback(
      BucketHost::DurabilityCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::DurabilityCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketHost_Durability_ForwardToCallback);
};

class BucketHost_SetExpires_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_SetExpires_ForwardToCallback(
      BucketHost::SetExpiresCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::SetExpiresCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketHost_SetExpires_ForwardToCallback);
};

class BucketHost_Expires_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Expires_ForwardToCallback(
      BucketHost::ExpiresCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::ExpiresCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketHost_Expires_ForwardToCallback);
};

BucketHostProxy::BucketHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BucketHostProxy::Persist(
    PersistCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BucketHost::Persist");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Persist_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persist_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persist");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Persist_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketHostProxy::Persisted(
    PersistedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BucketHost::Persisted");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Persisted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persisted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persisted");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Persisted_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketHostProxy::Estimate(
    EstimateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BucketHost::Estimate");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Estimate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Estimate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Estimate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Estimate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketHostProxy::Durability(
    DurabilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BucketHost::Durability");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Durability_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Durability_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Durability");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Durability_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketHostProxy::SetExpires(
    ::base::Time in_expires, SetExpiresCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BucketHost::SetExpires", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expires"), in_expires,
                        "<value of type ::base::Time>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_SetExpires_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_SetExpires_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->expires)::BaseType> expires_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expires, expires_fragment);
  params->expires.Set(
      expires_fragment.is_null() ? nullptr : expires_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->expires.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expires in BucketHost.SetExpires request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("SetExpires");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_SetExpires_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketHostProxy::Expires(
    ExpiresCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BucketHost::Expires");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Expires_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Expires_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Expires");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Expires_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BucketHost_Persist_ProxyToResponder {
 public:
  static BucketHost::PersistCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketHost_Persist_ProxyToResponder> proxy(
        new BucketHost_Persist_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketHost_Persist_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Persist_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketHost_Persist_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketHost::PersistCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_persisted, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketHost_Persist_ProxyToResponder);
};

bool BucketHost_Persist_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketHost::PersistCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketHost_Persist_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Persist_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_persisted{};
  bool p_success{};
  BucketHost_Persist_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_persisted = input_data_view.persisted();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_persisted), 
std::move(p_success));
  return true;
}

void BucketHost_Persist_ProxyToResponder::Run(
    bool in_persisted, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketHost::PersistCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("persisted"), in_persisted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Persist_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persist_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->persisted = in_persisted;
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketHost::PersistCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persist");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Persisted_ProxyToResponder {
 public:
  static BucketHost::PersistedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketHost_Persisted_ProxyToResponder> proxy(
        new BucketHost_Persisted_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketHost_Persisted_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Persisted_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketHost_Persisted_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketHost::PersistedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_persisted, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketHost_Persisted_ProxyToResponder);
};

bool BucketHost_Persisted_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketHost::PersistedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketHost_Persisted_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Persisted_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_persisted{};
  bool p_success{};
  BucketHost_Persisted_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_persisted = input_data_view.persisted();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_persisted), 
std::move(p_success));
  return true;
}

void BucketHost_Persisted_ProxyToResponder::Run(
    bool in_persisted, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketHost::PersistedCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("persisted"), in_persisted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Persisted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persisted_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->persisted = in_persisted;
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketHost::PersistedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persisted");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Estimate_ProxyToResponder {
 public:
  static BucketHost::EstimateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketHost_Estimate_ProxyToResponder> proxy(
        new BucketHost_Estimate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketHost_Estimate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Estimate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketHost_Estimate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketHost::EstimateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_current_usage, int64_t in_current_quota, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketHost_Estimate_ProxyToResponder);
};

bool BucketHost_Estimate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketHost::EstimateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketHost_Estimate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Estimate_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_current_usage{};
  int64_t p_current_quota{};
  bool p_success{};
  BucketHost_Estimate_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_current_usage = input_data_view.current_usage();
  if (success)
    p_current_quota = input_data_view.current_quota();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_current_usage), 
std::move(p_current_quota), 
std::move(p_success));
  return true;
}

void BucketHost_Estimate_ProxyToResponder::Run(
    int64_t in_current_usage, int64_t in_current_quota, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketHost::EstimateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_usage"), in_current_usage,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_quota"), in_current_quota,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Estimate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Estimate_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->current_usage = in_current_usage;
  params->current_quota = in_current_quota;
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketHost::EstimateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Estimate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Durability_ProxyToResponder {
 public:
  static BucketHost::DurabilityCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketHost_Durability_ProxyToResponder> proxy(
        new BucketHost_Durability_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketHost_Durability_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Durability_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketHost_Durability_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketHost::DurabilityCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BucketDurability in_durability, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketHost_Durability_ProxyToResponder);
};

bool BucketHost_Durability_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketHost::DurabilityCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketHost_Durability_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Durability_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BucketDurability p_durability{};
  bool p_success{};
  BucketHost_Durability_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDurability(&p_durability))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_durability), 
std::move(p_success));
  return true;
}

void BucketHost_Durability_ProxyToResponder::Run(
    BucketDurability in_durability, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketHost::DurabilityCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("durability"), in_durability,
                        "<value of type BucketDurability>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Durability_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Durability_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BucketDurability>(
      in_durability, &params->durability);
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketHost::DurabilityCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Durability");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_SetExpires_ProxyToResponder {
 public:
  static BucketHost::SetExpiresCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketHost_SetExpires_ProxyToResponder> proxy(
        new BucketHost_SetExpires_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketHost_SetExpires_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_SetExpires_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketHost_SetExpires_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketHost::SetExpiresCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketHost_SetExpires_ProxyToResponder);
};

bool BucketHost_SetExpires_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketHost::SetExpiresCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketHost_SetExpires_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_SetExpires_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  BucketHost_SetExpires_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void BucketHost_SetExpires_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketHost::SetExpiresCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_SetExpires_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_SetExpires_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketHost::SetExpiresCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("SetExpires");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Expires_ProxyToResponder {
 public:
  static BucketHost::ExpiresCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketHost_Expires_ProxyToResponder> proxy(
        new BucketHost_Expires_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketHost_Expires_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Expires_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketHost_Expires_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketHost::ExpiresCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      absl::optional<::base::Time> in_expires, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketHost_Expires_ProxyToResponder);
};

bool BucketHost_Expires_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketHost::ExpiresCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketHost_Expires_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Expires_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::base::Time> p_expires{};
  bool p_success{};
  BucketHost_Expires_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadExpires(&p_expires))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_expires), 
std::move(p_success));
  return true;
}

void BucketHost_Expires_ProxyToResponder::Run(
    absl::optional<::base::Time> in_expires, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketHost::ExpiresCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expires"), in_expires,
                        "<value of type absl::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketHost_Expires_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Expires_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->expires)::BaseType> expires_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expires, expires_fragment);
  params->expires.Set(
      expires_fragment.is_null() ? nullptr : expires_fragment.data());
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketHost::ExpiresCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Expires");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BucketHostStubDispatch::Accept(
    BucketHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBucketHost_Persist_Name: {
      break;
    }
    case internal::kBucketHost_Persisted_Name: {
      break;
    }
    case internal::kBucketHost_Estimate_Name: {
      break;
    }
    case internal::kBucketHost_Durability_Name: {
      break;
    }
    case internal::kBucketHost_SetExpires_Name: {
      break;
    }
    case internal::kBucketHost_Expires_Name: {
      break;
    }
  }
  return false;
}

// static
bool BucketHostStubDispatch::AcceptWithResponder(
    BucketHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBucketHost_Persist_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketHost::Persist",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketHost::Persist");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketHost_Persist_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Persist_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BucketHost_Persist_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 0, false);
        return false;
      }
      BucketHost::PersistCallback callback =
          BucketHost_Persist_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Persist(std::move(callback));
      return true;
    }
    case internal::kBucketHost_Persisted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketHost::Persisted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketHost::Persisted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketHost_Persisted_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Persisted_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BucketHost_Persisted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 1, false);
        return false;
      }
      BucketHost::PersistedCallback callback =
          BucketHost_Persisted_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Persisted(std::move(callback));
      return true;
    }
    case internal::kBucketHost_Estimate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketHost::Estimate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketHost::Estimate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketHost_Estimate_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Estimate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BucketHost_Estimate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 2, false);
        return false;
      }
      BucketHost::EstimateCallback callback =
          BucketHost_Estimate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Estimate(std::move(callback));
      return true;
    }
    case internal::kBucketHost_Durability_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketHost::Durability",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketHost::Durability");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketHost_Durability_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Durability_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BucketHost_Durability_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 3, false);
        return false;
      }
      BucketHost::DurabilityCallback callback =
          BucketHost_Durability_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Durability(std::move(callback));
      return true;
    }
    case internal::kBucketHost_SetExpires_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketHost::SetExpires",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketHost::SetExpires");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketHost_SetExpires_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_SetExpires_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Time p_expires{};
      BucketHost_SetExpires_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExpires(&p_expires))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 4, false);
        return false;
      }
      BucketHost::SetExpiresCallback callback =
          BucketHost_SetExpires_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetExpires(
std::move(p_expires), std::move(callback));
      return true;
    }
    case internal::kBucketHost_Expires_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketHost::Expires",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketHost::Expires");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketHost_Expires_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Expires_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BucketHost_Expires_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 5, false);
        return false;
      }
      BucketHost::ExpiresCallback callback =
          BucketHost_Expires_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Expires(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBucketHostValidationInfo[] = {
    {&internal::BucketHost_Persist_Params_Data::Validate,
     &internal::BucketHost_Persist_ResponseParams_Data::Validate},
    {&internal::BucketHost_Persisted_Params_Data::Validate,
     &internal::BucketHost_Persisted_ResponseParams_Data::Validate},
    {&internal::BucketHost_Estimate_Params_Data::Validate,
     &internal::BucketHost_Estimate_ResponseParams_Data::Validate},
    {&internal::BucketHost_Durability_Params_Data::Validate,
     &internal::BucketHost_Durability_ResponseParams_Data::Validate},
    {&internal::BucketHost_SetExpires_Params_Data::Validate,
     &internal::BucketHost_SetExpires_ResponseParams_Data::Validate},
    {&internal::BucketHost_Expires_Params_Data::Validate,
     &internal::BucketHost_Expires_ResponseParams_Data::Validate},
};

bool BucketHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BucketHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBucketHostValidationInfo);
}

bool BucketHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BucketHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBucketHostValidationInfo);
}
const char BucketManagerHost::Name_[] = "blink.mojom.BucketManagerHost";

class BucketManagerHost_OpenBucket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketManagerHost_OpenBucket_ForwardToCallback(
      BucketManagerHost::OpenBucketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketManagerHost::OpenBucketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketManagerHost_OpenBucket_ForwardToCallback);
};

class BucketManagerHost_Keys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketManagerHost_Keys_ForwardToCallback(
      BucketManagerHost::KeysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketManagerHost::KeysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketManagerHost_Keys_ForwardToCallback);
};

class BucketManagerHost_DeleteBucket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketManagerHost_DeleteBucket_ForwardToCallback(
      BucketManagerHost::DeleteBucketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BucketManagerHost::DeleteBucketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BucketManagerHost_DeleteBucket_ForwardToCallback);
};

BucketManagerHostProxy::BucketManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BucketManagerHostProxy::OpenBucket(
    const WTF::String& in_name, BucketPoliciesPtr in_policy, OpenBucketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BucketManagerHost::OpenBucket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type BucketPoliciesPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketManagerHost_OpenBucket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_OpenBucket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in BucketManagerHost.OpenBucket request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy)::BaseType> policy_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BucketPoliciesDataView>(
      in_policy, policy_fragment);
  params->policy.Set(
      policy_fragment.is_null() ? nullptr : policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy in BucketManagerHost.OpenBucket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("OpenBucket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketManagerHost_OpenBucket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketManagerHostProxy::Keys(
    KeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BucketManagerHost::Keys");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketManagerHost_Keys_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_Keys_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("Keys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketManagerHost_Keys_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BucketManagerHostProxy::DeleteBucket(
    const WTF::String& in_name, DeleteBucketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BucketManagerHost::DeleteBucket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketManagerHost_DeleteBucket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_DeleteBucket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in BucketManagerHost.DeleteBucket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("DeleteBucket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketManagerHost_DeleteBucket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BucketManagerHost_OpenBucket_ProxyToResponder {
 public:
  static BucketManagerHost::OpenBucketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketManagerHost_OpenBucket_ProxyToResponder> proxy(
        new BucketManagerHost_OpenBucket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketManagerHost_OpenBucket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketManagerHost_OpenBucket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketManagerHost_OpenBucket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketManagerHost::OpenBucketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<BucketHost> in_remote);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketManagerHost_OpenBucket_ProxyToResponder);
};

bool BucketManagerHost_OpenBucket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketManagerHost::OpenBucketCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketManagerHost_OpenBucket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketManagerHost_OpenBucket_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<BucketHost> p_remote{};
  BucketManagerHost_OpenBucket_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_remote =
        input_data_view.TakeRemote<decltype(p_remote)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketManagerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_remote));
  return true;
}

void BucketManagerHost_OpenBucket_ProxyToResponder::Run(
    ::mojo::PendingRemote<BucketHost> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketManagerHost::OpenBucketCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingRemote<BucketHost>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketManagerHost_OpenBucket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_OpenBucket_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BucketHostInterfaceBase>>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketManagerHost::OpenBucketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("OpenBucket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketManagerHost_Keys_ProxyToResponder {
 public:
  static BucketManagerHost::KeysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketManagerHost_Keys_ProxyToResponder> proxy(
        new BucketManagerHost_Keys_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketManagerHost_Keys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketManagerHost_Keys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketManagerHost_Keys_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketManagerHost::KeysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<WTF::String>& in_buckets, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketManagerHost_Keys_ProxyToResponder);
};

bool BucketManagerHost_Keys_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketManagerHost::KeysCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketManagerHost_Keys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketManagerHost_Keys_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<WTF::String> p_buckets{};
  bool p_success{};
  BucketManagerHost_Keys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBuckets(&p_buckets))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketManagerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buckets), 
std::move(p_success));
  return true;
}

void BucketManagerHost_Keys_ProxyToResponder::Run(
    const WTF::Vector<WTF::String>& in_buckets, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketManagerHost::KeysCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buckets"), in_buckets,
                        "<value of type const WTF::Vector<WTF::String>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketManagerHost_Keys_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_Keys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buckets)::BaseType>
      buckets_fragment(params.message());
  const mojo::internal::ContainerValidateParams buckets_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_buckets, buckets_fragment, &buckets_validate_params);
  params->buckets.Set(
      buckets_fragment.is_null() ? nullptr : buckets_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buckets.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buckets in ");
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketManagerHost::KeysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("Keys");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketManagerHost_DeleteBucket_ProxyToResponder {
 public:
  static BucketManagerHost::DeleteBucketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BucketManagerHost_DeleteBucket_ProxyToResponder> proxy(
        new BucketManagerHost_DeleteBucket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BucketManagerHost_DeleteBucket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketManagerHost_DeleteBucket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BucketManagerHost_DeleteBucket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BucketManagerHost::DeleteBucketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BucketManagerHost_DeleteBucket_ProxyToResponder);
};

bool BucketManagerHost_DeleteBucket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BucketManagerHost::DeleteBucketCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BucketManagerHost_DeleteBucket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketManagerHost_DeleteBucket_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  BucketManagerHost_DeleteBucket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketManagerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void BucketManagerHost_DeleteBucket_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BucketManagerHost::DeleteBucketCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBucketManagerHost_DeleteBucket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_DeleteBucket_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BucketManagerHost::DeleteBucketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("DeleteBucket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BucketManagerHostStubDispatch::Accept(
    BucketManagerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBucketManagerHost_OpenBucket_Name: {
      break;
    }
    case internal::kBucketManagerHost_Keys_Name: {
      break;
    }
    case internal::kBucketManagerHost_DeleteBucket_Name: {
      break;
    }
  }
  return false;
}

// static
bool BucketManagerHostStubDispatch::AcceptWithResponder(
    BucketManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBucketManagerHost_OpenBucket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketManagerHost::OpenBucket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketManagerHost::OpenBucket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketManagerHost_OpenBucket_Params_Data* params =
          reinterpret_cast<
              internal::BucketManagerHost_OpenBucket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_name{};
      BucketPoliciesPtr p_policy{};
      BucketManagerHost_OpenBucket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 0, false);
        return false;
      }
      BucketManagerHost::OpenBucketCallback callback =
          BucketManagerHost_OpenBucket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenBucket(
std::move(p_name), 
std::move(p_policy), std::move(callback));
      return true;
    }
    case internal::kBucketManagerHost_Keys_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketManagerHost::Keys",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketManagerHost::Keys");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketManagerHost_Keys_Params_Data* params =
          reinterpret_cast<
              internal::BucketManagerHost_Keys_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BucketManagerHost_Keys_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 1, false);
        return false;
      }
      BucketManagerHost::KeysCallback callback =
          BucketManagerHost_Keys_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Keys(std::move(callback));
      return true;
    }
    case internal::kBucketManagerHost_DeleteBucket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BucketManagerHost::DeleteBucket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BucketManagerHost::DeleteBucket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BucketManagerHost_DeleteBucket_Params_Data* params =
          reinterpret_cast<
              internal::BucketManagerHost_DeleteBucket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_name{};
      BucketManagerHost_DeleteBucket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 2, false);
        return false;
      }
      BucketManagerHost::DeleteBucketCallback callback =
          BucketManagerHost_DeleteBucket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteBucket(
std::move(p_name), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBucketManagerHostValidationInfo[] = {
    {&internal::BucketManagerHost_OpenBucket_Params_Data::Validate,
     &internal::BucketManagerHost_OpenBucket_ResponseParams_Data::Validate},
    {&internal::BucketManagerHost_Keys_Params_Data::Validate,
     &internal::BucketManagerHost_Keys_ResponseParams_Data::Validate},
    {&internal::BucketManagerHost_DeleteBucket_Params_Data::Validate,
     &internal::BucketManagerHost_DeleteBucket_ResponseParams_Data::Validate},
};

bool BucketManagerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BucketManagerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBucketManagerHostValidationInfo);
}

bool BucketManagerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BucketManagerHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBucketManagerHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::BucketPolicies::DataView, ::blink::mojom::blink::BucketPoliciesPtr>::Read(
    ::blink::mojom::blink::BucketPolicies::DataView input,
    ::blink::mojom::blink::BucketPoliciesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BucketPoliciesPtr result(::blink::mojom::blink::BucketPolicies::New());
  
      if (success)
        result->persisted = input.persisted();
      if (success && !input.ReadDurability(&result->durability))
        success = false;
      if (success)
        result->quota = input.quota();
      if (success && !input.ReadExpires(&result->expires))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif