// third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom-params-data.h"
#include "third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_COMPUTE_PRESSURE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_COMPUTE_PRESSURE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ComputePressureState::ComputePressureState()
    : cpu_utilization(),
      cpu_speed() {}

ComputePressureState::ComputePressureState(
    double cpu_utilization_in,
    double cpu_speed_in)
    : cpu_utilization(std::move(cpu_utilization_in)),
      cpu_speed(std::move(cpu_speed_in)) {}

ComputePressureState::~ComputePressureState() = default;
size_t ComputePressureState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->cpu_utilization);
  seed = mojo::internal::Hash(seed, this->cpu_speed);
  return seed;
}

void ComputePressureState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cpu_utilization"), this->cpu_utilization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cpu_speed"), this->cpu_speed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ComputePressureState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ComputePressureQuantization::ComputePressureQuantization()
    : cpu_utilization_thresholds(),
      cpu_speed_thresholds() {}

ComputePressureQuantization::ComputePressureQuantization(
    std::vector<double> cpu_utilization_thresholds_in,
    std::vector<double> cpu_speed_thresholds_in)
    : cpu_utilization_thresholds(std::move(cpu_utilization_thresholds_in)),
      cpu_speed_thresholds(std::move(cpu_speed_thresholds_in)) {}

ComputePressureQuantization::~ComputePressureQuantization() = default;

void ComputePressureQuantization::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cpu_utilization_thresholds"), this->cpu_utilization_thresholds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<double>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cpu_speed_thresholds"), this->cpu_speed_thresholds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<double>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ComputePressureQuantization::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ComputePressureObserver::Name_[] = "blink.mojom.ComputePressureObserver";

ComputePressureObserverProxy::ComputePressureObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ComputePressureObserverProxy::OnUpdate(
    ComputePressureStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ComputePressureObserver::OnUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ComputePressureStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kComputePressureObserver_OnUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ComputePressureObserver_OnUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ComputePressureStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in ComputePressureObserver.OnUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComputePressureObserver::Name_);
  message.set_method_name("OnUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ComputePressureObserverStubDispatch::Accept(
    ComputePressureObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kComputePressureObserver_OnUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ComputePressureObserver::OnUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ComputePressureObserver::OnUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ComputePressureObserver_OnUpdate_Params_Data* params =
          reinterpret_cast<internal::ComputePressureObserver_OnUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ComputePressureStatePtr p_state{};
      ComputePressureObserver_OnUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComputePressureObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUpdate(
std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool ComputePressureObserverStubDispatch::AcceptWithResponder(
    ComputePressureObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kComputePressureObserver_OnUpdate_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kComputePressureObserverValidationInfo[] = {
    {&internal::ComputePressureObserver_OnUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool ComputePressureObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ComputePressureObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kComputePressureObserverValidationInfo);
}

const char ComputePressureHost::Name_[] = "blink.mojom.ComputePressureHost";

class ComputePressureHost_AddObserver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComputePressureHost_AddObserver_ForwardToCallback(
      ComputePressureHost::AddObserverCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ComputePressureHost::AddObserverCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ComputePressureHost_AddObserver_ForwardToCallback);
};

ComputePressureHostProxy::ComputePressureHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ComputePressureHostProxy::AddObserver(
    ::mojo::PendingRemote<ComputePressureObserver> in_observer, ComputePressureQuantizationPtr in_quantization, AddObserverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ComputePressureHost::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<ComputePressureObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quantization"), in_quantization,
                        "<value of type ComputePressureQuantizationPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kComputePressureHost_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ComputePressureHost_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ComputePressureObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in ComputePressureHost.AddObserver request");
  mojo::internal::MessageFragment<
      typename decltype(params->quantization)::BaseType> quantization_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ComputePressureQuantizationDataView>(
      in_quantization, quantization_fragment);
  params->quantization.Set(
      quantization_fragment.is_null() ? nullptr : quantization_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->quantization.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null quantization in ComputePressureHost.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComputePressureHost::Name_);
  message.set_method_name("AddObserver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComputePressureHost_AddObserver_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ComputePressureHost_AddObserver_ProxyToResponder {
 public:
  static ComputePressureHost::AddObserverCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ComputePressureHost_AddObserver_ProxyToResponder> proxy(
        new ComputePressureHost_AddObserver_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ComputePressureHost_AddObserver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComputePressureHost_AddObserver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ComputePressureHost_AddObserver_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ComputePressureHost::AddObserverCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ComputePressureStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ComputePressureHost_AddObserver_ProxyToResponder);
};

bool ComputePressureHost_AddObserver_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ComputePressureHost::AddObserverCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ComputePressureHost_AddObserver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComputePressureHost_AddObserver_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ComputePressureStatus p_status{};
  ComputePressureHost_AddObserver_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComputePressureHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ComputePressureHost_AddObserver_ProxyToResponder::Run(
    ComputePressureStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ComputePressureHost::AddObserverCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ComputePressureStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kComputePressureHost_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ComputePressureHost_AddObserver_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ComputePressureStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ComputePressureHost::AddObserverCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComputePressureHost::Name_);
  message.set_method_name("AddObserver");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ComputePressureHostStubDispatch::Accept(
    ComputePressureHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kComputePressureHost_AddObserver_Name: {
      break;
    }
  }
  return false;
}

// static
bool ComputePressureHostStubDispatch::AcceptWithResponder(
    ComputePressureHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kComputePressureHost_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ComputePressureHost::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ComputePressureHost::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ComputePressureHost_AddObserver_Params_Data* params =
          reinterpret_cast<
              internal::ComputePressureHost_AddObserver_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<ComputePressureObserver> p_observer{};
      ComputePressureQuantizationPtr p_quantization{};
      ComputePressureHost_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success && !input_data_view.ReadQuantization(&p_quantization))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComputePressureHost::Name_, 0, false);
        return false;
      }
      ComputePressureHost::AddObserverCallback callback =
          ComputePressureHost_AddObserver_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer), 
std::move(p_quantization), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kComputePressureHostValidationInfo[] = {
    {&internal::ComputePressureHost_AddObserver_Params_Data::Validate,
     &internal::ComputePressureHost_AddObserver_ResponseParams_Data::Validate},
};

bool ComputePressureHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ComputePressureHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kComputePressureHostValidationInfo);
}

bool ComputePressureHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ComputePressureHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kComputePressureHostValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ComputePressureState::DataView, ::blink::mojom::ComputePressureStatePtr>::Read(
    ::blink::mojom::ComputePressureState::DataView input,
    ::blink::mojom::ComputePressureStatePtr* output) {
  bool success = true;
  ::blink::mojom::ComputePressureStatePtr result(::blink::mojom::ComputePressureState::New());
  
      if (success)
        result->cpu_utilization = input.cpu_utilization();
      if (success)
        result->cpu_speed = input.cpu_speed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ComputePressureQuantization::DataView, ::blink::mojom::ComputePressureQuantizationPtr>::Read(
    ::blink::mojom::ComputePressureQuantization::DataView input,
    ::blink::mojom::ComputePressureQuantizationPtr* output) {
  bool success = true;
  ::blink::mojom::ComputePressureQuantizationPtr result(::blink::mojom::ComputePressureQuantization::New());
  
      if (success && !input.ReadCpuUtilizationThresholds(&result->cpu_utilization_thresholds))
        success = false;
      if (success && !input.ReadCpuSpeedThresholds(&result->cpu_speed_thresholds))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif