// third_party/blink/public/mojom/content_index/content_index.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/content_index/content_index.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace mojom {
namespace blink {


void ContentIndexServiceInterceptorForTesting::GetIconSizes(ContentCategory category, GetIconSizesCallback callback) {
  GetForwardingInterface()->GetIconSizes(std::move(category), std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::CheckOfflineCapability(int64_t service_worker_registration_id, const ::blink::KURL& launch_url, CheckOfflineCapabilityCallback callback) {
  GetForwardingInterface()->CheckOfflineCapability(std::move(service_worker_registration_id), std::move(launch_url), std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::Add(int64_t service_worker_registration_id, ContentDescriptionPtr description, const WTF::Vector<::SkBitmap>& icon, const ::blink::KURL& launchUrl, AddCallback callback) {
  GetForwardingInterface()->Add(std::move(service_worker_registration_id), std::move(description), std::move(icon), std::move(launchUrl), std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::Delete(int64_t service_worker_registration_id, const WTF::String& id, DeleteCallback callback) {
  GetForwardingInterface()->Delete(std::move(service_worker_registration_id), std::move(id), std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::GetDescriptions(int64_t service_worker_registration_id, GetDescriptionsCallback callback) {
  GetForwardingInterface()->GetDescriptions(std::move(service_worker_registration_id), std::move(callback));
}
ContentIndexServiceAsyncWaiter::ContentIndexServiceAsyncWaiter(
    ContentIndexService* proxy) : proxy_(proxy) {}

ContentIndexServiceAsyncWaiter::~ContentIndexServiceAsyncWaiter() = default;

void ContentIndexServiceAsyncWaiter::GetIconSizes(
    ContentCategory category, WTF::Vector<::gfx::Size>* out_icon_sizes) {
  base::RunLoop loop;
  proxy_->GetIconSizes(std::move(category),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::gfx::Size>* out_icon_sizes
,
             const WTF::Vector<::gfx::Size>& icon_sizes) {*out_icon_sizes = std::move(icon_sizes);
            loop->Quit();
          },
          &loop,
          out_icon_sizes));
  loop.Run();
}
void ContentIndexServiceAsyncWaiter::CheckOfflineCapability(
    int64_t service_worker_registration_id, const ::blink::KURL& launch_url, bool* out_is_offline_capable) {
  base::RunLoop loop;
  proxy_->CheckOfflineCapability(std::move(service_worker_registration_id),std::move(launch_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_offline_capable
,
             bool is_offline_capable) {*out_is_offline_capable = std::move(is_offline_capable);
            loop->Quit();
          },
          &loop,
          out_is_offline_capable));
  loop.Run();
}
void ContentIndexServiceAsyncWaiter::Add(
    int64_t service_worker_registration_id, ContentDescriptionPtr description, const WTF::Vector<::SkBitmap>& icon, const ::blink::KURL& launchUrl, ContentIndexError* out_error) {
  base::RunLoop loop;
  proxy_->Add(std::move(service_worker_registration_id),std::move(description),std::move(icon),std::move(launchUrl),
      base::BindOnce(
          [](base::RunLoop* loop,
             ContentIndexError* out_error
,
             ContentIndexError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}
void ContentIndexServiceAsyncWaiter::Delete(
    int64_t service_worker_registration_id, const WTF::String& id, ContentIndexError* out_error) {
  base::RunLoop loop;
  proxy_->Delete(std::move(service_worker_registration_id),std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ContentIndexError* out_error
,
             ContentIndexError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}
void ContentIndexServiceAsyncWaiter::GetDescriptions(
    int64_t service_worker_registration_id, ContentIndexError* out_error, WTF::Vector<ContentDescriptionPtr>* out_descriptions) {
  base::RunLoop loop;
  proxy_->GetDescriptions(std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ContentIndexError* out_error
,
             WTF::Vector<ContentDescriptionPtr>* out_descriptions
,
             ContentIndexError error,
             WTF::Vector<ContentDescriptionPtr> descriptions) {*out_error = std::move(error);*out_descriptions = std::move(descriptions);
            loop->Quit();
          },
          &loop,
          out_error,
          out_descriptions));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif