// third_party/blink/public/mojom/conversions/conversions.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* RegisterImpressionErrorToStringHelper(RegisterImpressionError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RegisterImpressionError::kNotAllowed:
      return "kNotAllowed";
    case RegisterImpressionError::kInsecureContext:
      return "kInsecureContext";
    case RegisterImpressionError::kInsecureAttributionDestination:
      return "kInsecureAttributionDestination";
    case RegisterImpressionError::kInsecureAttributionReportTo:
      return "kInsecureAttributionReportTo";
    case RegisterImpressionError::kInvalidAttributionSourceEventId:
      return "kInvalidAttributionSourceEventId";
    default:
      return nullptr;
  }
}

std::string RegisterImpressionErrorToString(RegisterImpressionError value) {
  const char *str = RegisterImpressionErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RegisterImpressionError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RegisterImpressionError value) {
  return os << RegisterImpressionErrorToString(value);
}

namespace internal {


// static
bool DedupKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedupKey_Data* object = static_cast<const DedupKey_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DedupKey_Data::DedupKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Conversion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Conversion_Data* object = static_cast<const Conversion_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dedup_key, validation_context))
    return false;

  return true;
}

Conversion_Data::Conversion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Impression_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Impression_Data* object = static_cast<const Impression_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conversion_destination, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conversion_destination, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  return true;
}

Impression_Data::Impression_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionHost_RegisterConversion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionHost_RegisterConversion_Params_Data* object = static_cast<const ConversionHost_RegisterConversion_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conversion, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conversion, validation_context))
    return false;

  return true;
}

ConversionHost_RegisterConversion_Params_Data::ConversionHost_RegisterConversion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionHost_RegisterImpression_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionHost_RegisterImpression_Params_Data* object = static_cast<const ConversionHost_RegisterImpression_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->impression, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->impression, validation_context))
    return false;

  return true;
}

ConversionHost_RegisterImpression_Params_Data::ConversionHost_RegisterImpression_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RegisterImpressionError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RegisterImpressionError value) {
  return std::move(context).WriteString(::blink::mojom::RegisterImpressionErrorToString(value));
}

} // namespace perfetto
