// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
FileSystemAccessEntry::FileSystemAccessEntry()
    : entry_handle(),
      name() {}

FileSystemAccessEntry::FileSystemAccessEntry(
    FileSystemAccessHandlePtr entry_handle_in,
    const std::string& name_in)
    : entry_handle(std::move(entry_handle_in)),
      name(std::move(name_in)) {}

FileSystemAccessEntry::~FileSystemAccessEntry() = default;

void FileSystemAccessEntry::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entry_handle"), this->entry_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileSystemAccessHandlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemAccessEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessHandle::FileSystemAccessHandle() : tag_(Tag::FILE) {
  data_.file = new ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>;
}

FileSystemAccessHandle::~FileSystemAccessHandle() {
  DestroyActive();
}


void FileSystemAccessHandle::set_file(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>(
        std::move(file));
  }
}
void FileSystemAccessHandle::set_directory(
    ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> directory) {
  if (tag_ == Tag::DIRECTORY) {
    *(data_.directory) = std::move(directory);
  } else {
    DestroyActive();
    tag_ = Tag::DIRECTORY;
    data_.directory = new ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>(
        std::move(directory));
  }
}

void FileSystemAccessHandle::DestroyActive() {
  switch (tag_) {

    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::DIRECTORY:

      delete data_.directory;
      break;
  }
}

bool FileSystemAccessHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char FileSystemAccessDirectoryEntriesListener::Name_[] = "blink.mojom.FileSystemAccessDirectoryEntriesListener";

FileSystemAccessDirectoryEntriesListenerProxy::FileSystemAccessDirectoryEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessDirectoryEntriesListenerProxy::DidReadDirectory(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<FileSystemAccessEntryPtr> in_entries, bool in_has_more_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<FileSystemAccessEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_more_entries"), in_has_more_entries,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in FileSystemAccessDirectoryEntriesListener.DidReadDirectory request");
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessEntryDataView>>(
      in_entries, entries_fragment, &entries_validate_params);
  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in FileSystemAccessDirectoryEntriesListener.DidReadDirectory request");
  params->has_more_entries = in_has_more_entries;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryEntriesListener::Name_);
  message.set_method_name("DidReadDirectory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FileSystemAccessDirectoryEntriesListenerStubDispatch::Accept(
    FileSystemAccessDirectoryEntriesListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FileSystemAccessErrorPtr p_result{};
      std::vector<FileSystemAccessEntryPtr> p_entries{};
      bool p_has_more_entries{};
      FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (success)
        p_has_more_entries = input_data_view.has_more_entries();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryEntriesListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReadDirectory(
std::move(p_result), 
std::move(p_entries), 
std::move(p_has_more_entries));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessDirectoryEntriesListenerStubDispatch::AcceptWithResponder(
    FileSystemAccessDirectoryEntriesListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessDirectoryEntriesListenerValidationInfo[] = {
    {&internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessDirectoryEntriesListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessDirectoryEntriesListener::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessDirectoryEntriesListenerValidationInfo);
}

const char FileSystemAccessDirectoryHandle::Name_[] = "blink.mojom.FileSystemAccessDirectoryHandle";

class FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetPermissionStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback);
};

class FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RequestPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback);
};

class FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback);
};

class FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetDirectoryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback);
};

class FileSystemAccessDirectoryHandle_Remove_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_Remove_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RemoveCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RemoveCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_Remove_ForwardToCallback);
};

class FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RemoveEntryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RemoveEntryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback);
};

class FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback(
      FileSystemAccessDirectoryHandle::ResolveCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::ResolveCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback);
};

FileSystemAccessDirectoryHandleProxy::FileSystemAccessDirectoryHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessDirectoryHandleProxy::GetPermissionStatus(
    bool in_writable, GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data> params(
          message);
  params.Allocate();
  params->writable = in_writable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::RequestPermission(
    bool in_writable, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data> params(
          message);
  params.Allocate();
  params->writable = in_writable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::GetFile(
    const std::string& in_basename, bool in_create, GetFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("basename"), in_basename,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("create"), in_create,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->basename)::BaseType> basename_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_basename, basename_fragment);
  params->basename.Set(
      basename_fragment.is_null() ? nullptr : basename_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->basename.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null basename in FileSystemAccessDirectoryHandle.GetFile request");
  params->create = in_create;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::GetDirectory(
    const std::string& in_basename, bool in_create, GetDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("basename"), in_basename,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("create"), in_create,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->basename)::BaseType> basename_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_basename, basename_fragment);
  params->basename.Set(
      basename_fragment.is_null() ? nullptr : basename_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->basename.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null basename in FileSystemAccessDirectoryHandle.GetDirectory request");
  params->create = in_create;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::GetEntries(
    ::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetEntries_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryEntriesListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in FileSystemAccessDirectoryHandle.GetEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FileSystemAccessDirectoryHandleProxy::Remove(
    bool in_recurse, RemoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recurse"), in_recurse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_Remove_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Remove_Params_Data> params(
          message);
  params.Allocate();
  params->recurse = in_recurse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Remove");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_Remove_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::RemoveEntry(
    const std::string& in_basename, bool in_recurse, RemoveEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("basename"), in_basename,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recurse"), in_recurse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_RemoveEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->basename)::BaseType> basename_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_basename, basename_fragment);
  params->basename.Set(
      basename_fragment.is_null() ? nullptr : basename_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->basename.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null basename in FileSystemAccessDirectoryHandle.RemoveEntry request");
  params->recurse = in_recurse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RemoveEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::Resolve(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_possible_child, ResolveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::Resolve", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("possible_child"), in_possible_child,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_Resolve_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_possible_child, &params->possible_child, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->possible_child),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid possible_child in FileSystemAccessDirectoryHandle.Resolve request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Resolve");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDirectoryHandleProxy::Transfer(
    ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDirectoryHandle::Transfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_Transfer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessDirectoryHandle.Transfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Transfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetPermissionStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::GetPermissionStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RequestPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::RequestPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::RequestPermissionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_status));
  return true;
}

void FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RequestPermissionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RequestPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::GetFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> in_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> p_file{};
  FileSystemAccessDirectoryHandle_GetFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_file =
        input_data_view.TakeFile<decltype(p_file)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_file));
  return true;
}

void FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileHandleInterfaceBase>>(
      in_file, &params->file, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetDirectoryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::GetDirectoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> in_directory);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::GetDirectoryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> p_directory{};
  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  return true;
}

void FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetDirectoryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_GetDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
      in_directory, &params->directory, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetDirectoryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetDirectory");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_Remove_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RemoveCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_Remove_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_Remove_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_Remove_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_Remove_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_Remove_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::RemoveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_Remove_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_Remove_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::RemoveCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessDirectoryHandle_Remove_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void FileSystemAccessDirectoryHandle_Remove_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RemoveCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_Remove_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RemoveCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Remove");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RemoveEntryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::RemoveEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_RemoveEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RemoveEntry");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::ResolveCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDirectoryHandle::ResolveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, const absl::optional<std::vector<std::string>>& in_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder);
};

bool FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDirectoryHandle::ResolveCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  absl::optional<std::vector<std::string>> p_path{};
  FileSystemAccessDirectoryHandle_Resolve_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_path));
  return true;
}

void FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, const absl::optional<std::vector<std::string>>& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::ResolveCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const absl::optional<std::vector<std::string>>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessDirectoryHandle_Resolve_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType>
      path_fragment(params.message());
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_path, path_fragment, &path_validate_params);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::ResolveCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Resolve");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessDirectoryHandleStubDispatch::Accept(
    FileSystemAccessDirectoryHandle* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_RequestPermission_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_GetFile_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_GetDirectory_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_GetEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> p_listener{};
      FileSystemAccessDirectoryHandle_GetEntries_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntries(
std::move(p_listener));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_Remove_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_RemoveEntry_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_Resolve_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_Transfer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::Transfer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::Transfer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessDirectoryHandle_Transfer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transfer(
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessDirectoryHandleStubDispatch::AcceptWithResponder(
    FileSystemAccessDirectoryHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 0, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::GetPermissionStatusCallback callback =
          FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_RequestPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      FileSystemAccessDirectoryHandle_RequestPermission_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 1, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::RequestPermissionCallback callback =
          FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_GetFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_basename{};
      bool p_create{};
      FileSystemAccessDirectoryHandle_GetFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_create = input_data_view.create();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 2, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::GetFileCallback callback =
          FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFile(
std::move(p_basename), 
std::move(p_create), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_GetDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_basename{};
      bool p_create{};
      FileSystemAccessDirectoryHandle_GetDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_create = input_data_view.create();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 3, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::GetDirectoryCallback callback =
          FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectory(
std::move(p_basename), 
std::move(p_create), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_GetEntries_Name: {
      break;
    }
    case internal::kFileSystemAccessDirectoryHandle_Remove_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::Remove",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::Remove");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_Remove_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_Remove_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_recurse{};
      FileSystemAccessDirectoryHandle_Remove_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_recurse = input_data_view.recurse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 5, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::RemoveCallback callback =
          FileSystemAccessDirectoryHandle_Remove_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(
std::move(p_recurse), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_RemoveEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_basename{};
      bool p_recurse{};
      FileSystemAccessDirectoryHandle_RemoveEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_recurse = input_data_view.recurse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 6, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::RemoveEntryCallback callback =
          FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveEntry(
std::move(p_basename), 
std::move(p_recurse), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_Resolve_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::Resolve",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDirectoryHandle::Resolve");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_possible_child{};
      FileSystemAccessDirectoryHandle_Resolve_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_possible_child =
            input_data_view.TakePossibleChild<decltype(p_possible_child)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 7, false);
        return false;
      }
      FileSystemAccessDirectoryHandle::ResolveCallback callback =
          FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resolve(
std::move(p_possible_child), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDirectoryHandle_Transfer_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessDirectoryHandleValidationInfo[] = {
    {&internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FileSystemAccessDirectoryHandle_Remove_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessDirectoryHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessDirectoryHandle::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessDirectoryHandleValidationInfo);
}

bool FileSystemAccessDirectoryHandleResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessDirectoryHandle::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFileSystemAccessDirectoryHandleValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FileSystemAccessEntry::DataView, ::blink::mojom::FileSystemAccessEntryPtr>::Read(
    ::blink::mojom::FileSystemAccessEntry::DataView input,
    ::blink::mojom::FileSystemAccessEntryPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessEntryPtr result(::blink::mojom::FileSystemAccessEntry::New());
  
      if (success && !input.ReadEntryHandle(&result->entry_handle))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::FileSystemAccessHandle::DataView, ::blink::mojom::FileSystemAccessHandlePtr>::Read(
    ::blink::mojom::FileSystemAccessHandle::DataView input,
    ::blink::mojom::FileSystemAccessHandlePtr* output) {
  using UnionType = ::blink::mojom::FileSystemAccessHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::FILE: {
      *output = UnionType::NewFile(
          input.TakeFile<::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>>());
      break;
    }
    case Tag::DIRECTORY: {
      *output = UnionType::NewDirectory(
          input.TakeDirectory<::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>());
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif