// third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_WRITER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_WRITER_MOJOM_JUMBO_H_
#endif


namespace blink {
namespace mojom {


void FileSystemAccessFileWriterInterceptorForTesting::Write(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, WriteCallback callback) {
  GetForwardingInterface()->Write(std::move(offset), std::move(stream), std::move(callback));
}
void FileSystemAccessFileWriterInterceptorForTesting::Truncate(uint64_t length, TruncateCallback callback) {
  GetForwardingInterface()->Truncate(std::move(length), std::move(callback));
}
void FileSystemAccessFileWriterInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
void FileSystemAccessFileWriterInterceptorForTesting::Abort(AbortCallback callback) {
  GetForwardingInterface()->Abort(std::move(callback));
}
FileSystemAccessFileWriterAsyncWaiter::FileSystemAccessFileWriterAsyncWaiter(
    FileSystemAccessFileWriter* proxy) : proxy_(proxy) {}

FileSystemAccessFileWriterAsyncWaiter::~FileSystemAccessFileWriterAsyncWaiter() = default;

void FileSystemAccessFileWriterAsyncWaiter::Write(
    uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, ::blink::mojom::FileSystemAccessErrorPtr* out_result, uint64_t* out_bytes_written) {
  base::RunLoop loop;
  proxy_->Write(std::move(offset),std::move(stream),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             uint64_t* out_bytes_written
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             uint64_t bytes_written) {*out_result = std::move(result);*out_bytes_written = std::move(bytes_written);
            loop->Quit();
          },
          &loop,
          out_result,
          out_bytes_written));
  loop.Run();
}
void FileSystemAccessFileWriterAsyncWaiter::Truncate(
    uint64_t length, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Truncate(std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void FileSystemAccessFileWriterAsyncWaiter::Close(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void FileSystemAccessFileWriterAsyncWaiter::Abort(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Abort(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}





}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif