// third_party/blink/public/mojom/frame/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_JUMBO_H_
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#include "third_party/blink/public/common/messaging/transferable_message_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
SavableSubframe::SavableSubframe()
    : original_url(),
      subframe_token() {}

SavableSubframe::SavableSubframe(
    const ::GURL& original_url_in,
    const ::blink::FrameToken& subframe_token_in)
    : original_url(std::move(original_url_in)),
      subframe_token(std::move(subframe_token_in)) {}

SavableSubframe::~SavableSubframe() = default;

void SavableSubframe::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_url"), this->original_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframe_token"), this->subframe_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SavableSubframe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetSavableResourceLinksReply::GetSavableResourceLinksReply()
    : resources_list(),
      referrer(),
      subframes() {}

GetSavableResourceLinksReply::GetSavableResourceLinksReply(
    std::vector<::GURL> resources_list_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    std::vector<SavableSubframePtr> subframes_in)
    : resources_list(std::move(resources_list_in)),
      referrer(std::move(referrer_in)),
      subframes(std::move(subframes_in)) {}

GetSavableResourceLinksReply::~GetSavableResourceLinksReply() = default;

void GetSavableResourceLinksReply::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources_list"), this->resources_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframes"), this->subframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SavableSubframePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetSavableResourceLinksReply::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FindInPageResultAXParams::FindInPageResultAXParams()
    : request_id(),
      match_index(),
      start_id(),
      start_offset(),
      end_id(),
      end_offset() {}

FindInPageResultAXParams::FindInPageResultAXParams(
    int32_t request_id_in,
    int32_t match_index_in,
    int32_t start_id_in,
    int32_t start_offset_in,
    int32_t end_id_in,
    int32_t end_offset_in)
    : request_id(std::move(request_id_in)),
      match_index(std::move(match_index_in)),
      start_id(std::move(start_id_in)),
      start_offset(std::move(start_offset_in)),
      end_id(std::move(end_id_in)),
      end_offset(std::move(end_offset_in)) {}

FindInPageResultAXParams::~FindInPageResultAXParams() = default;
size_t FindInPageResultAXParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->request_id);
  seed = mojo::internal::Hash(seed, this->match_index);
  seed = mojo::internal::Hash(seed, this->start_id);
  seed = mojo::internal::Hash(seed, this->start_offset);
  seed = mojo::internal::Hash(seed, this->end_id);
  seed = mojo::internal::Hash(seed, this->end_offset);
  return seed;
}

void FindInPageResultAXParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_index"), this->match_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_id"), this->start_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_offset"), this->start_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_id"), this->end_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_offset"), this->end_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FindInPageResultAXParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DownloadURLParams::DownloadURLParams()
    : url(),
      referrer(),
      initiator_origin(),
      suggested_name(),
      cross_origin_redirects(),
      blob_url_token(),
      data_url_blob(),
      is_context_menu_save(false),
      has_user_gesture(false) {}

DownloadURLParams::DownloadURLParams(
    const ::GURL& url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    const absl::optional<::url::Origin>& initiator_origin_in,
    const absl::optional<::std::u16string>& suggested_name_in,
    ::network::mojom::RedirectMode cross_origin_redirects_in,
    ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token_in,
    ::mojo::PendingRemote<::blink::mojom::Blob> data_url_blob_in,
    bool is_context_menu_save_in,
    bool has_user_gesture_in)
    : url(std::move(url_in)),
      referrer(std::move(referrer_in)),
      initiator_origin(std::move(initiator_origin_in)),
      suggested_name(std::move(suggested_name_in)),
      cross_origin_redirects(std::move(cross_origin_redirects_in)),
      blob_url_token(std::move(blob_url_token_in)),
      data_url_blob(std::move(data_url_blob_in)),
      is_context_menu_save(std::move(is_context_menu_save_in)),
      has_user_gesture(std::move(has_user_gesture_in)) {}

DownloadURLParams::~DownloadURLParams() = default;

void DownloadURLParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggested_name"), this->suggested_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_redirects"), this->cross_origin_redirects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RedirectMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob_url_token"), this->blob_url_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_url_blob"), this->data_url_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_context_menu_save"), this->is_context_menu_save,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DownloadURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenURLParams::OpenURLParams()
    : url(),
      initiator_origin(),
      initiator_frame_token(),
      post_body(),
      extra_headers(),
      referrer(),
      disposition(),
      should_replace_current_entry(),
      user_gesture(),
      triggering_event_info(),
      blob_url_token(),
      href_translate(),
      impression(),
      download_policy(),
      source_location(),
      initiator_policy_container_keep_alive_handle() {}

OpenURLParams::OpenURLParams(
    const ::GURL& url_in,
    const ::url::Origin& initiator_origin_in,
    const absl::optional<::blink::LocalFrameToken>& initiator_frame_token_in,
    ::scoped_refptr<::network::ResourceRequestBody> post_body_in,
    const std::string& extra_headers_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::WindowOpenDisposition disposition_in,
    bool should_replace_current_entry_in,
    bool user_gesture_in,
    ::blink::mojom::TriggeringEventInfo triggering_event_info_in,
    ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token_in,
    const std::string& href_translate_in,
    const absl::optional<::blink::Impression>& impression_in,
    const ::blink::NavigationDownloadPolicy& download_policy_in,
    ::network::mojom::SourceLocationPtr source_location_in,
    ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle> initiator_policy_container_keep_alive_handle_in)
    : url(std::move(url_in)),
      initiator_origin(std::move(initiator_origin_in)),
      initiator_frame_token(std::move(initiator_frame_token_in)),
      post_body(std::move(post_body_in)),
      extra_headers(std::move(extra_headers_in)),
      referrer(std::move(referrer_in)),
      disposition(std::move(disposition_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      user_gesture(std::move(user_gesture_in)),
      triggering_event_info(std::move(triggering_event_info_in)),
      blob_url_token(std::move(blob_url_token_in)),
      href_translate(std::move(href_translate_in)),
      impression(std::move(impression_in)),
      download_policy(std::move(download_policy_in)),
      source_location(std::move(source_location_in)),
      initiator_policy_container_keep_alive_handle(std::move(initiator_policy_container_keep_alive_handle_in)) {}

OpenURLParams::~OpenURLParams() = default;

void OpenURLParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_frame_token"), this->initiator_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::LocalFrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_body"), this->post_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_headers"), this->extra_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disposition"), this->disposition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::WindowOpenDisposition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_current_entry"), this->should_replace_current_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "triggering_event_info"), this->triggering_event_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::TriggeringEventInfo>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob_url_token"), this->blob_url_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "href_translate"), this->href_translate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::Impression>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_policy"), this->download_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::NavigationDownloadPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_location"), this->source_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::SourceLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_policy_container_keep_alive_handle"), this->initiator_policy_container_keep_alive_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OpenURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char KeepAliveHandle::Name_[] = "blink.mojom.KeepAliveHandle";

KeepAliveHandleProxy::KeepAliveHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool KeepAliveHandleStubDispatch::Accept(
    KeepAliveHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool KeepAliveHandleStubDispatch::AcceptWithResponder(
    KeepAliveHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool KeepAliveHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::KeepAliveHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char KeepAliveHandleFactory::Name_[] = "blink.mojom.KeepAliveHandleFactory";

KeepAliveHandleFactoryProxy::KeepAliveHandleFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void KeepAliveHandleFactoryProxy::IssueKeepAliveHandle(
    ::mojo::PendingReceiver<KeepAliveHandle> in_keep_alive_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::KeepAliveHandleFactory::IssueKeepAliveHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_alive_handle"), in_keep_alive_handle,
                        "<value of type ::mojo::PendingReceiver<KeepAliveHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kKeepAliveHandleFactory_IssueKeepAliveHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::KeepAliveHandleInterfaceBase>>(
      in_keep_alive_handle, &params->keep_alive_handle, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->keep_alive_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid keep_alive_handle in KeepAliveHandleFactory.IssueKeepAliveHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeepAliveHandleFactory::Name_);
  message.set_method_name("IssueKeepAliveHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool KeepAliveHandleFactoryStubDispatch::Accept(
    KeepAliveHandleFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kKeepAliveHandleFactory_IssueKeepAliveHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::KeepAliveHandleFactory::IssueKeepAliveHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::KeepAliveHandleFactory::IssueKeepAliveHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data* params =
          reinterpret_cast<internal::KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<KeepAliveHandle> p_keep_alive_handle{};
      KeepAliveHandleFactory_IssueKeepAliveHandle_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_keep_alive_handle =
            input_data_view.TakeKeepAliveHandle<decltype(p_keep_alive_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeepAliveHandleFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueKeepAliveHandle(
std::move(p_keep_alive_handle));
      return true;
    }
  }
  return false;
}

// static
bool KeepAliveHandleFactoryStubDispatch::AcceptWithResponder(
    KeepAliveHandleFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kKeepAliveHandleFactory_IssueKeepAliveHandle_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kKeepAliveHandleFactoryValidationInfo[] = {
    {internal::kKeepAliveHandleFactory_IssueKeepAliveHandle_Name,
     {&internal::KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data::Validate,
      nullptr /* no response */}},
};

bool KeepAliveHandleFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::KeepAliveHandleFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kKeepAliveHandleFactoryValidationInfo);
}

const char LocalFrameHost::Name_[] = "blink.mojom.LocalFrameHost";
bool LocalFrameHost::RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion) {
  NOTREACHED();
  return false;
}
bool LocalFrameHost::RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success) {
  NOTREACHED();
  return false;
}
bool LocalFrameHost::RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::std::u16string* out_result) {
  NOTREACHED();
  return false;
}
bool LocalFrameHost::RunBeforeUnloadConfirm(bool is_reload, bool* out_success) {
  NOTREACHED();
  return false;
}

class LocalFrameHost_EnterFullscreen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_EnterFullscreen_ForwardToCallback(
      LocalFrameHost::EnterFullscreenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::EnterFullscreenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_EnterFullscreen_ForwardToCallback);
};
class LocalFrameHost_RunModalAlertDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalAlertDialog_HandleSyncResponse);
};

class LocalFrameHost_RunModalAlertDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalAlertDialog_ForwardToCallback(
      LocalFrameHost::RunModalAlertDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalAlertDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalAlertDialog_ForwardToCallback);
};
class LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse);
};

class LocalFrameHost_RunModalConfirmDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(
      LocalFrameHost::RunModalConfirmDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalConfirmDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalConfirmDialog_ForwardToCallback);
};
class LocalFrameHost_RunModalPromptDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(
      bool* result, bool* out_success, ::std::u16string* out_result)
      : result_(result), out_success_(out_success), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  ::std::u16string* out_result_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalPromptDialog_HandleSyncResponse);
};

class LocalFrameHost_RunModalPromptDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalPromptDialog_ForwardToCallback(
      LocalFrameHost::RunModalPromptDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalPromptDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalPromptDialog_ForwardToCallback);
};
class LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse);
};

class LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(
      LocalFrameHost::RunBeforeUnloadConfirmCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunBeforeUnloadConfirmCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback);
};

LocalFrameHostProxy::LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameHostProxy::EnterFullscreen(
    ::blink::mojom::FullscreenOptionsPtr in_options, EnterFullscreenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::EnterFullscreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnterFullscreen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnterFullscreen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in LocalFrameHost.EnterFullscreen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnterFullscreen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_EnterFullscreen_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::ExitFullscreen(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::ExitFullscreen");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_ExitFullscreen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ExitFullscreen_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ExitFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::FullscreenStateChanged(
    bool in_is_fullscreen, ::blink::mojom::FullscreenOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::FullscreenStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_fullscreen"), in_is_fullscreen,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_FullscreenStateChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_FullscreenStateChanged_Params_Data> params(
          message);
  params.Allocate();
  params->is_fullscreen = in_is_fullscreen;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FullscreenStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::RegisterProtocolHandler(
    const std::string& in_scheme, const ::GURL& in_url, bool in_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RegisterProtocolHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scheme"), in_scheme,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RegisterProtocolHandler_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RegisterProtocolHandler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scheme)::BaseType> scheme_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme, scheme_fragment);
  params->scheme.Set(
      scheme_fragment.is_null() ? nullptr : scheme_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scheme.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in LocalFrameHost.RegisterProtocolHandler request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.RegisterProtocolHandler request");
  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RegisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::UnregisterProtocolHandler(
    const std::string& in_scheme, const ::GURL& in_url, bool in_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UnregisterProtocolHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scheme"), in_scheme,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_UnregisterProtocolHandler_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scheme)::BaseType> scheme_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme, scheme_fragment);
  params->scheme.Set(
      scheme_fragment.is_null() ? nullptr : scheme_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scheme.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in LocalFrameHost.UnregisterProtocolHandler request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.UnregisterProtocolHandler request");
  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UnregisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidDisplayInsecureContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidDisplayInsecureContent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidDisplayInsecureContent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidDisplayInsecureContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidContainInsecureFormAction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidContainInsecureFormAction");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidContainInsecureFormAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidContainInsecureFormAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DocumentAvailableInMainFrame(
    bool in_uses_temporary_zoom_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DocumentAvailableInMainFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uses_temporary_zoom_level"), in_uses_temporary_zoom_level,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data> params(
          message);
  params.Allocate();
  params->uses_temporary_zoom_level = in_uses_temporary_zoom_level;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DocumentAvailableInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SetNeedsOcclusionTracking(
    bool in_needs_tracking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_tracking"), in_needs_tracking,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data> params(
          message);
  params.Allocate();
  params->needs_tracking = in_needs_tracking;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetNeedsOcclusionTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SetVirtualKeyboardOverlayPolicy(
    bool in_vk_overlays_content) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SetVirtualKeyboardOverlayPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vk_overlays_content"), in_vk_overlays_content,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data> params(
          message);
  params.Allocate();
  params->vk_overlays_content = in_vk_overlays_content;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetVirtualKeyboardOverlayPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::VisibilityChanged(
    ::blink::mojom::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::VisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type ::blink::mojom::FrameVisibility>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_VisibilityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_VisibilityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
      in_visibility, &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("VisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeThemeColor(
    absl::optional<::SkColor> in_theme_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeThemeColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme_color"), in_theme_color,
                        "<value of type absl::optional<::SkColor>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeThemeColor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeThemeColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme_color)::BaseType> theme_color_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_theme_color, theme_color_fragment);
  params->theme_color.Set(
      theme_color_fragment.is_null() ? nullptr : theme_color_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeThemeColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeBackgroundColor(
    ::SkColor in_background_color, bool in_color_adjust) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("background_color"), in_background_color,
                        "<value of type ::SkColor>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_adjust"), in_color_adjust,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeBackgroundColor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->background_color)::BaseType> background_color_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color, background_color_fragment);
  params->background_color.Set(
      background_color_fragment.is_null() ? nullptr : background_color_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->background_color.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in LocalFrameHost.DidChangeBackgroundColor request");
  params->color_adjust = in_color_adjust;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFailLoadWithError(
    const ::GURL& in_url, int32_t in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidFailLoadWithError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFailLoadWithError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFailLoadWithError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.DidFailLoadWithError request");
  params->error_code = in_error_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFailLoadWithError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFocusFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidFocusFrame");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFocusFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFocusFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFocusFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidCallFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidCallFocus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidCallFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidCallFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidCallFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::EnforceInsecureRequestPolicy(
    ::blink::mojom::InsecureRequestPolicy in_policy_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_bitmap"), in_policy_bitmap,
                        "<value of type ::blink::mojom::InsecureRequestPolicy>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
      in_policy_bitmap, &params->policy_bitmap);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnforceInsecureRequestPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::EnforceInsecureNavigationsSet(
    const std::vector<uint32_t>& in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type const std::vector<uint32_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType>
      set_fragment(params.message());
  const mojo::internal::ContainerValidateParams set_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_set, set_fragment, &set_validate_params);
  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->set.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null set in LocalFrameHost.EnforceInsecureNavigationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnforceInsecureNavigationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeActiveSchedulerTrackedFeatures(
    uint64_t in_features_mask) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeActiveSchedulerTrackedFeatures", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features_mask"), in_features_mask,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data> params(
          message);
  params.Allocate();
  params->features_mask = in_features_mask;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeActiveSchedulerTrackedFeatures");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SuddenTerminationDisablerChanged(
    bool in_present, ::blink::mojom::SuddenTerminationDisablerType in_disabler_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("present"), in_present,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disabler_type"), in_disabler_type,
                        "<value of type ::blink::mojom::SuddenTerminationDisablerType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data> params(
          message);
  params.Allocate();
  params->present = in_present;
  mojo::internal::Serialize<::blink::mojom::SuddenTerminationDisablerType>(
      in_disabler_type, &params->disabler_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SuddenTerminationDisablerChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::HadStickyUserActivationBeforeNavigationChanged(
    bool in_has_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gesture"), in_has_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data> params(
          message);
  params.Allocate();
  params->has_gesture = in_has_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HadStickyUserActivationBeforeNavigationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ScrollRectToVisibleInParentFrame(
    const ::gfx::Rect& in_rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect_to_scroll"), in_rect_to_scroll,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::ScrollIntoViewParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect_to_scroll)::BaseType> rect_to_scroll_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect_to_scroll, rect_to_scroll_fragment);
  params->rect_to_scroll.Set(
      rect_to_scroll_fragment.is_null() ? nullptr : rect_to_scroll_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect_to_scroll.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect_to_scroll in LocalFrameHost.ScrollRectToVisibleInParentFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ScrollIntoViewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.ScrollRectToVisibleInParentFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ScrollRectToVisibleInParentFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::BubbleLogicalScrollInParentFrame(
    ::blink::mojom::ScrollDirection in_direction, ::ui::ScrollGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type ::blink::mojom::ScrollDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type ::ui::ScrollGranularity>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ScrollDirection>(
      in_direction, &params->direction);
  mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
      in_granularity, &params->granularity);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("BubbleLogicalScrollInParentFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidAccessInitialDocument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidAccessInitialDocument");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidAccessInitialDocument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidAccessInitialDocument_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidAccessInitialDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidBlockNavigation(
    const ::GURL& in_blocked_url, const ::GURL& in_initiator_url, ::blink::mojom::NavigationBlockedReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidBlockNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_url"), in_initiator_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::blink::mojom::NavigationBlockedReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidBlockNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidBlockNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_blocked_url, blocked_url_fragment);
  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->blocked_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blocked_url in LocalFrameHost.DidBlockNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_url)::BaseType> initiator_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_initiator_url, initiator_url_fragment);
  params->initiator_url.Set(
      initiator_url_fragment.is_null() ? nullptr : initiator_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initiator_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_url in LocalFrameHost.DidBlockNavigation request");
  mojo::internal::Serialize<::blink::mojom::NavigationBlockedReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidBlockNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeLoadProgress(
    double in_load_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeLoadProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_progress"), in_load_progress,
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeLoadProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeLoadProgress_Params_Data> params(
          message);
  params.Allocate();
  params->load_progress = in_load_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeLoadProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFinishLoad(
    const ::GURL& in_validated_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidFinishLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("validated_url"), in_validated_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFinishLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFinishLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->validated_url)::BaseType> validated_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_validated_url, validated_url_fragment);
  params->validated_url.Set(
      validated_url_fragment.is_null() ? nullptr : validated_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->validated_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null validated_url in LocalFrameHost.DidFinishLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFinishLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DispatchLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DispatchLoad");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DispatchLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DispatchLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DispatchLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::GoToEntryAtOffset(
    int32_t in_offset, bool in_has_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::GoToEntryAtOffset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_GoToEntryAtOffset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_GoToEntryAtOffset_Params_Data> params(
          message);
  params.Allocate();
  params->offset = in_offset;
  params->has_user_gesture = in_has_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GoToEntryAtOffset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::NavigateToAppHistoryKey(
    const std::string& in_key, bool in_has_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::NavigateToAppHistoryKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_NavigateToAppHistoryKey_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_NavigateToAppHistoryKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in LocalFrameHost.NavigateToAppHistoryKey request");
  params->has_user_gesture = in_has_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("NavigateToAppHistoryKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::UpdateTitle(
    const absl::optional<::std::u16string>& in_title, ::base::i18n::TextDirection in_title_direction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UpdateTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const absl::optional<::std::u16string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title_direction"), in_title_direction,
                        "<value of type ::base::i18n::TextDirection>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_UpdateTitle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title, title_fragment);
  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      in_title_direction, &params->title_direction);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::UpdateUserActivationState(
    ::blink::mojom::UserActivationUpdateType in_update_type, ::blink::mojom::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UpdateUserActivationState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type ::blink::mojom::UserActivationUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_type"), in_notification_type,
                        "<value of type ::blink::mojom::UserActivationNotificationType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_UpdateUserActivationState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateUserActivationState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::UserActivationUpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
      in_notification_type, &params->notification_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateUserActivationState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::HandleAccessibilityFindInPageResult(
    FindInPageResultAXParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type FindInPageResultAXParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FindInPageResultAXParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.HandleAccessibilityFindInPageResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HandleAccessibilityFindInPageResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::HandleAccessibilityFindInPageTermination(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HandleAccessibilityFindInPageTermination");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DocumentOnLoadCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DocumentOnLoadCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DocumentOnLoadCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DocumentOnLoadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ForwardResourceTimingToParent(
    ::blink::mojom::ResourceTimingInfoPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ForwardResourceTimingToParent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ::blink::mojom::ResourceTimingInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_ForwardResourceTimingToParent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in LocalFrameHost.ForwardResourceTimingToParent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ForwardResourceTimingToParent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFinishDocumentLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidFinishDocumentLoad");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFinishDocumentLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFinishDocumentLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool LocalFrameHostProxy::RunModalAlertDialog(
    const ::std::u16string& param_alert_message, bool param_disable_third_party_subframe_suppresion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), param_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), param_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalAlertDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_alert_message, alert_message_fragment);
  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalAlertDialog request");
  params->disable_third_party_subframe_suppresion = param_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialog");
#endif
  return result;
}

void LocalFrameHostProxy::RunModalAlertDialog(
    const ::std::u16string& in_alert_message, bool in_disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), in_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), in_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalAlertDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_alert_message, alert_message_fragment);
  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalAlertDialog request");
  params->disable_third_party_subframe_suppresion = in_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalAlertDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool LocalFrameHostProxy::RunModalConfirmDialog(
    const ::std::u16string& param_alert_message, bool param_disable_third_party_subframe_suppresion, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), param_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), param_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalConfirmDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_alert_message, alert_message_fragment);
  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalConfirmDialog request");
  params->disable_third_party_subframe_suppresion = param_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialog", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void LocalFrameHostProxy::RunModalConfirmDialog(
    const ::std::u16string& in_alert_message, bool in_disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), in_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), in_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalConfirmDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_alert_message, alert_message_fragment);
  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalConfirmDialog request");
  params->disable_third_party_subframe_suppresion = in_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool LocalFrameHostProxy::RunModalPromptDialog(
    const ::std::u16string& param_alert_message, const ::std::u16string& param_default_value, bool param_disable_third_party_subframe_suppresion, bool* out_param_success, ::std::u16string* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), param_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_value"), param_default_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), param_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalPromptDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_alert_message, alert_message_fragment);
  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalPromptDialog request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_value)::BaseType> default_value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_default_value, default_value_fragment);
  params->default_value.Set(
      default_value_fragment.is_null() ? nullptr : default_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_value in LocalFrameHost.RunModalPromptDialog request");
  params->disable_third_party_subframe_suppresion = param_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(
          &result, out_param_success, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialog", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::std::u16string&>");
   });
#endif
  return result;
}

void LocalFrameHostProxy::RunModalPromptDialog(
    const ::std::u16string& in_alert_message, const ::std::u16string& in_default_value, bool in_disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_message"), in_alert_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_value"), in_default_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disable_third_party_subframe_suppresion"), in_disable_third_party_subframe_suppresion,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalPromptDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->alert_message)::BaseType> alert_message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_alert_message, alert_message_fragment);
  params->alert_message.Set(
      alert_message_fragment.is_null() ? nullptr : alert_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalPromptDialog request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_value)::BaseType> default_value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_default_value, default_value_fragment);
  params->default_value.Set(
      default_value_fragment.is_null() ? nullptr : default_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_value in LocalFrameHost.RunModalPromptDialog request");
  params->disable_third_party_subframe_suppresion = in_disable_third_party_subframe_suppresion;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalPromptDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool LocalFrameHostProxy::RunBeforeUnloadConfirm(
    bool param_is_reload, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), param_is_reload,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data> params(
          message);
  params.Allocate();
  params->is_reload = param_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void LocalFrameHostProxy::RunBeforeUnloadConfirm(
    bool in_is_reload, RunBeforeUnloadConfirmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), in_is_reload,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data> params(
          message);
  params.Allocate();
  params->is_reload = in_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::UpdateFaviconURL(
    std::vector<::blink::mojom::FaviconURLPtr> in_favicon_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UpdateFaviconURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("favicon_urls"), in_favicon_urls,
                        "<value of type std::vector<::blink::mojom::FaviconURLPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_UpdateFaviconURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_UpdateFaviconURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->favicon_urls)::BaseType>
      favicon_urls_fragment(params.message());
  const mojo::internal::ContainerValidateParams favicon_urls_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FaviconURLDataView>>(
      in_favicon_urls, favicon_urls_fragment, &favicon_urls_validate_params);
  params->favicon_urls.Set(
      favicon_urls_fragment.is_null() ? nullptr : favicon_urls_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->favicon_urls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_urls in LocalFrameHost.UpdateFaviconURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateFaviconURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DownloadURL(
    DownloadURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DownloadURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DownloadURLParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DownloadURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DownloadURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DownloadURLParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.DownloadURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DownloadURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::FocusedElementChanged(
    bool in_is_editable_element, const ::gfx::Rect& in_bounds_in_frame_widget, ::blink::mojom::FocusType in_focus_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::FocusedElementChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_editable_element"), in_is_editable_element,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds_in_frame_widget"), in_bounds_in_frame_widget,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_FocusedElementChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_FocusedElementChanged_Params_Data> params(
          message);
  params.Allocate();
  params->is_editable_element = in_is_editable_element;
  mojo::internal::MessageFragment<
      typename decltype(params->bounds_in_frame_widget)::BaseType> bounds_in_frame_widget_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds_in_frame_widget, bounds_in_frame_widget_fragment);
  params->bounds_in_frame_widget.Set(
      bounds_in_frame_widget_fragment.is_null() ? nullptr : bounds_in_frame_widget_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds_in_frame_widget.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds_in_frame_widget in LocalFrameHost.FocusedElementChanged request");
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FocusedElementChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::TextSelectionChanged(
    const ::std::u16string& in_text, uint32_t in_offset, const ::gfx::Range& in_range, bool in_user_initiated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::TextSelectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_initiated"), in_user_initiated,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_TextSelectionChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_TextSelectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in LocalFrameHost.TextSelectionChanged request");
  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
      in_range, range_fragment);
  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null range in LocalFrameHost.TextSelectionChanged request");
  params->user_initiated = in_user_initiated;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("TextSelectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ShowPopupMenu(
    ::mojo::PendingRemote<::blink::mojom::PopupMenuClient> in_popup_client, const ::gfx::Rect& in_bounds, int32_t in_item_height, double in_font_size, int32_t in_selected_item, std::vector<::blink::mojom::MenuItemPtr> in_menu_items, bool in_right_aligned, bool in_allow_multiple_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ShowPopupMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_client"), in_popup_client,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::PopupMenuClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item_height"), in_item_height,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_item"), in_selected_item,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu_items"), in_menu_items,
                        "<value of type std::vector<::blink::mojom::MenuItemPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_aligned"), in_right_aligned,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_multiple_selection"), in_allow_multiple_selection,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_ShowPopupMenu_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ShowPopupMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PopupMenuClientInterfaceBase>>(
      in_popup_client, &params->popup_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->popup_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid popup_client in LocalFrameHost.ShowPopupMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in LocalFrameHost.ShowPopupMenu request");
  params->item_height = in_item_height;
  params->font_size = in_font_size;
  params->selected_item = in_selected_item;
  mojo::internal::MessageFragment<
      typename decltype(params->menu_items)::BaseType>
      menu_items_fragment(params.message());
  const mojo::internal::ContainerValidateParams menu_items_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>>(
      in_menu_items, menu_items_fragment, &menu_items_validate_params);
  params->menu_items.Set(
      menu_items_fragment.is_null() ? nullptr : menu_items_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->menu_items.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null menu_items in LocalFrameHost.ShowPopupMenu request");
  params->right_aligned = in_right_aligned;
  params->allow_multiple_selection = in_allow_multiple_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ShowPopupMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::CreateNewPopupWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> in_popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> in_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> in_blink_widget) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::CreateNewPopupWidget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_host"), in_popup_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blink_widget_host"), in_blink_widget_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blink_widget"), in_blink_widget,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::Widget>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_CreateNewPopupWidget_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_CreateNewPopupWidget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PopupWidgetHostAssociatedRequestDataView>(
      in_popup_host, &params->popup_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->popup_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid popup_host in LocalFrameHost.CreateNewPopupWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      in_blink_widget_host, &params->blink_widget_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget_host in LocalFrameHost.CreateNewPopupWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      in_blink_widget, &params->blink_widget, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget in LocalFrameHost.CreateNewPopupWidget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("CreateNewPopupWidget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ShowContextMenu(
    ::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> in_client, const ::blink::UntrustworthyContextMenuParams& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::blink::UntrustworthyContextMenuParams&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_ShowContextMenu_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ContextMenuClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in LocalFrameHost.ShowContextMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::UntrustworthyContextMenuParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.ShowContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidLoadResourceFromMemoryCache(
    const ::GURL& in_url, const std::string& in_http_method, const std::string& in_mime_type, ::network::mojom::RequestDestination in_request_destination) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_method"), in_http_method,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_destination"), in_request_destination,
                        "<value of type ::network::mojom::RequestDestination>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->http_method)::BaseType> http_method_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_http_method, http_method_fragment);
  params->http_method.Set(
      http_method_fragment.is_null() ? nullptr : http_method_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_method in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
      in_request_destination, &params->request_destination);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidLoadResourceFromMemoryCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeFrameOwnerProperties(
    const ::blink::FrameToken& in_child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr in_frame_owner_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_owner_properties"), in_frame_owner_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_child_frame_token, child_frame_token_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_token in LocalFrameHost.DidChangeFrameOwnerProperties request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_owner_properties)::BaseType> frame_owner_properties_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_frame_owner_properties, frame_owner_properties_fragment);
  params->frame_owner_properties.Set(
      frame_owner_properties_fragment.is_null() ? nullptr : frame_owner_properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_owner_properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_owner_properties in LocalFrameHost.DidChangeFrameOwnerProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeOpener(
    const absl::optional<::blink::LocalFrameToken>& in_opener_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame"), in_opener_frame,
                        "<value of type const absl::optional<::blink::LocalFrameToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeOpener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->opener_frame)::BaseType> opener_frame_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_opener_frame, opener_frame_fragment);
  params->opener_frame.Set(
      opener_frame_fragment.is_null() ? nullptr : opener_frame_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeFramePolicy(
    const ::blink::FrameToken& in_child_frame_token, const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeFramePolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_child_frame_token, child_frame_token_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_token in LocalFrameHost.DidChangeFramePolicy request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, frame_policy_fragment);
  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in LocalFrameHost.DidChangeFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeIframeAttributes(
    const ::blink::FrameToken& in_child_frame_token, ::network::mojom::ContentSecurityPolicyPtr in_parsed_csp_attribute, bool in_anonymous) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeIframeAttributes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_csp_attribute"), in_parsed_csp_attribute,
                        "<value of type ::network::mojom::ContentSecurityPolicyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anonymous"), in_anonymous,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeIframeAttributes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->child_frame_token)>
      child_frame_token_fragment(params.message());
  child_frame_token_fragment.Claim(&params->child_frame_token);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_child_frame_token, child_frame_token_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_token in LocalFrameHost.DidChangeIframeAttributes request");
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_csp_attribute)::BaseType> parsed_csp_attribute_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyDataView>(
      in_parsed_csp_attribute, parsed_csp_attribute_fragment);
  params->parsed_csp_attribute.Set(
      parsed_csp_attribute_fragment.is_null() ? nullptr : parsed_csp_attribute_fragment.data());
  params->anonymous = in_anonymous;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeIframeAttributes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::CapturePaintPreviewOfSubframe(
    const ::gfx::Rect& in_clip_rect, const ::base::UnguessableToken& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clip_rect"), in_clip_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clip_rect)::BaseType> clip_rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_clip_rect, clip_rect_fragment);
  params->clip_rect.Set(
      clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clip_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clip_rect in LocalFrameHost.CapturePaintPreviewOfSubframe request");
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_guid, guid_fragment);
  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in LocalFrameHost.CapturePaintPreviewOfSubframe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("CapturePaintPreviewOfSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SetModalCloseListener(
    ::mojo::PendingRemote<::blink::mojom::ModalCloseListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SetModalCloseListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ModalCloseListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_SetModalCloseListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_SetModalCloseListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModalCloseListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in LocalFrameHost.SetModalCloseListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetModalCloseListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::Detach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::Detach");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_Detach_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_Detach_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Detach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::GetKeepAliveHandleFactory(
    ::mojo::PendingReceiver<KeepAliveHandleFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<KeepAliveHandleFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_GetKeepAliveHandleFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::KeepAliveHandleFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in LocalFrameHost.GetKeepAliveHandleFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GetKeepAliveHandleFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidAddMessageToConsole(
    ::blink::mojom::ConsoleMessageLevel in_log_level, const ::std::u16string& in_msg, int32_t in_line_number, const absl::optional<::std::u16string>& in_source_id, const absl::optional<::std::u16string>& in_untrusted_stack_trace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidAddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_level"), in_log_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("msg"), in_msg,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const absl::optional<::std::u16string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("untrusted_stack_trace"), in_untrusted_stack_trace,
                        "<value of type const absl::optional<::std::u16string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidAddMessageToConsole_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidAddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
      in_log_level, &params->log_level);
  mojo::internal::MessageFragment<
      typename decltype(params->msg)::BaseType> msg_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_msg, msg_fragment);
  params->msg.Set(
      msg_fragment.is_null() ? nullptr : msg_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->msg.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null msg in LocalFrameHost.DidAddMessageToConsole request");
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source_id, source_id_fragment);
  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->untrusted_stack_trace)::BaseType> untrusted_stack_trace_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_untrusted_stack_trace, untrusted_stack_trace_fragment);
  params->untrusted_stack_trace.Set(
      untrusted_stack_trace_fragment.is_null() ? nullptr : untrusted_stack_trace_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidAddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::FrameSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::FrameSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_FrameSizeChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_FrameSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in LocalFrameHost.FrameSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FrameSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidUpdatePreferredColorScheme(
    ::blink::mojom::PreferredColorScheme in_preferred_color_scheme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidUpdatePreferredColorScheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferred_color_scheme"), in_preferred_color_scheme,
                        "<value of type ::blink::mojom::PreferredColorScheme>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidUpdatePreferredColorScheme_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
      in_preferred_color_scheme, &params->preferred_color_scheme);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidUpdatePreferredColorScheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalFrameHost_EnterFullscreen_ProxyToResponder {
 public:
  static LocalFrameHost::EnterFullscreenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_EnterFullscreen_ProxyToResponder> proxy(
        new LocalFrameHost_EnterFullscreen_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_EnterFullscreen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_EnterFullscreen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_EnterFullscreen_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::EnterFullscreenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_granted);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_EnterFullscreen_ProxyToResponder);
};

bool LocalFrameHost_EnterFullscreen_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::EnterFullscreenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_granted{};
  LocalFrameHost_EnterFullscreen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted = input_data_view.granted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_granted));
  return true;
}

void LocalFrameHost_EnterFullscreen_ProxyToResponder::Run(
    bool in_granted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::EnterFullscreenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted"), in_granted,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnterFullscreen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->granted = in_granted;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::EnterFullscreenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnterFullscreen");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_RunModalAlertDialog_ProxyToResponder {
 public:
  static LocalFrameHost::RunModalAlertDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunModalAlertDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalAlertDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunModalAlertDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalAlertDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunModalAlertDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunModalAlertDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalAlertDialog_ProxyToResponder);
};

bool LocalFrameHost_RunModalAlertDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialogCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalFrameHost_RunModalAlertDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalFrameHost_RunModalAlertDialog_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialogCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalAlertDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalAlertDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  LocalFrameHost_RunModalAlertDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 37, true);
    return false;
  }
  *result_ = true;
  return true;
}
class LocalFrameHost_RunModalConfirmDialog_ProxyToResponder {
 public:
  static LocalFrameHost::RunModalConfirmDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunModalConfirmDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalConfirmDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalConfirmDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunModalConfirmDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunModalConfirmDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalConfirmDialog_ProxyToResponder);
};

bool LocalFrameHost_RunModalConfirmDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialogCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunModalConfirmDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialogCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalConfirmDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunModalConfirmDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 38, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunModalPromptDialog_ProxyToResponder {
 public:
  static LocalFrameHost::RunModalPromptDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunModalPromptDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalPromptDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunModalPromptDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalPromptDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunModalPromptDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunModalPromptDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::std::u16string& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalPromptDialog_ProxyToResponder);
};

bool LocalFrameHost_RunModalPromptDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialogCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::std::u16string p_result{};
  LocalFrameHost_RunModalPromptDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_result));
  return true;
}

void LocalFrameHost_RunModalPromptDialog_ProxyToResponder::Run(
    bool in_success, const ::std::u16string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialogCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::std::u16string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalPromptDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalPromptDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::std::u16string p_result{};
  LocalFrameHost_RunModalPromptDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 39, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder {
 public:
  static LocalFrameHost::RunBeforeUnloadConfirmCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder> proxy(
        new LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunBeforeUnloadConfirmCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder);
};

bool LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirmCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 40, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirmCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirmCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 40, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}

// static
bool LocalFrameHostStubDispatch::Accept(
    LocalFrameHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalFrameHost_EnterFullscreen_Name: {
      break;
    }
    case internal::kLocalFrameHost_ExitFullscreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ExitFullscreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ExitFullscreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ExitFullscreen_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ExitFullscreen_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_ExitFullscreen_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitFullscreen();
      return true;
    }
    case internal::kLocalFrameHost_FullscreenStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::FullscreenStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::FullscreenStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FullscreenStateChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FullscreenStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_fullscreen{};
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      LocalFrameHost_FullscreenStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_fullscreen = input_data_view.is_fullscreen();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FullscreenStateChanged(
std::move(p_is_fullscreen), 
std::move(p_options));
      return true;
    }
    case internal::kLocalFrameHost_RegisterProtocolHandler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RegisterProtocolHandler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RegisterProtocolHandler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_RegisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_RegisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_scheme{};
      ::GURL p_url{};
      bool p_user_gesture{};
      LocalFrameHost_RegisterProtocolHandler_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterProtocolHandler(
std::move(p_scheme), 
std::move(p_url), 
std::move(p_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_UnregisterProtocolHandler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UnregisterProtocolHandler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UnregisterProtocolHandler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_scheme{};
      ::GURL p_url{};
      bool p_user_gesture{};
      LocalFrameHost_UnregisterProtocolHandler_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterProtocolHandler(
std::move(p_scheme), 
std::move(p_url), 
std::move(p_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_DidDisplayInsecureContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidDisplayInsecureContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidDisplayInsecureContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidDisplayInsecureContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDisplayInsecureContent();
      return true;
    }
    case internal::kLocalFrameHost_DidContainInsecureFormAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidContainInsecureFormAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidContainInsecureFormAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidContainInsecureFormAction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidContainInsecureFormAction();
      return true;
    }
    case internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DocumentAvailableInMainFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DocumentAvailableInMainFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_uses_temporary_zoom_level{};
      LocalFrameHost_DocumentAvailableInMainFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_uses_temporary_zoom_level = input_data_view.uses_temporary_zoom_level();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DocumentAvailableInMainFrame(
std::move(p_uses_temporary_zoom_level));
      return true;
    }
    case internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_tracking{};
      LocalFrameHost_SetNeedsOcclusionTracking_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_tracking = input_data_view.needs_tracking();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsOcclusionTracking(
std::move(p_needs_tracking));
      return true;
    }
    case internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SetVirtualKeyboardOverlayPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SetVirtualKeyboardOverlayPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_vk_overlays_content{};
      LocalFrameHost_SetVirtualKeyboardOverlayPolicy_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_vk_overlays_content = input_data_view.vk_overlays_content();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVirtualKeyboardOverlayPolicy(
std::move(p_vk_overlays_content));
      return true;
    }
    case internal::kLocalFrameHost_VisibilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::VisibilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::VisibilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_VisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_VisibilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FrameVisibility p_visibility{};
      LocalFrameHost_VisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisibilityChanged(
std::move(p_visibility));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeThemeColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeThemeColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeThemeColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeThemeColor_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeThemeColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::SkColor> p_theme_color{};
      LocalFrameHost_DidChangeThemeColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThemeColor(&p_theme_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeThemeColor(
std::move(p_theme_color));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeBackgroundColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeBackgroundColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeBackgroundColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::SkColor p_background_color{};
      bool p_color_adjust{};
      LocalFrameHost_DidChangeBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBackgroundColor(&p_background_color))
        success = false;
      if (success)
        p_color_adjust = input_data_view.color_adjust();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeBackgroundColor(
std::move(p_background_color), 
std::move(p_color_adjust));
      return true;
    }
    case internal::kLocalFrameHost_DidFailLoadWithError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFailLoadWithError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFailLoadWithError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFailLoadWithError_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFailLoadWithError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      int32_t p_error_code{};
      LocalFrameHost_DidFailLoadWithError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_error_code = input_data_view.error_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFailLoadWithError(
std::move(p_url), 
std::move(p_error_code));
      return true;
    }
    case internal::kLocalFrameHost_DidFocusFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFocusFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFocusFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFocusFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFocusFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidFocusFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFocusFrame();
      return true;
    }
    case internal::kLocalFrameHost_DidCallFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidCallFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidCallFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidCallFocus_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidCallFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidCallFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCallFocus();
      return true;
    }
    case internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::InsecureRequestPolicy p_policy_bitmap{};
      LocalFrameHost_EnforceInsecureRequestPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyBitmap(&p_policy_bitmap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureRequestPolicy(
std::move(p_policy_bitmap));
      return true;
    }
    case internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint32_t> p_set{};
      LocalFrameHost_EnforceInsecureNavigationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureNavigationsSet(
std::move(p_set));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeActiveSchedulerTrackedFeatures",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeActiveSchedulerTrackedFeatures");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_features_mask{};
      LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_features_mask = input_data_view.features_mask();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeActiveSchedulerTrackedFeatures(
std::move(p_features_mask));
      return true;
    }
    case internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_present{};
      ::blink::mojom::SuddenTerminationDisablerType p_disabler_type{};
      LocalFrameHost_SuddenTerminationDisablerChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_present = input_data_view.present();
      if (success && !input_data_view.ReadDisablerType(&p_disabler_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuddenTerminationDisablerChanged(
std::move(p_present), 
std::move(p_disabler_type));
      return true;
    }
    case internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_gesture{};
      LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_gesture = input_data_view.has_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HadStickyUserActivationBeforeNavigationChanged(
std::move(p_has_gesture));
      return true;
    }
    case internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect_to_scroll{};
      ::blink::mojom::ScrollIntoViewParamsPtr p_params{};
      LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRectToScroll(&p_rect_to_scroll))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollRectToVisibleInParentFrame(
std::move(p_rect_to_scroll), 
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ScrollDirection p_direction{};
      ::ui::ScrollGranularity p_granularity{};
      LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BubbleLogicalScrollInParentFrame(
std::move(p_direction), 
std::move(p_granularity));
      return true;
    }
    case internal::kLocalFrameHost_DidAccessInitialDocument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidAccessInitialDocument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidAccessInitialDocument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidAccessInitialDocument_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidAccessInitialDocument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidAccessInitialDocument_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAccessInitialDocument();
      return true;
    }
    case internal::kLocalFrameHost_DidBlockNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidBlockNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidBlockNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidBlockNavigation_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidBlockNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_blocked_url{};
      ::GURL p_initiator_url{};
      ::blink::mojom::NavigationBlockedReason p_reason{};
      LocalFrameHost_DidBlockNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadInitiatorUrl(&p_initiator_url))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidBlockNavigation(
std::move(p_blocked_url), 
std::move(p_initiator_url), 
std::move(p_reason));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeLoadProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeLoadProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeLoadProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeLoadProgress_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeLoadProgress_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_load_progress{};
      LocalFrameHost_DidChangeLoadProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_load_progress = input_data_view.load_progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeLoadProgress(
std::move(p_load_progress));
      return true;
    }
    case internal::kLocalFrameHost_DidFinishLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFinishLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFinishLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFinishLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFinishLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_validated_url{};
      LocalFrameHost_DidFinishLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValidatedUrl(&p_validated_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishLoad(
std::move(p_validated_url));
      return true;
    }
    case internal::kLocalFrameHost_DispatchLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DispatchLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DispatchLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DispatchLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DispatchLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DispatchLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoad();
      return true;
    }
    case internal::kLocalFrameHost_GoToEntryAtOffset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::GoToEntryAtOffset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::GoToEntryAtOffset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_GoToEntryAtOffset_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_GoToEntryAtOffset_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_offset{};
      bool p_has_user_gesture{};
      LocalFrameHost_GoToEntryAtOffset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoToEntryAtOffset(
std::move(p_offset), 
std::move(p_has_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_NavigateToAppHistoryKey_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::NavigateToAppHistoryKey",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::NavigateToAppHistoryKey");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_NavigateToAppHistoryKey_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_NavigateToAppHistoryKey_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_key{};
      bool p_has_user_gesture{};
      LocalFrameHost_NavigateToAppHistoryKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateToAppHistoryKey(
std::move(p_key), 
std::move(p_has_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_UpdateTitle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UpdateTitle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UpdateTitle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateTitle_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateTitle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::std::u16string> p_title{};
      ::base::i18n::TextDirection p_title_direction{};
      LocalFrameHost_UpdateTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadTitleDirection(&p_title_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTitle(
std::move(p_title), 
std::move(p_title_direction));
      return true;
    }
    case internal::kLocalFrameHost_UpdateUserActivationState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UpdateUserActivationState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UpdateUserActivationState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateUserActivationState_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateUserActivationState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::UserActivationUpdateType p_update_type{};
      ::blink::mojom::UserActivationNotificationType p_notification_type{};
      LocalFrameHost_UpdateUserActivationState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserActivationState(
std::move(p_update_type), 
std::move(p_notification_type));
      return true;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FindInPageResultAXParamsPtr p_params{};
      LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAccessibilityFindInPageResult(
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAccessibilityFindInPageTermination();
      return true;
    }
    case internal::kLocalFrameHost_DocumentOnLoadCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DocumentOnLoadCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DocumentOnLoadCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DocumentOnLoadCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DocumentOnLoadCompleted();
      return true;
    }
    case internal::kLocalFrameHost_ForwardResourceTimingToParent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ForwardResourceTimingToParent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ForwardResourceTimingToParent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceTimingInfoPtr p_timing{};
      LocalFrameHost_ForwardResourceTimingToParent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardResourceTimingToParent(
std::move(p_timing));
      return true;
    }
    case internal::kLocalFrameHost_DidFinishDocumentLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFinishDocumentLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFinishDocumentLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidFinishDocumentLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishDocumentLoad();
      return true;
    }
    case internal::kLocalFrameHost_RunModalAlertDialog_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunModalConfirmDialog_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunModalPromptDialog_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name: {
      break;
    }
    case internal::kLocalFrameHost_UpdateFaviconURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UpdateFaviconURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UpdateFaviconURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateFaviconURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateFaviconURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::blink::mojom::FaviconURLPtr> p_favicon_urls{};
      LocalFrameHost_UpdateFaviconURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFaviconUrls(&p_favicon_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 41, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFaviconURL(
std::move(p_favicon_urls));
      return true;
    }
    case internal::kLocalFrameHost_DownloadURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DownloadURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DownloadURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DownloadURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DownloadURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DownloadURLParamsPtr p_params{};
      LocalFrameHost_DownloadURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 42, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadURL(
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_FocusedElementChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::FocusedElementChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::FocusedElementChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FocusedElementChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FocusedElementChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_editable_element{};
      ::gfx::Rect p_bounds_in_frame_widget{};
      ::blink::mojom::FocusType p_focus_type{};
      LocalFrameHost_FocusedElementChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_editable_element = input_data_view.is_editable_element();
      if (success && !input_data_view.ReadBoundsInFrameWidget(&p_bounds_in_frame_widget))
        success = false;
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusedElementChanged(
std::move(p_is_editable_element), 
std::move(p_bounds_in_frame_widget), 
std::move(p_focus_type));
      return true;
    }
    case internal::kLocalFrameHost_TextSelectionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::TextSelectionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::TextSelectionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_TextSelectionChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_TextSelectionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_text{};
      uint32_t p_offset{};
      ::gfx::Range p_range{};
      bool p_user_initiated{};
      LocalFrameHost_TextSelectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success)
        p_user_initiated = input_data_view.user_initiated();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextSelectionChanged(
std::move(p_text), 
std::move(p_offset), 
std::move(p_range), 
std::move(p_user_initiated));
      return true;
    }
    case internal::kLocalFrameHost_ShowPopupMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ShowPopupMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ShowPopupMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ShowPopupMenu_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ShowPopupMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::PopupMenuClient> p_popup_client{};
      ::gfx::Rect p_bounds{};
      int32_t p_item_height{};
      double p_font_size{};
      int32_t p_selected_item{};
      std::vector<::blink::mojom::MenuItemPtr> p_menu_items{};
      bool p_right_aligned{};
      bool p_allow_multiple_selection{};
      LocalFrameHost_ShowPopupMenu_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_popup_client =
            input_data_view.TakePopupClient<decltype(p_popup_client)>();
      }
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (success)
        p_item_height = input_data_view.item_height();
      if (success)
        p_font_size = input_data_view.font_size();
      if (success)
        p_selected_item = input_data_view.selected_item();
      if (success && !input_data_view.ReadMenuItems(&p_menu_items))
        success = false;
      if (success)
        p_right_aligned = input_data_view.right_aligned();
      if (success)
        p_allow_multiple_selection = input_data_view.allow_multiple_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPopupMenu(
std::move(p_popup_client), 
std::move(p_bounds), 
std::move(p_item_height), 
std::move(p_font_size), 
std::move(p_selected_item), 
std::move(p_menu_items), 
std::move(p_right_aligned), 
std::move(p_allow_multiple_selection));
      return true;
    }
    case internal::kLocalFrameHost_CreateNewPopupWidget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::CreateNewPopupWidget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::CreateNewPopupWidget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_CreateNewPopupWidget_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_CreateNewPopupWidget_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> p_popup_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> p_blink_widget_host{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> p_blink_widget{};
      LocalFrameHost_CreateNewPopupWidget_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_popup_host =
            input_data_view.TakePopupHost<decltype(p_popup_host)>();
      }
      if (success) {
        p_blink_widget_host =
            input_data_view.TakeBlinkWidgetHost<decltype(p_blink_widget_host)>();
      }
      if (success) {
        p_blink_widget =
            input_data_view.TakeBlinkWidget<decltype(p_blink_widget)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 46, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewPopupWidget(
std::move(p_popup_host), 
std::move(p_blink_widget_host), 
std::move(p_blink_widget));
      return true;
    }
    case internal::kLocalFrameHost_ShowContextMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ShowContextMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ShowContextMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> p_client{};
      ::blink::UntrustworthyContextMenuParams p_params{};
      LocalFrameHost_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 47, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(
std::move(p_client), 
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::string p_http_method{};
      std::string p_mime_type{};
      ::network::mojom::RequestDestination p_request_destination{};
      LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHttpMethod(&p_http_method))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (success && !input_data_view.ReadRequestDestination(&p_request_destination))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 48, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoadResourceFromMemoryCache(
std::move(p_url), 
std::move(p_http_method), 
std::move(p_mime_type), 
std::move(p_request_destination));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      ::blink::mojom::FrameOwnerPropertiesPtr p_frame_owner_properties{};
      LocalFrameHost_DidChangeFrameOwnerProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadFrameOwnerProperties(&p_frame_owner_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFrameOwnerProperties(
std::move(p_child_frame_token), 
std::move(p_frame_owner_properties));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeOpener_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::blink::LocalFrameToken> p_opener_frame{};
      LocalFrameHost_DidChangeOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrame(&p_opener_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeOpener(
std::move(p_opener_frame));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeFramePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeFramePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeFramePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeFramePolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeFramePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      ::blink::FramePolicy p_frame_policy{};
      LocalFrameHost_DidChangeFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFramePolicy(
std::move(p_child_frame_token), 
std::move(p_frame_policy));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeIframeAttributes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeIframeAttributes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeIframeAttributes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FrameToken p_child_frame_token{};
      ::network::mojom::ContentSecurityPolicyPtr p_parsed_csp_attribute{};
      bool p_anonymous{};
      LocalFrameHost_DidChangeIframeAttributes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadParsedCspAttribute(&p_parsed_csp_attribute))
        success = false;
      if (success)
        p_anonymous = input_data_view.anonymous();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeIframeAttributes(
std::move(p_child_frame_token), 
std::move(p_parsed_csp_attribute), 
std::move(p_anonymous));
      return true;
    }
    case internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      ::base::UnguessableToken p_guid{};
      LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreviewOfSubframe(
std::move(p_clip_rect), 
std::move(p_guid));
      return true;
    }
    case internal::kLocalFrameHost_SetModalCloseListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SetModalCloseListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SetModalCloseListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetModalCloseListener_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetModalCloseListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::ModalCloseListener> p_listener{};
      LocalFrameHost_SetModalCloseListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 54, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModalCloseListener(
std::move(p_listener));
      return true;
    }
    case internal::kLocalFrameHost_Detach_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::Detach",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::Detach");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_Detach_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_Detach_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_Detach_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 55, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach();
      return true;
    }
    case internal::kLocalFrameHost_GetKeepAliveHandleFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::GetKeepAliveHandleFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<KeepAliveHandleFactory> p_factory{};
      LocalFrameHost_GetKeepAliveHandleFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 56, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeepAliveHandleFactory(
std::move(p_factory));
      return true;
    }
    case internal::kLocalFrameHost_DidAddMessageToConsole_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidAddMessageToConsole",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidAddMessageToConsole");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidAddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidAddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ConsoleMessageLevel p_log_level{};
      ::std::u16string p_msg{};
      int32_t p_line_number{};
      absl::optional<::std::u16string> p_source_id{};
      absl::optional<::std::u16string> p_untrusted_stack_trace{};
      LocalFrameHost_DidAddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLogLevel(&p_log_level))
        success = false;
      if (success && !input_data_view.ReadMsg(&p_msg))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success && !input_data_view.ReadUntrustedStackTrace(&p_untrusted_stack_trace))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 57, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAddMessageToConsole(
std::move(p_log_level), 
std::move(p_msg), 
std::move(p_line_number), 
std::move(p_source_id), 
std::move(p_untrusted_stack_trace));
      return true;
    }
    case internal::kLocalFrameHost_FrameSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::FrameSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::FrameSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FrameSizeChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FrameSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      LocalFrameHost_FrameSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 58, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameSizeChanged(
std::move(p_size));
      return true;
    }
    case internal::kLocalFrameHost_DidUpdatePreferredColorScheme_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidUpdatePreferredColorScheme",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidUpdatePreferredColorScheme");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::PreferredColorScheme p_preferred_color_scheme{};
      LocalFrameHost_DidUpdatePreferredColorScheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPreferredColorScheme(&p_preferred_color_scheme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 59, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdatePreferredColorScheme(
std::move(p_preferred_color_scheme));
      return true;
    }
  }
  return false;
}

// static
bool LocalFrameHostStubDispatch::AcceptWithResponder(
    LocalFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrameHost_EnterFullscreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::EnterFullscreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::EnterFullscreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_EnterFullscreen_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_EnterFullscreen_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      LocalFrameHost_EnterFullscreen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 0, false);
        return false;
      }
      LocalFrameHost::EnterFullscreenCallback callback =
          LocalFrameHost_EnterFullscreen_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterFullscreen(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_ExitFullscreen_Name: {
      break;
    }
    case internal::kLocalFrameHost_FullscreenStateChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_RegisterProtocolHandler_Name: {
      break;
    }
    case internal::kLocalFrameHost_UnregisterProtocolHandler_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidDisplayInsecureContent_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidContainInsecureFormAction_Name: {
      break;
    }
    case internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name: {
      break;
    }
    case internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name: {
      break;
    }
    case internal::kLocalFrameHost_VisibilityChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeThemeColor_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeBackgroundColor_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFailLoadWithError_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFocusFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidCallFocus_Name: {
      break;
    }
    case internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name: {
      break;
    }
    case internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name: {
      break;
    }
    case internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidAccessInitialDocument_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidBlockNavigation_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeLoadProgress_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFinishLoad_Name: {
      break;
    }
    case internal::kLocalFrameHost_DispatchLoad_Name: {
      break;
    }
    case internal::kLocalFrameHost_GoToEntryAtOffset_Name: {
      break;
    }
    case internal::kLocalFrameHost_NavigateToAppHistoryKey_Name: {
      break;
    }
    case internal::kLocalFrameHost_UpdateTitle_Name: {
      break;
    }
    case internal::kLocalFrameHost_UpdateUserActivationState_Name: {
      break;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name: {
      break;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name: {
      break;
    }
    case internal::kLocalFrameHost_DocumentOnLoadCompleted_Name: {
      break;
    }
    case internal::kLocalFrameHost_ForwardResourceTimingToParent_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFinishDocumentLoad_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunModalAlertDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunModalAlertDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalAlertDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_alert_message{};
      bool p_disable_third_party_subframe_suppresion{};
      LocalFrameHost_RunModalAlertDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success)
        p_disable_third_party_subframe_suppresion = input_data_view.disable_third_party_subframe_suppresion();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 37, false);
        return false;
      }
      LocalFrameHost::RunModalAlertDialogCallback callback =
          LocalFrameHost_RunModalAlertDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalAlertDialog(
std::move(p_alert_message), 
std::move(p_disable_third_party_subframe_suppresion), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_RunModalConfirmDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunModalConfirmDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalConfirmDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_alert_message{};
      bool p_disable_third_party_subframe_suppresion{};
      LocalFrameHost_RunModalConfirmDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success)
        p_disable_third_party_subframe_suppresion = input_data_view.disable_third_party_subframe_suppresion();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 38, false);
        return false;
      }
      LocalFrameHost::RunModalConfirmDialogCallback callback =
          LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalConfirmDialog(
std::move(p_alert_message), 
std::move(p_disable_third_party_subframe_suppresion), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_RunModalPromptDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunModalPromptDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalPromptDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_alert_message{};
      ::std::u16string p_default_value{};
      bool p_disable_third_party_subframe_suppresion{};
      LocalFrameHost_RunModalPromptDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success && !input_data_view.ReadDefaultValue(&p_default_value))
        success = false;
      if (success)
        p_disable_third_party_subframe_suppresion = input_data_view.disable_third_party_subframe_suppresion();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 39, false);
        return false;
      }
      LocalFrameHost::RunModalPromptDialogCallback callback =
          LocalFrameHost_RunModalPromptDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalPromptDialog(
std::move(p_alert_message), 
std::move(p_default_value), 
std::move(p_disable_third_party_subframe_suppresion), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_is_reload{};
      LocalFrameHost_RunBeforeUnloadConfirm_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 40, false);
        return false;
      }
      LocalFrameHost::RunBeforeUnloadConfirmCallback callback =
          LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunBeforeUnloadConfirm(
std::move(p_is_reload), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_UpdateFaviconURL_Name: {
      break;
    }
    case internal::kLocalFrameHost_DownloadURL_Name: {
      break;
    }
    case internal::kLocalFrameHost_FocusedElementChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_TextSelectionChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_ShowPopupMenu_Name: {
      break;
    }
    case internal::kLocalFrameHost_CreateNewPopupWidget_Name: {
      break;
    }
    case internal::kLocalFrameHost_ShowContextMenu_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeOpener_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeFramePolicy_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeIframeAttributes_Name: {
      break;
    }
    case internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name: {
      break;
    }
    case internal::kLocalFrameHost_SetModalCloseListener_Name: {
      break;
    }
    case internal::kLocalFrameHost_Detach_Name: {
      break;
    }
    case internal::kLocalFrameHost_GetKeepAliveHandleFactory_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidAddMessageToConsole_Name: {
      break;
    }
    case internal::kLocalFrameHost_FrameSizeChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidUpdatePreferredColorScheme_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameHostValidationInfo[] = {
    {internal::kLocalFrameHost_EnterFullscreen_Name,
     {&internal::LocalFrameHost_EnterFullscreen_Params_Data::Validate,
      &internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_ExitFullscreen_Name,
     {&internal::LocalFrameHost_ExitFullscreen_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_FullscreenStateChanged_Name,
     {&internal::LocalFrameHost_FullscreenStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_RegisterProtocolHandler_Name,
     {&internal::LocalFrameHost_RegisterProtocolHandler_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_UnregisterProtocolHandler_Name,
     {&internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidDisplayInsecureContent_Name,
     {&internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidContainInsecureFormAction_Name,
     {&internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name,
     {&internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name,
     {&internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name,
     {&internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_VisibilityChanged_Name,
     {&internal::LocalFrameHost_VisibilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeThemeColor_Name,
     {&internal::LocalFrameHost_DidChangeThemeColor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeBackgroundColor_Name,
     {&internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFailLoadWithError_Name,
     {&internal::LocalFrameHost_DidFailLoadWithError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFocusFrame_Name,
     {&internal::LocalFrameHost_DidFocusFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidCallFocus_Name,
     {&internal::LocalFrameHost_DidCallFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name,
     {&internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name,
     {&internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name,
     {&internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name,
     {&internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name,
     {&internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name,
     {&internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name,
     {&internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidAccessInitialDocument_Name,
     {&internal::LocalFrameHost_DidAccessInitialDocument_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidBlockNavigation_Name,
     {&internal::LocalFrameHost_DidBlockNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeLoadProgress_Name,
     {&internal::LocalFrameHost_DidChangeLoadProgress_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFinishLoad_Name,
     {&internal::LocalFrameHost_DidFinishLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DispatchLoad_Name,
     {&internal::LocalFrameHost_DispatchLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_GoToEntryAtOffset_Name,
     {&internal::LocalFrameHost_GoToEntryAtOffset_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_NavigateToAppHistoryKey_Name,
     {&internal::LocalFrameHost_NavigateToAppHistoryKey_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_UpdateTitle_Name,
     {&internal::LocalFrameHost_UpdateTitle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_UpdateUserActivationState_Name,
     {&internal::LocalFrameHost_UpdateUserActivationState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name,
     {&internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name,
     {&internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DocumentOnLoadCompleted_Name,
     {&internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ForwardResourceTimingToParent_Name,
     {&internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFinishDocumentLoad_Name,
     {&internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_RunModalAlertDialog_Name,
     {&internal::LocalFrameHost_RunModalAlertDialog_Params_Data::Validate,
      &internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_RunModalConfirmDialog_Name,
     {&internal::LocalFrameHost_RunModalConfirmDialog_Params_Data::Validate,
      &internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_RunModalPromptDialog_Name,
     {&internal::LocalFrameHost_RunModalPromptDialog_Params_Data::Validate,
      &internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name,
     {&internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::Validate,
      &internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_UpdateFaviconURL_Name,
     {&internal::LocalFrameHost_UpdateFaviconURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DownloadURL_Name,
     {&internal::LocalFrameHost_DownloadURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_FocusedElementChanged_Name,
     {&internal::LocalFrameHost_FocusedElementChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_TextSelectionChanged_Name,
     {&internal::LocalFrameHost_TextSelectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ShowPopupMenu_Name,
     {&internal::LocalFrameHost_ShowPopupMenu_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_CreateNewPopupWidget_Name,
     {&internal::LocalFrameHost_CreateNewPopupWidget_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ShowContextMenu_Name,
     {&internal::LocalFrameHost_ShowContextMenu_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name,
     {&internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name,
     {&internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeOpener_Name,
     {&internal::LocalFrameHost_DidChangeOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeFramePolicy_Name,
     {&internal::LocalFrameHost_DidChangeFramePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeIframeAttributes_Name,
     {&internal::LocalFrameHost_DidChangeIframeAttributes_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name,
     {&internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SetModalCloseListener_Name,
     {&internal::LocalFrameHost_SetModalCloseListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_Detach_Name,
     {&internal::LocalFrameHost_Detach_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_GetKeepAliveHandleFactory_Name,
     {&internal::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidAddMessageToConsole_Name,
     {&internal::LocalFrameHost_DidAddMessageToConsole_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_FrameSizeChanged_Name,
     {&internal::LocalFrameHost_FrameSizeChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidUpdatePreferredColorScheme_Name,
     {&internal::LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameHostValidationInfo);
}

bool LocalFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalFrameHostValidationInfo);

}
const char LocalFrame::Name_[] = "blink.mojom.LocalFrame";

class LocalFrame_GetTextSurroundingSelection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetTextSurroundingSelection_ForwardToCallback(
      LocalFrame::GetTextSurroundingSelectionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetTextSurroundingSelectionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetTextSurroundingSelection_ForwardToCallback);
};

class LocalFrame_BeforeUnload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_BeforeUnload_ForwardToCallback(
      LocalFrame::BeforeUnloadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::BeforeUnloadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_BeforeUnload_ForwardToCallback);
};

class LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback(
      LocalFrame::JavaScriptMethodExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptMethodExecuteRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback);
};

class LocalFrame_JavaScriptExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptExecuteRequest_ForwardToCallback(
      LocalFrame::JavaScriptExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptExecuteRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptExecuteRequest_ForwardToCallback);
};

class LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback(
      LocalFrame::JavaScriptExecuteRequestForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptExecuteRequestForTestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback);
};

class LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
      LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback);
};

class LocalFrame_GetSavableResourceLinks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetSavableResourceLinks_ForwardToCallback(
      LocalFrame::GetSavableResourceLinksCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetSavableResourceLinksCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetSavableResourceLinks_ForwardToCallback);
};

class LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback(
      LocalFrame::GetCanonicalUrlForSharingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetCanonicalUrlForSharingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback);
};

LocalFrameProxy::LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameProxy::GetTextSurroundingSelection(
    uint32_t in_max_length, GetTextSurroundingSelectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::GetTextSurroundingSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_length"), in_max_length,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetTextSurroundingSelection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetTextSurroundingSelection_Params_Data> params(
          message);
  params.Allocate();
  params->max_length = in_max_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetTextSurroundingSelection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetTextSurroundingSelection_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::SendInterventionReport(
    const std::string& in_id, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::SendInterventionReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SendInterventionReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SendInterventionReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LocalFrame.SendInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalFrame.SendInterventionReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SendInterventionReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SetFrameOwnerProperties(
    ::blink::mojom::FrameOwnerPropertiesPtr in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::SetFrameOwnerProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SetFrameOwnerProperties_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SetFrameOwnerProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_properties, properties_fragment);
  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in LocalFrame.SetFrameOwnerProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::NotifyUserActivation(
    ::blink::mojom::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::NotifyUserActivation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_type"), in_notification_type,
                        "<value of type ::blink::mojom::UserActivationNotificationType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_NotifyUserActivation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_NotifyUserActivation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
      in_notification_type, &params->notification_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyUserActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::NotifyVirtualKeyboardOverlayRect(
    const ::gfx::Rect& in_keyboard_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keyboard_rect"), in_keyboard_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keyboard_rect)::BaseType> keyboard_rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_keyboard_rect, keyboard_rect_fragment);
  params->keyboard_rect.Set(
      keyboard_rect_fragment.is_null() ? nullptr : keyboard_rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keyboard_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keyboard_rect in LocalFrame.NotifyVirtualKeyboardOverlayRect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyVirtualKeyboardOverlayRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AddMessageToConsole(
    ::blink::mojom::ConsoleMessageLevel in_level, const std::string& in_message, bool in_discard_duplicates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discard_duplicates"), in_discard_duplicates,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_AddMessageToConsole_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
      in_level, &params->level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalFrame.AddMessageToConsole request");
  params->discard_duplicates = in_discard_duplicates;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AddInspectorIssue(
    ::blink::mojom::InspectorIssueInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AddInspectorIssue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::blink::mojom::InspectorIssueInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_AddInspectorIssue_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AddInspectorIssue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::InspectorIssueInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in LocalFrame.AddInspectorIssue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AddInspectorIssue");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SwapInImmediately(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::SwapInImmediately");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SwapInImmediately_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SwapInImmediately_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SwapInImmediately");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::CheckCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::CheckCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_CheckCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_CheckCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("CheckCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::StopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::StopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_StopLoading_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_StopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("StopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::Collapse(
    bool in_collapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::Collapse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collapsed"), in_collapsed,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_Collapse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_Collapse_Params_Data> params(
          message);
  params.Allocate();
  params->collapsed = in_collapsed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("Collapse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::EnableViewSourceMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::EnableViewSourceMode");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_EnableViewSourceMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_EnableViewSourceMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("EnableViewSourceMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::Focus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_Focus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_Focus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ClearFocusedElement(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::ClearFocusedElement");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_ClearFocusedElement_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ClearFocusedElement_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ClearFocusedElement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::GetResourceSnapshotForWebBundle(
    ::mojo::PendingReceiver<::data_decoder::mojom::ResourceSnapshotForWebBundle> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::GetResourceSnapshotForWebBundle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::data_decoder::mojom::ResourceSnapshotForWebBundle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::ResourceSnapshotForWebBundleInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in LocalFrame.GetResourceSnapshotForWebBundle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetResourceSnapshotForWebBundle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::CopyImageAt(
    const ::gfx::Point& in_window_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::CopyImageAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_point"), in_window_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_CopyImageAt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_CopyImageAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_point)::BaseType> window_point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_window_point, window_point_fragment);
  params->window_point.Set(
      window_point_fragment.is_null() ? nullptr : window_point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_point in LocalFrame.CopyImageAt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("CopyImageAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SaveImageAt(
    const ::gfx::Point& in_window_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::SaveImageAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_point"), in_window_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SaveImageAt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_SaveImageAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_point)::BaseType> window_point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_window_point, window_point_fragment);
  params->window_point.Set(
      window_point_fragment.is_null() ? nullptr : window_point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_point in LocalFrame.SaveImageAt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SaveImageAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ReportBlinkFeatureUsage(
    const std::vector<::blink::mojom::WebFeature>& in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::ReportBlinkFeatureUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type const std::vector<::blink::mojom::WebFeature>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_ReportBlinkFeatureUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  const mojo::internal::ContainerValidateParams features_validate_params(
      0, ::blink::mojom::internal::WebFeature_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
      in_features, features_fragment, &features_validate_params);
  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in LocalFrame.ReportBlinkFeatureUsage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ReportBlinkFeatureUsage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::RenderFallbackContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::RenderFallbackContent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_RenderFallbackContent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_RenderFallbackContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("RenderFallbackContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::RenderFallbackContentWithResourceTiming(
    ::blink::mojom::ResourceTimingInfoPtr in_timing, const std::string& in_server_timing_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::RenderFallbackContentWithResourceTiming", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ::blink::mojom::ResourceTimingInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("server_timing_value"), in_server_timing_value,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_RenderFallbackContentWithResourceTiming_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in LocalFrame.RenderFallbackContentWithResourceTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->server_timing_value)::BaseType> server_timing_value_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_server_timing_value, server_timing_value_fragment);
  params->server_timing_value.Set(
      server_timing_value_fragment.is_null() ? nullptr : server_timing_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->server_timing_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_timing_value in LocalFrame.RenderFallbackContentWithResourceTiming request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("RenderFallbackContentWithResourceTiming");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::BeforeUnload(
    bool in_is_reload, BeforeUnloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::BeforeUnload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), in_is_reload,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_BeforeUnload_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BeforeUnload_Params_Data> params(
          message);
  params.Allocate();
  params->is_reload = in_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BeforeUnload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_BeforeUnload_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::MediaPlayerActionAt(
    const ::gfx::Point& in_location, ::blink::mojom::MediaPlayerActionPtr in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::MediaPlayerActionAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::blink::mojom::MediaPlayerActionPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_MediaPlayerActionAt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_MediaPlayerActionAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location, location_fragment);
  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->location.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in LocalFrame.MediaPlayerActionAt request");
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType> action_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaPlayerActionDataView>(
      in_action, action_fragment);
  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in LocalFrame.MediaPlayerActionAt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MediaPlayerActionAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AdvanceFocusInFrame(
    ::blink::mojom::FocusType in_focus_type, const absl::optional<::blink::RemoteFrameToken>& in_source_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AdvanceFocusInFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const absl::optional<::blink::RemoteFrameToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_AdvanceFocusInFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AdvanceFocusInFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_source_frame_token, source_frame_token_fragment);
  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AdvanceFocusInFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AdvanceFocusInForm(
    ::blink::mojom::FocusType in_focus_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AdvanceFocusInForm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_AdvanceFocusInForm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_AdvanceFocusInForm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AdvanceFocusInForm");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ReportContentSecurityPolicyViolation(
    ::network::mojom::CSPViolationPtr in_violation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("violation"), in_violation,
                        "<value of type ::network::mojom::CSPViolationPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->violation)::BaseType> violation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CSPViolationDataView>(
      in_violation, violation_fragment);
  params->violation.Set(
      violation_fragment.is_null() ? nullptr : violation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->violation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null violation in LocalFrame.ReportContentSecurityPolicyViolation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ReportContentSecurityPolicyViolation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::DidUpdateFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::DidUpdateFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_DidUpdateFramePolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_DidUpdateFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, frame_policy_fragment);
  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in LocalFrame.DidUpdateFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DidUpdateFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::OnScreensChange(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::OnScreensChange");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_OnScreensChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_OnScreensChange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("OnScreensChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::PostMessageEvent(
    const absl::optional<::blink::RemoteFrameToken>& in_source_frame_token, const ::std::u16string& in_source_origin, const ::std::u16string& in_target_origin, ::blink::TransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::PostMessageEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const absl::optional<::blink::RemoteFrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_origin"), in_target_origin,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::TransferableMessage>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_PostMessageEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_PostMessageEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_source_frame_token, source_frame_token_fragment);
  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source_origin, source_origin_fragment);
  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in LocalFrame.PostMessageEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_origin)::BaseType> target_origin_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_target_origin, target_origin_fragment);
  params->target_origin.Set(
      target_origin_fragment.is_null() ? nullptr : target_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->target_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_origin in LocalFrame.PostMessageEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalFrame.PostMessageEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("PostMessageEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::JavaScriptMethodExecuteRequest(
    const ::std::u16string& in_object_name, const ::std::u16string& in_method_name, ::base::Value in_arguments, bool in_wants_result, JavaScriptMethodExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_name"), in_object_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_name"), in_method_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("arguments"), in_arguments,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptMethodExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->object_name)::BaseType> object_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_object_name, object_name_fragment);
  params->object_name.Set(
      object_name_fragment.is_null() ? nullptr : object_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->object_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_name in LocalFrame.JavaScriptMethodExecuteRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->method_name)::BaseType> method_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_method_name, method_name_fragment);
  params->method_name.Set(
      method_name_fragment.is_null() ? nullptr : method_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in LocalFrame.JavaScriptMethodExecuteRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->arguments)::BaseType> arguments_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_arguments, arguments_fragment);
  params->arguments.Set(
      arguments_fragment.is_null() ? nullptr : arguments_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->arguments.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null arguments in LocalFrame.JavaScriptMethodExecuteRequest request");
  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::JavaScriptExecuteRequest(
    const ::std::u16string& in_javascript, bool in_wants_result, JavaScriptExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::JavaScriptExecuteRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, javascript_fragment);
  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in LocalFrame.JavaScriptExecuteRequest request");
  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::JavaScriptExecuteRequestForTests(
    const ::std::u16string& in_javascript, bool in_wants_result, bool in_has_user_gesture, int32_t in_world_id, JavaScriptExecuteRequestForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptExecuteRequestForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, javascript_fragment);
  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in LocalFrame.JavaScriptExecuteRequestForTests request");
  params->wants_result = in_wants_result;
  params->has_user_gesture = in_has_user_gesture;
  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::JavaScriptExecuteRequestInIsolatedWorld(
    const ::std::u16string& in_javascript, bool in_wants_result, int32_t in_world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, javascript_fragment);
  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in LocalFrame.JavaScriptExecuteRequestInIsolatedWorld request");
  params->wants_result = in_wants_result;
  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::BindReportingObserver(
    ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::BindReportingObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::ReportingObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_BindReportingObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BindReportingObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in LocalFrame.BindReportingObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BindReportingObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::UpdateOpener(
    const absl::optional<::blink::FrameToken>& in_opener_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::UpdateOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const absl::optional<::blink::FrameToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_UpdateOpener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_UpdateOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_opener_frame_token, opener_frame_token_fragment, true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("UpdateOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::GetSavableResourceLinks(
    GetSavableResourceLinksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::GetSavableResourceLinks");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetSavableResourceLinks_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetSavableResourceLinks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetSavableResourceLinks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetSavableResourceLinks_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::MixedContentFound(
    const ::GURL& in_main_resource_url, const ::GURL& in_mixed_content_url, ::blink::mojom::RequestContextType in_request_context, bool in_was_allowed, const ::GURL& in_url_before_redirects, bool in_had_redirect, ::network::mojom::SourceLocationPtr in_source_location) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::MixedContentFound", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_resource_url"), in_main_resource_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mixed_content_url"), in_mixed_content_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_context"), in_request_context,
                        "<value of type ::blink::mojom::RequestContextType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_allowed"), in_was_allowed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_before_redirects"), in_url_before_redirects,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("had_redirect"), in_had_redirect,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_location"), in_source_location,
                        "<value of type ::network::mojom::SourceLocationPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_MixedContentFound_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_MixedContentFound_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->main_resource_url)::BaseType> main_resource_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_main_resource_url, main_resource_url_fragment);
  params->main_resource_url.Set(
      main_resource_url_fragment.is_null() ? nullptr : main_resource_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_resource_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_resource_url in LocalFrame.MixedContentFound request");
  mojo::internal::MessageFragment<
      typename decltype(params->mixed_content_url)::BaseType> mixed_content_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_mixed_content_url, mixed_content_url_fragment);
  params->mixed_content_url.Set(
      mixed_content_url_fragment.is_null() ? nullptr : mixed_content_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mixed_content_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mixed_content_url in LocalFrame.MixedContentFound request");
  mojo::internal::Serialize<::blink::mojom::RequestContextType>(
      in_request_context, &params->request_context);
  params->was_allowed = in_was_allowed;
  mojo::internal::MessageFragment<
      typename decltype(params->url_before_redirects)::BaseType> url_before_redirects_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url_before_redirects, url_before_redirects_fragment);
  params->url_before_redirects.Set(
      url_before_redirects_fragment.is_null() ? nullptr : url_before_redirects_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_before_redirects.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_before_redirects in LocalFrame.MixedContentFound request");
  params->had_redirect = in_had_redirect;
  mojo::internal::MessageFragment<
      typename decltype(params->source_location)::BaseType> source_location_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
      in_source_location, source_location_fragment);
  params->source_location.Set(
      source_location_fragment.is_null() ? nullptr : source_location_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MixedContentFound");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::BindDevToolsAgent(
    ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> in_agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::BindDevToolsAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_BindDevToolsAgent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BindDevToolsAgent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentHostAssociatedPtrInfoDataView>(
      in_agent_host, &params->agent_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent_host in LocalFrame.BindDevToolsAgent request");
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
      in_agent, &params->agent, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent in LocalFrame.BindDevToolsAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BindDevToolsAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::HandleRendererDebugURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::HandleRendererDebugURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_HandleRendererDebugURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_HandleRendererDebugURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrame.HandleRendererDebugURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("HandleRendererDebugURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::GetCanonicalUrlForSharing(
    GetCanonicalUrlForSharingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::GetCanonicalUrlForSharing");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetCanonicalUrlForSharing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LocalFrame_GetTextSurroundingSelection_ProxyToResponder {
 public:
  static LocalFrame::GetTextSurroundingSelectionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_GetTextSurroundingSelection_ProxyToResponder> proxy(
        new LocalFrame_GetTextSurroundingSelection_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_GetTextSurroundingSelection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetTextSurroundingSelection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_GetTextSurroundingSelection_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::GetTextSurroundingSelectionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_content, uint32_t in_start_offset, uint32_t in_end_offset);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetTextSurroundingSelection_ProxyToResponder);
};

bool LocalFrame_GetTextSurroundingSelection_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::GetTextSurroundingSelectionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::std::u16string p_content{};
  uint32_t p_start_offset{};
  uint32_t p_end_offset{};
  LocalFrame_GetTextSurroundingSelection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContent(&p_content))
    success = false;
  if (success)
    p_start_offset = input_data_view.start_offset();
  if (success)
    p_end_offset = input_data_view.end_offset();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_content), 
std::move(p_start_offset), 
std::move(p_end_offset));
  return true;
}

void LocalFrame_GetTextSurroundingSelection_ProxyToResponder::Run(
    const ::std::u16string& in_content, uint32_t in_start_offset, uint32_t in_end_offset) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelectionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content"), in_content,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_offset"), in_start_offset,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_offset"), in_end_offset,
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetTextSurroundingSelection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content)::BaseType> content_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_content, content_fragment);
  params->content.Set(
      content_fragment.is_null() ? nullptr : content_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in ");
  params->start_offset = in_start_offset;
  params->end_offset = in_end_offset;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelectionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetTextSurroundingSelection");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_BeforeUnload_ProxyToResponder {
 public:
  static LocalFrame::BeforeUnloadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_BeforeUnload_ProxyToResponder> proxy(
        new LocalFrame_BeforeUnload_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_BeforeUnload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_BeforeUnload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_BeforeUnload_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::BeforeUnloadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_BeforeUnload_ProxyToResponder);
};

bool LocalFrame_BeforeUnload_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::BeforeUnloadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_BeforeUnload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_BeforeUnload_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_proceed{};
  ::base::TimeTicks p_before_unload_start_time{};
  ::base::TimeTicks p_before_unload_end_time{};
  LocalFrame_BeforeUnload_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success && !input_data_view.ReadBeforeUnloadStartTime(&p_before_unload_start_time))
    success = false;
  if (success && !input_data_view.ReadBeforeUnloadEndTime(&p_before_unload_end_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_before_unload_start_time), 
std::move(p_before_unload_end_time));
  return true;
}

void LocalFrame_BeforeUnload_ProxyToResponder::Run(
    bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::BeforeUnloadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proceed"), in_proceed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_start_time"), in_before_unload_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_end_time"), in_before_unload_end_time,
                        "<value of type ::base::TimeTicks>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_BeforeUnload_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_BeforeUnload_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->proceed = in_proceed;
  mojo::internal::MessageFragment<
      typename decltype(params->before_unload_start_time)::BaseType> before_unload_start_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_start_time, before_unload_start_time_fragment);
  params->before_unload_start_time.Set(
      before_unload_start_time_fragment.is_null() ? nullptr : before_unload_start_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_start_time in ");
  mojo::internal::MessageFragment<
      typename decltype(params->before_unload_end_time)::BaseType> before_unload_end_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_end_time, before_unload_end_time_fragment);
  params->before_unload_end_time.Set(
      before_unload_end_time_fragment.is_null() ? nullptr : before_unload_end_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_end_time in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::BeforeUnloadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BeforeUnload");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder {
 public:
  static LocalFrame::JavaScriptMethodExecuteRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::JavaScriptMethodExecuteRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder);
};

bool LocalFrame_JavaScriptMethodExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::JavaScriptMethodExecuteRequestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptMethodExecuteRequestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptMethodExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptMethodExecuteRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptExecuteRequest_ProxyToResponder {
 public:
  static LocalFrame::JavaScriptExecuteRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_JavaScriptExecuteRequest_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptExecuteRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_JavaScriptExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_JavaScriptExecuteRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::JavaScriptExecuteRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptExecuteRequest_ProxyToResponder);
};

bool LocalFrame_JavaScriptExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::JavaScriptExecuteRequestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptExecuteRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 29, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LocalFrame_JavaScriptExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder {
 public:
  static LocalFrame::JavaScriptExecuteRequestForTestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::JavaScriptExecuteRequestForTestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder);
};

bool LocalFrame_JavaScriptExecuteRequestForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::JavaScriptExecuteRequestForTestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestForTestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptExecuteRequestForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestForTestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder {
 public:
  static LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder> proxy(
        new LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder);
};

bool LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetSavableResourceLinks_ProxyToResponder {
 public:
  static LocalFrame::GetSavableResourceLinksCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_GetSavableResourceLinks_ProxyToResponder> proxy(
        new LocalFrame_GetSavableResourceLinks_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_GetSavableResourceLinks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetSavableResourceLinks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_GetSavableResourceLinks_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::GetSavableResourceLinksCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetSavableResourceLinksReplyPtr in_reply);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetSavableResourceLinks_ProxyToResponder);
};

bool LocalFrame_GetSavableResourceLinks_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::GetSavableResourceLinksCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GetSavableResourceLinksReplyPtr p_reply{};
  LocalFrame_GetSavableResourceLinks_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 34, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_reply));
  return true;
}

void LocalFrame_GetSavableResourceLinks_ProxyToResponder::Run(
    GetSavableResourceLinksReplyPtr in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinksCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type GetSavableResourceLinksReplyPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetSavableResourceLinks_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::GetSavableResourceLinksReplyDataView>(
      in_reply, reply_fragment);
  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinksCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetSavableResourceLinks");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder {
 public:
  static LocalFrame::GetCanonicalUrlForSharingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder> proxy(
        new LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::GetCanonicalUrlForSharingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<::GURL>& in_canonical_url);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder);
};

bool LocalFrame_GetCanonicalUrlForSharing_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::GetCanonicalUrlForSharingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::GURL> p_canonical_url{};
  LocalFrame_GetCanonicalUrlForSharing_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCanonicalUrl(&p_canonical_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_canonical_url));
  return true;
}

void LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder::Run(
    const absl::optional<::GURL>& in_canonical_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::GetCanonicalUrlForSharingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("canonical_url"), in_canonical_url,
                        "<value of type const absl::optional<::GURL>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_GetCanonicalUrlForSharing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->canonical_url)::BaseType> canonical_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_canonical_url, canonical_url_fragment);
  params->canonical_url.Set(
      canonical_url_fragment.is_null() ? nullptr : canonical_url_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::GetCanonicalUrlForSharingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameStubDispatch::Accept(
    LocalFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalFrame_GetTextSurroundingSelection_Name: {
      break;
    }
    case internal::kLocalFrame_SendInterventionReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SendInterventionReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SendInterventionReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SendInterventionReport_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SendInterventionReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_id{};
      std::string p_message{};
      LocalFrame_SendInterventionReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendInterventionReport(
std::move(p_id), 
std::move(p_message));
      return true;
    }
    case internal::kLocalFrame_SetFrameOwnerProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SetFrameOwnerProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SetFrameOwnerProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FrameOwnerPropertiesPtr p_properties{};
      LocalFrame_SetFrameOwnerProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameOwnerProperties(
std::move(p_properties));
      return true;
    }
    case internal::kLocalFrame_NotifyUserActivation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::NotifyUserActivation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::NotifyUserActivation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyUserActivation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyUserActivation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::UserActivationNotificationType p_notification_type{};
      LocalFrame_NotifyUserActivation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUserActivation(
std::move(p_notification_type));
      return true;
    }
    case internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_keyboard_rect{};
      LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyboardRect(&p_keyboard_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyVirtualKeyboardOverlayRect(
std::move(p_keyboard_rect));
      return true;
    }
    case internal::kLocalFrame_AddMessageToConsole_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AddMessageToConsole",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AddMessageToConsole");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ConsoleMessageLevel p_level{};
      std::string p_message{};
      bool p_discard_duplicates{};
      LocalFrame_AddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_discard_duplicates = input_data_view.discard_duplicates();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMessageToConsole(
std::move(p_level), 
std::move(p_message), 
std::move(p_discard_duplicates));
      return true;
    }
    case internal::kLocalFrame_AddInspectorIssue_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AddInspectorIssue",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AddInspectorIssue");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AddInspectorIssue_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AddInspectorIssue_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::InspectorIssueInfoPtr p_info{};
      LocalFrame_AddInspectorIssue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddInspectorIssue(
std::move(p_info));
      return true;
    }
    case internal::kLocalFrame_SwapInImmediately_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SwapInImmediately",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SwapInImmediately");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SwapInImmediately_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SwapInImmediately_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_SwapInImmediately_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwapInImmediately();
      return true;
    }
    case internal::kLocalFrame_CheckCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::CheckCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::CheckCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_CheckCompleted_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_CheckCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_CheckCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckCompleted();
      return true;
    }
    case internal::kLocalFrame_StopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::StopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::StopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_StopLoading_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_StopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_StopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopLoading();
      return true;
    }
    case internal::kLocalFrame_Collapse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::Collapse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::Collapse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_Collapse_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_Collapse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_collapsed{};
      LocalFrame_Collapse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_collapsed = input_data_view.collapsed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collapse(
std::move(p_collapsed));
      return true;
    }
    case internal::kLocalFrame_EnableViewSourceMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::EnableViewSourceMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::EnableViewSourceMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_EnableViewSourceMode_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_EnableViewSourceMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_EnableViewSourceMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableViewSourceMode();
      return true;
    }
    case internal::kLocalFrame_Focus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::Focus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::Focus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_Focus_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_Focus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_Focus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus();
      return true;
    }
    case internal::kLocalFrame_ClearFocusedElement_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::ClearFocusedElement",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::ClearFocusedElement");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ClearFocusedElement_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ClearFocusedElement_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_ClearFocusedElement_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearFocusedElement();
      return true;
    }
    case internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetResourceSnapshotForWebBundle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetResourceSnapshotForWebBundle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::ResourceSnapshotForWebBundle> p_receiver{};
      LocalFrame_GetResourceSnapshotForWebBundle_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetResourceSnapshotForWebBundle(
std::move(p_receiver));
      return true;
    }
    case internal::kLocalFrame_CopyImageAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::CopyImageAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::CopyImageAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_CopyImageAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_CopyImageAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_window_point{};
      LocalFrame_CopyImageAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowPoint(&p_window_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyImageAt(
std::move(p_window_point));
      return true;
    }
    case internal::kLocalFrame_SaveImageAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SaveImageAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SaveImageAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SaveImageAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SaveImageAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_window_point{};
      LocalFrame_SaveImageAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowPoint(&p_window_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveImageAt(
std::move(p_window_point));
      return true;
    }
    case internal::kLocalFrame_ReportBlinkFeatureUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::ReportBlinkFeatureUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::ReportBlinkFeatureUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::blink::mojom::WebFeature> p_features{};
      LocalFrame_ReportBlinkFeatureUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportBlinkFeatureUsage(
std::move(p_features));
      return true;
    }
    case internal::kLocalFrame_RenderFallbackContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::RenderFallbackContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::RenderFallbackContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_RenderFallbackContent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_RenderFallbackContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_RenderFallbackContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContent();
      return true;
    }
    case internal::kLocalFrame_RenderFallbackContentWithResourceTiming_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::RenderFallbackContentWithResourceTiming",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::RenderFallbackContentWithResourceTiming");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceTimingInfoPtr p_timing{};
      std::string p_server_timing_value{};
      LocalFrame_RenderFallbackContentWithResourceTiming_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (success && !input_data_view.ReadServerTimingValue(&p_server_timing_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContentWithResourceTiming(
std::move(p_timing), 
std::move(p_server_timing_value));
      return true;
    }
    case internal::kLocalFrame_BeforeUnload_Name: {
      break;
    }
    case internal::kLocalFrame_MediaPlayerActionAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::MediaPlayerActionAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::MediaPlayerActionAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_MediaPlayerActionAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MediaPlayerActionAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_location{};
      ::blink::mojom::MediaPlayerActionPtr p_action{};
      LocalFrame_MediaPlayerActionAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaPlayerActionAt(
std::move(p_location), 
std::move(p_action));
      return true;
    }
    case internal::kLocalFrame_AdvanceFocusInFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AdvanceFocusInFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AdvanceFocusInFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AdvanceFocusInFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AdvanceFocusInFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FocusType p_focus_type{};
      absl::optional<::blink::RemoteFrameToken> p_source_frame_token{};
      LocalFrame_AdvanceFocusInFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocusInFrame(
std::move(p_focus_type), 
std::move(p_source_frame_token));
      return true;
    }
    case internal::kLocalFrame_AdvanceFocusInForm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AdvanceFocusInForm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AdvanceFocusInForm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AdvanceFocusInForm_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AdvanceFocusInForm_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FocusType p_focus_type{};
      LocalFrame_AdvanceFocusInForm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocusInForm(
std::move(p_focus_type));
      return true;
    }
    case internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::CSPViolationPtr p_violation{};
      LocalFrame_ReportContentSecurityPolicyViolation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViolation(&p_violation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportContentSecurityPolicyViolation(
std::move(p_violation));
      return true;
    }
    case internal::kLocalFrame_DidUpdateFramePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::DidUpdateFramePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::DidUpdateFramePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_DidUpdateFramePolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_DidUpdateFramePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      LocalFrame_DidUpdateFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateFramePolicy(
std::move(p_frame_policy));
      return true;
    }
    case internal::kLocalFrame_OnScreensChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::OnScreensChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::OnScreensChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_OnScreensChange_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_OnScreensChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_OnScreensChange_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreensChange();
      return true;
    }
    case internal::kLocalFrame_PostMessageEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::PostMessageEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::PostMessageEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_PostMessageEvent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_PostMessageEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::blink::RemoteFrameToken> p_source_frame_token{};
      ::std::u16string p_source_origin{};
      ::std::u16string p_target_origin{};
      ::blink::TransferableMessage p_message{};
      LocalFrame_PostMessageEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadTargetOrigin(&p_target_origin))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageEvent(
std::move(p_source_frame_token), 
std::move(p_source_origin), 
std::move(p_target_origin), 
std::move(p_message));
      return true;
    }
    case internal::kLocalFrame_JavaScriptMethodExecuteRequest_Name: {
      break;
    }
    case internal::kLocalFrame_JavaScriptExecuteRequest_Name: {
      break;
    }
    case internal::kLocalFrame_JavaScriptExecuteRequestForTests_Name: {
      break;
    }
    case internal::kLocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Name: {
      break;
    }
    case internal::kLocalFrame_BindReportingObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::BindReportingObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::BindReportingObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_BindReportingObserver_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_BindReportingObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> p_receiver{};
      LocalFrame_BindReportingObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReportingObserver(
std::move(p_receiver));
      return true;
    }
    case internal::kLocalFrame_UpdateOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::UpdateOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::UpdateOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_UpdateOpener_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_UpdateOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::blink::FrameToken> p_opener_frame_token{};
      LocalFrame_UpdateOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOpener(
std::move(p_opener_frame_token));
      return true;
    }
    case internal::kLocalFrame_GetSavableResourceLinks_Name: {
      break;
    }
    case internal::kLocalFrame_MixedContentFound_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::MixedContentFound",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::MixedContentFound");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_MixedContentFound_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MixedContentFound_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_main_resource_url{};
      ::GURL p_mixed_content_url{};
      ::blink::mojom::RequestContextType p_request_context{};
      bool p_was_allowed{};
      ::GURL p_url_before_redirects{};
      bool p_had_redirect{};
      ::network::mojom::SourceLocationPtr p_source_location{};
      LocalFrame_MixedContentFound_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMainResourceUrl(&p_main_resource_url))
        success = false;
      if (success && !input_data_view.ReadMixedContentUrl(&p_mixed_content_url))
        success = false;
      if (success && !input_data_view.ReadRequestContext(&p_request_context))
        success = false;
      if (success)
        p_was_allowed = input_data_view.was_allowed();
      if (success && !input_data_view.ReadUrlBeforeRedirects(&p_url_before_redirects))
        success = false;
      if (success)
        p_had_redirect = input_data_view.had_redirect();
      if (success && !input_data_view.ReadSourceLocation(&p_source_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MixedContentFound(
std::move(p_main_resource_url), 
std::move(p_mixed_content_url), 
std::move(p_request_context), 
std::move(p_was_allowed), 
std::move(p_url_before_redirects), 
std::move(p_had_redirect), 
std::move(p_source_location));
      return true;
    }
    case internal::kLocalFrame_BindDevToolsAgent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::BindDevToolsAgent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::BindDevToolsAgent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_BindDevToolsAgent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_BindDevToolsAgent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> p_agent{};
      LocalFrame_BindDevToolsAgent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDevToolsAgent(
std::move(p_agent_host), 
std::move(p_agent));
      return true;
    }
    case internal::kLocalFrame_HandleRendererDebugURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::HandleRendererDebugURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::HandleRendererDebugURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_HandleRendererDebugURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_HandleRendererDebugURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      LocalFrame_HandleRendererDebugURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleRendererDebugURL(
std::move(p_url));
      return true;
    }
    case internal::kLocalFrame_GetCanonicalUrlForSharing_Name: {
      break;
    }
  }
  return false;
}

// static
bool LocalFrameStubDispatch::AcceptWithResponder(
    LocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrame_GetTextSurroundingSelection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_GetTextSurroundingSelection_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetTextSurroundingSelection_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_max_length{};
      LocalFrame_GetTextSurroundingSelection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_max_length = input_data_view.max_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 0, false);
        return false;
      }
      LocalFrame::GetTextSurroundingSelectionCallback callback =
          LocalFrame_GetTextSurroundingSelection_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTextSurroundingSelection(
std::move(p_max_length), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_SendInterventionReport_Name: {
      break;
    }
    case internal::kLocalFrame_SetFrameOwnerProperties_Name: {
      break;
    }
    case internal::kLocalFrame_NotifyUserActivation_Name: {
      break;
    }
    case internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name: {
      break;
    }
    case internal::kLocalFrame_AddMessageToConsole_Name: {
      break;
    }
    case internal::kLocalFrame_AddInspectorIssue_Name: {
      break;
    }
    case internal::kLocalFrame_SwapInImmediately_Name: {
      break;
    }
    case internal::kLocalFrame_CheckCompleted_Name: {
      break;
    }
    case internal::kLocalFrame_StopLoading_Name: {
      break;
    }
    case internal::kLocalFrame_Collapse_Name: {
      break;
    }
    case internal::kLocalFrame_EnableViewSourceMode_Name: {
      break;
    }
    case internal::kLocalFrame_Focus_Name: {
      break;
    }
    case internal::kLocalFrame_ClearFocusedElement_Name: {
      break;
    }
    case internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name: {
      break;
    }
    case internal::kLocalFrame_CopyImageAt_Name: {
      break;
    }
    case internal::kLocalFrame_SaveImageAt_Name: {
      break;
    }
    case internal::kLocalFrame_ReportBlinkFeatureUsage_Name: {
      break;
    }
    case internal::kLocalFrame_RenderFallbackContent_Name: {
      break;
    }
    case internal::kLocalFrame_RenderFallbackContentWithResourceTiming_Name: {
      break;
    }
    case internal::kLocalFrame_BeforeUnload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::BeforeUnload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::BeforeUnload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_BeforeUnload_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_BeforeUnload_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_is_reload{};
      LocalFrame_BeforeUnload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 20, false);
        return false;
      }
      LocalFrame::BeforeUnloadCallback callback =
          LocalFrame_BeforeUnload_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeforeUnload(
std::move(p_is_reload), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_MediaPlayerActionAt_Name: {
      break;
    }
    case internal::kLocalFrame_AdvanceFocusInFrame_Name: {
      break;
    }
    case internal::kLocalFrame_AdvanceFocusInForm_Name: {
      break;
    }
    case internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name: {
      break;
    }
    case internal::kLocalFrame_DidUpdateFramePolicy_Name: {
      break;
    }
    case internal::kLocalFrame_OnScreensChange_Name: {
      break;
    }
    case internal::kLocalFrame_PostMessageEvent_Name: {
      break;
    }
    case internal::kLocalFrame_JavaScriptMethodExecuteRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::JavaScriptMethodExecuteRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_object_name{};
      ::std::u16string p_method_name{};
      ::base::Value p_arguments{};
      bool p_wants_result{};
      LocalFrame_JavaScriptMethodExecuteRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadObjectName(&p_object_name))
        success = false;
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadArguments(&p_arguments))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 28, false);
        return false;
      }
      LocalFrame::JavaScriptMethodExecuteRequestCallback callback =
          LocalFrame_JavaScriptMethodExecuteRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptMethodExecuteRequest(
std::move(p_object_name), 
std::move(p_method_name), 
std::move(p_arguments), 
std::move(p_wants_result), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_JavaScriptExecuteRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_JavaScriptExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_javascript{};
      bool p_wants_result{};
      LocalFrame_JavaScriptExecuteRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 29, false);
        return false;
      }
      LocalFrame::JavaScriptExecuteRequestCallback callback =
          LocalFrame_JavaScriptExecuteRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequest(
std::move(p_javascript), 
std::move(p_wants_result), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_JavaScriptExecuteRequestForTests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestForTests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_javascript{};
      bool p_wants_result{};
      bool p_has_user_gesture{};
      int32_t p_world_id{};
      LocalFrame_JavaScriptExecuteRequestForTests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 30, false);
        return false;
      }
      LocalFrame::JavaScriptExecuteRequestForTestsCallback callback =
          LocalFrame_JavaScriptExecuteRequestForTests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestForTests(
std::move(p_javascript), 
std::move(p_wants_result), 
std::move(p_has_user_gesture), 
std::move(p_world_id), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::JavaScriptExecuteRequestInIsolatedWorld");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_javascript{};
      bool p_wants_result{};
      int32_t p_world_id{};
      LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 31, false);
        return false;
      }
      LocalFrame::JavaScriptExecuteRequestInIsolatedWorldCallback callback =
          LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestInIsolatedWorld(
std::move(p_javascript), 
std::move(p_wants_result), 
std::move(p_world_id), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_BindReportingObserver_Name: {
      break;
    }
    case internal::kLocalFrame_UpdateOpener_Name: {
      break;
    }
    case internal::kLocalFrame_GetSavableResourceLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_GetSavableResourceLinks_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetSavableResourceLinks_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalFrame_GetSavableResourceLinks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 34, false);
        return false;
      }
      LocalFrame::GetSavableResourceLinksCallback callback =
          LocalFrame_GetSavableResourceLinks_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSavableResourceLinks(std::move(callback));
      return true;
    }
    case internal::kLocalFrame_MixedContentFound_Name: {
      break;
    }
    case internal::kLocalFrame_BindDevToolsAgent_Name: {
      break;
    }
    case internal::kLocalFrame_HandleRendererDebugURL_Name: {
      break;
    }
    case internal::kLocalFrame_GetCanonicalUrlForSharing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetCanonicalUrlForSharing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetCanonicalUrlForSharing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalFrame_GetCanonicalUrlForSharing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 38, false);
        return false;
      }
      LocalFrame::GetCanonicalUrlForSharingCallback callback =
          LocalFrame_GetCanonicalUrlForSharing_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCanonicalUrlForSharing(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameValidationInfo[] = {
    {internal::kLocalFrame_GetTextSurroundingSelection_Name,
     {&internal::LocalFrame_GetTextSurroundingSelection_Params_Data::Validate,
      &internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_SendInterventionReport_Name,
     {&internal::LocalFrame_SendInterventionReport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SetFrameOwnerProperties_Name,
     {&internal::LocalFrame_SetFrameOwnerProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_NotifyUserActivation_Name,
     {&internal::LocalFrame_NotifyUserActivation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name,
     {&internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AddMessageToConsole_Name,
     {&internal::LocalFrame_AddMessageToConsole_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AddInspectorIssue_Name,
     {&internal::LocalFrame_AddInspectorIssue_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SwapInImmediately_Name,
     {&internal::LocalFrame_SwapInImmediately_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_CheckCompleted_Name,
     {&internal::LocalFrame_CheckCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_StopLoading_Name,
     {&internal::LocalFrame_StopLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_Collapse_Name,
     {&internal::LocalFrame_Collapse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_EnableViewSourceMode_Name,
     {&internal::LocalFrame_EnableViewSourceMode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_Focus_Name,
     {&internal::LocalFrame_Focus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ClearFocusedElement_Name,
     {&internal::LocalFrame_ClearFocusedElement_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name,
     {&internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_CopyImageAt_Name,
     {&internal::LocalFrame_CopyImageAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SaveImageAt_Name,
     {&internal::LocalFrame_SaveImageAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ReportBlinkFeatureUsage_Name,
     {&internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_RenderFallbackContent_Name,
     {&internal::LocalFrame_RenderFallbackContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_RenderFallbackContentWithResourceTiming_Name,
     {&internal::LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_BeforeUnload_Name,
     {&internal::LocalFrame_BeforeUnload_Params_Data::Validate,
      &internal::LocalFrame_BeforeUnload_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_MediaPlayerActionAt_Name,
     {&internal::LocalFrame_MediaPlayerActionAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AdvanceFocusInFrame_Name,
     {&internal::LocalFrame_AdvanceFocusInFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AdvanceFocusInForm_Name,
     {&internal::LocalFrame_AdvanceFocusInForm_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name,
     {&internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_DidUpdateFramePolicy_Name,
     {&internal::LocalFrame_DidUpdateFramePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_OnScreensChange_Name,
     {&internal::LocalFrame_OnScreensChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_PostMessageEvent_Name,
     {&internal::LocalFrame_PostMessageEvent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_JavaScriptMethodExecuteRequest_Name,
     {&internal::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data::Validate,
      &internal::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_JavaScriptExecuteRequest_Name,
     {&internal::LocalFrame_JavaScriptExecuteRequest_Params_Data::Validate,
      &internal::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_JavaScriptExecuteRequestForTests_Name,
     {&internal::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data::Validate,
      &internal::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Name,
     {&internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::Validate,
      &internal::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_BindReportingObserver_Name,
     {&internal::LocalFrame_BindReportingObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_UpdateOpener_Name,
     {&internal::LocalFrame_UpdateOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_GetSavableResourceLinks_Name,
     {&internal::LocalFrame_GetSavableResourceLinks_Params_Data::Validate,
      &internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_MixedContentFound_Name,
     {&internal::LocalFrame_MixedContentFound_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_BindDevToolsAgent_Name,
     {&internal::LocalFrame_BindDevToolsAgent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_HandleRendererDebugURL_Name,
     {&internal::LocalFrame_HandleRendererDebugURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_GetCanonicalUrlForSharing_Name,
     {&internal::LocalFrame_GetCanonicalUrlForSharing_Params_Data::Validate,
      &internal::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data::Validate}},
};

bool LocalFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameValidationInfo);
}

bool LocalFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalFrameValidationInfo);

}
const char HighPriorityLocalFrame::Name_[] = "blink.mojom.HighPriorityLocalFrame";

class HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback(
      HighPriorityLocalFrame::DispatchBeforeUnloadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HighPriorityLocalFrame::DispatchBeforeUnloadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback);
};

HighPriorityLocalFrameProxy::HighPriorityLocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HighPriorityLocalFrameProxy::DispatchBeforeUnload(
    bool in_is_reload, DispatchBeforeUnloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), in_is_reload,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data> params(
          message);
  params.Allocate();
  params->is_reload = in_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HighPriorityLocalFrame::Name_);
  message.set_method_name("DispatchBeforeUnload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder {
 public:
  static HighPriorityLocalFrame::DispatchBeforeUnloadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder> proxy(
        new HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HighPriorityLocalFrame::DispatchBeforeUnloadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder);
};

bool HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnloadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_proceed{};
  ::base::TimeTicks p_before_unload_start_time{};
  ::base::TimeTicks p_before_unload_end_time{};
  HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success && !input_data_view.ReadBeforeUnloadStartTime(&p_before_unload_start_time))
    success = false;
  if (success && !input_data_view.ReadBeforeUnloadEndTime(&p_before_unload_end_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HighPriorityLocalFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_before_unload_start_time), 
std::move(p_before_unload_end_time));
  return true;
}

void HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder::Run(
    bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnloadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proceed"), in_proceed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_start_time"), in_before_unload_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before_unload_end_time"), in_before_unload_end_time,
                        "<value of type ::base::TimeTicks>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->proceed = in_proceed;
  mojo::internal::MessageFragment<
      typename decltype(params->before_unload_start_time)::BaseType> before_unload_start_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_start_time, before_unload_start_time_fragment);
  params->before_unload_start_time.Set(
      before_unload_start_time_fragment.is_null() ? nullptr : before_unload_start_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_start_time in ");
  mojo::internal::MessageFragment<
      typename decltype(params->before_unload_end_time)::BaseType> before_unload_end_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_end_time, before_unload_end_time_fragment);
  params->before_unload_end_time.Set(
      before_unload_end_time_fragment.is_null() ? nullptr : before_unload_end_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_end_time in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnloadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HighPriorityLocalFrame::Name_);
  message.set_method_name("DispatchBeforeUnload");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HighPriorityLocalFrameStubDispatch::Accept(
    HighPriorityLocalFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name: {
      break;
    }
  }
  return false;
}

// static
bool HighPriorityLocalFrameStubDispatch::AcceptWithResponder(
    HighPriorityLocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data* params =
          reinterpret_cast<
              internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_is_reload{};
      HighPriorityLocalFrame_DispatchBeforeUnload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HighPriorityLocalFrame::Name_, 0, false);
        return false;
      }
      HighPriorityLocalFrame::DispatchBeforeUnloadCallback callback =
          HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBeforeUnload(
std::move(p_is_reload), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHighPriorityLocalFrameValidationInfo[] = {
    {internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name,
     {&internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data::Validate,
      &internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data::Validate}},
};

bool HighPriorityLocalFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::HighPriorityLocalFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHighPriorityLocalFrameValidationInfo);
}

bool HighPriorityLocalFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::HighPriorityLocalFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kHighPriorityLocalFrameValidationInfo);

}
const char RemoteFrameHost::Name_[] = "blink.mojom.RemoteFrameHost";

RemoteFrameHostProxy::RemoteFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteFrameHostProxy::SetInheritedEffectiveTouchAction(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type ::cc::TouchAction>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
      in_touch_action, &params->touch_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SetInheritedEffectiveTouchAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::UpdateRenderThrottlingStatus(
    bool in_is_throttled, bool in_subtree_throttled, bool in_display_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_throttled"), in_is_throttled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subtree_throttled"), in_subtree_throttled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_locked"), in_display_locked,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data> params(
          message);
  params.Allocate();
  params->is_throttled = in_is_throttled;
  params->subtree_throttled = in_subtree_throttled;
  params->display_locked = in_display_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("UpdateRenderThrottlingStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::VisibilityChanged(
    ::blink::mojom::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::VisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type ::blink::mojom::FrameVisibility>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_VisibilityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_VisibilityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
      in_visibility, &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("VisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::DidFocusFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrameHost::DidFocusFrame");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_DidFocusFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_DidFocusFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("DidFocusFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::CheckCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrameHost::CheckCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_CheckCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_CheckCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("CheckCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::CapturePaintPreviewOfCrossProcessSubframe(
    const ::gfx::Rect& in_clip_rect, const ::base::UnguessableToken& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clip_rect"), in_clip_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clip_rect)::BaseType> clip_rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_clip_rect, clip_rect_fragment);
  params->clip_rect.Set(
      clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clip_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clip_rect in RemoteFrameHost.CapturePaintPreviewOfCrossProcessSubframe request");
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_guid, guid_fragment);
  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in RemoteFrameHost.CapturePaintPreviewOfCrossProcessSubframe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("CapturePaintPreviewOfCrossProcessSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::SetIsInert(
    bool in_inert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::SetIsInert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inert"), in_inert,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_SetIsInert_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_SetIsInert_Params_Data> params(
          message);
  params.Allocate();
  params->inert = in_inert;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SetIsInert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::DidChangeOpener(
    const absl::optional<::blink::LocalFrameToken>& in_opener_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::DidChangeOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame"), in_opener_frame,
                        "<value of type const absl::optional<::blink::LocalFrameToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_DidChangeOpener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_DidChangeOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->opener_frame)::BaseType> opener_frame_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_opener_frame, opener_frame_fragment);
  params->opener_frame.Set(
      opener_frame_fragment.is_null() ? nullptr : opener_frame_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("DidChangeOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::AdvanceFocus(
    ::blink::mojom::FocusType in_focus_type, const ::blink::LocalFrameToken& in_source_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::AdvanceFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_AdvanceFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_AdvanceFocus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_source_frame_token, source_frame_token_fragment);
  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_frame_token in RemoteFrameHost.AdvanceFocus request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("AdvanceFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::RouteMessageEvent(
    const absl::optional<::blink::LocalFrameToken>& in_source_frame_token, const ::std::u16string& in_source_origin, const ::std::u16string& in_target_origin, ::blink::TransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::RouteMessageEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const absl::optional<::blink::LocalFrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_origin"), in_target_origin,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::TransferableMessage>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_RouteMessageEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_RouteMessageEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_source_frame_token, source_frame_token_fragment);
  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source_origin, source_origin_fragment);
  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in RemoteFrameHost.RouteMessageEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_origin)::BaseType> target_origin_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_target_origin, target_origin_fragment);
  params->target_origin.Set(
      target_origin_fragment.is_null() ? nullptr : target_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->target_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_origin in RemoteFrameHost.RouteMessageEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in RemoteFrameHost.RouteMessageEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("RouteMessageEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::PrintCrossProcessSubframe(
    const ::gfx::Rect& in_frame_content_rect, int32_t in_document_cookie) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_content_rect"), in_frame_content_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_content_rect)::BaseType> frame_content_rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_frame_content_rect, frame_content_rect_fragment);
  params->frame_content_rect.Set(
      frame_content_rect_fragment.is_null() ? nullptr : frame_content_rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_content_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_content_rect in RemoteFrameHost.PrintCrossProcessSubframe request");
  params->document_cookie = in_document_cookie;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("PrintCrossProcessSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::Detach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrameHost::Detach");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_Detach_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_Detach_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("Detach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::UpdateViewportIntersection(
    ::blink::mojom::ViewportIntersectionStatePtr in_intersection_state, const absl::optional<::blink::FrameVisualProperties>& in_visual_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::UpdateViewportIntersection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intersection_state"), in_intersection_state,
                        "<value of type ::blink::mojom::ViewportIntersectionStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visual_properties"), in_visual_properties,
                        "<value of type const absl::optional<::blink::FrameVisualProperties>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_UpdateViewportIntersection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->intersection_state)::BaseType> intersection_state_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ViewportIntersectionStateDataView>(
      in_intersection_state, intersection_state_fragment);
  params->intersection_state.Set(
      intersection_state_fragment.is_null() ? nullptr : intersection_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intersection_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intersection_state in RemoteFrameHost.UpdateViewportIntersection request");
  mojo::internal::MessageFragment<
      typename decltype(params->visual_properties)::BaseType> visual_properties_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameVisualPropertiesDataView>(
      in_visual_properties, visual_properties_fragment);
  params->visual_properties.Set(
      visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("UpdateViewportIntersection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::SynchronizeVisualProperties(
    const ::blink::FrameVisualProperties& in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::SynchronizeVisualProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type const ::blink::FrameVisualProperties&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_SynchronizeVisualProperties_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameVisualPropertiesDataView>(
      in_properties, properties_fragment);
  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in RemoteFrameHost.SynchronizeVisualProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SynchronizeVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::OpenURL(
    OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::OpenURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type OpenURLParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrameHost_OpenURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_OpenURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::OpenURLParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in RemoteFrameHost.OpenURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteFrameHostStubDispatch::Accept(
    RemoteFrameHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInheritedEffectiveTouchAction(
std::move(p_touch_action));
      return true;
    }
    case internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_throttled{};
      bool p_subtree_throttled{};
      bool p_display_locked{};
      RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_throttled = input_data_view.is_throttled();
      if (success)
        p_subtree_throttled = input_data_view.subtree_throttled();
      if (success)
        p_display_locked = input_data_view.display_locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRenderThrottlingStatus(
std::move(p_is_throttled), 
std::move(p_subtree_throttled), 
std::move(p_display_locked));
      return true;
    }
    case internal::kRemoteFrameHost_VisibilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::VisibilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::VisibilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_VisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_VisibilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FrameVisibility p_visibility{};
      RemoteFrameHost_VisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisibilityChanged(
std::move(p_visibility));
      return true;
    }
    case internal::kRemoteFrameHost_DidFocusFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::DidFocusFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::DidFocusFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_DidFocusFrame_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_DidFocusFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrameHost_DidFocusFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFocusFrame();
      return true;
    }
    case internal::kRemoteFrameHost_CheckCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::CheckCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::CheckCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_CheckCompleted_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_CheckCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrameHost_CheckCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckCompleted();
      return true;
    }
    case internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      ::base::UnguessableToken p_guid{};
      RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreviewOfCrossProcessSubframe(
std::move(p_clip_rect), 
std::move(p_guid));
      return true;
    }
    case internal::kRemoteFrameHost_SetIsInert_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::SetIsInert",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::SetIsInert");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SetIsInert_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SetIsInert_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_inert{};
      RemoteFrameHost_SetIsInert_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_inert = input_data_view.inert();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsInert(
std::move(p_inert));
      return true;
    }
    case internal::kRemoteFrameHost_DidChangeOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::DidChangeOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::DidChangeOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_DidChangeOpener_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_DidChangeOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::blink::LocalFrameToken> p_opener_frame{};
      RemoteFrameHost_DidChangeOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrame(&p_opener_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeOpener(
std::move(p_opener_frame));
      return true;
    }
    case internal::kRemoteFrameHost_AdvanceFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::AdvanceFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::AdvanceFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_AdvanceFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_AdvanceFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FocusType p_focus_type{};
      ::blink::LocalFrameToken p_source_frame_token{};
      RemoteFrameHost_AdvanceFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocus(
std::move(p_focus_type), 
std::move(p_source_frame_token));
      return true;
    }
    case internal::kRemoteFrameHost_RouteMessageEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::RouteMessageEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::RouteMessageEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_RouteMessageEvent_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_RouteMessageEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::blink::LocalFrameToken> p_source_frame_token{};
      ::std::u16string p_source_origin{};
      ::std::u16string p_target_origin{};
      ::blink::TransferableMessage p_message{};
      RemoteFrameHost_RouteMessageEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadTargetOrigin(&p_target_origin))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteMessageEvent(
std::move(p_source_frame_token), 
std::move(p_source_origin), 
std::move(p_target_origin), 
std::move(p_message));
      return true;
    }
    case internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_frame_content_rect{};
      int32_t p_document_cookie{};
      RemoteFrameHost_PrintCrossProcessSubframe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameContentRect(&p_frame_content_rect))
        success = false;
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintCrossProcessSubframe(
std::move(p_frame_content_rect), 
std::move(p_document_cookie));
      return true;
    }
    case internal::kRemoteFrameHost_Detach_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::Detach",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::Detach");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_Detach_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_Detach_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrameHost_Detach_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach();
      return true;
    }
    case internal::kRemoteFrameHost_UpdateViewportIntersection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::UpdateViewportIntersection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::UpdateViewportIntersection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ViewportIntersectionStatePtr p_intersection_state{};
      absl::optional<::blink::FrameVisualProperties> p_visual_properties{};
      RemoteFrameHost_UpdateViewportIntersection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIntersectionState(&p_intersection_state))
        success = false;
      if (success && !input_data_view.ReadVisualProperties(&p_visual_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateViewportIntersection(
std::move(p_intersection_state), 
std::move(p_visual_properties));
      return true;
    }
    case internal::kRemoteFrameHost_SynchronizeVisualProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::SynchronizeVisualProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::SynchronizeVisualProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FrameVisualProperties p_properties{};
      RemoteFrameHost_SynchronizeVisualProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SynchronizeVisualProperties(
std::move(p_properties));
      return true;
    }
    case internal::kRemoteFrameHost_OpenURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::OpenURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::OpenURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      OpenURLParamsPtr p_params{};
      RemoteFrameHost_OpenURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(
std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool RemoteFrameHostStubDispatch::AcceptWithResponder(
    RemoteFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name: {
      break;
    }
    case internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name: {
      break;
    }
    case internal::kRemoteFrameHost_VisibilityChanged_Name: {
      break;
    }
    case internal::kRemoteFrameHost_DidFocusFrame_Name: {
      break;
    }
    case internal::kRemoteFrameHost_CheckCompleted_Name: {
      break;
    }
    case internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name: {
      break;
    }
    case internal::kRemoteFrameHost_SetIsInert_Name: {
      break;
    }
    case internal::kRemoteFrameHost_DidChangeOpener_Name: {
      break;
    }
    case internal::kRemoteFrameHost_AdvanceFocus_Name: {
      break;
    }
    case internal::kRemoteFrameHost_RouteMessageEvent_Name: {
      break;
    }
    case internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name: {
      break;
    }
    case internal::kRemoteFrameHost_Detach_Name: {
      break;
    }
    case internal::kRemoteFrameHost_UpdateViewportIntersection_Name: {
      break;
    }
    case internal::kRemoteFrameHost_SynchronizeVisualProperties_Name: {
      break;
    }
    case internal::kRemoteFrameHost_OpenURL_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteFrameHostValidationInfo[] = {
    {internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name,
     {&internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name,
     {&internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_VisibilityChanged_Name,
     {&internal::RemoteFrameHost_VisibilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_DidFocusFrame_Name,
     {&internal::RemoteFrameHost_DidFocusFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_CheckCompleted_Name,
     {&internal::RemoteFrameHost_CheckCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name,
     {&internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_SetIsInert_Name,
     {&internal::RemoteFrameHost_SetIsInert_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_DidChangeOpener_Name,
     {&internal::RemoteFrameHost_DidChangeOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_AdvanceFocus_Name,
     {&internal::RemoteFrameHost_AdvanceFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_RouteMessageEvent_Name,
     {&internal::RemoteFrameHost_RouteMessageEvent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name,
     {&internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_Detach_Name,
     {&internal::RemoteFrameHost_Detach_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_UpdateViewportIntersection_Name,
     {&internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_SynchronizeVisualProperties_Name,
     {&internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_OpenURL_Name,
     {&internal::RemoteFrameHost_OpenURL_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RemoteFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteFrameHostValidationInfo);
}

const char RemoteFrame::Name_[] = "blink.mojom.RemoteFrame";

RemoteFrameProxy::RemoteFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteFrameProxy::WillEnterFullscreen(
    ::blink::mojom::FullscreenOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::WillEnterFullscreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_WillEnterFullscreen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_WillEnterFullscreen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in RemoteFrame.WillEnterFullscreen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("WillEnterFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::EnforceInsecureNavigationsSet(
    const std::vector<uint32_t>& in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type const std::vector<uint32_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType>
      set_fragment(params.message());
  const mojo::internal::ContainerValidateParams set_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_set, set_fragment, &set_validate_params);
  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->set.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null set in RemoteFrame.EnforceInsecureNavigationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnforceInsecureNavigationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetFrameOwnerProperties(
    ::blink::mojom::FrameOwnerPropertiesPtr in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetFrameOwnerProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetFrameOwnerProperties_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetFrameOwnerProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_properties, properties_fragment);
  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in RemoteFrame.SetFrameOwnerProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::EnforceInsecureRequestPolicy(
    ::blink::mojom::InsecureRequestPolicy in_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type ::blink::mojom::InsecureRequestPolicy>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
      in_policy, &params->policy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnforceInsecureRequestPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetReplicatedOrigin(
    const ::url::Origin& in_origin, bool in_is_potentially_trustworthy_unique_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetReplicatedOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_potentially_trustworthy_unique_origin"), in_is_potentially_trustworthy_unique_origin,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetReplicatedOrigin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetReplicatedOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in RemoteFrame.SetReplicatedOrigin request");
  params->is_potentially_trustworthy_unique_origin = in_is_potentially_trustworthy_unique_origin;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetReplicatedIsAdSubframe(
    bool in_is_ad_subframe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetReplicatedIsAdSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_subframe"), in_is_ad_subframe,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetReplicatedIsAdSubframe_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetReplicatedIsAdSubframe_Params_Data> params(
          message);
  params.Allocate();
  params->is_ad_subframe = in_is_ad_subframe;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedIsAdSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetReplicatedName(
    const std::string& in_name, const std::string& in_unique_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetReplicatedName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_name"), in_unique_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetReplicatedName_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetReplicatedName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in RemoteFrame.SetReplicatedName request");
  mojo::internal::MessageFragment<
      typename decltype(params->unique_name)::BaseType> unique_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_unique_name, unique_name_fragment);
  params->unique_name.Set(
      unique_name_fragment.is_null() ? nullptr : unique_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_name in RemoteFrame.SetReplicatedName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DispatchLoadEventForFrameOwner(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DispatchLoadEventForFrameOwner");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetNeedsOcclusionTracking(
    bool in_needs_tracking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetNeedsOcclusionTracking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_tracking"), in_needs_tracking,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetNeedsOcclusionTracking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data> params(
          message);
  params.Allocate();
  params->needs_tracking = in_needs_tracking;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetNeedsOcclusionTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::Collapse(
    bool in_collapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::Collapse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collapsed"), in_collapsed,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_Collapse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_Collapse_Params_Data> params(
          message);
  params.Allocate();
  params->collapsed = in_collapsed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("Collapse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::Focus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_Focus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_Focus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetHadStickyUserActivationBeforeNavigation(
    bool in_has_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gesture"), in_has_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data> params(
          message);
  params.Allocate();
  params->has_gesture = in_has_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetHadStickyUserActivationBeforeNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::BubbleLogicalScroll(
    ::blink::mojom::ScrollDirection in_direction, ::ui::ScrollGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::BubbleLogicalScroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type ::blink::mojom::ScrollDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type ::ui::ScrollGranularity>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_BubbleLogicalScroll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_BubbleLogicalScroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ScrollDirection>(
      in_direction, &params->direction);
  mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
      in_granularity, &params->granularity);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("BubbleLogicalScroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::UpdateUserActivationState(
    ::blink::mojom::UserActivationUpdateType in_state_update_type, ::blink::mojom::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::UpdateUserActivationState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state_update_type"), in_state_update_type,
                        "<value of type ::blink::mojom::UserActivationUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_type"), in_notification_type,
                        "<value of type ::blink::mojom::UserActivationNotificationType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_UpdateUserActivationState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_UpdateUserActivationState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::UserActivationUpdateType>(
      in_state_update_type, &params->state_update_type);
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
      in_notification_type, &params->notification_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("UpdateUserActivationState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetEmbeddingToken(
    const ::base::UnguessableToken& in_embedding_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetEmbeddingToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedding_token"), in_embedding_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetEmbeddingToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetEmbeddingToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->embedding_token)::BaseType> embedding_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_embedding_token, embedding_token_fragment);
  params->embedding_token.Set(
      embedding_token_fragment.is_null() ? nullptr : embedding_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedding_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedding_token in RemoteFrame.SetEmbeddingToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetEmbeddingToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetPageFocus(
    bool in_is_focused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetPageFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_focused"), in_is_focused,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetPageFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetPageFocus_Params_Data> params(
          message);
  params.Allocate();
  params->is_focused = in_is_focused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetPageFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::RenderFallbackContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::RenderFallbackContent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_RenderFallbackContent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_RenderFallbackContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("RenderFallbackContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::RenderFallbackContentWithResourceTiming(
    ::blink::mojom::ResourceTimingInfoPtr in_timing, const std::string& in_server_timing_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::RenderFallbackContentWithResourceTiming", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ::blink::mojom::ResourceTimingInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("server_timing_value"), in_server_timing_value,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_RenderFallbackContentWithResourceTiming_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in RemoteFrame.RenderFallbackContentWithResourceTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->server_timing_value)::BaseType> server_timing_value_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_server_timing_value, server_timing_value_fragment);
  params->server_timing_value.Set(
      server_timing_value_fragment.is_null() ? nullptr : server_timing_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->server_timing_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_timing_value in RemoteFrame.RenderFallbackContentWithResourceTiming request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("RenderFallbackContentWithResourceTiming");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::AddResourceTimingFromChild(
    ::blink::mojom::ResourceTimingInfoPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::AddResourceTimingFromChild", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ::blink::mojom::ResourceTimingInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_AddResourceTimingFromChild_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_AddResourceTimingFromChild_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in RemoteFrame.AddResourceTimingFromChild request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("AddResourceTimingFromChild");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::ScrollRectToVisible(
    const ::gfx::Rect& in_rect, ::blink::mojom::ScrollIntoViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::ScrollRectToVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::ScrollIntoViewParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_ScrollRectToVisible_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_ScrollRectToVisible_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, rect_fragment);
  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in RemoteFrame.ScrollRectToVisible request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ScrollIntoViewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in RemoteFrame.ScrollRectToVisible request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ScrollRectToVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidStartLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DidStartLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DidStartLoading_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidStartLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidStartLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DidStopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DidStopLoading_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidStopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::IntrinsicSizingInfoOfChildChanged(
    ::blink::mojom::IntrinsicSizingInfoPtr in_sizing_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sizing_info"), in_sizing_info,
                        "<value of type ::blink::mojom::IntrinsicSizingInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sizing_info)::BaseType> sizing_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::IntrinsicSizingInfoDataView>(
      in_sizing_info, sizing_info_fragment);
  params->sizing_info.Set(
      sizing_info_fragment.is_null() ? nullptr : sizing_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sizing_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sizing_info in RemoteFrame.IntrinsicSizingInfoOfChildChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("IntrinsicSizingInfoOfChildChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidSetFramePolicyHeaders(
    ::network::mojom::WebSandboxFlags in_sandbox_flags, const std::vector<::blink::ParsedPermissionsPolicyDeclaration>& in_parsed_permissions_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::DidSetFramePolicyHeaders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sandbox_flags"), in_sandbox_flags,
                        "<value of type ::network::mojom::WebSandboxFlags>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_permissions_policy"), in_parsed_permissions_policy,
                        "<value of type const std::vector<::blink::ParsedPermissionsPolicyDeclaration>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DidSetFramePolicyHeaders_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
      in_sandbox_flags, &params->sandbox_flags);
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_permissions_policy)::BaseType>
      parsed_permissions_policy_fragment(params.message());
  const mojo::internal::ContainerValidateParams parsed_permissions_policy_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
      in_parsed_permissions_policy, parsed_permissions_policy_fragment, &parsed_permissions_policy_validate_params);
  params->parsed_permissions_policy.Set(
      parsed_permissions_policy_fragment.is_null() ? nullptr : parsed_permissions_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parsed_permissions_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parsed_permissions_policy in RemoteFrame.DidSetFramePolicyHeaders request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidSetFramePolicyHeaders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidUpdateFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::DidUpdateFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DidUpdateFramePolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidUpdateFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, frame_policy_fragment);
  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in RemoteFrame.DidUpdateFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidUpdateFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::UpdateOpener(
    const absl::optional<::blink::FrameToken>& in_opener_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::UpdateOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const absl::optional<::blink::FrameToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_UpdateOpener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_UpdateOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_opener_frame_token, opener_frame_token_fragment, true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("UpdateOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DetachAndDispose(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DetachAndDispose");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DetachAndDispose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DetachAndDispose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DetachAndDispose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::EnableAutoResize(
    const ::gfx::Size& in_min_size, const ::gfx::Size& in_max_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::EnableAutoResize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_size"), in_min_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size"), in_max_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_EnableAutoResize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_EnableAutoResize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_size)::BaseType> min_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_size, min_size_fragment);
  params->min_size.Set(
      min_size_fragment.is_null() ? nullptr : min_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_size in RemoteFrame.EnableAutoResize request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_size)::BaseType> max_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_size, max_size_fragment);
  params->max_size.Set(
      max_size_fragment.is_null() ? nullptr : max_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->max_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_size in RemoteFrame.EnableAutoResize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnableAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DisableAutoResize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DisableAutoResize");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DisableAutoResize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DisableAutoResize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DisableAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidUpdateVisualProperties(
    const ::cc::RenderFrameMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::DidUpdateVisualProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::cc::RenderFrameMetadata&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_DidUpdateVisualProperties_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidUpdateVisualProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::cc::mojom::RenderFrameMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in RemoteFrame.DidUpdateVisualProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidUpdateVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetFrameSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_SetFrameSinkId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetFrameSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in RemoteFrame.SetFrameSinkId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetFrameSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::ChildProcessGone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::ChildProcessGone");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteFrame_ChildProcessGone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_ChildProcessGone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ChildProcessGone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteFrameStubDispatch::Accept(
    RemoteFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemoteFrame_WillEnterFullscreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::WillEnterFullscreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::WillEnterFullscreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_WillEnterFullscreen_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_WillEnterFullscreen_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      RemoteFrame_WillEnterFullscreen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WillEnterFullscreen(
std::move(p_options));
      return true;
    }
    case internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint32_t> p_set{};
      RemoteFrame_EnforceInsecureNavigationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureNavigationsSet(
std::move(p_set));
      return true;
    }
    case internal::kRemoteFrame_SetFrameOwnerProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetFrameOwnerProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetFrameOwnerProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FrameOwnerPropertiesPtr p_properties{};
      RemoteFrame_SetFrameOwnerProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameOwnerProperties(
std::move(p_properties));
      return true;
    }
    case internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::InsecureRequestPolicy p_policy{};
      RemoteFrame_EnforceInsecureRequestPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureRequestPolicy(
std::move(p_policy));
      return true;
    }
    case internal::kRemoteFrame_SetReplicatedOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetReplicatedOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetReplicatedOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedOrigin_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedOrigin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      bool p_is_potentially_trustworthy_unique_origin{};
      RemoteFrame_SetReplicatedOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_is_potentially_trustworthy_unique_origin = input_data_view.is_potentially_trustworthy_unique_origin();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedOrigin(
std::move(p_origin), 
std::move(p_is_potentially_trustworthy_unique_origin));
      return true;
    }
    case internal::kRemoteFrame_SetReplicatedIsAdSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetReplicatedIsAdSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetReplicatedIsAdSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedIsAdSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedIsAdSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_ad_subframe{};
      RemoteFrame_SetReplicatedIsAdSubframe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_ad_subframe = input_data_view.is_ad_subframe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedIsAdSubframe(
std::move(p_is_ad_subframe));
      return true;
    }
    case internal::kRemoteFrame_SetReplicatedName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetReplicatedName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetReplicatedName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedName_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      std::string p_unique_name{};
      RemoteFrame_SetReplicatedName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUniqueName(&p_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedName(
std::move(p_name), 
std::move(p_unique_name));
      return true;
    }
    case internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DispatchLoadEventForFrameOwner_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoadEventForFrameOwner();
      return true;
    }
    case internal::kRemoteFrame_SetNeedsOcclusionTracking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetNeedsOcclusionTracking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetNeedsOcclusionTracking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_tracking{};
      RemoteFrame_SetNeedsOcclusionTracking_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_tracking = input_data_view.needs_tracking();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsOcclusionTracking(
std::move(p_needs_tracking));
      return true;
    }
    case internal::kRemoteFrame_Collapse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::Collapse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::Collapse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_Collapse_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_Collapse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_collapsed{};
      RemoteFrame_Collapse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_collapsed = input_data_view.collapsed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collapse(
std::move(p_collapsed));
      return true;
    }
    case internal::kRemoteFrame_Focus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::Focus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::Focus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_Focus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_Focus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_Focus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus();
      return true;
    }
    case internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_gesture{};
      RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_gesture = input_data_view.has_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadStickyUserActivationBeforeNavigation(
std::move(p_has_gesture));
      return true;
    }
    case internal::kRemoteFrame_BubbleLogicalScroll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::BubbleLogicalScroll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::BubbleLogicalScroll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_BubbleLogicalScroll_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_BubbleLogicalScroll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ScrollDirection p_direction{};
      ::ui::ScrollGranularity p_granularity{};
      RemoteFrame_BubbleLogicalScroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BubbleLogicalScroll(
std::move(p_direction), 
std::move(p_granularity));
      return true;
    }
    case internal::kRemoteFrame_UpdateUserActivationState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::UpdateUserActivationState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::UpdateUserActivationState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_UpdateUserActivationState_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_UpdateUserActivationState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::UserActivationUpdateType p_state_update_type{};
      ::blink::mojom::UserActivationNotificationType p_notification_type{};
      RemoteFrame_UpdateUserActivationState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStateUpdateType(&p_state_update_type))
        success = false;
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserActivationState(
std::move(p_state_update_type), 
std::move(p_notification_type));
      return true;
    }
    case internal::kRemoteFrame_SetEmbeddingToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetEmbeddingToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetEmbeddingToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetEmbeddingToken_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetEmbeddingToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_embedding_token{};
      RemoteFrame_SetEmbeddingToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEmbeddingToken(&p_embedding_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEmbeddingToken(
std::move(p_embedding_token));
      return true;
    }
    case internal::kRemoteFrame_SetPageFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetPageFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetPageFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetPageFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetPageFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_focused{};
      RemoteFrame_SetPageFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_focused = input_data_view.is_focused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageFocus(
std::move(p_is_focused));
      return true;
    }
    case internal::kRemoteFrame_RenderFallbackContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::RenderFallbackContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::RenderFallbackContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_RenderFallbackContent_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_RenderFallbackContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_RenderFallbackContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContent();
      return true;
    }
    case internal::kRemoteFrame_RenderFallbackContentWithResourceTiming_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::RenderFallbackContentWithResourceTiming",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::RenderFallbackContentWithResourceTiming");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceTimingInfoPtr p_timing{};
      std::string p_server_timing_value{};
      RemoteFrame_RenderFallbackContentWithResourceTiming_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (success && !input_data_view.ReadServerTimingValue(&p_server_timing_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContentWithResourceTiming(
std::move(p_timing), 
std::move(p_server_timing_value));
      return true;
    }
    case internal::kRemoteFrame_AddResourceTimingFromChild_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::AddResourceTimingFromChild",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::AddResourceTimingFromChild");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_AddResourceTimingFromChild_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_AddResourceTimingFromChild_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceTimingInfoPtr p_timing{};
      RemoteFrame_AddResourceTimingFromChild_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddResourceTimingFromChild(
std::move(p_timing));
      return true;
    }
    case internal::kRemoteFrame_ScrollRectToVisible_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::ScrollRectToVisible",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::ScrollRectToVisible");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_ScrollRectToVisible_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ScrollRectToVisible_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect{};
      ::blink::mojom::ScrollIntoViewParamsPtr p_params{};
      RemoteFrame_ScrollRectToVisible_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollRectToVisible(
std::move(p_rect), 
std::move(p_params));
      return true;
    }
    case internal::kRemoteFrame_DidStartLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidStartLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidStartLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidStartLoading_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidStartLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DidStartLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartLoading();
      return true;
    }
    case internal::kRemoteFrame_DidStopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidStopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidStopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DidStopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading();
      return true;
    }
    case internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::IntrinsicSizingInfoPtr p_sizing_info{};
      RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSizingInfo(&p_sizing_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IntrinsicSizingInfoOfChildChanged(
std::move(p_sizing_info));
      return true;
    }
    case internal::kRemoteFrame_DidSetFramePolicyHeaders_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidSetFramePolicyHeaders",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidSetFramePolicyHeaders");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::WebSandboxFlags p_sandbox_flags{};
      std::vector<::blink::ParsedPermissionsPolicyDeclaration> p_parsed_permissions_policy{};
      RemoteFrame_DidSetFramePolicyHeaders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSandboxFlags(&p_sandbox_flags))
        success = false;
      if (success && !input_data_view.ReadParsedPermissionsPolicy(&p_parsed_permissions_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidSetFramePolicyHeaders(
std::move(p_sandbox_flags), 
std::move(p_parsed_permissions_policy));
      return true;
    }
    case internal::kRemoteFrame_DidUpdateFramePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidUpdateFramePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidUpdateFramePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidUpdateFramePolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidUpdateFramePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      RemoteFrame_DidUpdateFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateFramePolicy(
std::move(p_frame_policy));
      return true;
    }
    case internal::kRemoteFrame_UpdateOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::UpdateOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::UpdateOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_UpdateOpener_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_UpdateOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::blink::FrameToken> p_opener_frame_token{};
      RemoteFrame_UpdateOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOpener(
std::move(p_opener_frame_token));
      return true;
    }
    case internal::kRemoteFrame_DetachAndDispose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DetachAndDispose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DetachAndDispose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DetachAndDispose_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DetachAndDispose_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DetachAndDispose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachAndDispose();
      return true;
    }
    case internal::kRemoteFrame_EnableAutoResize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::EnableAutoResize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::EnableAutoResize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnableAutoResize_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnableAutoResize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_min_size{};
      ::gfx::Size p_max_size{};
      RemoteFrame_EnableAutoResize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinSize(&p_min_size))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAutoResize(
std::move(p_min_size), 
std::move(p_max_size));
      return true;
    }
    case internal::kRemoteFrame_DisableAutoResize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DisableAutoResize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DisableAutoResize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DisableAutoResize_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DisableAutoResize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DisableAutoResize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableAutoResize();
      return true;
    }
    case internal::kRemoteFrame_DidUpdateVisualProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidUpdateVisualProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidUpdateVisualProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidUpdateVisualProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidUpdateVisualProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::RenderFrameMetadata p_metadata{};
      RemoteFrame_DidUpdateVisualProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateVisualProperties(
std::move(p_metadata));
      return true;
    }
    case internal::kRemoteFrame_SetFrameSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetFrameSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetFrameSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetFrameSinkId_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetFrameSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      RemoteFrame_SetFrameSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameSinkId(
std::move(p_frame_sink_id));
      return true;
    }
    case internal::kRemoteFrame_ChildProcessGone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::ChildProcessGone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::ChildProcessGone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_ChildProcessGone_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ChildProcessGone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_ChildProcessGone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChildProcessGone();
      return true;
    }
  }
  return false;
}

// static
bool RemoteFrameStubDispatch::AcceptWithResponder(
    RemoteFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteFrame_WillEnterFullscreen_Name: {
      break;
    }
    case internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name: {
      break;
    }
    case internal::kRemoteFrame_SetFrameOwnerProperties_Name: {
      break;
    }
    case internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name: {
      break;
    }
    case internal::kRemoteFrame_SetReplicatedOrigin_Name: {
      break;
    }
    case internal::kRemoteFrame_SetReplicatedIsAdSubframe_Name: {
      break;
    }
    case internal::kRemoteFrame_SetReplicatedName_Name: {
      break;
    }
    case internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name: {
      break;
    }
    case internal::kRemoteFrame_SetNeedsOcclusionTracking_Name: {
      break;
    }
    case internal::kRemoteFrame_Collapse_Name: {
      break;
    }
    case internal::kRemoteFrame_Focus_Name: {
      break;
    }
    case internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name: {
      break;
    }
    case internal::kRemoteFrame_BubbleLogicalScroll_Name: {
      break;
    }
    case internal::kRemoteFrame_UpdateUserActivationState_Name: {
      break;
    }
    case internal::kRemoteFrame_SetEmbeddingToken_Name: {
      break;
    }
    case internal::kRemoteFrame_SetPageFocus_Name: {
      break;
    }
    case internal::kRemoteFrame_RenderFallbackContent_Name: {
      break;
    }
    case internal::kRemoteFrame_RenderFallbackContentWithResourceTiming_Name: {
      break;
    }
    case internal::kRemoteFrame_AddResourceTimingFromChild_Name: {
      break;
    }
    case internal::kRemoteFrame_ScrollRectToVisible_Name: {
      break;
    }
    case internal::kRemoteFrame_DidStartLoading_Name: {
      break;
    }
    case internal::kRemoteFrame_DidStopLoading_Name: {
      break;
    }
    case internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name: {
      break;
    }
    case internal::kRemoteFrame_DidSetFramePolicyHeaders_Name: {
      break;
    }
    case internal::kRemoteFrame_DidUpdateFramePolicy_Name: {
      break;
    }
    case internal::kRemoteFrame_UpdateOpener_Name: {
      break;
    }
    case internal::kRemoteFrame_DetachAndDispose_Name: {
      break;
    }
    case internal::kRemoteFrame_EnableAutoResize_Name: {
      break;
    }
    case internal::kRemoteFrame_DisableAutoResize_Name: {
      break;
    }
    case internal::kRemoteFrame_DidUpdateVisualProperties_Name: {
      break;
    }
    case internal::kRemoteFrame_SetFrameSinkId_Name: {
      break;
    }
    case internal::kRemoteFrame_ChildProcessGone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteFrameValidationInfo[] = {
    {internal::kRemoteFrame_WillEnterFullscreen_Name,
     {&internal::RemoteFrame_WillEnterFullscreen_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name,
     {&internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetFrameOwnerProperties_Name,
     {&internal::RemoteFrame_SetFrameOwnerProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name,
     {&internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetReplicatedOrigin_Name,
     {&internal::RemoteFrame_SetReplicatedOrigin_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetReplicatedIsAdSubframe_Name,
     {&internal::RemoteFrame_SetReplicatedIsAdSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetReplicatedName_Name,
     {&internal::RemoteFrame_SetReplicatedName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name,
     {&internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetNeedsOcclusionTracking_Name,
     {&internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_Collapse_Name,
     {&internal::RemoteFrame_Collapse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_Focus_Name,
     {&internal::RemoteFrame_Focus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name,
     {&internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_BubbleLogicalScroll_Name,
     {&internal::RemoteFrame_BubbleLogicalScroll_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_UpdateUserActivationState_Name,
     {&internal::RemoteFrame_UpdateUserActivationState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetEmbeddingToken_Name,
     {&internal::RemoteFrame_SetEmbeddingToken_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetPageFocus_Name,
     {&internal::RemoteFrame_SetPageFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_RenderFallbackContent_Name,
     {&internal::RemoteFrame_RenderFallbackContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_RenderFallbackContentWithResourceTiming_Name,
     {&internal::RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_AddResourceTimingFromChild_Name,
     {&internal::RemoteFrame_AddResourceTimingFromChild_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_ScrollRectToVisible_Name,
     {&internal::RemoteFrame_ScrollRectToVisible_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidStartLoading_Name,
     {&internal::RemoteFrame_DidStartLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidStopLoading_Name,
     {&internal::RemoteFrame_DidStopLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name,
     {&internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidSetFramePolicyHeaders_Name,
     {&internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidUpdateFramePolicy_Name,
     {&internal::RemoteFrame_DidUpdateFramePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_UpdateOpener_Name,
     {&internal::RemoteFrame_UpdateOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DetachAndDispose_Name,
     {&internal::RemoteFrame_DetachAndDispose_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_EnableAutoResize_Name,
     {&internal::RemoteFrame_EnableAutoResize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DisableAutoResize_Name,
     {&internal::RemoteFrame_DisableAutoResize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidUpdateVisualProperties_Name,
     {&internal::RemoteFrame_DidUpdateVisualProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetFrameSinkId_Name,
     {&internal::RemoteFrame_SetFrameSinkId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_ChildProcessGone_Name,
     {&internal::RemoteFrame_ChildProcessGone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RemoteFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteFrameValidationInfo);
}

const char LocalMainFrame::Name_[] = "blink.mojom.LocalMainFrame";

class LocalMainFrame_ClosePage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_ClosePage_ForwardToCallback(
      LocalMainFrame::ClosePageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::ClosePageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_ClosePage_ForwardToCallback);
};

class LocalMainFrame_OnPortalActivated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_OnPortalActivated_ForwardToCallback(
      LocalMainFrame::OnPortalActivatedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::OnPortalActivatedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_OnPortalActivated_ForwardToCallback);
};

LocalMainFrameProxy::LocalMainFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalMainFrameProxy::AnimateDoubleTapZoom(
    const ::gfx::Point& in_point, const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::AnimateDoubleTapZoom", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_AnimateDoubleTapZoom_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in LocalMainFrame.AnimateDoubleTapZoom request");
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, rect_fragment);
  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in LocalMainFrame.AnimateDoubleTapZoom request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("AnimateDoubleTapZoom");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::SetScaleFactor(
    float in_scale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::SetScaleFactor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scale"), in_scale,
                        "<value of type float>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_SetScaleFactor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_SetScaleFactor_Params_Data> params(
          message);
  params.Allocate();
  params->scale = in_scale;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetScaleFactor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::ClosePage(
    ClosePageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrame::ClosePage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_ClosePage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ClosePage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ClosePage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_ClosePage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameProxy::PluginActionAt(
    const ::gfx::Point& in_location, PluginActionType in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::PluginActionAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location"), in_location,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type PluginActionType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_PluginActionAt_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_PluginActionAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->location)::BaseType> location_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location, location_fragment);
  params->location.Set(
      location_fragment.is_null() ? nullptr : location_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->location.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in LocalMainFrame.PluginActionAt request");
  mojo::internal::Serialize<::blink::mojom::PluginActionType>(
      in_action, &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("PluginActionAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::SetInitialFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::SetInitialFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_SetInitialFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_SetInitialFocus_Params_Data> params(
          message);
  params.Allocate();
  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetInitialFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::EnablePreferredSizeChangedMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("EnablePreferredSizeChangedMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::ZoomToFindInPageRect(
    const ::gfx::Rect& in_rect_in_root_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::ZoomToFindInPageRect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect_in_root_frame"), in_rect_in_root_frame,
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_ZoomToFindInPageRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect_in_root_frame)::BaseType> rect_in_root_frame_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect_in_root_frame, rect_in_root_frame_fragment);
  params->rect_in_root_frame.Set(
      rect_in_root_frame_fragment.is_null() ? nullptr : rect_in_root_frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect_in_root_frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect_in_root_frame in LocalMainFrame.ZoomToFindInPageRect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ZoomToFindInPageRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::InstallCoopAccessMonitor(
    ::network::mojom::CoopAccessReportType in_report_type, const ::blink::FrameToken& in_accessed_window, ::mojo::PendingRemote<::network::mojom::CrossOriginOpenerPolicyReporter> in_reporter, bool in_endpoint_defined, const std::string& in_reported_window_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::InstallCoopAccessMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_type"), in_report_type,
                        "<value of type ::network::mojom::CoopAccessReportType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessed_window"), in_accessed_window,
                        "<value of type const ::blink::FrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporter"), in_reporter,
                        "<value of type ::mojo::PendingRemote<::network::mojom::CrossOriginOpenerPolicyReporter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint_defined"), in_endpoint_defined,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reported_window_url"), in_reported_window_url,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_InstallCoopAccessMonitor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::CoopAccessReportType>(
      in_report_type, &params->report_type);
  mojo::internal::MessageFragment<decltype(params->accessed_window)>
      accessed_window_fragment(params.message());
  accessed_window_fragment.Claim(&params->accessed_window);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_accessed_window, accessed_window_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accessed_window.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessed_window in LocalMainFrame.InstallCoopAccessMonitor request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginOpenerPolicyReporterInterfaceBase>>(
      in_reporter, &params->reporter, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->reporter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reporter in LocalMainFrame.InstallCoopAccessMonitor request");
  params->endpoint_defined = in_endpoint_defined;
  mojo::internal::MessageFragment<
      typename decltype(params->reported_window_url)::BaseType> reported_window_url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reported_window_url, reported_window_url_fragment);
  params->reported_window_url.Set(
      reported_window_url_fragment.is_null() ? nullptr : reported_window_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reported_window_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reported_window_url in LocalMainFrame.InstallCoopAccessMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("InstallCoopAccessMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::OnPortalActivated(
    const ::blink::PortalToken& in_portal_token, ::mojo::PendingAssociatedRemote<::blink::mojom::Portal> in_portal, ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient> in_portal_client, ::blink::TransferableMessage in_data, uint64_t in_trace_id, OnPortalActivatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::OnPortalActivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal_token"), in_portal_token,
                        "<value of type const ::blink::PortalToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal"), in_portal,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::Portal>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal_client"), in_portal_client,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::blink::TransferableMessage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_OnPortalActivated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_OnPortalActivated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->portal_token)::BaseType> portal_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      in_portal_token, portal_token_fragment);
  params->portal_token.Set(
      portal_token_fragment.is_null() ? nullptr : portal_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in LocalMainFrame.OnPortalActivated request");
  mojo::internal::Serialize<::blink::mojom::PortalAssociatedPtrInfoDataView>(
      in_portal, &params->portal, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal in LocalMainFrame.OnPortalActivated request");
  mojo::internal::Serialize<::blink::mojom::PortalClientAssociatedRequestDataView>(
      in_portal_client, &params->portal_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal_client in LocalMainFrame.OnPortalActivated request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in LocalMainFrame.OnPortalActivated request");
  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("OnPortalActivated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_OnPortalActivated_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameProxy::ForwardMessageFromHost(
    ::blink::TransferableMessage in_message, const ::url::Origin& in_source_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::ForwardMessageFromHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::TransferableMessage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::url::Origin&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_ForwardMessageFromHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ForwardMessageFromHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalMainFrame.ForwardMessageFromHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_source_origin, source_origin_fragment);
  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in LocalMainFrame.ForwardMessageFromHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ForwardMessageFromHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::UpdateBrowserControlsState(
    ::cc::BrowserControlsState in_constraints, ::cc::BrowserControlsState in_current, bool in_animate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::UpdateBrowserControlsState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraints"), in_constraints,
                        "<value of type ::cc::BrowserControlsState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current"), in_current,
                        "<value of type ::cc::BrowserControlsState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("animate"), in_animate,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_UpdateBrowserControlsState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::cc::mojom::BrowserControlsState>(
      in_constraints, &params->constraints);
  mojo::internal::Serialize<::cc::mojom::BrowserControlsState>(
      in_current, &params->current);
  params->animate = in_animate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("UpdateBrowserControlsState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalMainFrame_ClosePage_ProxyToResponder {
 public:
  static LocalMainFrame::ClosePageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrame_ClosePage_ProxyToResponder> proxy(
        new LocalMainFrame_ClosePage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrame_ClosePage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_ClosePage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrame_ClosePage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrame::ClosePageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_ClosePage_ProxyToResponder);
};

bool LocalMainFrame_ClosePage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrame::ClosePageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalMainFrame_ClosePage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_ClosePage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalMainFrame_ClosePage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalMainFrame_ClosePage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalMainFrame::ClosePageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_ClosePage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_ClosePage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrame::ClosePageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ClosePage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalMainFrame_OnPortalActivated_ProxyToResponder {
 public:
  static LocalMainFrame::OnPortalActivatedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrame_OnPortalActivated_ProxyToResponder> proxy(
        new LocalMainFrame_OnPortalActivated_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrame_OnPortalActivated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_OnPortalActivated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrame_OnPortalActivated_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrame::OnPortalActivatedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PortalActivateResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_OnPortalActivated_ProxyToResponder);
};

bool LocalMainFrame_OnPortalActivated_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrame::OnPortalActivatedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::PortalActivateResult p_result{};
  LocalMainFrame_OnPortalActivated_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LocalMainFrame_OnPortalActivated_ProxyToResponder::Run(
    ::blink::mojom::PortalActivateResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalMainFrame::OnPortalActivatedCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::PortalActivateResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrame_OnPortalActivated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PortalActivateResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrame::OnPortalActivatedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("OnPortalActivated");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalMainFrameStubDispatch::Accept(
    LocalMainFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalMainFrame_AnimateDoubleTapZoom_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::AnimateDoubleTapZoom",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::AnimateDoubleTapZoom");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_point{};
      ::gfx::Rect p_rect{};
      LocalMainFrame_AnimateDoubleTapZoom_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnimateDoubleTapZoom(
std::move(p_point), 
std::move(p_rect));
      return true;
    }
    case internal::kLocalMainFrame_SetScaleFactor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::SetScaleFactor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::SetScaleFactor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetScaleFactor_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetScaleFactor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      float p_scale{};
      LocalMainFrame_SetScaleFactor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_scale = input_data_view.scale();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScaleFactor(
std::move(p_scale));
      return true;
    }
    case internal::kLocalMainFrame_ClosePage_Name: {
      break;
    }
    case internal::kLocalMainFrame_PluginActionAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::PluginActionAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::PluginActionAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_PluginActionAt_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_PluginActionAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_location{};
      PluginActionType p_action{};
      LocalMainFrame_PluginActionAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PluginActionAt(
std::move(p_location), 
std::move(p_action));
      return true;
    }
    case internal::kLocalMainFrame_SetInitialFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::SetInitialFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::SetInitialFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetInitialFocus_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetInitialFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_reverse{};
      LocalMainFrame_SetInitialFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialFocus(
std::move(p_reverse));
      return true;
    }
    case internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalMainFrame_EnablePreferredSizeChangedMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnablePreferredSizeChangedMode();
      return true;
    }
    case internal::kLocalMainFrame_ZoomToFindInPageRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::ZoomToFindInPageRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::ZoomToFindInPageRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect_in_root_frame{};
      LocalMainFrame_ZoomToFindInPageRect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRectInRootFrame(&p_rect_in_root_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomToFindInPageRect(
std::move(p_rect_in_root_frame));
      return true;
    }
    case internal::kLocalMainFrame_InstallCoopAccessMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::InstallCoopAccessMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::InstallCoopAccessMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::CoopAccessReportType p_report_type{};
      ::blink::FrameToken p_accessed_window{};
      ::mojo::PendingRemote<::network::mojom::CrossOriginOpenerPolicyReporter> p_reporter{};
      bool p_endpoint_defined{};
      std::string p_reported_window_url{};
      LocalMainFrame_InstallCoopAccessMonitor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportType(&p_report_type))
        success = false;
      if (success && !input_data_view.ReadAccessedWindow(&p_accessed_window))
        success = false;
      if (success) {
        p_reporter =
            input_data_view.TakeReporter<decltype(p_reporter)>();
      }
      if (success)
        p_endpoint_defined = input_data_view.endpoint_defined();
      if (success && !input_data_view.ReadReportedWindowUrl(&p_reported_window_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallCoopAccessMonitor(
std::move(p_report_type), 
std::move(p_accessed_window), 
std::move(p_reporter), 
std::move(p_endpoint_defined), 
std::move(p_reported_window_url));
      return true;
    }
    case internal::kLocalMainFrame_OnPortalActivated_Name: {
      break;
    }
    case internal::kLocalMainFrame_ForwardMessageFromHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::ForwardMessageFromHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::ForwardMessageFromHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_ForwardMessageFromHost_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_ForwardMessageFromHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::TransferableMessage p_message{};
      ::url::Origin p_source_origin{};
      LocalMainFrame_ForwardMessageFromHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardMessageFromHost(
std::move(p_message), 
std::move(p_source_origin));
      return true;
    }
    case internal::kLocalMainFrame_UpdateBrowserControlsState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::UpdateBrowserControlsState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::UpdateBrowserControlsState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::BrowserControlsState p_constraints{};
      ::cc::BrowserControlsState p_current{};
      bool p_animate{};
      LocalMainFrame_UpdateBrowserControlsState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstraints(&p_constraints))
        success = false;
      if (success && !input_data_view.ReadCurrent(&p_current))
        success = false;
      if (success)
        p_animate = input_data_view.animate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateBrowserControlsState(
std::move(p_constraints), 
std::move(p_current), 
std::move(p_animate));
      return true;
    }
  }
  return false;
}

// static
bool LocalMainFrameStubDispatch::AcceptWithResponder(
    LocalMainFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalMainFrame_AnimateDoubleTapZoom_Name: {
      break;
    }
    case internal::kLocalMainFrame_SetScaleFactor_Name: {
      break;
    }
    case internal::kLocalMainFrame_ClosePage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::ClosePage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::ClosePage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrame_ClosePage_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_ClosePage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalMainFrame_ClosePage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 2, false);
        return false;
      }
      LocalMainFrame::ClosePageCallback callback =
          LocalMainFrame_ClosePage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePage(std::move(callback));
      return true;
    }
    case internal::kLocalMainFrame_PluginActionAt_Name: {
      break;
    }
    case internal::kLocalMainFrame_SetInitialFocus_Name: {
      break;
    }
    case internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name: {
      break;
    }
    case internal::kLocalMainFrame_ZoomToFindInPageRect_Name: {
      break;
    }
    case internal::kLocalMainFrame_InstallCoopAccessMonitor_Name: {
      break;
    }
    case internal::kLocalMainFrame_OnPortalActivated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::OnPortalActivated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::OnPortalActivated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrame_OnPortalActivated_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_OnPortalActivated_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::PortalToken p_portal_token{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::Portal> p_portal{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient> p_portal_client{};
      ::blink::TransferableMessage p_data{};
      uint64_t p_trace_id{};
      LocalMainFrame_OnPortalActivated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortalToken(&p_portal_token))
        success = false;
      if (success) {
        p_portal =
            input_data_view.TakePortal<decltype(p_portal)>();
      }
      if (success) {
        p_portal_client =
            input_data_view.TakePortalClient<decltype(p_portal_client)>();
      }
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 8, false);
        return false;
      }
      LocalMainFrame::OnPortalActivatedCallback callback =
          LocalMainFrame_OnPortalActivated_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortalActivated(
std::move(p_portal_token), 
std::move(p_portal), 
std::move(p_portal_client), 
std::move(p_data), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kLocalMainFrame_ForwardMessageFromHost_Name: {
      break;
    }
    case internal::kLocalMainFrame_UpdateBrowserControlsState_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalMainFrameValidationInfo[] = {
    {internal::kLocalMainFrame_AnimateDoubleTapZoom_Name,
     {&internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_SetScaleFactor_Name,
     {&internal::LocalMainFrame_SetScaleFactor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_ClosePage_Name,
     {&internal::LocalMainFrame_ClosePage_Params_Data::Validate,
      &internal::LocalMainFrame_ClosePage_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrame_PluginActionAt_Name,
     {&internal::LocalMainFrame_PluginActionAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_SetInitialFocus_Name,
     {&internal::LocalMainFrame_SetInitialFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name,
     {&internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_ZoomToFindInPageRect_Name,
     {&internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_InstallCoopAccessMonitor_Name,
     {&internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_OnPortalActivated_Name,
     {&internal::LocalMainFrame_OnPortalActivated_Params_Data::Validate,
      &internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrame_ForwardMessageFromHost_Name,
     {&internal::LocalMainFrame_ForwardMessageFromHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_UpdateBrowserControlsState_Name,
     {&internal::LocalMainFrame_UpdateBrowserControlsState_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalMainFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalMainFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalMainFrameValidationInfo);
}

bool LocalMainFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalMainFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalMainFrameValidationInfo);

}
const char RemoteMainFrame::Name_[] = "blink.mojom.RemoteMainFrame";

RemoteMainFrameProxy::RemoteMainFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteMainFrameProxy::UpdateTextAutosizerPageInfo(
    ::blink::mojom::TextAutosizerPageInfoPtr in_page_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_info"), in_page_info,
                        "<value of type ::blink::mojom::TextAutosizerPageInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_info)::BaseType> page_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TextAutosizerPageInfoDataView>(
      in_page_info, page_info_fragment);
  params->page_info.Set(
      page_info_fragment.is_null() ? nullptr : page_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->page_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_info in RemoteMainFrame.UpdateTextAutosizerPageInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrame::Name_);
  message.set_method_name("UpdateTextAutosizerPageInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteMainFrameStubDispatch::Accept(
    RemoteMainFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::TextAutosizerPageInfoPtr p_page_info{};
      RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageInfo(&p_page_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTextAutosizerPageInfo(
std::move(p_page_info));
      return true;
    }
  }
  return false;
}

// static
bool RemoteMainFrameStubDispatch::AcceptWithResponder(
    RemoteMainFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteMainFrameValidationInfo[] = {
    {internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name,
     {&internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteMainFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RemoteMainFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteMainFrameValidationInfo);
}

const char LocalMainFrameHost::Name_[] = "blink.mojom.LocalMainFrameHost";

class LocalMainFrameHost_UpdateTargetURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrameHost_UpdateTargetURL_ForwardToCallback(
      LocalMainFrameHost::UpdateTargetURLCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrameHost::UpdateTargetURLCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_UpdateTargetURL_ForwardToCallback);
};

class LocalMainFrameHost_ShowCreatedWindow_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrameHost_ShowCreatedWindow_ForwardToCallback(
      LocalMainFrameHost::ShowCreatedWindowCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrameHost::ShowCreatedWindowCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_ShowCreatedWindow_ForwardToCallback);
};

class LocalMainFrameHost_SetWindowRect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrameHost_SetWindowRect_ForwardToCallback(
      LocalMainFrameHost::SetWindowRectCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrameHost::SetWindowRectCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_SetWindowRect_ForwardToCallback);
};

LocalMainFrameHostProxy::LocalMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalMainFrameHostProxy::ScaleFactorChanged(
    float in_scale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::ScaleFactorChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scale"), in_scale,
                        "<value of type float>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_ScaleFactorChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data> params(
          message);
  params.Allocate();
  params->scale = in_scale;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("ScaleFactorChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::ContentsPreferredSizeChanged(
    const ::gfx::Size& in_pref_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pref_size"), in_pref_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pref_size)::BaseType> pref_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_pref_size, pref_size_fragment);
  params->pref_size.Set(
      pref_size_fragment.is_null() ? nullptr : pref_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pref_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pref_size in LocalMainFrameHost.ContentsPreferredSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("ContentsPreferredSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::TextAutosizerPageInfoChanged(
    ::blink::mojom::TextAutosizerPageInfoPtr in_page_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_info"), in_page_info,
                        "<value of type ::blink::mojom::TextAutosizerPageInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_info)::BaseType> page_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TextAutosizerPageInfoDataView>(
      in_page_info, page_info_fragment);
  params->page_info.Set(
      page_info_fragment.is_null() ? nullptr : page_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->page_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_info in LocalMainFrameHost.TextAutosizerPageInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("TextAutosizerPageInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::FocusPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrameHost::FocusPage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_FocusPage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_FocusPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("FocusPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::TakeFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::TakeFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_TakeFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_TakeFocus_Params_Data> params(
          message);
  params.Allocate();
  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("TakeFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::UpdateTargetURL(
    const ::GURL& in_url, UpdateTargetURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::UpdateTargetURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_UpdateTargetURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalMainFrameHost.UpdateTargetURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrameHost_UpdateTargetURL_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameHostProxy::RequestClose(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrameHost::RequestClose");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_RequestClose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_RequestClose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("RequestClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::ShowCreatedWindow(
    const ::blink::LocalFrameToken& in_opener_frame_token, ::WindowOpenDisposition in_disposition, const ::gfx::Rect& in_rect, bool in_opened_by_user_gesture, ShowCreatedWindowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::ShowCreatedWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type ::WindowOpenDisposition>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opened_by_user_gesture"), in_opened_by_user_gesture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_ShowCreatedWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_ShowCreatedWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->opener_frame_token)::BaseType> opener_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_opener_frame_token, opener_frame_token_fragment);
  params->opener_frame_token.Set(
      opener_frame_token_fragment.is_null() ? nullptr : opener_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->opener_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null opener_frame_token in LocalMainFrameHost.ShowCreatedWindow request");
  mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
      in_disposition, &params->disposition);
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, rect_fragment);
  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in LocalMainFrameHost.ShowCreatedWindow request");
  params->opened_by_user_gesture = in_opened_by_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("ShowCreatedWindow");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrameHost_ShowCreatedWindow_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameHostProxy::SetWindowRect(
    const ::gfx::Rect& in_bounds, SetWindowRectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::SetWindowRect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_SetWindowRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_SetWindowRect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in LocalMainFrameHost.SetWindowRect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("SetWindowRect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrameHost_SetWindowRect_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameHostProxy::DidFirstVisuallyNonEmptyPaint(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("DidFirstVisuallyNonEmptyPaint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalMainFrameHost_UpdateTargetURL_ProxyToResponder {
 public:
  static LocalMainFrameHost::UpdateTargetURLCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrameHost_UpdateTargetURL_ProxyToResponder> proxy(
        new LocalMainFrameHost_UpdateTargetURL_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrameHost_UpdateTargetURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrameHost_UpdateTargetURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrameHost_UpdateTargetURL_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrameHost::UpdateTargetURLCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_UpdateTargetURL_ProxyToResponder);
};

bool LocalMainFrameHost_UpdateTargetURL_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrameHost::UpdateTargetURLCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalMainFrameHost_UpdateTargetURL_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrameHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalMainFrameHost_UpdateTargetURL_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURLCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURLCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder {
 public:
  static LocalMainFrameHost::ShowCreatedWindowCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder> proxy(
        new LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrameHost::ShowCreatedWindowCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder);
};

bool LocalMainFrameHost_ShowCreatedWindow_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrameHost::ShowCreatedWindowCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalMainFrameHost_ShowCreatedWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrameHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalMainFrameHost::ShowCreatedWindowCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_ShowCreatedWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrameHost::ShowCreatedWindowCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("ShowCreatedWindow");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalMainFrameHost_SetWindowRect_ProxyToResponder {
 public:
  static LocalMainFrameHost::SetWindowRectCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrameHost_SetWindowRect_ProxyToResponder> proxy(
        new LocalMainFrameHost_SetWindowRect_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrameHost_SetWindowRect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrameHost_SetWindowRect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrameHost_SetWindowRect_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrameHost::SetWindowRectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_SetWindowRect_ProxyToResponder);
};

bool LocalMainFrameHost_SetWindowRect_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrameHost::SetWindowRectCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalMainFrameHost_SetWindowRect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrameHost_SetWindowRect_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalMainFrameHost_SetWindowRect_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrameHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalMainFrameHost_SetWindowRect_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalMainFrameHost::SetWindowRectCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_SetWindowRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LocalMainFrameHost_SetWindowRect_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrameHost::SetWindowRectCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("SetWindowRect");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalMainFrameHostStubDispatch::Accept(
    LocalMainFrameHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalMainFrameHost_ScaleFactorChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::ScaleFactorChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::ScaleFactorChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      float p_scale{};
      LocalMainFrameHost_ScaleFactorChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_scale = input_data_view.scale();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScaleFactorChanged(
std::move(p_scale));
      return true;
    }
    case internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_pref_size{};
      LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrefSize(&p_pref_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContentsPreferredSizeChanged(
std::move(p_pref_size));
      return true;
    }
    case internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::TextAutosizerPageInfoPtr p_page_info{};
      LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageInfo(&p_page_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextAutosizerPageInfoChanged(
std::move(p_page_info));
      return true;
    }
    case internal::kLocalMainFrameHost_FocusPage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::FocusPage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::FocusPage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_FocusPage_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_FocusPage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalMainFrameHost_FocusPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusPage();
      return true;
    }
    case internal::kLocalMainFrameHost_TakeFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::TakeFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::TakeFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_TakeFocus_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_TakeFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_reverse{};
      LocalMainFrameHost_TakeFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeFocus(
std::move(p_reverse));
      return true;
    }
    case internal::kLocalMainFrameHost_UpdateTargetURL_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_RequestClose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::RequestClose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::RequestClose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_RequestClose_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_RequestClose_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalMainFrameHost_RequestClose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestClose();
      return true;
    }
    case internal::kLocalMainFrameHost_ShowCreatedWindow_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_SetWindowRect_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::DidFirstVisuallyNonEmptyPaint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFirstVisuallyNonEmptyPaint();
      return true;
    }
  }
  return false;
}

// static
bool LocalMainFrameHostStubDispatch::AcceptWithResponder(
    LocalMainFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalMainFrameHost_ScaleFactorChanged_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_FocusPage_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_TakeFocus_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_UpdateTargetURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrameHost_UpdateTargetURL_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrameHost_UpdateTargetURL_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      LocalMainFrameHost_UpdateTargetURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 5, false);
        return false;
      }
      LocalMainFrameHost::UpdateTargetURLCallback callback =
          LocalMainFrameHost_UpdateTargetURL_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTargetURL(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kLocalMainFrameHost_RequestClose_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_ShowCreatedWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::ShowCreatedWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::ShowCreatedWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrameHost_ShowCreatedWindow_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrameHost_ShowCreatedWindow_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::LocalFrameToken p_opener_frame_token{};
      ::WindowOpenDisposition p_disposition{};
      ::gfx::Rect p_rect{};
      bool p_opened_by_user_gesture{};
      LocalMainFrameHost_ShowCreatedWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (success)
        p_opened_by_user_gesture = input_data_view.opened_by_user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 7, false);
        return false;
      }
      LocalMainFrameHost::ShowCreatedWindowCallback callback =
          LocalMainFrameHost_ShowCreatedWindow_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowCreatedWindow(
std::move(p_opener_frame_token), 
std::move(p_disposition), 
std::move(p_rect), 
std::move(p_opened_by_user_gesture), std::move(callback));
      return true;
    }
    case internal::kLocalMainFrameHost_SetWindowRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::SetWindowRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::SetWindowRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrameHost_SetWindowRect_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrameHost_SetWindowRect_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_bounds{};
      LocalMainFrameHost_SetWindowRect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 8, false);
        return false;
      }
      LocalMainFrameHost::SetWindowRectCallback callback =
          LocalMainFrameHost_SetWindowRect_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowRect(
std::move(p_bounds), std::move(callback));
      return true;
    }
    case internal::kLocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalMainFrameHostValidationInfo[] = {
    {internal::kLocalMainFrameHost_ScaleFactorChanged_Name,
     {&internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name,
     {&internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name,
     {&internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_FocusPage_Name,
     {&internal::LocalMainFrameHost_FocusPage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_TakeFocus_Name,
     {&internal::LocalMainFrameHost_TakeFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_UpdateTargetURL_Name,
     {&internal::LocalMainFrameHost_UpdateTargetURL_Params_Data::Validate,
      &internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrameHost_RequestClose_Name,
     {&internal::LocalMainFrameHost_RequestClose_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_ShowCreatedWindow_Name,
     {&internal::LocalMainFrameHost_ShowCreatedWindow_Params_Data::Validate,
      &internal::LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrameHost_SetWindowRect_Name,
     {&internal::LocalMainFrameHost_SetWindowRect_Params_Data::Validate,
      &internal::LocalMainFrameHost_SetWindowRect_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Name,
     {&internal::LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalMainFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalMainFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalMainFrameHostValidationInfo);
}

bool LocalMainFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LocalMainFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalMainFrameHostValidationInfo);

}
const char RemoteMainFrameHost::Name_[] = "blink.mojom.RemoteMainFrameHost";

class RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(
      RemoteMainFrameHost::UpdateTargetURLCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RemoteMainFrameHost::UpdateTargetURLCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback);
};

RemoteMainFrameHostProxy::RemoteMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteMainFrameHostProxy::FocusPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteMainFrameHost::FocusPage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_FocusPage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_FocusPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("FocusPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteMainFrameHostProxy::TakeFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteMainFrameHost::TakeFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_TakeFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_TakeFocus_Params_Data> params(
          message);
  params.Allocate();
  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("TakeFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteMainFrameHostProxy::UpdateTargetURL(
    const ::GURL& in_url, UpdateTargetURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteMainFrameHost::UpdateTargetURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RemoteMainFrameHost.UpdateTargetURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RemoteMainFrameHostProxy::RouteCloseEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteMainFrameHost::RouteCloseEvent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_RouteCloseEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("RouteCloseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder {
 public:
  static RemoteMainFrameHost::UpdateTargetURLCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder> proxy(
        new RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RemoteMainFrameHost::UpdateTargetURLCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder);
};

bool RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::RemoteMainFrameHost::UpdateTargetURLCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  RemoteMainFrameHost_UpdateTargetURL_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RemoteMainFrameHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURLCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURLCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RemoteMainFrameHostStubDispatch::Accept(
    RemoteMainFrameHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemoteMainFrameHost_FocusPage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::FocusPage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::FocusPage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_FocusPage_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_FocusPage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteMainFrameHost_FocusPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusPage();
      return true;
    }
    case internal::kRemoteMainFrameHost_TakeFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::TakeFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::TakeFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_TakeFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_TakeFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_reverse{};
      RemoteMainFrameHost_TakeFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeFocus(
std::move(p_reverse));
      return true;
    }
    case internal::kRemoteMainFrameHost_UpdateTargetURL_Name: {
      break;
    }
    case internal::kRemoteMainFrameHost_RouteCloseEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::RouteCloseEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::RouteCloseEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteMainFrameHost_RouteCloseEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteCloseEvent();
      return true;
    }
  }
  return false;
}

// static
bool RemoteMainFrameHostStubDispatch::AcceptWithResponder(
    RemoteMainFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteMainFrameHost_FocusPage_Name: {
      break;
    }
    case internal::kRemoteMainFrameHost_TakeFocus_Name: {
      break;
    }
    case internal::kRemoteMainFrameHost_UpdateTargetURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data* params =
          reinterpret_cast<
              internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      RemoteMainFrameHost_UpdateTargetURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 2, false);
        return false;
      }
      RemoteMainFrameHost::UpdateTargetURLCallback callback =
          RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTargetURL(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kRemoteMainFrameHost_RouteCloseEvent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteMainFrameHostValidationInfo[] = {
    {internal::kRemoteMainFrameHost_FocusPage_Name,
     {&internal::RemoteMainFrameHost_FocusPage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteMainFrameHost_TakeFocus_Name,
     {&internal::RemoteMainFrameHost_TakeFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteMainFrameHost_UpdateTargetURL_Name,
     {&internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data::Validate,
      &internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate}},
    {internal::kRemoteMainFrameHost_RouteCloseEvent_Name,
     {&internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteMainFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RemoteMainFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteMainFrameHostValidationInfo);
}

bool RemoteMainFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RemoteMainFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRemoteMainFrameHostValidationInfo);

}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::SavableSubframe::DataView, ::blink::mojom::SavableSubframePtr>::Read(
    ::blink::mojom::SavableSubframe::DataView input,
    ::blink::mojom::SavableSubframePtr* output) {
  bool success = true;
  ::blink::mojom::SavableSubframePtr result(::blink::mojom::SavableSubframe::New());
  
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadSubframeToken(&result->subframe_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::GetSavableResourceLinksReply::DataView, ::blink::mojom::GetSavableResourceLinksReplyPtr>::Read(
    ::blink::mojom::GetSavableResourceLinksReply::DataView input,
    ::blink::mojom::GetSavableResourceLinksReplyPtr* output) {
  bool success = true;
  ::blink::mojom::GetSavableResourceLinksReplyPtr result(::blink::mojom::GetSavableResourceLinksReply::New());
  
      if (success && !input.ReadResourcesList(&result->resources_list))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadSubframes(&result->subframes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FindInPageResultAXParams::DataView, ::blink::mojom::FindInPageResultAXParamsPtr>::Read(
    ::blink::mojom::FindInPageResultAXParams::DataView input,
    ::blink::mojom::FindInPageResultAXParamsPtr* output) {
  bool success = true;
  ::blink::mojom::FindInPageResultAXParamsPtr result(::blink::mojom::FindInPageResultAXParams::New());
  
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->match_index = input.match_index();
      if (success)
        result->start_id = input.start_id();
      if (success)
        result->start_offset = input.start_offset();
      if (success)
        result->end_id = input.end_id();
      if (success)
        result->end_offset = input.end_offset();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DownloadURLParams::DataView, ::blink::mojom::DownloadURLParamsPtr>::Read(
    ::blink::mojom::DownloadURLParams::DataView input,
    ::blink::mojom::DownloadURLParamsPtr* output) {
  bool success = true;
  ::blink::mojom::DownloadURLParamsPtr result(::blink::mojom::DownloadURLParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadSuggestedName(&result->suggested_name))
        success = false;
      if (success && !input.ReadCrossOriginRedirects(&result->cross_origin_redirects))
        success = false;
      if (success) {
        result->blob_url_token =
            input.TakeBlobUrlToken<decltype(result->blob_url_token)>();
      }
      if (success) {
        result->data_url_blob =
            input.TakeDataUrlBlob<decltype(result->data_url_blob)>();
      }
      if (success)
        result->is_context_menu_save = input.is_context_menu_save();
      if (success)
        result->has_user_gesture = input.has_user_gesture();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::OpenURLParams::DataView, ::blink::mojom::OpenURLParamsPtr>::Read(
    ::blink::mojom::OpenURLParams::DataView input,
    ::blink::mojom::OpenURLParamsPtr* output) {
  bool success = true;
  ::blink::mojom::OpenURLParamsPtr result(::blink::mojom::OpenURLParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadInitiatorFrameToken(&result->initiator_frame_token))
        success = false;
      if (success && !input.ReadPostBody(&result->post_body))
        success = false;
      if (success && !input.ReadExtraHeaders(&result->extra_headers))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success)
        result->user_gesture = input.user_gesture();
      if (success && !input.ReadTriggeringEventInfo(&result->triggering_event_info))
        success = false;
      if (success) {
        result->blob_url_token =
            input.TakeBlobUrlToken<decltype(result->blob_url_token)>();
      }
      if (success && !input.ReadHrefTranslate(&result->href_translate))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
      if (success) {
        result->initiator_policy_container_keep_alive_handle =
            input.TakeInitiatorPolicyContainerKeepAliveHandle<decltype(result->initiator_policy_container_keep_alive_handle)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif