// third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool FrameReplicationState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameReplicationState_Data* object = static_cast<const FrameReplicationState_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams unique_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->unique_name, validation_context,
                                         &unique_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions_policy_header, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams permissions_policy_header_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->permissions_policy_header, validation_context,
                                         &permissions_policy_header_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->active_sandbox_flags, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->insecure_request_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->insecure_navigations_set, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams insecure_navigations_set_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->insecure_navigations_set, validation_context,
                                         &insecure_navigations_set_validate_params)) {
    return false;
  }

  return true;
}

FrameReplicationState_Data::FrameReplicationState_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
