// third_party/blink/public/mojom/image_downloader/image_downloader.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace mojom {
namespace blink {


void ImageDownloaderInterceptorForTesting::DownloadImage(const ::blink::KURL& url, bool is_favicon, uint32_t preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageCallback callback) {
  GetForwardingInterface()->DownloadImage(std::move(url), std::move(is_favicon), std::move(preferred_size), std::move(max_bitmap_size), std::move(bypass_cache), std::move(callback));
}
ImageDownloaderAsyncWaiter::ImageDownloaderAsyncWaiter(
    ImageDownloader* proxy) : proxy_(proxy) {}

ImageDownloaderAsyncWaiter::~ImageDownloaderAsyncWaiter() = default;

void ImageDownloaderAsyncWaiter::DownloadImage(
    const ::blink::KURL& url, bool is_favicon, uint32_t preferred_size, uint32_t max_bitmap_size, bool bypass_cache, int32_t* out_http_status_code, WTF::Vector<::SkBitmap>* out_images, WTF::Vector<::gfx::Size>* out_original_image_sizes) {
  base::RunLoop loop;
  proxy_->DownloadImage(std::move(url),std::move(is_favicon),std::move(preferred_size),std::move(max_bitmap_size),std::move(bypass_cache),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_http_status_code
,
             WTF::Vector<::SkBitmap>* out_images
,
             WTF::Vector<::gfx::Size>* out_original_image_sizes
,
             int32_t http_status_code,
             const WTF::Vector<::SkBitmap>& images,
             const WTF::Vector<::gfx::Size>& original_image_sizes) {*out_http_status_code = std::move(http_status_code);*out_images = std::move(images);*out_original_image_sizes = std::move(original_image_sizes);
            loop->Quit();
          },
          &loop,
          out_http_status_code,
          out_images,
          out_original_image_sizes));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif