// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* IDBCursorDirectionToStringHelper(IDBCursorDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBCursorDirection::Next:
      return "Next";
    case IDBCursorDirection::NextNoDuplicate:
      return "NextNoDuplicate";
    case IDBCursorDirection::Prev:
      return "Prev";
    case IDBCursorDirection::PrevNoDuplicate:
      return "PrevNoDuplicate";
    default:
      return nullptr;
  }
}

std::string IDBCursorDirectionToString(IDBCursorDirection value) {
  const char *str = IDBCursorDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBCursorDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBCursorDirection value) {
  return os << IDBCursorDirectionToString(value);
}

static NOINLINE const char* IDBDataLossToStringHelper(IDBDataLoss value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBDataLoss::None:
      return "None";
    case IDBDataLoss::Total:
      return "Total";
    default:
      return nullptr;
  }
}

std::string IDBDataLossToString(IDBDataLoss value) {
  const char *str = IDBDataLossToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBDataLoss value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBDataLoss value) {
  return os << IDBDataLossToString(value);
}

static NOINLINE const char* IDBKeyTypeToStringHelper(IDBKeyType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBKeyType::Invalid:
      return "Invalid";
    case IDBKeyType::Array:
      return "Array";
    case IDBKeyType::Binary:
      return "Binary";
    case IDBKeyType::String:
      return "String";
    case IDBKeyType::Date:
      return "Date";
    case IDBKeyType::Number:
      return "Number";
    case IDBKeyType::None:
      return "None";
    case IDBKeyType::Min:
      return "Min";
    default:
      return nullptr;
  }
}

std::string IDBKeyTypeToString(IDBKeyType value) {
  const char *str = IDBKeyTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBKeyType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBKeyType value) {
  return os << IDBKeyTypeToString(value);
}

static NOINLINE const char* IDBTransactionDurabilityToStringHelper(IDBTransactionDurability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBTransactionDurability::Default:
      return "Default";
    case IDBTransactionDurability::Strict:
      return "Strict";
    case IDBTransactionDurability::Relaxed:
      return "Relaxed";
    default:
      return nullptr;
  }
}

std::string IDBTransactionDurabilityToString(IDBTransactionDurability value) {
  const char *str = IDBTransactionDurabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBTransactionDurability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBTransactionDurability value) {
  return os << IDBTransactionDurabilityToString(value);
}

static NOINLINE const char* IDBKeyPathTypeToStringHelper(IDBKeyPathType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBKeyPathType::Null:
      return "Null";
    case IDBKeyPathType::String:
      return "String";
    case IDBKeyPathType::Array:
      return "Array";
    default:
      return nullptr;
  }
}

std::string IDBKeyPathTypeToString(IDBKeyPathType value) {
  const char *str = IDBKeyPathTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBKeyPathType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBKeyPathType value) {
  return os << IDBKeyPathTypeToString(value);
}

static NOINLINE const char* IDBOperationTypeToStringHelper(IDBOperationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBOperationType::Add:
      return "Add";
    case IDBOperationType::Put:
      return "Put";
    case IDBOperationType::Delete:
      return "Delete";
    case IDBOperationType::Clear:
      return "Clear";
    default:
      return nullptr;
  }
}

std::string IDBOperationTypeToString(IDBOperationType value) {
  const char *str = IDBOperationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBOperationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBOperationType value) {
  return os << IDBOperationTypeToString(value);
}

static NOINLINE const char* IDBPutModeToStringHelper(IDBPutMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBPutMode::AddOrUpdate:
      return "AddOrUpdate";
    case IDBPutMode::AddOnly:
      return "AddOnly";
    case IDBPutMode::CursorUpdate:
      return "CursorUpdate";
    default:
      return nullptr;
  }
}

std::string IDBPutModeToString(IDBPutMode value) {
  const char *str = IDBPutModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBPutMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBPutMode value) {
  return os << IDBPutModeToString(value);
}

static NOINLINE const char* IDBTaskTypeToStringHelper(IDBTaskType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBTaskType::Normal:
      return "Normal";
    case IDBTaskType::Preemptive:
      return "Preemptive";
    default:
      return nullptr;
  }
}

std::string IDBTaskTypeToString(IDBTaskType value) {
  const char *str = IDBTaskTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBTaskType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBTaskType value) {
  return os << IDBTaskTypeToString(value);
}

static NOINLINE const char* IDBTransactionModeToStringHelper(IDBTransactionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBTransactionMode::ReadOnly:
      return "ReadOnly";
    case IDBTransactionMode::ReadWrite:
      return "ReadWrite";
    case IDBTransactionMode::VersionChange:
      return "VersionChange";
    default:
      return nullptr;
  }
}

std::string IDBTransactionModeToString(IDBTransactionMode value) {
  const char *str = IDBTransactionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBTransactionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBTransactionMode value) {
  return os << IDBTransactionModeToString(value);
}

static NOINLINE const char* IDBStatusToStringHelper(IDBStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBStatus::OK:
      return "OK";
    case IDBStatus::NotFound:
      return "NotFound";
    case IDBStatus::Corruption:
      return "Corruption";
    case IDBStatus::NotSupported:
      return "NotSupported";
    case IDBStatus::InvalidArgument:
      return "InvalidArgument";
    case IDBStatus::IOError:
      return "IOError";
    default:
      return nullptr;
  }
}

std::string IDBStatusToString(IDBStatus value) {
  const char *str = IDBStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBStatus value) {
  return os << IDBStatusToString(value);
}

static NOINLINE const char* IDBExceptionToStringHelper(IDBException value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IDBException::kNoError:
      return "kNoError";
    case IDBException::kIgnorableAbortError:
      return "kIgnorableAbortError";
    case IDBException::kAbortError:
      return "kAbortError";
    case IDBException::kQuotaError:
      return "kQuotaError";
    case IDBException::kTimeoutError:
      return "kTimeoutError";
    case IDBException::kUnknownError:
      return "kUnknownError";
    case IDBException::kConstraintError:
      return "kConstraintError";
    case IDBException::kDataError:
      return "kDataError";
    case IDBException::kVersionError:
      return "kVersionError";
    default:
      return nullptr;
  }
}

std::string IDBExceptionToString(IDBException value) {
  const char *str = IDBExceptionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IDBException value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IDBException value) {
  return os << IDBExceptionToString(value);
}

namespace internal {
// static
bool IDBKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBKey_Data* object = static_cast<const IDBKey_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBKey_Tag::KEY_ARRAY: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_key_array, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams key_array_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_key_array, validation_context,
                                             &key_array_validate_params)) {
        return false;
      }
      return true;
    }
    case IDBKey_Tag::BINARY: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_binary, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams binary_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_binary, validation_context,
                                             &binary_validate_params)) {
        return false;
      }
      return true;
    }
    case IDBKey_Tag::STRING: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_string, validation_context))
        return false;
      return true;
    }
    case IDBKey_Tag::DATE: {

      return true;
    }
    case IDBKey_Tag::NUMBER: {

      return true;
    }
    case IDBKey_Tag::OTHER_NONE: {

      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBKey");
      return false;
    }
  }
}
// static
bool IDBKeyPathData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBKeyPathData_Data* object = static_cast<const IDBKeyPathData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBKeyPathData_Tag::STRING: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_string, validation_context))
        return false;
      return true;
    }
    case IDBKeyPathData_Tag::STRING_ARRAY: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string_array, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams string_array_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_string_array, validation_context,
                                             &string_array_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBKeyPathData");
      return false;
    }
  }
}
// static
bool IDBExternalObject_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBExternalObject_Data* object = static_cast<const IDBExternalObject_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBExternalObject_Tag::BLOB_OR_FILE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_blob_or_file, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_blob_or_file, validation_context))
        return false;
      return true;
    }
    case IDBExternalObject_Tag::FILE_SYSTEM_ACCESS_TOKEN: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_file_system_access_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_file_system_access_token,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBExternalObject");
      return false;
    }
  }
}
// static
bool IDBCursorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBCursorResult_Data* object = static_cast<const IDBCursorResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBCursorResult_Tag::ERROR_RESULT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBCursorResult_Tag::EMPTY: {

      return true;
    }
    case IDBCursorResult_Tag::VALUES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_values, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_values, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBCursorResult");
      return false;
    }
  }
}
// static
bool IDBTransactionPutResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBTransactionPutResult_Data* object = static_cast<const IDBTransactionPutResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBTransactionPutResult_Tag::ERROR_RESULT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBTransactionPutResult_Tag::KEY: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_key, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_key,
                                                   validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBTransactionPutResult");
      return false;
    }
  }
}
// static
bool IDBTransactionPutAllResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBTransactionPutAllResult_Data* object = static_cast<const IDBTransactionPutAllResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBTransactionPutAllResult_Tag::ERROR_RESULT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBTransactionPutAllResult_Tag::KEYS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_keys, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams keys_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_keys, validation_context,
                                             &keys_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBTransactionPutAllResult");
      return false;
    }
  }
}
// static
bool IDBDatabaseGetResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBDatabaseGetResult_Data* object = static_cast<const IDBDatabaseGetResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBDatabaseGetResult_Tag::ERROR_RESULT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBDatabaseGetResult_Tag::EMPTY: {

      return true;
    }
    case IDBDatabaseGetResult_Tag::KEY: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_key, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_key,
                                                   validation_context))
        return false;
      return true;
    }
    case IDBDatabaseGetResult_Tag::VALUE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBDatabaseGetResult");
      return false;
    }
  }
}
// static
bool IDBDatabaseOpenCursorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IDBDatabaseOpenCursorResult_Data* object = static_cast<const IDBDatabaseOpenCursorResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IDBDatabaseOpenCursorResult_Tag::ERROR_RESULT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_result, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error_result, validation_context))
        return false;
      return true;
    }
    case IDBDatabaseOpenCursorResult_Tag::EMPTY: {

      return true;
    }
    case IDBDatabaseOpenCursorResult_Tag::VALUE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IDBDatabaseOpenCursorResult");
      return false;
    }
  }
}


// static
bool IDBKeyPath_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBKeyPath_Data* object = static_cast<const IDBKeyPath_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

IDBKeyPath_Data::IDBKeyPath_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBKeyRange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBKeyRange_Data* object = static_cast<const IDBKeyRange_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->lower, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->lower, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->upper, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->upper, validation_context))
    return false;

  return true;
}

IDBKeyRange_Data::IDBKeyRange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBIndexMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBIndexMetadata_Data* object = static_cast<const IDBIndexMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBIndexMetadata_Data::IDBIndexMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBObjectStoreMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBObjectStoreMetadata_Data* object = static_cast<const IDBObjectStoreMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indexes, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams indexes_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->indexes, validation_context,
                                         &indexes_validate_params)) {
    return false;
  }

  return true;
}

IDBObjectStoreMetadata_Data::IDBObjectStoreMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseMetadata_Data* object = static_cast<const IDBDatabaseMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_stores, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams object_stores_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->object_stores, validation_context,
                                         &object_stores_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabaseMetadata_Data::IDBDatabaseMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBNameAndVersion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBNameAndVersion_Data* object = static_cast<const IDBNameAndVersion_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  return true;
}

IDBNameAndVersion_Data::IDBNameAndVersion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBIndexKeys_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBIndexKeys_Data* object = static_cast<const IDBIndexKeys_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams index_keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->index_keys, validation_context,
                                         &index_keys_validate_params)) {
    return false;
  }

  return true;
}

IDBIndexKeys_Data::IDBIndexKeys_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFileInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFileInfo_Data* object = static_cast<const IDBFileInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_modified, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_modified, validation_context))
    return false;

  return true;
}

IDBFileInfo_Data::IDBFileInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBBlobInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBBlobInfo_Data* object = static_cast<const IDBBlobInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blob, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blob,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams uuid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->uuid, validation_context,
                                         &uuid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mime_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

IDBBlobInfo_Data::IDBBlobInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBValue_Data* object = static_cast<const IDBValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bits, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams bits_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bits, validation_context,
                                         &bits_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->external_objects, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams external_objects_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->external_objects, validation_context,
                                         &external_objects_validate_params)) {
    return false;
  }

  return true;
}

IDBValue_Data::IDBValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBReturnValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBReturnValue_Data* object = static_cast<const IDBReturnValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBReturnValue_Data::IDBReturnValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBError_Data* object = static_cast<const IDBError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::IDBException_Data
        ::Validate(object->error_code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error_message, validation_context))
    return false;

  return true;
}

IDBError_Data::IDBError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursorValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursorValue_Data* object = static_cast<const IDBCursorValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_keys, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams primary_keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->primary_keys, validation_context,
                                         &primary_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

IDBCursorValue_Data::IDBCursorValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBPutParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBPutParams_Data* object = static_cast<const IDBPutParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams index_keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->index_keys, validation_context,
                                         &index_keys_validate_params)) {
    return false;
  }

  return true;
}

IDBPutParams_Data::IDBPutParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseOpenCursorValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseOpenCursorValue_Data* object = static_cast<const IDBDatabaseOpenCursorValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cursor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cursor,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

IDBDatabaseOpenCursorValue_Data::IDBDatabaseOpenCursorValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_Error_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_Error_Params_Data* object = static_cast<const IDBCallbacks_Error_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::IDBException_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

IDBCallbacks_Error_Params_Data::IDBCallbacks_Error_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_SuccessNamesAndVersionsList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_SuccessNamesAndVersionsList_Params_Data* object = static_cast<const IDBCallbacks_SuccessNamesAndVersionsList_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

IDBCallbacks_SuccessNamesAndVersionsList_Params_Data::IDBCallbacks_SuccessNamesAndVersionsList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_Blocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_Blocked_Params_Data* object = static_cast<const IDBCallbacks_Blocked_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBCallbacks_Blocked_Params_Data::IDBCallbacks_Blocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_UpgradeNeeded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_UpgradeNeeded_Params_Data* object = static_cast<const IDBCallbacks_UpgradeNeeded_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_database, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_database,
                                                 validation_context)) {
    return false;
  }


  if (!::blink::mojom::internal::IDBDataLoss_Data
        ::Validate(object->data_loss, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_loss_message, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_loss_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data_loss_message, validation_context,
                                         &data_loss_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->db_metadata, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->db_metadata, validation_context))
    return false;

  return true;
}

IDBCallbacks_UpgradeNeeded_Params_Data::IDBCallbacks_UpgradeNeeded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_SuccessDatabase_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_SuccessDatabase_Params_Data* object = static_cast<const IDBCallbacks_SuccessDatabase_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->pending_database,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

IDBCallbacks_SuccessDatabase_Params_Data::IDBCallbacks_SuccessDatabase_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_SuccessInteger_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_SuccessInteger_Params_Data* object = static_cast<const IDBCallbacks_SuccessInteger_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBCallbacks_SuccessInteger_Params_Data::IDBCallbacks_SuccessInteger_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCallbacks_Success_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCallbacks_Success_Params_Data* object = static_cast<const IDBCallbacks_Success_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBCallbacks_Success_Params_Data::IDBCallbacks_Success_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_ForcedClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseCallbacks_ForcedClose_Params_Data* object = static_cast<const IDBDatabaseCallbacks_ForcedClose_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabaseCallbacks_ForcedClose_Params_Data::IDBDatabaseCallbacks_ForcedClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_VersionChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseCallbacks_VersionChange_Params_Data* object = static_cast<const IDBDatabaseCallbacks_VersionChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabaseCallbacks_VersionChange_Params_Data::IDBDatabaseCallbacks_VersionChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseCallbacks_Abort_Params_Data* object = static_cast<const IDBDatabaseCallbacks_Abort_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::IDBException_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

IDBDatabaseCallbacks_Abort_Params_Data::IDBDatabaseCallbacks_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseCallbacks_Complete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseCallbacks_Complete_Params_Data* object = static_cast<const IDBDatabaseCallbacks_Complete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabaseCallbacks_Complete_Params_Data::IDBDatabaseCallbacks_Complete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Advance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_Advance_Params_Data* object = static_cast<const IDBCursor_Advance_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBCursor_Advance_Params_Data::IDBCursor_Advance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Advance_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_Advance_ResponseParams_Data* object = static_cast<const IDBCursor_Advance_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBCursor_Advance_ResponseParams_Data::IDBCursor_Advance_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_CursorContinue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_CursorContinue_Params_Data* object = static_cast<const IDBCursor_CursorContinue_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  return true;
}

IDBCursor_CursorContinue_Params_Data::IDBCursor_CursorContinue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_CursorContinue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_CursorContinue_ResponseParams_Data* object = static_cast<const IDBCursor_CursorContinue_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBCursor_CursorContinue_ResponseParams_Data::IDBCursor_CursorContinue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Prefetch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_Prefetch_Params_Data* object = static_cast<const IDBCursor_Prefetch_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBCursor_Prefetch_Params_Data::IDBCursor_Prefetch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_Prefetch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_Prefetch_ResponseParams_Data* object = static_cast<const IDBCursor_Prefetch_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBCursor_Prefetch_ResponseParams_Data::IDBCursor_Prefetch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBCursor_PrefetchReset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBCursor_PrefetchReset_Params_Data* object = static_cast<const IDBCursor_PrefetchReset_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBCursor_PrefetchReset_Params_Data::IDBCursor_PrefetchReset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_CreateObjectStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_CreateObjectStore_Params_Data* object = static_cast<const IDBTransaction_CreateObjectStore_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBTransaction_CreateObjectStore_Params_Data::IDBTransaction_CreateObjectStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_DeleteObjectStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_DeleteObjectStore_Params_Data* object = static_cast<const IDBTransaction_DeleteObjectStore_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBTransaction_DeleteObjectStore_Params_Data::IDBTransaction_DeleteObjectStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_Put_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_Put_Params_Data* object = static_cast<const IDBTransaction_Put_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBPutMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams index_keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->index_keys, validation_context,
                                         &index_keys_validate_params)) {
    return false;
  }

  return true;
}

IDBTransaction_Put_Params_Data::IDBTransaction_Put_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_Put_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_Put_ResponseParams_Data* object = static_cast<const IDBTransaction_Put_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBTransaction_Put_ResponseParams_Data::IDBTransaction_Put_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_PutAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_PutAll_Params_Data* object = static_cast<const IDBTransaction_PutAll_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->put_params, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams put_params_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->put_params, validation_context,
                                         &put_params_validate_params)) {
    return false;
  }

  return true;
}

IDBTransaction_PutAll_Params_Data::IDBTransaction_PutAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_PutAll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_PutAll_ResponseParams_Data* object = static_cast<const IDBTransaction_PutAll_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBTransaction_PutAll_ResponseParams_Data::IDBTransaction_PutAll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBTransaction_Commit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBTransaction_Commit_Params_Data* object = static_cast<const IDBTransaction_Commit_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBTransaction_Commit_Params_Data::IDBTransaction_Commit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data* object = static_cast<const IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data::IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data* object = static_cast<const IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data::IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabaseGetAllResultSink_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabaseGetAllResultSink_OnError_Params_Data* object = static_cast<const IDBDatabaseGetAllResultSink_OnError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

IDBDatabaseGetAllResultSink_OnError_Params_Data::IDBDatabaseGetAllResultSink_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_RenameObjectStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_RenameObjectStore_Params_Data* object = static_cast<const IDBDatabase_RenameObjectStore_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_name, validation_context))
    return false;

  return true;
}

IDBDatabase_RenameObjectStore_Params_Data::IDBDatabase_RenameObjectStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_CreateTransaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_CreateTransaction_Params_Data* object = static_cast<const IDBDatabase_CreateTransaction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->transaction_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->transaction_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_store_ids, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams object_store_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->object_store_ids, validation_context,
                                         &object_store_ids_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::IDBTransactionMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBTransactionDurability_Data
        ::Validate(object->durability, validation_context))
    return false;

  return true;
}

IDBDatabase_CreateTransaction_Params_Data::IDBDatabase_CreateTransaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_Close_Params_Data* object = static_cast<const IDBDatabase_Close_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabase_Close_Params_Data::IDBDatabase_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_VersionChangeIgnored_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_VersionChangeIgnored_Params_Data* object = static_cast<const IDBDatabase_VersionChangeIgnored_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabase_VersionChangeIgnored_Params_Data::IDBDatabase_VersionChangeIgnored_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Get_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_Get_Params_Data* object = static_cast<const IDBDatabase_Get_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  return true;
}

IDBDatabase_Get_Params_Data::IDBDatabase_Get_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Get_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_Get_ResponseParams_Data* object = static_cast<const IDBDatabase_Get_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBDatabase_Get_ResponseParams_Data::IDBDatabase_Get_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_GetAll_Params_Data* object = static_cast<const IDBDatabase_GetAll_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  return true;
}

IDBDatabase_GetAll_Params_Data::IDBDatabase_GetAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetAll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_GetAll_ResponseParams_Data* object = static_cast<const IDBDatabase_GetAll_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBDatabase_GetAll_ResponseParams_Data::IDBDatabase_GetAll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_SetIndexKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_SetIndexKeys_Params_Data* object = static_cast<const IDBDatabase_SetIndexKeys_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->primary_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->primary_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_keys, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams index_keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->index_keys, validation_context,
                                         &index_keys_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabase_SetIndexKeys_Params_Data::IDBDatabase_SetIndexKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_SetIndexesReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_SetIndexesReady_Params_Data* object = static_cast<const IDBDatabase_SetIndexesReady_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->index_ids, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams index_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->index_ids, validation_context,
                                         &index_ids_validate_params)) {
    return false;
  }

  return true;
}

IDBDatabase_SetIndexesReady_Params_Data::IDBDatabase_SetIndexesReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_OpenCursor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_OpenCursor_Params_Data* object = static_cast<const IDBDatabase_OpenCursor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBCursorDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::blink::mojom::internal::IDBTaskType_Data
        ::Validate(object->task_type, validation_context))
    return false;

  return true;
}

IDBDatabase_OpenCursor_Params_Data::IDBDatabase_OpenCursor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_OpenCursor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_OpenCursor_ResponseParams_Data* object = static_cast<const IDBDatabase_OpenCursor_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

IDBDatabase_OpenCursor_ResponseParams_Data::IDBDatabase_OpenCursor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Count_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_Count_Params_Data* object = static_cast<const IDBDatabase_Count_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBDatabase_Count_Params_Data::IDBDatabase_Count_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_DeleteRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_DeleteRange_Params_Data* object = static_cast<const IDBDatabase_DeleteRange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_range, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBDatabase_DeleteRange_Params_Data::IDBDatabase_DeleteRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data* object = static_cast<const IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Clear_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_Clear_Params_Data* object = static_cast<const IDBDatabase_Clear_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBDatabase_Clear_Params_Data::IDBDatabase_Clear_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_CreateIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_CreateIndex_Params_Data* object = static_cast<const IDBDatabase_CreateIndex_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_path, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_path, validation_context))
    return false;

  return true;
}

IDBDatabase_CreateIndex_Params_Data::IDBDatabase_CreateIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_DeleteIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_DeleteIndex_Params_Data* object = static_cast<const IDBDatabase_DeleteIndex_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabase_DeleteIndex_Params_Data::IDBDatabase_DeleteIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_RenameIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_RenameIndex_Params_Data* object = static_cast<const IDBDatabase_RenameIndex_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_name, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_name, validation_context))
    return false;

  return true;
}

IDBDatabase_RenameIndex_Params_Data::IDBDatabase_RenameIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBDatabase_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBDatabase_Abort_Params_Data* object = static_cast<const IDBDatabase_Abort_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBDatabase_Abort_Params_Data::IDBDatabase_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_GetDatabaseInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_GetDatabaseInfo_Params_Data* object = static_cast<const IDBFactory_GetDatabaseInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBFactory_GetDatabaseInfo_Params_Data::IDBFactory_GetDatabaseInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_Open_Params_Data* object = static_cast<const IDBFactory_Open_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->database_callbacks, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->database_callbacks,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->version_change_transaction_receiver, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->version_change_transaction_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IDBFactory_Open_Params_Data::IDBFactory_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_DeleteDatabase_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_DeleteDatabase_Params_Data* object = static_cast<const IDBFactory_DeleteDatabase_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_callbacks, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_callbacks,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  return true;
}

IDBFactory_DeleteDatabase_Params_Data::IDBFactory_DeleteDatabase_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data* object = static_cast<const IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data::IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data* object = static_cast<const IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::IDBStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data::IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_AbortTransactionsForDatabase_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_AbortTransactionsForDatabase_Params_Data* object = static_cast<const IDBFactory_AbortTransactionsForDatabase_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IDBFactory_AbortTransactionsForDatabase_Params_Data::IDBFactory_AbortTransactionsForDatabase_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data* object = static_cast<const IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::IDBStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data::IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBCursorDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBCursorDirection value) {
  return std::move(context).WriteString(::blink::mojom::IDBCursorDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBDataLoss>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBDataLoss value) {
  return std::move(context).WriteString(::blink::mojom::IDBDataLossToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBKeyType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBKeyType value) {
  return std::move(context).WriteString(::blink::mojom::IDBKeyTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBTransactionDurability>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBTransactionDurability value) {
  return std::move(context).WriteString(::blink::mojom::IDBTransactionDurabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBKeyPathType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBKeyPathType value) {
  return std::move(context).WriteString(::blink::mojom::IDBKeyPathTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBOperationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBOperationType value) {
  return std::move(context).WriteString(::blink::mojom::IDBOperationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBPutMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBPutMode value) {
  return std::move(context).WriteString(::blink::mojom::IDBPutModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBTaskType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBTaskType value) {
  return std::move(context).WriteString(::blink::mojom::IDBTaskTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBTransactionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBTransactionMode value) {
  return std::move(context).WriteString(::blink::mojom::IDBTransactionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBStatus value) {
  return std::move(context).WriteString(::blink::mojom::IDBStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IDBException>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IDBException value) {
  return std::move(context).WriteString(::blink::mojom::IDBExceptionToString(value));
}

} // namespace perfetto
