// third_party/blink/public/mojom/input/gesture_event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/gesture_event.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/gesture_event.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* GestureDeviceToStringHelper(GestureDevice value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GestureDevice::kUninitialized:
      return "kUninitialized";
    case GestureDevice::kTouchpad:
      return "kTouchpad";
    case GestureDevice::kTouchscreen:
      return "kTouchscreen";
    case GestureDevice::kSyntheticAutoscroll:
      return "kSyntheticAutoscroll";
    case GestureDevice::kScrollbar:
      return "kScrollbar";
    default:
      return nullptr;
  }
}

std::string GestureDeviceToString(GestureDevice value) {
  const char *str = GestureDeviceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GestureDevice value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GestureDevice value) {
  return os << GestureDeviceToString(value);
}

static NOINLINE const char* InertialPhaseStateToStringHelper(InertialPhaseState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InertialPhaseState::kUnknownMomentum:
      return "kUnknownMomentum";
    case InertialPhaseState::kNonMomentum:
      return "kNonMomentum";
    case InertialPhaseState::kMomentum:
      return "kMomentum";
    default:
      return nullptr;
  }
}

std::string InertialPhaseStateToString(InertialPhaseState value) {
  const char *str = InertialPhaseStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InertialPhaseState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InertialPhaseState value) {
  return os << InertialPhaseStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::GestureDevice>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::GestureDevice value) {
  return std::move(context).WriteString(::blink::mojom::GestureDeviceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InertialPhaseState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::InertialPhaseState value) {
  return std::move(context).WriteString(::blink::mojom::InertialPhaseStateToString(value));
}

} // namespace perfetto
