// third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_OUTPUT_STREAM_FACTORY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_OUTPUT_STREAM_FACTORY_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char RendererAudioOutputStreamFactory::Name_[] = "blink.mojom.RendererAudioOutputStreamFactory";

class RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback(
      RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback);
};

RendererAudioOutputStreamFactoryProxy::RendererAudioOutputStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererAudioOutputStreamFactoryProxy::RequestDeviceAuthorization(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStreamProvider> in_stream_provider_receiver, const absl::optional<::base::UnguessableToken>& in_session_id, const std::string& in_device_id, RequestDeviceAuthorizationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_provider_receiver"), in_stream_provider_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioOutputStreamProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererAudioOutputStreamFactory_RequestDeviceAuthorization_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamProviderInterfaceBase>>(
      in_stream_provider_receiver, &params->stream_provider_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream_provider_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream_provider_receiver in RendererAudioOutputStreamFactory.RequestDeviceAuthorization request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in RendererAudioOutputStreamFactory.RequestDeviceAuthorization request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioOutputStreamFactory::Name_);
  message.set_method_name("RequestDeviceAuthorization");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder {
 public:
  static RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder> proxy(
        new RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::OutputDeviceStatus in_state, const ::media::AudioParameters& in_output_params, const std::string& in_matched_device_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder);
};

bool RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::OutputDeviceStatus p_state{};
  ::media::AudioParameters p_output_params{};
  std::string p_matched_device_id{};
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (success && !input_data_view.ReadOutputParams(&p_output_params))
    success = false;
  if (success && !input_data_view.ReadMatchedDeviceId(&p_matched_device_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererAudioOutputStreamFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_state), 
std::move(p_output_params), 
std::move(p_matched_device_id));
  return true;
}

void RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder::Run(
    ::media::OutputDeviceStatus in_state, const ::media::AudioParameters& in_output_params, const std::string& in_matched_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::media::OutputDeviceStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_params"), in_output_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("matched_device_id"), in_matched_device_id,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererAudioOutputStreamFactory_RequestDeviceAuthorization_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::OutputDeviceStatus>(
      in_state, &params->state);
  mojo::internal::MessageFragment<
      typename decltype(params->output_params)::BaseType> output_params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_output_params, output_params_fragment);
  params->output_params.Set(
      output_params_fragment.is_null() ? nullptr : output_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->output_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_params in ");
  mojo::internal::MessageFragment<
      typename decltype(params->matched_device_id)::BaseType> matched_device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_matched_device_id, matched_device_id_fragment);
  params->matched_device_id.Set(
      matched_device_id_fragment.is_null() ? nullptr : matched_device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->matched_device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null matched_device_id in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioOutputStreamFactory::Name_);
  message.set_method_name("RequestDeviceAuthorization");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererAudioOutputStreamFactoryStubDispatch::Accept(
    RendererAudioOutputStreamFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRendererAudioOutputStreamFactory_RequestDeviceAuthorization_Name: {
      break;
    }
  }
  return false;
}

// static
bool RendererAudioOutputStreamFactoryStubDispatch::AcceptWithResponder(
    RendererAudioOutputStreamFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererAudioOutputStreamFactory_RequestDeviceAuthorization_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data* params =
          reinterpret_cast<
              internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioOutputStreamProvider> p_stream_provider_receiver{};
      absl::optional<::base::UnguessableToken> p_session_id{};
      std::string p_device_id{};
      RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream_provider_receiver =
            input_data_view.TakeStreamProviderReceiver<decltype(p_stream_provider_receiver)>();
      }
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererAudioOutputStreamFactory::Name_, 0, false);
        return false;
      }
      RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback callback =
          RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDeviceAuthorization(
std::move(p_stream_provider_receiver), 
std::move(p_session_id), 
std::move(p_device_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kRendererAudioOutputStreamFactoryValidationInfo[] = {
    {&internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data::Validate,
     &internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data::Validate},
};

bool RendererAudioOutputStreamFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RendererAudioOutputStreamFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kRendererAudioOutputStreamFactoryValidationInfo);
}

bool RendererAudioOutputStreamFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RendererAudioOutputStreamFactory::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kRendererAudioOutputStreamFactoryValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif