// third_party/blink/public/mojom/mediasession/media_session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* MediaSessionPlaybackStateToStringHelper(MediaSessionPlaybackState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSessionPlaybackState::NONE:
      return "NONE";
    case MediaSessionPlaybackState::PAUSED:
      return "PAUSED";
    case MediaSessionPlaybackState::PLAYING:
      return "PLAYING";
    default:
      return nullptr;
  }
}

std::string MediaSessionPlaybackStateToString(MediaSessionPlaybackState value) {
  const char *str = MediaSessionPlaybackStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSessionPlaybackState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSessionPlaybackState value) {
  return os << MediaSessionPlaybackStateToString(value);
}

namespace internal {
// static
bool MediaSessionActionDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MediaSessionActionDetails_Data* object = static_cast<const MediaSessionActionDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MediaSessionActionDetails_Tag::SEEK_TO: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_seek_to, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_seek_to, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MediaSessionActionDetails");
      return false;
    }
  }
}


// static
bool MediaSessionSeekToDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionSeekToDetails_Data* object = static_cast<const MediaSessionSeekToDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSessionSeekToDetails_Data::MediaSessionSeekToDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpecMediaMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpecMediaMetadata_Data* object = static_cast<const SpecMediaMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artist, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->artist, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->album, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->album, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artwork, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams artwork_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->artwork, validation_context,
                                         &artwork_validate_params)) {
    return false;
  }

  return true;
}

SpecMediaMetadata_Data::SpecMediaMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionClient_DidReceiveAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionClient_DidReceiveAction_Params_Data* object = static_cast<const MediaSessionClient_DidReceiveAction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSessionAction_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->details, validation_context))
    return false;

  return true;
}

MediaSessionClient_DidReceiveAction_Params_Data::MediaSessionClient_DidReceiveAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_SetClient_Params_Data* object = static_cast<const MediaSessionService_SetClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaSessionService_SetClient_Params_Data::MediaSessionService_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetPlaybackState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_SetPlaybackState_Params_Data* object = static_cast<const MediaSessionService_SetPlaybackState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::MediaSessionPlaybackState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

MediaSessionService_SetPlaybackState_Params_Data::MediaSessionService_SetPlaybackState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetPositionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_SetPositionState_Params_Data* object = static_cast<const MediaSessionService_SetPositionState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

MediaSessionService_SetPositionState_Params_Data::MediaSessionService_SetPositionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_SetMetadata_Params_Data* object = static_cast<const MediaSessionService_SetMetadata_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

MediaSessionService_SetMetadata_Params_Data::MediaSessionService_SetMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetMicrophoneState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_SetMicrophoneState_Params_Data* object = static_cast<const MediaSessionService_SetMicrophoneState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MicrophoneState_Data
        ::Validate(object->microphone_state, validation_context))
    return false;

  return true;
}

MediaSessionService_SetMicrophoneState_Params_Data::MediaSessionService_SetMicrophoneState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetCameraState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_SetCameraState_Params_Data* object = static_cast<const MediaSessionService_SetCameraState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::CameraState_Data
        ::Validate(object->camera_state, validation_context))
    return false;

  return true;
}

MediaSessionService_SetCameraState_Params_Data::MediaSessionService_SetCameraState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_EnableAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_EnableAction_Params_Data* object = static_cast<const MediaSessionService_EnableAction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSessionAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

MediaSessionService_EnableAction_Params_Data::MediaSessionService_EnableAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_DisableAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionService_DisableAction_Params_Data* object = static_cast<const MediaSessionService_DisableAction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSessionAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

MediaSessionService_DisableAction_Params_Data::MediaSessionService_DisableAction_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MediaSessionPlaybackState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::MediaSessionPlaybackState value) {
  return std::move(context).WriteString(::blink::mojom::MediaSessionPlaybackStateToString(value));
}

} // namespace perfetto
