// third_party/blink/public/mojom/mediastream/media_stream.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
StreamSelectionInfo::StreamSelectionInfo()
    : strategy(),
      session_id() {}

StreamSelectionInfo::StreamSelectionInfo(
    StreamSelectionStrategy strategy_in,
    const absl::optional<::base::UnguessableToken>& session_id_in)
    : strategy(std::move(strategy_in)),
      session_id(std::move(session_id_in)) {}

StreamSelectionInfo::~StreamSelectionInfo() = default;

void StreamSelectionInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strategy"), this->strategy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type StreamSelectionStrategy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id"), this->session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamSelectionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaStreamDevice::MediaStreamDevice()
    : type(),
      id(),
      video_facing(),
      group_id(),
      matched_output_device_id(),
      name(),
      input(),
      session_id(),
      display_media_info() {}

MediaStreamDevice::MediaStreamDevice(
    MediaStreamType type_in,
    const WTF::String& id_in,
    ::media::VideoFacingMode video_facing_in,
    const WTF::String& group_id_in,
    const WTF::String& matched_output_device_id_in,
    const WTF::String& name_in,
    const ::media::AudioParameters& input_in,
    const absl::optional<::base::UnguessableToken>& session_id_in,
    ::media::mojom::blink::DisplayMediaInformationPtr display_media_info_in)
    : type(std::move(type_in)),
      id(std::move(id_in)),
      video_facing(std::move(video_facing_in)),
      group_id(std::move(group_id_in)),
      matched_output_device_id(std::move(matched_output_device_id_in)),
      name(std::move(name_in)),
      input(std::move(input_in)),
      session_id(std::move(session_id_in)),
      display_media_info(std::move(display_media_info_in)) {}

MediaStreamDevice::~MediaStreamDevice() = default;

void MediaStreamDevice::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaStreamType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_facing"), this->video_facing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoFacingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_output_device_id"), this->matched_output_device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::AudioParameters&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id"), this->session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_media_info"), this->display_media_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::DisplayMediaInformationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaStreamDevice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrackControls::TrackControls()
    : requested(),
      stream_type(),
      device_id() {}

TrackControls::TrackControls(
    bool requested_in,
    MediaStreamType stream_type_in,
    const WTF::String& device_id_in)
    : requested(std::move(requested_in)),
      stream_type(std::move(stream_type_in)),
      device_id(std::move(device_id_in)) {}

TrackControls::~TrackControls() = default;

void TrackControls::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested"), this->requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_type"), this->stream_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaStreamType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrackControls::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StreamControls::StreamControls()
    : audio(),
      video(),
      hotword_enabled(),
      disable_local_echo(),
      request_pan_tilt_zoom_permission() {}

StreamControls::StreamControls(
    const ::blink::TrackControls& audio_in,
    const ::blink::TrackControls& video_in,
    bool hotword_enabled_in,
    bool disable_local_echo_in,
    bool request_pan_tilt_zoom_permission_in)
    : audio(std::move(audio_in)),
      video(std::move(video_in)),
      hotword_enabled(std::move(hotword_enabled_in)),
      disable_local_echo(std::move(disable_local_echo_in)),
      request_pan_tilt_zoom_permission(std::move(request_pan_tilt_zoom_permission_in)) {}

StreamControls::~StreamControls() = default;

void StreamControls::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio"), this->audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::TrackControls&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video"), this->video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::TrackControls&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hotword_enabled"), this->hotword_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_local_echo"), this->disable_local_echo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_pan_tilt_zoom_permission"), this->request_pan_tilt_zoom_permission,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamControls::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char MediaStreamDeviceObserver::Name_[] = "blink.mojom.MediaStreamDeviceObserver";

MediaStreamDeviceObserverProxy::MediaStreamDeviceObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStreamDeviceObserverProxy::OnDeviceStopped(
    const WTF::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDeviceObserver_OnDeviceStopped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaStreamDeviceObserver.OnDeviceStopped request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_device, device_fragment);
  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in MediaStreamDeviceObserver.OnDeviceStopped request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDeviceObserverProxy::OnDeviceChanged(
    const WTF::String& in_label, const ::blink::MediaStreamDevice& in_old_device, const ::blink::MediaStreamDevice& in_new_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_device"), in_old_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_device"), in_new_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDeviceObserver_OnDeviceChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaStreamDeviceObserver.OnDeviceChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_device)::BaseType> old_device_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_old_device, old_device_fragment);
  params->old_device.Set(
      old_device_fragment.is_null() ? nullptr : old_device_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_device.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_device in MediaStreamDeviceObserver.OnDeviceChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_device)::BaseType> new_device_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_new_device, new_device_fragment);
  params->new_device.Set(
      new_device_fragment.is_null() ? nullptr : new_device_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_device.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_device in MediaStreamDeviceObserver.OnDeviceChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDeviceObserverProxy::OnDeviceRequestStateChange(
    const WTF::String& in_label, const ::blink::MediaStreamDevice& in_device, MediaStreamStateChange in_new_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_state"), in_new_state,
                        "<value of type MediaStreamStateChange>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaStreamDeviceObserver.OnDeviceRequestStateChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_device, device_fragment);
  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in MediaStreamDeviceObserver.OnDeviceRequestStateChange request");
  mojo::internal::Serialize<::blink::mojom::MediaStreamStateChange>(
      in_new_state, &params->new_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceRequestStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDeviceObserverProxy::OnDeviceCaptureHandleChange(
    const WTF::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaStreamDeviceObserver.OnDeviceCaptureHandleChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_device, device_fragment);
  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in MediaStreamDeviceObserver.OnDeviceCaptureHandleChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceCaptureHandleChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaStreamDeviceObserverStubDispatch::Accept(
    MediaStreamDeviceObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaStreamDeviceObserver_OnDeviceStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceStopped(
std::move(p_label), 
std::move(p_device));
      return true;
    }
    case internal::kMediaStreamDeviceObserver_OnDeviceChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_label{};
      ::blink::MediaStreamDevice p_old_device{};
      ::blink::MediaStreamDevice p_new_device{};
      MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadOldDevice(&p_old_device))
        success = false;
      if (success && !input_data_view.ReadNewDevice(&p_new_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceChanged(
std::move(p_label), 
std::move(p_old_device), 
std::move(p_new_device));
      return true;
    }
    case internal::kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamStateChange p_new_state{};
      MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (success && !input_data_view.ReadNewState(&p_new_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceRequestStateChange(
std::move(p_label), 
std::move(p_device), 
std::move(p_new_state));
      return true;
    }
    case internal::kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceCaptureHandleChange(
std::move(p_label), 
std::move(p_device));
      return true;
    }
  }
  return false;
}

// static
bool MediaStreamDeviceObserverStubDispatch::AcceptWithResponder(
    MediaStreamDeviceObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaStreamDeviceObserver_OnDeviceStopped_Name: {
      break;
    }
    case internal::kMediaStreamDeviceObserver_OnDeviceChanged_Name: {
      break;
    }
    case internal::kMediaStreamDeviceObserver_OnDeviceRequestStateChange_Name: {
      break;
    }
    case internal::kMediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaStreamDeviceObserverValidationInfo[] = {
    {&internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaStreamDeviceObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::MediaStreamDeviceObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaStreamDeviceObserverValidationInfo);
}

const char MediaStreamDispatcherHost::Name_[] = "blink.mojom.MediaStreamDispatcherHost";

class MediaStreamDispatcherHost_GenerateStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_GenerateStream_ForwardToCallback(
      MediaStreamDispatcherHost::GenerateStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::GenerateStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaStreamDispatcherHost_GenerateStream_ForwardToCallback);
};

class MediaStreamDispatcherHost_OpenDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_OpenDevice_ForwardToCallback(
      MediaStreamDispatcherHost::OpenDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::OpenDeviceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaStreamDispatcherHost_OpenDevice_ForwardToCallback);
};

MediaStreamDispatcherHostProxy::MediaStreamDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStreamDispatcherHostProxy::GenerateStream(
    int32_t in_request_id, const ::blink::StreamControls& in_controls, bool in_user_gesture, StreamSelectionInfoPtr in_audio_stream_selection_info, GenerateStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::GenerateStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controls"), in_controls,
                        "<value of type const ::blink::StreamControls&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_stream_selection_info"), in_audio_stream_selection_info,
                        "<value of type StreamSelectionInfoPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_GenerateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GenerateStream_Params_Data> params(
          message);
  params.Allocate();
  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->controls)::BaseType> controls_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StreamControlsDataView>(
      in_controls, controls_fragment);
  params->controls.Set(
      controls_fragment.is_null() ? nullptr : controls_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->controls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null controls in MediaStreamDispatcherHost.GenerateStream request");
  params->user_gesture = in_user_gesture;
  mojo::internal::MessageFragment<
      typename decltype(params->audio_stream_selection_info)::BaseType> audio_stream_selection_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StreamSelectionInfoDataView>(
      in_audio_stream_selection_info, audio_stream_selection_info_fragment);
  params->audio_stream_selection_info.Set(
      audio_stream_selection_info_fragment.is_null() ? nullptr : audio_stream_selection_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_stream_selection_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_stream_selection_info in MediaStreamDispatcherHost.GenerateStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GenerateStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_GenerateStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaStreamDispatcherHostProxy::CancelRequest(
    int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::CancelRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_CancelRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_CancelRequest_Params_Data> params(
          message);
  params.Allocate();
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("CancelRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDispatcherHostProxy::StopStreamDevice(
    const WTF::String& in_device_id, const absl::optional<::base::UnguessableToken>& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::StopStreamDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_StopStreamDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in MediaStreamDispatcherHost.StopStreamDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("StopStreamDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDispatcherHostProxy::OpenDevice(
    int32_t in_request_id, const WTF::String& in_device_id, MediaStreamType in_type, OpenDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::OpenDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type MediaStreamType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_OpenDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_OpenDevice_Params_Data> params(
          message);
  params.Allocate();
  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in MediaStreamDispatcherHost.OpenDevice request");
  mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("OpenDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_OpenDevice_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaStreamDispatcherHostProxy::CloseDevice(
    const WTF::String& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::CloseDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_CloseDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_CloseDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaStreamDispatcherHost.CloseDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("CloseDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDispatcherHostProxy::SetCapturingLinkSecured(
    const absl::optional<::base::UnguessableToken>& in_session_id, MediaStreamType in_type, bool in_is_secure) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type MediaStreamType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_secure"), in_is_secure,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
      in_type, &params->type);
  params->is_secure = in_is_secure;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("SetCapturingLinkSecured");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamDispatcherHostProxy::OnStreamStarted(
    const WTF::String& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamDispatcherHost::OnStreamStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_OnStreamStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_OnStreamStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in MediaStreamDispatcherHost.OnStreamStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("OnStreamStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class MediaStreamDispatcherHost_GenerateStream_ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::GenerateStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaStreamDispatcherHost_GenerateStream_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_GenerateStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaStreamDispatcherHost_GenerateStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_GenerateStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaStreamDispatcherHost_GenerateStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaStreamDispatcherHost::GenerateStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaStreamRequestResult in_result, const WTF::String& in_label, const WTF::Vector<::blink::MediaStreamDevice>& in_audio_devices, const WTF::Vector<::blink::MediaStreamDevice>& in_video_devices, bool in_pan_tilt_zoom_allowed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaStreamDispatcherHost_GenerateStream_ProxyToResponder);
};

bool MediaStreamDispatcherHost_GenerateStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaStreamDispatcherHost::GenerateStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_GenerateStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_GenerateStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  MediaStreamRequestResult p_result{};
  WTF::String p_label{};
  WTF::Vector<::blink::MediaStreamDevice> p_audio_devices{};
  WTF::Vector<::blink::MediaStreamDevice> p_video_devices{};
  bool p_pan_tilt_zoom_allowed{};
  MediaStreamDispatcherHost_GenerateStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadLabel(&p_label))
    success = false;
  if (success && !input_data_view.ReadAudioDevices(&p_audio_devices))
    success = false;
  if (success && !input_data_view.ReadVideoDevices(&p_video_devices))
    success = false;
  if (success)
    p_pan_tilt_zoom_allowed = input_data_view.pan_tilt_zoom_allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_label), 
std::move(p_audio_devices), 
std::move(p_video_devices), 
std::move(p_pan_tilt_zoom_allowed));
  return true;
}

void MediaStreamDispatcherHost_GenerateStream_ProxyToResponder::Run(
    MediaStreamRequestResult in_result, const WTF::String& in_label, const WTF::Vector<::blink::MediaStreamDevice>& in_audio_devices, const WTF::Vector<::blink::MediaStreamDevice>& in_video_devices, bool in_pan_tilt_zoom_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaStreamDispatcherHost::GenerateStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MediaStreamRequestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_devices"), in_audio_devices,
                        "<value of type const WTF::Vector<::blink::MediaStreamDevice>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_devices"), in_video_devices,
                        "<value of type const WTF::Vector<::blink::MediaStreamDevice>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pan_tilt_zoom_allowed"), in_pan_tilt_zoom_allowed,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_GenerateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GenerateStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::MediaStreamRequestResult>(
      in_result, &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_devices)::BaseType>
      audio_devices_fragment(params.message());
  const mojo::internal::ContainerValidateParams audio_devices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MediaStreamDeviceDataView>>(
      in_audio_devices, audio_devices_fragment, &audio_devices_validate_params);
  params->audio_devices.Set(
      audio_devices_fragment.is_null() ? nullptr : audio_devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_devices in ");
  mojo::internal::MessageFragment<
      typename decltype(params->video_devices)::BaseType>
      video_devices_fragment(params.message());
  const mojo::internal::ContainerValidateParams video_devices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MediaStreamDeviceDataView>>(
      in_video_devices, video_devices_fragment, &video_devices_validate_params);
  params->video_devices.Set(
      video_devices_fragment.is_null() ? nullptr : video_devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->video_devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_devices in ");
  params->pan_tilt_zoom_allowed = in_pan_tilt_zoom_allowed;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaStreamDispatcherHost::GenerateStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GenerateStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaStreamDispatcherHost_OpenDevice_ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::OpenDeviceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaStreamDispatcherHost_OpenDevice_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_OpenDevice_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaStreamDispatcherHost_OpenDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_OpenDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaStreamDispatcherHost_OpenDevice_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaStreamDispatcherHost::OpenDeviceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const WTF::String& in_label, const ::blink::MediaStreamDevice& in_device);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaStreamDispatcherHost_OpenDevice_ProxyToResponder);
};

bool MediaStreamDispatcherHost_OpenDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaStreamDispatcherHost::OpenDeviceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  WTF::String p_label{};
  ::blink::MediaStreamDevice p_device{};
  MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadLabel(&p_label))
    success = false;
  if (success && !input_data_view.ReadDevice(&p_device))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_label), 
std::move(p_device));
  return true;
}

void MediaStreamDispatcherHost_OpenDevice_ProxyToResponder::Run(
    bool in_success, const WTF::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaStreamDispatcherHost::OpenDeviceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamDispatcherHost_OpenDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_label, label_fragment);
  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
      in_device, device_fragment);
  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaStreamDispatcherHost::OpenDeviceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("OpenDevice");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaStreamDispatcherHostStubDispatch::Accept(
    MediaStreamDispatcherHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaStreamDispatcherHost_GenerateStream_Name: {
      break;
    }
    case internal::kMediaStreamDispatcherHost_CancelRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::CancelRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::CancelRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_CancelRequest_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_CancelRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      MediaStreamDispatcherHost_CancelRequest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelRequest(
std::move(p_request_id));
      return true;
    }
    case internal::kMediaStreamDispatcherHost_StopStreamDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::StopStreamDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::StopStreamDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_device_id{};
      absl::optional<::base::UnguessableToken> p_session_id{};
      MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopStreamDevice(
std::move(p_device_id), 
std::move(p_session_id));
      return true;
    }
    case internal::kMediaStreamDispatcherHost_OpenDevice_Name: {
      break;
    }
    case internal::kMediaStreamDispatcherHost_CloseDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::CloseDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::CloseDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_CloseDevice_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_CloseDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_label{};
      MediaStreamDispatcherHost_CloseDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseDevice(
std::move(p_label));
      return true;
    }
    case internal::kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::base::UnguessableToken> p_session_id{};
      MediaStreamType p_type{};
      bool p_is_secure{};
      MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_is_secure = input_data_view.is_secure();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCapturingLinkSecured(
std::move(p_session_id), 
std::move(p_type), 
std::move(p_is_secure));
      return true;
    }
    case internal::kMediaStreamDispatcherHost_OnStreamStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::OnStreamStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::OnStreamStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_OnStreamStarted_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_OnStreamStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_label{};
      MediaStreamDispatcherHost_OnStreamStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStreamStarted(
std::move(p_label));
      return true;
    }
  }
  return false;
}

// static
bool MediaStreamDispatcherHostStubDispatch::AcceptWithResponder(
    MediaStreamDispatcherHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaStreamDispatcherHost_GenerateStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::GenerateStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::GenerateStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaStreamDispatcherHost_GenerateStream_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_GenerateStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      ::blink::StreamControls p_controls{};
      bool p_user_gesture{};
      StreamSelectionInfoPtr p_audio_stream_selection_info{};
      MediaStreamDispatcherHost_GenerateStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadControls(&p_controls))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (success && !input_data_view.ReadAudioStreamSelectionInfo(&p_audio_stream_selection_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 0, false);
        return false;
      }
      MediaStreamDispatcherHost::GenerateStreamCallback callback =
          MediaStreamDispatcherHost_GenerateStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerateStream(
std::move(p_request_id), 
std::move(p_controls), 
std::move(p_user_gesture), 
std::move(p_audio_stream_selection_info), std::move(callback));
      return true;
    }
    case internal::kMediaStreamDispatcherHost_CancelRequest_Name: {
      break;
    }
    case internal::kMediaStreamDispatcherHost_StopStreamDevice_Name: {
      break;
    }
    case internal::kMediaStreamDispatcherHost_OpenDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamDispatcherHost::OpenDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamDispatcherHost::OpenDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaStreamDispatcherHost_OpenDevice_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_OpenDevice_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      WTF::String p_device_id{};
      MediaStreamType p_type{};
      MediaStreamDispatcherHost_OpenDevice_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 3, false);
        return false;
      }
      MediaStreamDispatcherHost::OpenDeviceCallback callback =
          MediaStreamDispatcherHost_OpenDevice_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDevice(
std::move(p_request_id), 
std::move(p_device_id), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kMediaStreamDispatcherHost_CloseDevice_Name: {
      break;
    }
    case internal::kMediaStreamDispatcherHost_SetCapturingLinkSecured_Name: {
      break;
    }
    case internal::kMediaStreamDispatcherHost_OnStreamStarted_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaStreamDispatcherHostValidationInfo[] = {
    {&internal::MediaStreamDispatcherHost_GenerateStream_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_GenerateStream_ResponseParams_Data::Validate},
    {&internal::MediaStreamDispatcherHost_CancelRequest_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDispatcherHost_OpenDevice_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data::Validate},
    {&internal::MediaStreamDispatcherHost_CloseDevice_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamDispatcherHost_OnStreamStarted_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaStreamDispatcherHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::MediaStreamDispatcherHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaStreamDispatcherHostValidationInfo);
}

bool MediaStreamDispatcherHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::MediaStreamDispatcherHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kMediaStreamDispatcherHostValidationInfo);
}
const char MediaStreamTrackMetricsHost::Name_[] = "blink.mojom.MediaStreamTrackMetricsHost";

MediaStreamTrackMetricsHostProxy::MediaStreamTrackMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStreamTrackMetricsHostProxy::AddTrack(
    uint64_t in_id, bool in_is_audio, bool in_is_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamTrackMetricsHost::AddTrack", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_audio"), in_is_audio,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_remote"), in_is_remote,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamTrackMetricsHost_AddTrack_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;
  params->is_audio = in_is_audio;
  params->is_remote = in_is_remote;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamTrackMetricsHost::Name_);
  message.set_method_name("AddTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaStreamTrackMetricsHostProxy::RemoveTrack(
    uint64_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaStreamTrackMetricsHost_RemoveTrack_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamTrackMetricsHost::Name_);
  message.set_method_name("RemoveTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaStreamTrackMetricsHostStubDispatch::Accept(
    MediaStreamTrackMetricsHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaStreamTrackMetricsHost_AddTrack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamTrackMetricsHost::AddTrack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamTrackMetricsHost::AddTrack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data* params =
          reinterpret_cast<internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_id{};
      bool p_is_audio{};
      bool p_is_remote{};
      MediaStreamTrackMetricsHost_AddTrack_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success)
        p_is_audio = input_data_view.is_audio();
      if (success)
        p_is_remote = input_data_view.is_remote();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamTrackMetricsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTrack(
std::move(p_id), 
std::move(p_is_audio), 
std::move(p_is_remote));
      return true;
    }
    case internal::kMediaStreamTrackMetricsHost_RemoveTrack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data* params =
          reinterpret_cast<internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_id{};
      MediaStreamTrackMetricsHost_RemoveTrack_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamTrackMetricsHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveTrack(
std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool MediaStreamTrackMetricsHostStubDispatch::AcceptWithResponder(
    MediaStreamTrackMetricsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaStreamTrackMetricsHost_AddTrack_Name: {
      break;
    }
    case internal::kMediaStreamTrackMetricsHost_RemoveTrack_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaStreamTrackMetricsHostValidationInfo[] = {
    {&internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaStreamTrackMetricsHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::MediaStreamTrackMetricsHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaStreamTrackMetricsHostValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::StreamSelectionInfo::DataView, ::blink::mojom::blink::StreamSelectionInfoPtr>::Read(
    ::blink::mojom::blink::StreamSelectionInfo::DataView input,
    ::blink::mojom::blink::StreamSelectionInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::StreamSelectionInfoPtr result(::blink::mojom::blink::StreamSelectionInfo::New());
  
      if (success && !input.ReadStrategy(&result->strategy))
        success = false;
      if (success && !input.ReadSessionId(&result->session_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MediaStreamDevice::DataView, ::blink::mojom::blink::MediaStreamDevicePtr>::Read(
    ::blink::mojom::blink::MediaStreamDevice::DataView input,
    ::blink::mojom::blink::MediaStreamDevicePtr* output) {
  bool success = true;
  ::blink::mojom::blink::MediaStreamDevicePtr result(::blink::mojom::blink::MediaStreamDevice::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadVideoFacing(&result->video_facing))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadMatchedOutputDeviceId(&result->matched_output_device_id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadInput(&result->input))
        success = false;
      if (success && !input.ReadSessionId(&result->session_id))
        success = false;
      if (success && !input.ReadDisplayMediaInfo(&result->display_media_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TrackControls::DataView, ::blink::mojom::blink::TrackControlsPtr>::Read(
    ::blink::mojom::blink::TrackControls::DataView input,
    ::blink::mojom::blink::TrackControlsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TrackControlsPtr result(::blink::mojom::blink::TrackControls::New());
  
      if (success)
        result->requested = input.requested();
      if (success && !input.ReadStreamType(&result->stream_type))
        success = false;
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::StreamControls::DataView, ::blink::mojom::blink::StreamControlsPtr>::Read(
    ::blink::mojom::blink::StreamControls::DataView input,
    ::blink::mojom::blink::StreamControlsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::StreamControlsPtr result(::blink::mojom::blink::StreamControls::New());
  
      if (success && !input.ReadAudio(&result->audio))
        success = false;
      if (success && !input.ReadVideo(&result->video))
        success = false;
      if (success)
        result->hotword_enabled = input.hotword_enabled();
      if (success)
        result->disable_local_echo = input.disable_local_echo();
      if (success)
        result->request_pan_tilt_zoom_permission = input.request_pan_tilt_zoom_permission();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif