// third_party/blink/public/mojom/mobile_metrics/mobile_friendliness.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/mobile_metrics/mobile_friendliness.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mobile_metrics/mobile_friendliness.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ViewportStatusToStringHelper(ViewportStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ViewportStatus::kUnknown:
      return "kUnknown";
    case ViewportStatus::kYes:
      return "kYes";
    case ViewportStatus::kNo:
      return "kNo";
    default:
      return nullptr;
  }
}

std::string ViewportStatusToString(ViewportStatus value) {
  const char *str = ViewportStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ViewportStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ViewportStatus value) {
  return os << ViewportStatusToString(value);
}

namespace internal {


// static
bool MobileFriendliness_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MobileFriendliness_Data* object = static_cast<const MobileFriendliness_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ViewportStatus_Data
        ::Validate(object->viewport_device_width, validation_context))
    return false;


  if (!::blink::mojom::internal::ViewportStatus_Data
        ::Validate(object->allow_user_zoom, validation_context))
    return false;

  return true;
}

MobileFriendliness_Data::MobileFriendliness_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ViewportStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ViewportStatus value) {
  return std::move(context).WriteString(::blink::mojom::ViewportStatusToString(value));
}

} // namespace perfetto
