// third_party/blink/public/mojom/native_io/native_io.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/native_io/native_io.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/native_io/native_io.mojom-params-data.h"
#include "third_party/blink/public/mojom/native_io/native_io.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/native_io/native_io.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
NativeIOError::NativeIOError()
    : type(),
      message() {}

NativeIOError::NativeIOError(
    NativeIOErrorType type_in,
    const WTF::String& message_in)
    : type(std::move(type_in)),
      message(std::move(message_in)) {}

NativeIOError::~NativeIOError() = default;
size_t NativeIOError::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->type);
  seed = mojo::internal::WTFHash(seed, this->message);
  return seed;
}

void NativeIOError::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NativeIOErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NativeIOError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NativeIOFileHost::Name_[] = "blink.mojom.NativeIOFileHost";
bool NativeIOFileHost::Close() {
  NOTREACHED();
  return false;
}
class NativeIOFileHost_Close_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOFileHost_Close_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_Close_HandleSyncResponse);
};

class NativeIOFileHost_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOFileHost_Close_ForwardToCallback(
      NativeIOFileHost::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOFileHost::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_Close_ForwardToCallback);
};

NativeIOFileHostProxy::NativeIOFileHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NativeIOFileHostProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "blink::mojom::NativeIOFileHost::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOFileHost_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOFileHost_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("Close");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOFileHost_Close_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::NativeIOFileHost::Close");
#endif
  return result;
}

void NativeIOFileHostProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeIOFileHost::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOFileHost_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOFileHost_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOFileHost_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NativeIOFileHost_Close_ProxyToResponder {
 public:
  static NativeIOFileHost::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOFileHost_Close_ProxyToResponder> proxy(
        new NativeIOFileHost_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOFileHost_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOFileHost_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOFileHost_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOFileHost::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_Close_ProxyToResponder);
};

bool NativeIOFileHost_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOFileHost::CloseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NativeIOFileHost_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOFileHost_Close_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NativeIOFileHost_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOFileHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NativeIOFileHost_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::NativeIOFileHost::CloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOFileHost_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOFileHost_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOFileHost::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOFileHost_Close_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOFileHost_Close_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOFileHost_Close_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  NativeIOFileHost_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOFileHost::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool NativeIOFileHostStubDispatch::Accept(
    NativeIOFileHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNativeIOFileHost_Close_Name: {
      break;
    }
  }
  return false;
}

// static
bool NativeIOFileHostStubDispatch::AcceptWithResponder(
    NativeIOFileHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeIOFileHost_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOFileHost::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOFileHost::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOFileHost_Close_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOFileHost_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeIOFileHost_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOFileHost::Name_, 0, false);
        return false;
      }
      NativeIOFileHost::CloseCallback callback =
          NativeIOFileHost_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeIOFileHostValidationInfo[] = {
    {&internal::NativeIOFileHost_Close_Params_Data::Validate,
     &internal::NativeIOFileHost_Close_ResponseParams_Data::Validate},
};

bool NativeIOFileHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeIOFileHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeIOFileHostValidationInfo);
}

bool NativeIOFileHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeIOFileHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeIOFileHostValidationInfo);
}
const char NativeIOHost::Name_[] = "blink.mojom.NativeIOHost";
bool NativeIOHost::RequestCapacityChange(int64_t capacity_delta, int64_t* out_granted_capacity_delta) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::OpenFile(const WTF::String& name, ::mojo::PendingReceiver<NativeIOFileHost> file_host_receiver, ::base::File* out_backing_file, uint64_t* out_backing_file_size, NativeIOErrorPtr* out_open_error) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::DeleteFile(const WTF::String& name, NativeIOErrorPtr* out_delete_error, uint64_t* out_granted_capacity_delta) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::GetAllFileNames(bool* out_success, WTF::Vector<WTF::String>* out_names) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::RenameFile(const WTF::String& old_name, const WTF::String& new_name, NativeIOErrorPtr* out_rename_error) {
  NOTREACHED();
  return false;
}
class NativeIOHost_RequestCapacityChange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_RequestCapacityChange_HandleSyncResponse(
      bool* result, int64_t* out_granted_capacity_delta)
      : result_(result), out_granted_capacity_delta_(out_granted_capacity_delta) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int64_t* out_granted_capacity_delta_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RequestCapacityChange_HandleSyncResponse);
};

class NativeIOHost_RequestCapacityChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_RequestCapacityChange_ForwardToCallback(
      NativeIOHost::RequestCapacityChangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::RequestCapacityChangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RequestCapacityChange_ForwardToCallback);
};
class NativeIOHost_OpenFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_OpenFile_HandleSyncResponse(
      bool* result, ::base::File* out_backing_file, uint64_t* out_backing_file_size, NativeIOErrorPtr* out_open_error)
      : result_(result), out_backing_file_(out_backing_file), out_backing_file_size_(out_backing_file_size), out_open_error_(out_open_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_backing_file_;
  uint64_t* out_backing_file_size_;
  NativeIOErrorPtr* out_open_error_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_OpenFile_HandleSyncResponse);
};

class NativeIOHost_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_OpenFile_ForwardToCallback(
      NativeIOHost::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::OpenFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_OpenFile_ForwardToCallback);
};
class NativeIOHost_DeleteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_DeleteFile_HandleSyncResponse(
      bool* result, NativeIOErrorPtr* out_delete_error, uint64_t* out_granted_capacity_delta)
      : result_(result), out_delete_error_(out_delete_error), out_granted_capacity_delta_(out_granted_capacity_delta) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  NativeIOErrorPtr* out_delete_error_;
  uint64_t* out_granted_capacity_delta_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_DeleteFile_HandleSyncResponse);
};

class NativeIOHost_DeleteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_DeleteFile_ForwardToCallback(
      NativeIOHost::DeleteFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::DeleteFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_DeleteFile_ForwardToCallback);
};
class NativeIOHost_GetAllFileNames_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_GetAllFileNames_HandleSyncResponse(
      bool* result, bool* out_success, WTF::Vector<WTF::String>* out_names)
      : result_(result), out_success_(out_success), out_names_(out_names) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  WTF::Vector<WTF::String>* out_names_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_GetAllFileNames_HandleSyncResponse);
};

class NativeIOHost_GetAllFileNames_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_GetAllFileNames_ForwardToCallback(
      NativeIOHost::GetAllFileNamesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::GetAllFileNamesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_GetAllFileNames_ForwardToCallback);
};
class NativeIOHost_RenameFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_RenameFile_HandleSyncResponse(
      bool* result, NativeIOErrorPtr* out_rename_error)
      : result_(result), out_rename_error_(out_rename_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  NativeIOErrorPtr* out_rename_error_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RenameFile_HandleSyncResponse);
};

class NativeIOHost_RenameFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_RenameFile_ForwardToCallback(
      NativeIOHost::RenameFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::RenameFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RenameFile_ForwardToCallback);
};

NativeIOHostProxy::NativeIOHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NativeIOHostProxy::RequestCapacityChange(
    int64_t param_capacity_delta, int64_t* out_param_granted_capacity_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::RequestCapacityChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capacity_delta"), param_capacity_delta,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_RequestCapacityChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_RequestCapacityChange_Params_Data> params(
          message);
  params.Allocate();
  params->capacity_delta = param_capacity_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RequestCapacityChange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_RequestCapacityChange_HandleSyncResponse(
          &result, out_param_granted_capacity_delta));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::RequestCapacityChange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_capacity_delta"), out_param_granted_capacity_delta,
                        "<value of type int64_t>");
   });
#endif
  return result;
}

void NativeIOHostProxy::RequestCapacityChange(
    int64_t in_capacity_delta, RequestCapacityChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::RequestCapacityChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capacity_delta"), in_capacity_delta,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_RequestCapacityChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_RequestCapacityChange_Params_Data> params(
          message);
  params.Allocate();
  params->capacity_delta = in_capacity_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RequestCapacityChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_RequestCapacityChange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::OpenFile(
    const WTF::String& param_name, ::mojo::PendingReceiver<NativeIOFileHost> param_file_host_receiver, ::base::File* out_param_backing_file, uint64_t* out_param_backing_file_size, NativeIOErrorPtr* out_param_open_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), param_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_host_receiver"), param_file_host_receiver,
                        "<value of type ::mojo::PendingReceiver<NativeIOFileHost>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.OpenFile request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeIOFileHostInterfaceBase>>(
      param_file_host_receiver, &params->file_host_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_host_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_host_receiver in NativeIOHost.OpenFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("OpenFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_OpenFile_HandleSyncResponse(
          &result, out_param_backing_file, out_param_backing_file_size, out_param_open_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::OpenFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backing_file"), out_param_backing_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backing_file_size"), out_param_backing_file_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_error"), out_param_open_error,
                        "<value of type NativeIOErrorPtr>");
   });
#endif
  return result;
}

void NativeIOHostProxy::OpenFile(
    const WTF::String& in_name, ::mojo::PendingReceiver<NativeIOFileHost> in_file_host_receiver, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_host_receiver"), in_file_host_receiver,
                        "<value of type ::mojo::PendingReceiver<NativeIOFileHost>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.OpenFile request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeIOFileHostInterfaceBase>>(
      in_file_host_receiver, &params->file_host_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_host_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_host_receiver in NativeIOHost.OpenFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_OpenFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::DeleteFile(
    const WTF::String& param_name, NativeIOErrorPtr* out_param_delete_error, uint64_t* out_param_granted_capacity_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), param_name,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.DeleteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("DeleteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_DeleteFile_HandleSyncResponse(
          &result, out_param_delete_error, out_param_granted_capacity_delta));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::DeleteFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_error"), out_param_delete_error,
                        "<value of type NativeIOErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_capacity_delta"), out_param_granted_capacity_delta,
                        "<value of type uint64_t>");
   });
#endif
  return result;
}

void NativeIOHostProxy::DeleteFile(
    const WTF::String& in_name, DeleteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.DeleteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("DeleteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_DeleteFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::GetAllFileNames(
    bool* out_param_success, WTF::Vector<WTF::String>* out_param_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "blink::mojom::NativeIOHost::GetAllFileNames");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_GetAllFileNames_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_GetAllFileNames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("GetAllFileNames");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_GetAllFileNames_HandleSyncResponse(
          &result, out_param_success, out_param_names));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::GetAllFileNames", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("names"), out_param_names,
                        "<value of type const WTF::Vector<WTF::String>&>");
   });
#endif
  return result;
}

void NativeIOHostProxy::GetAllFileNames(
    GetAllFileNamesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeIOHost::GetAllFileNames");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_GetAllFileNames_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_GetAllFileNames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("GetAllFileNames");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_GetAllFileNames_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::RenameFile(
    const WTF::String& param_old_name, const WTF::String& param_new_name, NativeIOErrorPtr* out_param_rename_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::RenameFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_name"), param_old_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_name"), param_new_name,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_RenameFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_RenameFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_name)::BaseType> old_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_old_name, old_name_fragment);
  params->old_name.Set(
      old_name_fragment.is_null() ? nullptr : old_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_name in NativeIOHost.RenameFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_name)::BaseType> new_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_new_name, new_name_fragment);
  params->new_name.Set(
      new_name_fragment.is_null() ? nullptr : new_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_name in NativeIOHost.RenameFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RenameFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_RenameFile_HandleSyncResponse(
          &result, out_param_rename_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::RenameFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rename_error"), out_param_rename_error,
                        "<value of type NativeIOErrorPtr>");
   });
#endif
  return result;
}

void NativeIOHostProxy::RenameFile(
    const WTF::String& in_old_name, const WTF::String& in_new_name, RenameFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::RenameFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_name"), in_old_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_name"), in_new_name,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_RenameFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_RenameFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_name)::BaseType> old_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_old_name, old_name_fragment);
  params->old_name.Set(
      old_name_fragment.is_null() ? nullptr : old_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_name in NativeIOHost.RenameFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_name)::BaseType> new_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_new_name, new_name_fragment);
  params->new_name.Set(
      new_name_fragment.is_null() ? nullptr : new_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_name in NativeIOHost.RenameFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RenameFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_RenameFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NativeIOHost_RequestCapacityChange_ProxyToResponder {
 public:
  static NativeIOHost::RequestCapacityChangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_RequestCapacityChange_ProxyToResponder> proxy(
        new NativeIOHost_RequestCapacityChange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_RequestCapacityChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_RequestCapacityChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_RequestCapacityChange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::RequestCapacityChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_granted_capacity_delta);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RequestCapacityChange_ProxyToResponder);
};

bool NativeIOHost_RequestCapacityChange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::RequestCapacityChangeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NativeIOHost_RequestCapacityChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_RequestCapacityChange_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_granted_capacity_delta{};
  NativeIOHost_RequestCapacityChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted_capacity_delta = input_data_view.granted_capacity_delta();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_granted_capacity_delta));
  return true;
}

void NativeIOHost_RequestCapacityChange_ProxyToResponder::Run(
    int64_t in_granted_capacity_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::RequestCapacityChangeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_capacity_delta"), in_granted_capacity_delta,
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_RequestCapacityChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_RequestCapacityChange_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->granted_capacity_delta = in_granted_capacity_delta;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::RequestCapacityChangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RequestCapacityChange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_RequestCapacityChange_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_RequestCapacityChange_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_RequestCapacityChange_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int64_t p_granted_capacity_delta{};
  NativeIOHost_RequestCapacityChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted_capacity_delta = input_data_view.granted_capacity_delta();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 0, true);
    return false;
  }
  *out_granted_capacity_delta_ = std::move(p_granted_capacity_delta);
  *result_ = true;
  return true;
}
class NativeIOHost_OpenFile_ProxyToResponder {
 public:
  static NativeIOHost::OpenFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_OpenFile_ProxyToResponder> proxy(
        new NativeIOHost_OpenFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_OpenFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_backing_file, uint64_t in_backing_file_size, NativeIOErrorPtr in_open_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_OpenFile_ProxyToResponder);
};

bool NativeIOHost_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::OpenFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NativeIOHost_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File p_backing_file{};
  uint64_t p_backing_file_size{};
  NativeIOErrorPtr p_open_error{};
  NativeIOHost_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBackingFile(&p_backing_file))
    success = false;
  if (success)
    p_backing_file_size = input_data_view.backing_file_size();
  if (success && !input_data_view.ReadOpenError(&p_open_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_backing_file), 
std::move(p_backing_file_size), 
std::move(p_open_error));
  return true;
}

void NativeIOHost_OpenFile_ProxyToResponder::Run(
    ::base::File in_backing_file, uint64_t in_backing_file_size, NativeIOErrorPtr in_open_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::OpenFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backing_file"), in_backing_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backing_file_size"), in_backing_file_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_error"), in_open_error,
                        "<value of type NativeIOErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_OpenFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->backing_file)::BaseType> backing_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_backing_file, backing_file_fragment);
  params->backing_file.Set(
      backing_file_fragment.is_null() ? nullptr : backing_file_fragment.data());
  params->backing_file_size = in_backing_file_size;
  mojo::internal::MessageFragment<
      typename decltype(params->open_error)::BaseType> open_error_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::NativeIOErrorDataView>(
      in_open_error, open_error_fragment);
  params->open_error.Set(
      open_error_fragment.is_null() ? nullptr : open_error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->open_error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null open_error in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::OpenFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_OpenFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_OpenFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File p_backing_file{};
  uint64_t p_backing_file_size{};
  NativeIOErrorPtr p_open_error{};
  NativeIOHost_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBackingFile(&p_backing_file))
    success = false;
  if (success)
    p_backing_file_size = input_data_view.backing_file_size();
  if (success && !input_data_view.ReadOpenError(&p_open_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 1, true);
    return false;
  }
  *out_backing_file_ = std::move(p_backing_file);
  *out_backing_file_size_ = std::move(p_backing_file_size);
  *out_open_error_ = std::move(p_open_error);
  *result_ = true;
  return true;
}
class NativeIOHost_DeleteFile_ProxyToResponder {
 public:
  static NativeIOHost::DeleteFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_DeleteFile_ProxyToResponder> proxy(
        new NativeIOHost_DeleteFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_DeleteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_DeleteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_DeleteFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::DeleteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      NativeIOErrorPtr in_delete_error, uint64_t in_granted_capacity_delta);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_DeleteFile_ProxyToResponder);
};

bool NativeIOHost_DeleteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::DeleteFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NativeIOHost_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_DeleteFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NativeIOErrorPtr p_delete_error{};
  uint64_t p_granted_capacity_delta{};
  NativeIOHost_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeleteError(&p_delete_error))
    success = false;
  if (success)
    p_granted_capacity_delta = input_data_view.granted_capacity_delta();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_delete_error), 
std::move(p_granted_capacity_delta));
  return true;
}

void NativeIOHost_DeleteFile_ProxyToResponder::Run(
    NativeIOErrorPtr in_delete_error, uint64_t in_granted_capacity_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::DeleteFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_error"), in_delete_error,
                        "<value of type NativeIOErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_capacity_delta"), in_granted_capacity_delta,
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_DeleteFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delete_error)::BaseType> delete_error_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::NativeIOErrorDataView>(
      in_delete_error, delete_error_fragment);
  params->delete_error.Set(
      delete_error_fragment.is_null() ? nullptr : delete_error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->delete_error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null delete_error in ");
  params->granted_capacity_delta = in_granted_capacity_delta;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::DeleteFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("DeleteFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_DeleteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_DeleteFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  NativeIOErrorPtr p_delete_error{};
  uint64_t p_granted_capacity_delta{};
  NativeIOHost_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeleteError(&p_delete_error))
    success = false;
  if (success)
    p_granted_capacity_delta = input_data_view.granted_capacity_delta();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 2, true);
    return false;
  }
  *out_delete_error_ = std::move(p_delete_error);
  *out_granted_capacity_delta_ = std::move(p_granted_capacity_delta);
  *result_ = true;
  return true;
}
class NativeIOHost_GetAllFileNames_ProxyToResponder {
 public:
  static NativeIOHost::GetAllFileNamesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_GetAllFileNames_ProxyToResponder> proxy(
        new NativeIOHost_GetAllFileNames_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_GetAllFileNames_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_GetAllFileNames_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_GetAllFileNames_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::GetAllFileNamesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const WTF::Vector<WTF::String>& in_names);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_GetAllFileNames_ProxyToResponder);
};

bool NativeIOHost_GetAllFileNames_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::GetAllFileNamesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NativeIOHost_GetAllFileNames_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_GetAllFileNames_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  WTF::Vector<WTF::String> p_names{};
  NativeIOHost_GetAllFileNames_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadNames(&p_names))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_names));
  return true;
}

void NativeIOHost_GetAllFileNames_ProxyToResponder::Run(
    bool in_success, const WTF::Vector<WTF::String>& in_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::GetAllFileNamesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("names"), in_names,
                        "<value of type const WTF::Vector<WTF::String>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_GetAllFileNames_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_GetAllFileNames_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->names)::BaseType>
      names_fragment(params.message());
  const mojo::internal::ContainerValidateParams names_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_names, names_fragment, &names_validate_params);
  params->names.Set(
      names_fragment.is_null() ? nullptr : names_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->names.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null names in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::GetAllFileNamesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("GetAllFileNames");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_GetAllFileNames_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_GetAllFileNames_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_GetAllFileNames_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  WTF::Vector<WTF::String> p_names{};
  NativeIOHost_GetAllFileNames_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadNames(&p_names))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 3, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_names_ = std::move(p_names);
  *result_ = true;
  return true;
}
class NativeIOHost_RenameFile_ProxyToResponder {
 public:
  static NativeIOHost::RenameFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_RenameFile_ProxyToResponder> proxy(
        new NativeIOHost_RenameFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_RenameFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_RenameFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_RenameFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::RenameFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      NativeIOErrorPtr in_rename_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RenameFile_ProxyToResponder);
};

bool NativeIOHost_RenameFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::RenameFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NativeIOHost_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_RenameFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NativeIOErrorPtr p_rename_error{};
  NativeIOHost_RenameFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRenameError(&p_rename_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_rename_error));
  return true;
}

void NativeIOHost_RenameFile_ProxyToResponder::Run(
    NativeIOErrorPtr in_rename_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::RenameFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rename_error"), in_rename_error,
                        "<value of type NativeIOErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNativeIOHost_RenameFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NativeIOHost_RenameFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rename_error)::BaseType> rename_error_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::NativeIOErrorDataView>(
      in_rename_error, rename_error_fragment);
  params->rename_error.Set(
      rename_error_fragment.is_null() ? nullptr : rename_error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rename_error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rename_error in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::RenameFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RenameFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_RenameFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_RenameFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  NativeIOErrorPtr p_rename_error{};
  NativeIOHost_RenameFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRenameError(&p_rename_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 4, true);
    return false;
  }
  *out_rename_error_ = std::move(p_rename_error);
  *result_ = true;
  return true;
}

// static
bool NativeIOHostStubDispatch::Accept(
    NativeIOHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNativeIOHost_RequestCapacityChange_Name: {
      break;
    }
    case internal::kNativeIOHost_OpenFile_Name: {
      break;
    }
    case internal::kNativeIOHost_DeleteFile_Name: {
      break;
    }
    case internal::kNativeIOHost_GetAllFileNames_Name: {
      break;
    }
    case internal::kNativeIOHost_RenameFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool NativeIOHostStubDispatch::AcceptWithResponder(
    NativeIOHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeIOHost_RequestCapacityChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::RequestCapacityChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::RequestCapacityChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_RequestCapacityChange_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_RequestCapacityChange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_capacity_delta{};
      NativeIOHost_RequestCapacityChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_capacity_delta = input_data_view.capacity_delta();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 0, false);
        return false;
      }
      NativeIOHost::RequestCapacityChangeCallback callback =
          NativeIOHost_RequestCapacityChange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCapacityChange(
std::move(p_capacity_delta), std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_OpenFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::OpenFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::OpenFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_OpenFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_name{};
      ::mojo::PendingReceiver<NativeIOFileHost> p_file_host_receiver{};
      NativeIOHost_OpenFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_file_host_receiver =
            input_data_view.TakeFileHostReceiver<decltype(p_file_host_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 1, false);
        return false;
      }
      NativeIOHost::OpenFileCallback callback =
          NativeIOHost_OpenFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(
std::move(p_name), 
std::move(p_file_host_receiver), std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_DeleteFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::DeleteFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::DeleteFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_DeleteFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_DeleteFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_name{};
      NativeIOHost_DeleteFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 2, false);
        return false;
      }
      NativeIOHost::DeleteFileCallback callback =
          NativeIOHost_DeleteFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteFile(
std::move(p_name), std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_GetAllFileNames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::GetAllFileNames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::GetAllFileNames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_GetAllFileNames_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_GetAllFileNames_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeIOHost_GetAllFileNames_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 3, false);
        return false;
      }
      NativeIOHost::GetAllFileNamesCallback callback =
          NativeIOHost_GetAllFileNames_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllFileNames(std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_RenameFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::RenameFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::RenameFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_RenameFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_RenameFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_old_name{};
      WTF::String p_new_name{};
      NativeIOHost_RenameFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldName(&p_old_name))
        success = false;
      if (success && !input_data_view.ReadNewName(&p_new_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 4, false);
        return false;
      }
      NativeIOHost::RenameFileCallback callback =
          NativeIOHost_RenameFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameFile(
std::move(p_old_name), 
std::move(p_new_name), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeIOHostValidationInfo[] = {
    {&internal::NativeIOHost_RequestCapacityChange_Params_Data::Validate,
     &internal::NativeIOHost_RequestCapacityChange_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_OpenFile_Params_Data::Validate,
     &internal::NativeIOHost_OpenFile_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_DeleteFile_Params_Data::Validate,
     &internal::NativeIOHost_DeleteFile_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_GetAllFileNames_Params_Data::Validate,
     &internal::NativeIOHost_GetAllFileNames_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_RenameFile_Params_Data::Validate,
     &internal::NativeIOHost_RenameFile_ResponseParams_Data::Validate},
};

bool NativeIOHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeIOHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeIOHostValidationInfo);
}

bool NativeIOHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeIOHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeIOHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::NativeIOError::DataView, ::blink::mojom::blink::NativeIOErrorPtr>::Read(
    ::blink::mojom::blink::NativeIOError::DataView input,
    ::blink::mojom::blink::NativeIOErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::NativeIOErrorPtr result(::blink::mojom::blink::NativeIOError::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif