// third_party/blink/public/mojom/notifications/notification.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/notifications/notification.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/notifications/notification.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* NotificationDirectionToStringHelper(NotificationDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NotificationDirection::LEFT_TO_RIGHT:
      return "LEFT_TO_RIGHT";
    case NotificationDirection::RIGHT_TO_LEFT:
      return "RIGHT_TO_LEFT";
    case NotificationDirection::AUTO:
      return "AUTO";
    default:
      return nullptr;
  }
}

std::string NotificationDirectionToString(NotificationDirection value) {
  const char *str = NotificationDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NotificationDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NotificationDirection value) {
  return os << NotificationDirectionToString(value);
}

static NOINLINE const char* NotificationActionTypeToStringHelper(NotificationActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NotificationActionType::BUTTON:
      return "BUTTON";
    case NotificationActionType::TEXT:
      return "TEXT";
    default:
      return nullptr;
  }
}

std::string NotificationActionTypeToString(NotificationActionType value) {
  const char *str = NotificationActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NotificationActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NotificationActionType value) {
  return os << NotificationActionTypeToString(value);
}

namespace internal {


// static
bool NotificationAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NotificationAction_Data* object = static_cast<const NotificationAction_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::NotificationActionType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams action_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->action, validation_context,
                                         &action_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->placeholder, validation_context))
    return false;

  return true;
}

NotificationAction_Data::NotificationAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotificationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NotificationData_Data* object = static_cast<const NotificationData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;


  if (!::blink::mojom::internal::NotificationDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams lang_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->lang, validation_context,
                                         &lang_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->body, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tag, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams tag_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->tag, validation_context,
                                         &tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->badge, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->badge, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams vibration_pattern_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->vibration_pattern, validation_context,
                                         &vibration_pattern_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams actions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->actions, validation_context,
                                         &actions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->show_trigger_timestamp, validation_context))
    return false;

  return true;
}

NotificationData_Data::NotificationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotificationResources_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NotificationResources_Data* object = static_cast<const NotificationResources_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->badge, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams action_icons_validate_params(
      0, true, nullptr);
  if (!mojo::internal::ValidateContainer(object->action_icons, validation_context,
                                         &action_icons_validate_params)) {
    return false;
  }

  return true;
}

NotificationResources_Data::NotificationResources_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NotificationDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::NotificationDirection value) {
  return std::move(context).WriteString(::blink::mojom::NotificationDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NotificationActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::NotificationActionType value) {
  return std::move(context).WriteString(::blink::mojom::NotificationActionTypeToString(value));
}

} // namespace perfetto
