// third_party/blink/public/mojom/page/display_cutout.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/display_cutout.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/display_cutout.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/display_cutout.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/display_cutout.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DISPLAY_CUTOUT_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DISPLAY_CUTOUT_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
DisplayCutoutSafeArea::DisplayCutoutSafeArea()
    : top(),
      left(),
      bottom(),
      right() {}

DisplayCutoutSafeArea::DisplayCutoutSafeArea(
    int32_t top_in,
    int32_t left_in,
    int32_t bottom_in,
    int32_t right_in)
    : top(std::move(top_in)),
      left(std::move(left_in)),
      bottom(std::move(bottom_in)),
      right(std::move(right_in)) {}

DisplayCutoutSafeArea::~DisplayCutoutSafeArea() = default;
size_t DisplayCutoutSafeArea::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->top);
  seed = mojo::internal::WTFHash(seed, this->left);
  seed = mojo::internal::WTFHash(seed, this->bottom);
  seed = mojo::internal::WTFHash(seed, this->right);
  return seed;
}

void DisplayCutoutSafeArea::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top"), this->top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left"), this->left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom"), this->bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right"), this->right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplayCutoutSafeArea::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DisplayCutoutHost::Name_[] = "blink.mojom.DisplayCutoutHost";

DisplayCutoutHostProxy::DisplayCutoutHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayCutoutHostProxy::NotifyViewportFitChanged(
    ViewportFit in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ViewportFit>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDisplayCutoutHost_NotifyViewportFitChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ViewportFit>(
      in_value, &params->value);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayCutoutHost::Name_);
  message.set_method_name("NotifyViewportFitChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DisplayCutoutHostStubDispatch::Accept(
    DisplayCutoutHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDisplayCutoutHost_NotifyViewportFitChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data* params =
          reinterpret_cast<internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ViewportFit p_value{};
      DisplayCutoutHost_NotifyViewportFitChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayCutoutHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyViewportFitChanged(
std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool DisplayCutoutHostStubDispatch::AcceptWithResponder(
    DisplayCutoutHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDisplayCutoutHost_NotifyViewportFitChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDisplayCutoutHostValidationInfo[] = {
    {&internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool DisplayCutoutHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DisplayCutoutHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDisplayCutoutHostValidationInfo);
}

const char DisplayCutoutClient::Name_[] = "blink.mojom.DisplayCutoutClient";

DisplayCutoutClientProxy::DisplayCutoutClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayCutoutClientProxy::SetSafeArea(
    DisplayCutoutSafeAreaPtr in_safe_area) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DisplayCutoutClient::SetSafeArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("safe_area"), in_safe_area,
                        "<value of type DisplayCutoutSafeAreaPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDisplayCutoutClient_SetSafeArea_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DisplayCutoutClient_SetSafeArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->safe_area)::BaseType> safe_area_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DisplayCutoutSafeAreaDataView>(
      in_safe_area, safe_area_fragment);
  params->safe_area.Set(
      safe_area_fragment.is_null() ? nullptr : safe_area_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->safe_area.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null safe_area in DisplayCutoutClient.SetSafeArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayCutoutClient::Name_);
  message.set_method_name("SetSafeArea");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DisplayCutoutClientStubDispatch::Accept(
    DisplayCutoutClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDisplayCutoutClient_SetSafeArea_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DisplayCutoutClient::SetSafeArea",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DisplayCutoutClient::SetSafeArea");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayCutoutClient_SetSafeArea_Params_Data* params =
          reinterpret_cast<internal::DisplayCutoutClient_SetSafeArea_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DisplayCutoutSafeAreaPtr p_safe_area{};
      DisplayCutoutClient_SetSafeArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSafeArea(&p_safe_area))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayCutoutClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSafeArea(
std::move(p_safe_area));
      return true;
    }
  }
  return false;
}

// static
bool DisplayCutoutClientStubDispatch::AcceptWithResponder(
    DisplayCutoutClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDisplayCutoutClient_SetSafeArea_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDisplayCutoutClientValidationInfo[] = {
    {&internal::DisplayCutoutClient_SetSafeArea_Params_Data::Validate,
     nullptr /* no response */},
};

bool DisplayCutoutClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DisplayCutoutClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDisplayCutoutClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::DisplayCutoutSafeArea::DataView, ::blink::mojom::blink::DisplayCutoutSafeAreaPtr>::Read(
    ::blink::mojom::blink::DisplayCutoutSafeArea::DataView input,
    ::blink::mojom::blink::DisplayCutoutSafeAreaPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DisplayCutoutSafeAreaPtr result(::blink::mojom::blink::DisplayCutoutSafeArea::New());
  
      if (success)
        result->top = input.top();
      if (success)
        result->left = input.left();
      if (success)
        result->bottom = input.bottom();
      if (success)
        result->right = input.right();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif