// third_party/blink/public/mojom/page/drag.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/page/drag.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/drag.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool DragItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DragItem_Data* object = static_cast<const DragItem_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DragItem_Tag::STRING: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_string, validation_context))
        return false;
      return true;
    }
    case DragItem_Tag::FILE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file, validation_context))
        return false;
      return true;
    }
    case DragItem_Tag::BINARY: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_binary, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_binary, validation_context))
        return false;
      return true;
    }
    case DragItem_Tag::FILE_SYSTEM_FILE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file_system_file, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file_system_file, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DragItem");
      return false;
    }
  }
}


// static
bool AllowedDragOperations_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AllowedDragOperations_Data* object = static_cast<const AllowedDragOperations_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

AllowedDragOperations_Data::AllowedDragOperations_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DragItemString_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DragItemString_Data* object = static_cast<const DragItemString_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->string_type, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams string_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->string_type, validation_context,
                                         &string_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->string_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->string_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->base_url, validation_context))
    return false;

  return true;
}

DragItemString_Data::DragItemString_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DragItemBinary_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DragItemBinary_Data* object = static_cast<const DragItemBinary_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filename_extension, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filename_extension, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams content_disposition_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->content_disposition, validation_context,
                                         &content_disposition_validate_params)) {
    return false;
  }

  return true;
}

DragItemBinary_Data::DragItemBinary_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DragItemFileSystemFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DragItemFileSystemFile_Data* object = static_cast<const DragItemFileSystemFile_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams file_system_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_system_id, validation_context,
                                         &file_system_id_validate_params)) {
    return false;
  }

  return true;
}

DragItemFileSystemFile_Data::DragItemFileSystemFile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DragData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DragData_Data* object = static_cast<const DragData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams items_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams file_system_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_system_id, validation_context,
                                         &file_system_id_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  return true;
}

DragData_Data::DragData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DragEventSourceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DragEventSourceInfo_Data* object = static_cast<const DragEventSourceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::ui::mojom::internal::DragEventSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

DragEventSourceInfo_Data::DragEventSourceInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
