// third_party/blink/public/mojom/payments/payment_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-params-data.h"
namespace payments {
namespace mojom {

static NOINLINE const char* PaymentErrorReasonToStringHelper(PaymentErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentErrorReason::UNKNOWN:
      return "UNKNOWN";
    case PaymentErrorReason::USER_CANCEL:
      return "USER_CANCEL";
    case PaymentErrorReason::NOT_SUPPORTED:
      return "NOT_SUPPORTED";
    case PaymentErrorReason::NOT_SUPPORTED_FOR_INVALID_ORIGIN_OR_SSL:
      return "NOT_SUPPORTED_FOR_INVALID_ORIGIN_OR_SSL";
    case PaymentErrorReason::ALREADY_SHOWING:
      return "ALREADY_SHOWING";
    case PaymentErrorReason::INVALID_DATA_FROM_RENDERER:
      return "INVALID_DATA_FROM_RENDERER";
    case PaymentErrorReason::NOT_ALLOWED_ERROR:
      return "NOT_ALLOWED_ERROR";
    default:
      return nullptr;
  }
}

std::string PaymentErrorReasonToString(PaymentErrorReason value) {
  const char *str = PaymentErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentErrorReason value) {
  return os << PaymentErrorReasonToString(value);
}

static NOINLINE const char* CanMakePaymentQueryResultToStringHelper(CanMakePaymentQueryResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CanMakePaymentQueryResult::CAN_MAKE_PAYMENT:
      return "CAN_MAKE_PAYMENT";
    case CanMakePaymentQueryResult::CANNOT_MAKE_PAYMENT:
      return "CANNOT_MAKE_PAYMENT";
    default:
      return nullptr;
  }
}

std::string CanMakePaymentQueryResultToString(CanMakePaymentQueryResult value) {
  const char *str = CanMakePaymentQueryResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CanMakePaymentQueryResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CanMakePaymentQueryResult value) {
  return os << CanMakePaymentQueryResultToString(value);
}

static NOINLINE const char* HasEnrolledInstrumentQueryResultToStringHelper(HasEnrolledInstrumentQueryResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HasEnrolledInstrumentQueryResult::HAS_ENROLLED_INSTRUMENT:
      return "HAS_ENROLLED_INSTRUMENT";
    case HasEnrolledInstrumentQueryResult::HAS_NO_ENROLLED_INSTRUMENT:
      return "HAS_NO_ENROLLED_INSTRUMENT";
    case HasEnrolledInstrumentQueryResult::QUERY_QUOTA_EXCEEDED:
      return "QUERY_QUOTA_EXCEEDED";
    case HasEnrolledInstrumentQueryResult::WARNING_HAS_ENROLLED_INSTRUMENT:
      return "WARNING_HAS_ENROLLED_INSTRUMENT";
    case HasEnrolledInstrumentQueryResult::WARNING_HAS_NO_ENROLLED_INSTRUMENT:
      return "WARNING_HAS_NO_ENROLLED_INSTRUMENT";
    default:
      return nullptr;
  }
}

std::string HasEnrolledInstrumentQueryResultToString(HasEnrolledInstrumentQueryResult value) {
  const char *str = HasEnrolledInstrumentQueryResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HasEnrolledInstrumentQueryResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HasEnrolledInstrumentQueryResult value) {
  return os << HasEnrolledInstrumentQueryResultToString(value);
}

static NOINLINE const char* AndroidPayEnvironmentToStringHelper(AndroidPayEnvironment value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AndroidPayEnvironment::PRODUCTION:
      return "PRODUCTION";
    case AndroidPayEnvironment::TEST:
      return "TEST";
    default:
      return nullptr;
  }
}

std::string AndroidPayEnvironmentToString(AndroidPayEnvironment value) {
  const char *str = AndroidPayEnvironmentToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AndroidPayEnvironment value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AndroidPayEnvironment value) {
  return os << AndroidPayEnvironmentToString(value);
}

static NOINLINE const char* BasicCardNetworkToStringHelper(BasicCardNetwork value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BasicCardNetwork::AMEX:
      return "AMEX";
    case BasicCardNetwork::DINERS:
      return "DINERS";
    case BasicCardNetwork::DISCOVER:
      return "DISCOVER";
    case BasicCardNetwork::JCB:
      return "JCB";
    case BasicCardNetwork::MASTERCARD:
      return "MASTERCARD";
    case BasicCardNetwork::MIR:
      return "MIR";
    case BasicCardNetwork::UNIONPAY:
      return "UNIONPAY";
    case BasicCardNetwork::VISA:
      return "VISA";
    default:
      return nullptr;
  }
}

std::string BasicCardNetworkToString(BasicCardNetwork value) {
  const char *str = BasicCardNetworkToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BasicCardNetwork value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BasicCardNetwork value) {
  return os << BasicCardNetworkToString(value);
}

static NOINLINE const char* PaymentShippingTypeToStringHelper(PaymentShippingType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentShippingType::SHIPPING:
      return "SHIPPING";
    case PaymentShippingType::DELIVERY:
      return "DELIVERY";
    case PaymentShippingType::PICKUP:
      return "PICKUP";
    default:
      return nullptr;
  }
}

std::string PaymentShippingTypeToString(PaymentShippingType value) {
  const char *str = PaymentShippingTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentShippingType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentShippingType value) {
  return os << PaymentShippingTypeToString(value);
}

static NOINLINE const char* PaymentCompleteToStringHelper(PaymentComplete value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentComplete::FAIL:
      return "FAIL";
    case PaymentComplete::SUCCESS:
      return "SUCCESS";
    case PaymentComplete::UNKNOWN:
      return "UNKNOWN";
    default:
      return nullptr;
  }
}

std::string PaymentCompleteToString(PaymentComplete value) {
  const char *str = PaymentCompleteToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentComplete value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentComplete value) {
  return os << PaymentCompleteToString(value);
}

namespace internal {


// static
bool PaymentResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentResponse_Data* object = static_cast<const PaymentResponse_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method_name, validation_context,
                                         &method_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stringified_details, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stringified_details_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stringified_details, validation_context,
                                         &stringified_details_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->shipping_address, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams shipping_option_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shipping_option, validation_context,
                                         &shipping_option_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->payer, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->payer, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->secure_payment_confirmation, validation_context))
    return false;

  return true;
}

PaymentResponse_Data::PaymentResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SecurePaymentConfirmationResponse_Data* object = static_cast<const SecurePaymentConfirmationResponse_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->credential_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams user_handle_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_handle, validation_context,
                                         &user_handle_validate_params)) {
    return false;
  }

  return true;
}

SecurePaymentConfirmationResponse_Data::SecurePaymentConfirmationResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PayerDetail_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PayerDetail_Data* object = static_cast<const PayerDetail_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams email_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->email, validation_context,
                                         &email_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams phone_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->phone, validation_context,
                                         &phone_validate_params)) {
    return false;
  }

  return true;
}

PayerDetail_Data::PayerDetail_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentItem_Data* object = static_cast<const PaymentItem_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->amount, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->amount, validation_context))
    return false;

  return true;
}

PaymentItem_Data::PaymentItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentShippingOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentShippingOption_Data* object = static_cast<const PaymentShippingOption_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->amount, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->amount, validation_context))
    return false;

  return true;
}

PaymentShippingOption_Data::PaymentShippingOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GooglePaymentMethodData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GooglePaymentMethodData_Data* object = static_cast<const GooglePaymentMethodData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stringified_data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stringified_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stringified_data, validation_context,
                                         &stringified_data_validate_params)) {
    return false;
  }

  return true;
}

GooglePaymentMethodData_Data::GooglePaymentMethodData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SecurePaymentConfirmationRequest_Data* object = static_cast<const SecurePaymentConfirmationRequest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams credential_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->credential_ids, validation_context,
                                         &credential_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenge, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams challenge_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->challenge, validation_context,
                                         &challenge_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  return true;
}

SecurePaymentConfirmationRequest_Data::SecurePaymentConfirmationRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentMethodData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentMethodData_Data* object = static_cast<const PaymentMethodData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_method, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams supported_method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->supported_method, validation_context,
                                         &supported_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stringified_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stringified_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stringified_data, validation_context,
                                         &stringified_data_validate_params)) {
    return false;
  }


  if (!::payments::mojom::internal::AndroidPayEnvironment_Data
        ::Validate(object->environment, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_networks, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams supported_networks_validate_params(
      0, ::payments::mojom::internal::BasicCardNetwork_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->supported_networks, validation_context,
                                         &supported_networks_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->secure_payment_confirmation, validation_context))
    return false;

  return true;
}

PaymentMethodData_Data::PaymentMethodData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentDetailsModifier_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentDetailsModifier_Data* object = static_cast<const PaymentDetailsModifier_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->total, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_display_items, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_display_items_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->additional_display_items, validation_context,
                                         &additional_display_items_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->method_data, validation_context))
    return false;

  return true;
}

PaymentDetailsModifier_Data::PaymentDetailsModifier_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentDetails_Data* object = static_cast<const PaymentDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->total, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams display_items_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->display_items, validation_context,
                                         &display_items_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams shipping_options_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shipping_options, validation_context,
                                         &shipping_options_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams modifiers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->modifiers, validation_context,
                                         &modifiers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->shipping_address_errors, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams stringified_payment_method_errors_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stringified_payment_method_errors, validation_context,
                                         &stringified_payment_method_errors_validate_params)) {
    return false;
  }

  return true;
}

PaymentDetails_Data::PaymentDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentOptions_Data* object = static_cast<const PaymentOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::PaymentShippingType_Data
        ::Validate(object->shipping_type, validation_context))
    return false;

  return true;
}

PaymentOptions_Data::PaymentOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnPaymentMethodChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnPaymentMethodChange_Params_Data* object = static_cast<const PaymentRequestClient_OnPaymentMethodChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method_name, validation_context,
                                         &method_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stringified_details, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stringified_details_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stringified_details, validation_context,
                                         &stringified_details_validate_params)) {
    return false;
  }

  return true;
}

PaymentRequestClient_OnPaymentMethodChange_Params_Data::PaymentRequestClient_OnPaymentMethodChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnShippingAddressChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnShippingAddressChange_Params_Data* object = static_cast<const PaymentRequestClient_OnShippingAddressChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->address, validation_context))
    return false;

  return true;
}

PaymentRequestClient_OnShippingAddressChange_Params_Data::PaymentRequestClient_OnShippingAddressChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnShippingOptionChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnShippingOptionChange_Params_Data* object = static_cast<const PaymentRequestClient_OnShippingOptionChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shipping_option_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams shipping_option_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shipping_option_id, validation_context,
                                         &shipping_option_id_validate_params)) {
    return false;
  }

  return true;
}

PaymentRequestClient_OnShippingOptionChange_Params_Data::PaymentRequestClient_OnShippingOptionChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnPayerDetailChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnPayerDetailChange_Params_Data* object = static_cast<const PaymentRequestClient_OnPayerDetailChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->detail, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->detail, validation_context))
    return false;

  return true;
}

PaymentRequestClient_OnPayerDetailChange_Params_Data::PaymentRequestClient_OnPayerDetailChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnPaymentResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnPaymentResponse_Params_Data* object = static_cast<const PaymentRequestClient_OnPaymentResponse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaymentRequestClient_OnPaymentResponse_Params_Data::PaymentRequestClient_OnPaymentResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnError_Params_Data* object = static_cast<const PaymentRequestClient_OnError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::PaymentErrorReason_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

PaymentRequestClient_OnError_Params_Data::PaymentRequestClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnComplete_Params_Data* object = static_cast<const PaymentRequestClient_OnComplete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequestClient_OnComplete_Params_Data::PaymentRequestClient_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnAbort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnAbort_Params_Data* object = static_cast<const PaymentRequestClient_OnAbort_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequestClient_OnAbort_Params_Data::PaymentRequestClient_OnAbort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnCanMakePayment_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnCanMakePayment_Params_Data* object = static_cast<const PaymentRequestClient_OnCanMakePayment_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::CanMakePaymentQueryResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

PaymentRequestClient_OnCanMakePayment_Params_Data::PaymentRequestClient_OnCanMakePayment_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_OnHasEnrolledInstrument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_OnHasEnrolledInstrument_Params_Data* object = static_cast<const PaymentRequestClient_OnHasEnrolledInstrument_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::HasEnrolledInstrumentQueryResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

PaymentRequestClient_OnHasEnrolledInstrument_Params_Data::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestClient_WarnNoFavicon_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequestClient_WarnNoFavicon_Params_Data* object = static_cast<const PaymentRequestClient_WarnNoFavicon_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequestClient_WarnNoFavicon_Params_Data::PaymentRequestClient_WarnNoFavicon_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_Init_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_Init_Params_Data* object = static_cast<const PaymentRequest_Init_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method_data, validation_context,
                                         &method_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

PaymentRequest_Init_Params_Data::PaymentRequest_Init_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_Show_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_Show_Params_Data* object = static_cast<const PaymentRequest_Show_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequest_Show_Params_Data::PaymentRequest_Show_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_UpdateWith_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_UpdateWith_Params_Data* object = static_cast<const PaymentRequest_UpdateWith_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

PaymentRequest_UpdateWith_Params_Data::PaymentRequest_UpdateWith_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data* object = static_cast<const PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_Abort_Params_Data* object = static_cast<const PaymentRequest_Abort_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequest_Abort_Params_Data::PaymentRequest_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_Complete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_Complete_Params_Data* object = static_cast<const PaymentRequest_Complete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::PaymentComplete_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

PaymentRequest_Complete_Params_Data::PaymentRequest_Complete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_Retry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_Retry_Params_Data* object = static_cast<const PaymentRequest_Retry_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->errors, validation_context))
    return false;

  return true;
}

PaymentRequest_Retry_Params_Data::PaymentRequest_Retry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_CanMakePayment_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_CanMakePayment_Params_Data* object = static_cast<const PaymentRequest_CanMakePayment_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequest_CanMakePayment_Params_Data::PaymentRequest_CanMakePayment_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequest_HasEnrolledInstrument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentRequest_HasEnrolledInstrument_Params_Data* object = static_cast<const PaymentRequest_HasEnrolledInstrument_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PaymentRequest_HasEnrolledInstrument_Params_Data::PaymentRequest_HasEnrolledInstrument_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentErrorReason value) {
  return std::move(context).WriteString(::payments::mojom::PaymentErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::CanMakePaymentQueryResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::CanMakePaymentQueryResult value) {
  return std::move(context).WriteString(::payments::mojom::CanMakePaymentQueryResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::HasEnrolledInstrumentQueryResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::HasEnrolledInstrumentQueryResult value) {
  return std::move(context).WriteString(::payments::mojom::HasEnrolledInstrumentQueryResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::AndroidPayEnvironment>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::AndroidPayEnvironment value) {
  return std::move(context).WriteString(::payments::mojom::AndroidPayEnvironmentToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::BasicCardNetwork>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::BasicCardNetwork value) {
  return std::move(context).WriteString(::payments::mojom::BasicCardNetworkToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentShippingType>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentShippingType value) {
  return std::move(context).WriteString(::payments::mojom::PaymentShippingTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentComplete>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentComplete value) {
  return std::move(context).WriteString(::payments::mojom::PaymentCompleteToString(value));
}

} // namespace perfetto
