// third_party/blink/public/mojom/service_worker/service_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_JUMBO_H_
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#include "third_party/blink/public/common/messaging/transferable_message_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
ExtendableMessageEvent::ExtendableMessageEvent()
    : message(),
      source_origin(),
      source_info_for_client(),
      source_info_for_service_worker() {}

ExtendableMessageEvent::ExtendableMessageEvent(
    ::blink::TransferableMessage message_in,
    const ::url::Origin& source_origin_in,
    ::blink::mojom::ServiceWorkerClientInfoPtr source_info_for_client_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr source_info_for_service_worker_in)
    : message(std::move(message_in)),
      source_origin(std::move(source_origin_in)),
      source_info_for_client(std::move(source_info_for_client_in)),
      source_info_for_service_worker(std::move(source_info_for_service_worker_in)) {}

ExtendableMessageEvent::~ExtendableMessageEvent() = default;

void ExtendableMessageEvent::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::TransferableMessage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_origin"), this->source_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_info_for_client"), this->source_info_for_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerClientInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_info_for_service_worker"), this->source_info_for_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtendableMessageEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerHost::Name_[] = "blink.mojom.ServiceWorkerHost";

class ServiceWorkerHost_GetClients_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_GetClients_ForwardToCallback(
      ServiceWorkerHost::GetClientsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::GetClientsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_GetClients_ForwardToCallback);
};

class ServiceWorkerHost_GetClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_GetClient_ForwardToCallback(
      ServiceWorkerHost::GetClientCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::GetClientCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_GetClient_ForwardToCallback);
};

class ServiceWorkerHost_OpenNewTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_OpenNewTab_ForwardToCallback(
      ServiceWorkerHost::OpenNewTabCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::OpenNewTabCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_OpenNewTab_ForwardToCallback);
};

class ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback(
      ServiceWorkerHost::OpenPaymentHandlerWindowCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::OpenPaymentHandlerWindowCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback);
};

class ServiceWorkerHost_FocusClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_FocusClient_ForwardToCallback(
      ServiceWorkerHost::FocusClientCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::FocusClientCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_FocusClient_ForwardToCallback);
};

class ServiceWorkerHost_NavigateClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_NavigateClient_ForwardToCallback(
      ServiceWorkerHost::NavigateClientCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::NavigateClientCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_NavigateClient_ForwardToCallback);
};

class ServiceWorkerHost_SkipWaiting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_SkipWaiting_ForwardToCallback(
      ServiceWorkerHost::SkipWaitingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::SkipWaitingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_SkipWaiting_ForwardToCallback);
};

class ServiceWorkerHost_ClaimClients_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_ClaimClients_ForwardToCallback(
      ServiceWorkerHost::ClaimClientsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::ClaimClientsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_ClaimClients_ForwardToCallback);
};

ServiceWorkerHostProxy::ServiceWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerHostProxy::SetCachedMetadata(
    const ::GURL& in_url, ::base::span<const ::uint8_t> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::SetCachedMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_SetCachedMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_SetCachedMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerHost.SetCachedMetadata request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ServiceWorkerHost.SetCachedMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("SetCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerHostProxy::ClearCachedMetadata(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::ClearCachedMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_ClearCachedMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerHost.ClearCachedMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("ClearCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerHostProxy::GetClients(
    ::blink::mojom::ServiceWorkerClientQueryOptionsPtr in_options, GetClientsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::GetClients", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::ServiceWorkerClientQueryOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_GetClients_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClients_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientQueryOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in ServiceWorkerHost.GetClients request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClients");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_GetClients_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::GetClient(
    const std::string& in_client_uuid, GetClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::GetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_GetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_client_uuid, client_uuid_fragment);
  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_uuid in ServiceWorkerHost.GetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_GetClient_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::OpenNewTab(
    const ::GURL& in_url, OpenNewTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::OpenNewTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_OpenNewTab_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenNewTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerHost.OpenNewTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenNewTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_OpenNewTab_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::OpenPaymentHandlerWindow(
    const ::GURL& in_url, OpenPaymentHandlerWindowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_OpenPaymentHandlerWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerHost.OpenPaymentHandlerWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenPaymentHandlerWindow");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::PostMessageToClient(
    const std::string& in_client_uuid, ::blink::TransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::PostMessageToClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::TransferableMessage>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_PostMessageToClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_PostMessageToClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_client_uuid, client_uuid_fragment);
  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_uuid in ServiceWorkerHost.PostMessageToClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ServiceWorkerHost.PostMessageToClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("PostMessageToClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerHostProxy::FocusClient(
    const std::string& in_client_uuid, FocusClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::FocusClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_FocusClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_FocusClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_client_uuid, client_uuid_fragment);
  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_uuid in ServiceWorkerHost.FocusClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("FocusClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_FocusClient_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::NavigateClient(
    const std::string& in_client_uuid, const ::GURL& in_url, NavigateClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerHost::NavigateClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_NavigateClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_NavigateClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_client_uuid, client_uuid_fragment);
  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_uuid in ServiceWorkerHost.NavigateClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerHost.NavigateClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("NavigateClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_NavigateClient_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::SkipWaiting(
    SkipWaitingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerHost::SkipWaiting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_SkipWaiting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_SkipWaiting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("SkipWaiting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_SkipWaiting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerHostProxy::ClaimClients(
    ClaimClientsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerHost::ClaimClients");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_ClaimClients_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_ClaimClients_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("ClaimClients");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_ClaimClients_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerHost_GetClients_ProxyToResponder {
 public:
  static ServiceWorkerHost::GetClientsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_GetClients_ProxyToResponder> proxy(
        new ServiceWorkerHost_GetClients_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_GetClients_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_GetClients_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_GetClients_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::GetClientsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::blink::mojom::ServiceWorkerClientInfoPtr> in_clients);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_GetClients_ProxyToResponder);
};

bool ServiceWorkerHost_GetClients_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::GetClientsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_GetClients_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_GetClients_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::blink::mojom::ServiceWorkerClientInfoPtr> p_clients{};
  ServiceWorkerHost_GetClients_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadClients(&p_clients))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_clients));
  return true;
}

void ServiceWorkerHost_GetClients_ProxyToResponder::Run(
    std::vector<::blink::mojom::ServiceWorkerClientInfoPtr> in_clients) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::GetClientsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clients"), in_clients,
                        "<value of type std::vector<::blink::mojom::ServiceWorkerClientInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_GetClients_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClients_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clients)::BaseType>
      clients_fragment(params.message());
  const mojo::internal::ContainerValidateParams clients_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerClientInfoDataView>>(
      in_clients, clients_fragment, &clients_validate_params);
  params->clients.Set(
      clients_fragment.is_null() ? nullptr : clients_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clients.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clients in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::GetClientsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClients");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_GetClient_ProxyToResponder {
 public:
  static ServiceWorkerHost::GetClientCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_GetClient_ProxyToResponder> proxy(
        new ServiceWorkerHost_GetClient_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_GetClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_GetClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_GetClient_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::GetClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerClientInfoPtr in_client);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_GetClient_ProxyToResponder);
};

bool ServiceWorkerHost_GetClient_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::GetClientCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_GetClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_GetClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerClientInfoPtr p_client{};
  ServiceWorkerHost_GetClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_client));
  return true;
}

void ServiceWorkerHost_GetClient_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerClientInfoPtr in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::GetClientCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::ServiceWorkerClientInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_GetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
      in_client, client_fragment);
  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::GetClientCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClient");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_OpenNewTab_ProxyToResponder {
 public:
  static ServiceWorkerHost::OpenNewTabCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_OpenNewTab_ProxyToResponder> proxy(
        new ServiceWorkerHost_OpenNewTab_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_OpenNewTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_OpenNewTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_OpenNewTab_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::OpenNewTabCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::blink::mojom::ServiceWorkerClientInfoPtr in_client, const absl::optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_OpenNewTab_ProxyToResponder);
};

bool ServiceWorkerHost_OpenNewTab_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::OpenNewTabCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::blink::mojom::ServiceWorkerClientInfoPtr p_client{};
  absl::optional<std::string> p_error_msg{};
  ServiceWorkerHost_OpenNewTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_client), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerHost_OpenNewTab_ProxyToResponder::Run(
    bool in_success, ::blink::mojom::ServiceWorkerClientInfoPtr in_client, const absl::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::OpenNewTabCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::ServiceWorkerClientInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_OpenNewTab_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
      in_client, client_fragment);
  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::OpenNewTabCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenNewTab");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder {
 public:
  static ServiceWorkerHost::OpenPaymentHandlerWindowCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder> proxy(
        new ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::OpenPaymentHandlerWindowCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::blink::mojom::ServiceWorkerClientInfoPtr in_client, const absl::optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder);
};

bool ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindowCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::blink::mojom::ServiceWorkerClientInfoPtr p_client{};
  absl::optional<std::string> p_error_msg{};
  ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_client), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder::Run(
    bool in_success, ::blink::mojom::ServiceWorkerClientInfoPtr in_client, const absl::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindowCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::ServiceWorkerClientInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_OpenPaymentHandlerWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
      in_client, client_fragment);
  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindowCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenPaymentHandlerWindow");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_FocusClient_ProxyToResponder {
 public:
  static ServiceWorkerHost::FocusClientCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_FocusClient_ProxyToResponder> proxy(
        new ServiceWorkerHost_FocusClient_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_FocusClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_FocusClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_FocusClient_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::FocusClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerClientInfoPtr in_client);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_FocusClient_ProxyToResponder);
};

bool ServiceWorkerHost_FocusClient_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::FocusClientCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_FocusClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_FocusClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerClientInfoPtr p_client{};
  ServiceWorkerHost_FocusClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_client));
  return true;
}

void ServiceWorkerHost_FocusClient_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerClientInfoPtr in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::FocusClientCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::ServiceWorkerClientInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_FocusClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_FocusClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
      in_client, client_fragment);
  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::FocusClientCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("FocusClient");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_NavigateClient_ProxyToResponder {
 public:
  static ServiceWorkerHost::NavigateClientCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_NavigateClient_ProxyToResponder> proxy(
        new ServiceWorkerHost_NavigateClient_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_NavigateClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_NavigateClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_NavigateClient_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::NavigateClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::blink::mojom::ServiceWorkerClientInfoPtr in_client, const absl::optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_NavigateClient_ProxyToResponder);
};

bool ServiceWorkerHost_NavigateClient_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::NavigateClientCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::blink::mojom::ServiceWorkerClientInfoPtr p_client{};
  absl::optional<std::string> p_error_msg{};
  ServiceWorkerHost_NavigateClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_client), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerHost_NavigateClient_ProxyToResponder::Run(
    bool in_success, ::blink::mojom::ServiceWorkerClientInfoPtr in_client, const absl::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::NavigateClientCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::ServiceWorkerClientInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_NavigateClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
      in_client, client_fragment);
  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::NavigateClientCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("NavigateClient");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_SkipWaiting_ProxyToResponder {
 public:
  static ServiceWorkerHost::SkipWaitingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_SkipWaiting_ProxyToResponder> proxy(
        new ServiceWorkerHost_SkipWaiting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_SkipWaiting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_SkipWaiting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_SkipWaiting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::SkipWaitingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_SkipWaiting_ProxyToResponder);
};

bool ServiceWorkerHost_SkipWaiting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::SkipWaitingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ServiceWorkerHost_SkipWaiting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void ServiceWorkerHost_SkipWaiting_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::SkipWaitingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_SkipWaiting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::SkipWaitingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("SkipWaiting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_ClaimClients_ProxyToResponder {
 public:
  static ServiceWorkerHost::ClaimClientsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerHost_ClaimClients_ProxyToResponder> proxy(
        new ServiceWorkerHost_ClaimClients_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerHost_ClaimClients_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_ClaimClients_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerHost_ClaimClients_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerHost::ClaimClientsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const absl::optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerHost_ClaimClients_ProxyToResponder);
};

bool ServiceWorkerHost_ClaimClients_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerHost::ClaimClientsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  absl::optional<std::string> p_error_msg{};
  ServiceWorkerHost_ClaimClients_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerHost_ClaimClients_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const absl::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerHost::ClaimClientsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerHost_ClaimClients_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, error_msg_fragment);
  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerHost::ClaimClientsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("ClaimClients");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerHostStubDispatch::Accept(
    ServiceWorkerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerHost_SetCachedMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::SetCachedMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::SetCachedMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_SetCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_SetCachedMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::base::span<const ::uint8_t> p_data{};
      ServiceWorkerHost_SetCachedMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCachedMetadata(
std::move(p_url), 
std::move(p_data));
      return true;
    }
    case internal::kServiceWorkerHost_ClearCachedMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::ClearCachedMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::ClearCachedMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ServiceWorkerHost_ClearCachedMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCachedMetadata(
std::move(p_url));
      return true;
    }
    case internal::kServiceWorkerHost_GetClients_Name: {
      break;
    }
    case internal::kServiceWorkerHost_GetClient_Name: {
      break;
    }
    case internal::kServiceWorkerHost_OpenNewTab_Name: {
      break;
    }
    case internal::kServiceWorkerHost_OpenPaymentHandlerWindow_Name: {
      break;
    }
    case internal::kServiceWorkerHost_PostMessageToClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::PostMessageToClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::PostMessageToClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_PostMessageToClient_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_PostMessageToClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_client_uuid{};
      ::blink::TransferableMessage p_message{};
      ServiceWorkerHost_PostMessageToClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToClient(
std::move(p_client_uuid), 
std::move(p_message));
      return true;
    }
    case internal::kServiceWorkerHost_FocusClient_Name: {
      break;
    }
    case internal::kServiceWorkerHost_NavigateClient_Name: {
      break;
    }
    case internal::kServiceWorkerHost_SkipWaiting_Name: {
      break;
    }
    case internal::kServiceWorkerHost_ClaimClients_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerHost_SetCachedMetadata_Name: {
      break;
    }
    case internal::kServiceWorkerHost_ClearCachedMetadata_Name: {
      break;
    }
    case internal::kServiceWorkerHost_GetClients_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::GetClients",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::GetClients");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_GetClients_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_GetClients_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ServiceWorkerClientQueryOptionsPtr p_options{};
      ServiceWorkerHost_GetClients_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 2, false);
        return false;
      }
      ServiceWorkerHost::GetClientsCallback callback =
          ServiceWorkerHost_GetClients_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetClients(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_GetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::GetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::GetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_GetClient_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_GetClient_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_client_uuid{};
      ServiceWorkerHost_GetClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 3, false);
        return false;
      }
      ServiceWorkerHost::GetClientCallback callback =
          ServiceWorkerHost_GetClient_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetClient(
std::move(p_client_uuid), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_OpenNewTab_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::OpenNewTab",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::OpenNewTab");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_OpenNewTab_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_OpenNewTab_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ServiceWorkerHost_OpenNewTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 4, false);
        return false;
      }
      ServiceWorkerHost::OpenNewTabCallback callback =
          ServiceWorkerHost_OpenNewTab_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenNewTab(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_OpenPaymentHandlerWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 5, false);
        return false;
      }
      ServiceWorkerHost::OpenPaymentHandlerWindowCallback callback =
          ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPaymentHandlerWindow(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_PostMessageToClient_Name: {
      break;
    }
    case internal::kServiceWorkerHost_FocusClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::FocusClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::FocusClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_FocusClient_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_FocusClient_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_client_uuid{};
      ServiceWorkerHost_FocusClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 7, false);
        return false;
      }
      ServiceWorkerHost::FocusClientCallback callback =
          ServiceWorkerHost_FocusClient_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusClient(
std::move(p_client_uuid), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_NavigateClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::NavigateClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::NavigateClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_NavigateClient_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_NavigateClient_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_client_uuid{};
      ::GURL p_url{};
      ServiceWorkerHost_NavigateClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 8, false);
        return false;
      }
      ServiceWorkerHost::NavigateClientCallback callback =
          ServiceWorkerHost_NavigateClient_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateClient(
std::move(p_client_uuid), 
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_SkipWaiting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::SkipWaiting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::SkipWaiting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_SkipWaiting_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_SkipWaiting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerHost_SkipWaiting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 9, false);
        return false;
      }
      ServiceWorkerHost::SkipWaitingCallback callback =
          ServiceWorkerHost_SkipWaiting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SkipWaiting(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerHost_ClaimClients_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerHost::ClaimClients",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerHost::ClaimClients");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerHost_ClaimClients_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_ClaimClients_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerHost_ClaimClients_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 10, false);
        return false;
      }
      ServiceWorkerHost::ClaimClientsCallback callback =
          ServiceWorkerHost_ClaimClients_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClaimClients(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerHostValidationInfo[] = {
    {internal::kServiceWorkerHost_SetCachedMetadata_Name,
     {&internal::ServiceWorkerHost_SetCachedMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerHost_ClearCachedMetadata_Name,
     {&internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerHost_GetClients_Name,
     {&internal::ServiceWorkerHost_GetClients_Params_Data::Validate,
      &internal::ServiceWorkerHost_GetClients_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_GetClient_Name,
     {&internal::ServiceWorkerHost_GetClient_Params_Data::Validate,
      &internal::ServiceWorkerHost_GetClient_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_OpenNewTab_Name,
     {&internal::ServiceWorkerHost_OpenNewTab_Params_Data::Validate,
      &internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_OpenPaymentHandlerWindow_Name,
     {&internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data::Validate,
      &internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_PostMessageToClient_Name,
     {&internal::ServiceWorkerHost_PostMessageToClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerHost_FocusClient_Name,
     {&internal::ServiceWorkerHost_FocusClient_Params_Data::Validate,
      &internal::ServiceWorkerHost_FocusClient_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_NavigateClient_Name,
     {&internal::ServiceWorkerHost_NavigateClient_Params_Data::Validate,
      &internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_SkipWaiting_Name,
     {&internal::ServiceWorkerHost_SkipWaiting_Params_Data::Validate,
      &internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerHost_ClaimClients_Name,
     {&internal::ServiceWorkerHost_ClaimClients_Params_Data::Validate,
      &internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data::Validate}},
};

bool ServiceWorkerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerHostValidationInfo);
}

bool ServiceWorkerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerHostValidationInfo);

}
const char ServiceWorker::Name_[] = "blink.mojom.ServiceWorker";

class ServiceWorker_DispatchInstallEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchInstallEvent_ForwardToCallback(
      ServiceWorker::DispatchInstallEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchInstallEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchInstallEvent_ForwardToCallback);
};

class ServiceWorker_DispatchActivateEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchActivateEvent_ForwardToCallback(
      ServiceWorker::DispatchActivateEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchActivateEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchActivateEvent_ForwardToCallback);
};

class ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchAbortEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchAbortEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback);
};

class ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchClickEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchClickEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback);
};

class ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchFailEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchFailEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback);
};

class ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchSuccessEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchSuccessEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback);
};

class ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback(
      ServiceWorker::DispatchCookieChangeEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchCookieChangeEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback);
};

class ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback(
      ServiceWorker::DispatchFetchEventForMainResourceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchFetchEventForMainResourceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback);
};

class ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback(
      ServiceWorker::DispatchNotificationClickEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchNotificationClickEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback);
};

class ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback(
      ServiceWorker::DispatchNotificationCloseEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchNotificationCloseEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback);
};

class ServiceWorker_DispatchPushEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPushEvent_ForwardToCallback(
      ServiceWorker::DispatchPushEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPushEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPushEvent_ForwardToCallback);
};

class ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback(
      ServiceWorker::DispatchPushSubscriptionChangeEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPushSubscriptionChangeEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback);
};

class ServiceWorker_DispatchSyncEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchSyncEvent_ForwardToCallback(
      ServiceWorker::DispatchSyncEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchSyncEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchSyncEvent_ForwardToCallback);
};

class ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback(
      ServiceWorker::DispatchPeriodicSyncEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPeriodicSyncEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback);
};

class ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback(
      ServiceWorker::DispatchAbortPaymentEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchAbortPaymentEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback);
};

class ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback(
      ServiceWorker::DispatchCanMakePaymentEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchCanMakePaymentEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback);
};

class ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback(
      ServiceWorker::DispatchPaymentRequestEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPaymentRequestEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback);
};

class ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback(
      ServiceWorker::DispatchExtendableMessageEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchExtendableMessageEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback);
};

class ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback(
      ServiceWorker::DispatchContentDeleteEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchContentDeleteEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback);
};

class ServiceWorker_Ping_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_Ping_ForwardToCallback(
      ServiceWorker::PingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::PingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_Ping_ForwardToCallback);
};

ServiceWorkerProxy::ServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerProxy::InitializeGlobalScope(
    ::mojo::PendingAssociatedRemote<ServiceWorkerHost> in_service_worker_host, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr in_registration_info, ::blink::mojom::ServiceWorkerObjectInfoPtr in_service_worker_info, FetchHandlerExistence in_fetch_handler_existence, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> in_reporting_observer_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::InitializeGlobalScope", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_host"), in_service_worker_host,
                        "<value of type ::mojo::PendingAssociatedRemote<ServiceWorkerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_info"), in_registration_info,
                        "<value of type ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_info"), in_service_worker_info,
                        "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetch_handler_existence"), in_fetch_handler_existence,
                        "<value of type FetchHandlerExistence>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_observer_receiver"), in_reporting_observer_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::ReportingObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_InitializeGlobalScope_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_InitializeGlobalScope_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerHostAssociatedPtrInfoDataView>(
      in_service_worker_host, &params->service_worker_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->service_worker_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid service_worker_host in ServiceWorker.InitializeGlobalScope request");
  mojo::internal::MessageFragment<
      typename decltype(params->registration_info)::BaseType> registration_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
      in_registration_info, registration_info_fragment);
  params->registration_info.Set(
      registration_info_fragment.is_null() ? nullptr : registration_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration_info in ServiceWorker.InitializeGlobalScope request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_info)::BaseType> service_worker_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
      in_service_worker_info, service_worker_info_fragment);
  params->service_worker_info.Set(
      service_worker_info_fragment.is_null() ? nullptr : service_worker_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->service_worker_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_worker_info in ServiceWorker.InitializeGlobalScope request");
  mojo::internal::Serialize<::blink::mojom::FetchHandlerExistence>(
      in_fetch_handler_existence, &params->fetch_handler_existence);
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, subresource_loader_factories_fragment);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
      in_reporting_observer_receiver, &params->reporting_observer_receiver, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("InitializeGlobalScope");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerProxy::DispatchInstallEvent(
    DispatchInstallEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorker::DispatchInstallEvent");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchInstallEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchInstallEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchInstallEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchInstallEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchActivateEvent(
    DispatchActivateEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorker::DispatchActivateEvent");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchActivateEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchActivateEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchActivateEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchActivateEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchBackgroundFetchAbortEvent(
    ::blink::mojom::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchAbortEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::BackgroundFetchRegistrationPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchAbortEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration in ServiceWorker.DispatchBackgroundFetchAbortEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchAbortEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchBackgroundFetchClickEvent(
    ::blink::mojom::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchClickEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::BackgroundFetchRegistrationPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchClickEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration in ServiceWorker.DispatchBackgroundFetchClickEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchClickEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchBackgroundFetchFailEvent(
    ::blink::mojom::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchFailEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::BackgroundFetchRegistrationPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchFailEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration in ServiceWorker.DispatchBackgroundFetchFailEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchFailEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchBackgroundFetchSuccessEvent(
    ::blink::mojom::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchSuccessEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::BackgroundFetchRegistrationPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchSuccessEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration in ServiceWorker.DispatchBackgroundFetchSuccessEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchSuccessEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchCookieChangeEvent(
    const ::net::CookieChangeInfo& in_change, DispatchCookieChangeEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchCookieChangeEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("change"), in_change,
                        "<value of type const ::net::CookieChangeInfo&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchCookieChangeEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->change)::BaseType> change_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieChangeInfoDataView>(
      in_change, change_fragment);
  params->change.Set(
      change_fragment.is_null() ? nullptr : change_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->change.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null change in ServiceWorker.DispatchCookieChangeEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCookieChangeEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchFetchEventForMainResource(
    ::blink::mojom::DispatchFetchEventParamsPtr in_params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> in_response_callback, DispatchFetchEventForMainResourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchFetchEventForMainResource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::DispatchFetchEventParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_callback"), in_response_callback,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchFetchEventForMainResource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DispatchFetchEventParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ServiceWorker.DispatchFetchEventForMainResource request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ServiceWorkerFetchResponseCallbackInterfaceBase>>(
      in_response_callback, &params->response_callback, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_callback),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_callback in ServiceWorker.DispatchFetchEventForMainResource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForMainResource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchNotificationClickEvent(
    const std::string& in_notification_id, const ::blink::PlatformNotificationData& in_notification_data, int32_t in_action_index, const absl::optional<::std::u16string>& in_reply, DispatchNotificationClickEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchNotificationClickEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_data"), in_notification_data,
                        "<value of type const ::blink::PlatformNotificationData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_index"), in_action_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type const absl::optional<::std::u16string>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchNotificationClickEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_notification_id, notification_id_fragment);
  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->notification_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null notification_id in ServiceWorker.DispatchNotificationClickEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_data)::BaseType> notification_data_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::NotificationDataDataView>(
      in_notification_data, notification_data_fragment);
  params->notification_data.Set(
      notification_data_fragment.is_null() ? nullptr : notification_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->notification_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null notification_data in ServiceWorker.DispatchNotificationClickEvent request");
  params->action_index = in_action_index;
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_reply, reply_fragment);
  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationClickEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchNotificationCloseEvent(
    const std::string& in_notification_id, const ::blink::PlatformNotificationData& in_notification_data, DispatchNotificationCloseEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchNotificationCloseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_data"), in_notification_data,
                        "<value of type const ::blink::PlatformNotificationData&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchNotificationCloseEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_notification_id, notification_id_fragment);
  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->notification_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null notification_id in ServiceWorker.DispatchNotificationCloseEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_data)::BaseType> notification_data_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::NotificationDataDataView>(
      in_notification_data, notification_data_fragment);
  params->notification_data.Set(
      notification_data_fragment.is_null() ? nullptr : notification_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->notification_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null notification_data in ServiceWorker.DispatchNotificationCloseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationCloseEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchPushEvent(
    const absl::optional<std::string>& in_payload, DispatchPushEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchPushEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payload"), in_payload,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPushEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->payload)::BaseType> payload_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_payload, payload_fragment);
  params->payload.Set(
      payload_fragment.is_null() ? nullptr : payload_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPushEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchPushSubscriptionChangeEvent(
    ::blink::mojom::PushSubscriptionPtr in_old_subscription, ::blink::mojom::PushSubscriptionPtr in_new_subscription, DispatchPushSubscriptionChangeEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_subscription"), in_old_subscription,
                        "<value of type ::blink::mojom::PushSubscriptionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_subscription"), in_new_subscription,
                        "<value of type ::blink::mojom::PushSubscriptionPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPushSubscriptionChangeEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_subscription)::BaseType> old_subscription_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
      in_old_subscription, old_subscription_fragment);
  params->old_subscription.Set(
      old_subscription_fragment.is_null() ? nullptr : old_subscription_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->new_subscription)::BaseType> new_subscription_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
      in_new_subscription, new_subscription_fragment);
  params->new_subscription.Set(
      new_subscription_fragment.is_null() ? nullptr : new_subscription_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushSubscriptionChangeEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchSyncEvent(
    const std::string& in_tag, bool in_last_chance, ::base::TimeDelta in_timeout, DispatchSyncEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchSyncEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tag"), in_tag,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_chance"), in_last_chance,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchSyncEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchSyncEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tag)::BaseType> tag_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_tag, tag_fragment);
  params->tag.Set(
      tag_fragment.is_null() ? nullptr : tag_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tag.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tag in ServiceWorker.DispatchSyncEvent request");
  params->last_chance = in_last_chance;
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout, timeout_fragment);
  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timeout.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timeout in ServiceWorker.DispatchSyncEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchSyncEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchSyncEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchPeriodicSyncEvent(
    const std::string& in_tag, ::base::TimeDelta in_timeout, DispatchPeriodicSyncEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tag"), in_tag,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPeriodicSyncEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tag)::BaseType> tag_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_tag, tag_fragment);
  params->tag.Set(
      tag_fragment.is_null() ? nullptr : tag_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tag.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tag in ServiceWorker.DispatchPeriodicSyncEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout, timeout_fragment);
  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timeout.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timeout in ServiceWorker.DispatchPeriodicSyncEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPeriodicSyncEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchAbortPaymentEvent(
    ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> in_result_of_abort_payment, DispatchAbortPaymentEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchAbortPaymentEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_of_abort_payment"), in_result_of_abort_payment,
                        "<value of type ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchAbortPaymentEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerResponseCallbackInterfaceBase>>(
      in_result_of_abort_payment, &params->result_of_abort_payment, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->result_of_abort_payment),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid result_of_abort_payment in ServiceWorker.DispatchAbortPaymentEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchAbortPaymentEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchCanMakePaymentEvent(
    ::payments::mojom::CanMakePaymentEventDataPtr in_event_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> in_result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_data"), in_event_data,
                        "<value of type ::payments::mojom::CanMakePaymentEventDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_of_can_make_payment"), in_result_of_can_make_payment,
                        "<value of type ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchCanMakePaymentEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_data)::BaseType> event_data_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::CanMakePaymentEventDataDataView>(
      in_event_data, event_data_fragment);
  params->event_data.Set(
      event_data_fragment.is_null() ? nullptr : event_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_data in ServiceWorker.DispatchCanMakePaymentEvent request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerResponseCallbackInterfaceBase>>(
      in_result_of_can_make_payment, &params->result_of_can_make_payment, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->result_of_can_make_payment),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid result_of_can_make_payment in ServiceWorker.DispatchCanMakePaymentEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCanMakePaymentEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchPaymentRequestEvent(
    ::payments::mojom::PaymentRequestEventDataPtr in_request_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> in_response_callback, DispatchPaymentRequestEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchPaymentRequestEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_data"), in_request_data,
                        "<value of type ::payments::mojom::PaymentRequestEventDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_callback"), in_response_callback,
                        "<value of type ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPaymentRequestEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_data)::BaseType> request_data_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentRequestEventDataDataView>(
      in_request_data, request_data_fragment);
  params->request_data.Set(
      request_data_fragment.is_null() ? nullptr : request_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_data in ServiceWorker.DispatchPaymentRequestEvent request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerResponseCallbackInterfaceBase>>(
      in_response_callback, &params->response_callback, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_callback),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_callback in ServiceWorker.DispatchPaymentRequestEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPaymentRequestEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchExtendableMessageEvent(
    ExtendableMessageEventPtr in_event, DispatchExtendableMessageEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchExtendableMessageEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ExtendableMessageEventPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchExtendableMessageEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ExtendableMessageEventDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in ServiceWorker.DispatchExtendableMessageEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchExtendableMessageEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::DispatchContentDeleteEvent(
    const std::string& in_id, DispatchContentDeleteEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::DispatchContentDeleteEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchContentDeleteEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ServiceWorker.DispatchContentDeleteEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchContentDeleteEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::Ping(
    PingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorker::Ping");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_Ping_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_Ping_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("Ping");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_Ping_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerProxy::SetIdleDelay(
    ::base::TimeDelta in_delay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::SetIdleDelay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay"), in_delay,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_SetIdleDelay_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_SetIdleDelay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delay)::BaseType> delay_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_delay, delay_fragment);
  params->delay.Set(
      delay_fragment.is_null() ? nullptr : delay_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->delay.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null delay in ServiceWorker.SetIdleDelay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("SetIdleDelay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerProxy::AddMessageToConsole(
    ::blink::mojom::ConsoleMessageLevel in_level, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorker::AddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_AddMessageToConsole_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_AddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
      in_level, &params->level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ServiceWorker.AddMessageToConsole request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("AddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ServiceWorker_DispatchInstallEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchInstallEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchInstallEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchInstallEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchInstallEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchInstallEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchInstallEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchInstallEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status, uint32_t in_fetch_count);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchInstallEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchInstallEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchInstallEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  uint32_t p_fetch_count{};
  ServiceWorker_DispatchInstallEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_fetch_count = input_data_view.fetch_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_fetch_count));
  return true;
}

void ServiceWorker_DispatchInstallEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status, uint32_t in_fetch_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchInstallEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetch_count"), in_fetch_count,
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchInstallEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);
  params->fetch_count = in_fetch_count;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchInstallEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchInstallEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchActivateEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchActivateEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchActivateEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchActivateEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchActivateEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchActivateEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchActivateEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchActivateEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchActivateEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchActivateEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchActivateEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchActivateEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchActivateEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchActivateEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchActivateEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchActivateEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchActivateEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchAbortEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchBackgroundFetchAbortEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchAbortEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchAbortEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchClickEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchBackgroundFetchClickEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchClickEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchClickEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchFailEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchBackgroundFetchFailEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchFailEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchFailEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchSuccessEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchBackgroundFetchSuccessEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchBackgroundFetchSuccessEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchSuccessEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchCookieChangeEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchCookieChangeEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchCookieChangeEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchCookieChangeEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchCookieChangeEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchCookieChangeEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchCookieChangeEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCookieChangeEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder {
 public:
  static ServiceWorker::DispatchFetchEventForMainResourceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder> proxy(
        new ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchFetchEventForMainResourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder);
};

bool ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchFetchEventForMainResourceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchFetchEventForMainResourceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchFetchEventForMainResource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchFetchEventForMainResourceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForMainResource");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchNotificationClickEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchNotificationClickEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchNotificationClickEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchNotificationClickEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchNotificationClickEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchNotificationClickEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchNotificationClickEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationClickEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchNotificationCloseEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchNotificationCloseEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchNotificationCloseEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchNotificationCloseEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchNotificationCloseEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchNotificationCloseEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationCloseEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPushEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchPushEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchPushEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPushEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchPushEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPushEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchPushEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchPushEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPushEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchPushEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchPushEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPushEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchPushEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPushEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPushEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPushEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchPushSubscriptionChangeEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchPushSubscriptionChangeEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPushSubscriptionChangeEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushSubscriptionChangeEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchSyncEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchSyncEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchSyncEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchSyncEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchSyncEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchSyncEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchSyncEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchSyncEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchSyncEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchSyncEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchSyncEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchSyncEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchSyncEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchSyncEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchSyncEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchSyncEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchSyncEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchPeriodicSyncEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchPeriodicSyncEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchPeriodicSyncEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPeriodicSyncEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPeriodicSyncEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPeriodicSyncEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPeriodicSyncEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchAbortPaymentEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchAbortPaymentEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchAbortPaymentEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchAbortPaymentEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchAbortPaymentEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchAbortPaymentEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchAbortPaymentEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchCanMakePaymentEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchCanMakePaymentEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchCanMakePaymentEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchCanMakePaymentEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchCanMakePaymentEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchCanMakePaymentEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCanMakePaymentEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchPaymentRequestEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchPaymentRequestEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchPaymentRequestEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPaymentRequestEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchPaymentRequestEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchPaymentRequestEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPaymentRequestEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchExtendableMessageEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchExtendableMessageEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchExtendableMessageEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchExtendableMessageEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchExtendableMessageEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchExtendableMessageEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchExtendableMessageEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder {
 public:
  static ServiceWorker::DispatchContentDeleteEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchContentDeleteEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder);
};

bool ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::DispatchContentDeleteEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchContentDeleteEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorker::DispatchContentDeleteEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_DispatchContentDeleteEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::DispatchContentDeleteEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchContentDeleteEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_Ping_ProxyToResponder {
 public:
  static ServiceWorker::PingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorker_Ping_ProxyToResponder> proxy(
        new ServiceWorker_Ping_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorker_Ping_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_Ping_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorker_Ping_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::PingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorker_Ping_ProxyToResponder);
};

bool ServiceWorker_Ping_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorker::PingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorker_Ping_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_Ping_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceWorker_Ping_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorker_Ping_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::ServiceWorker::PingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorker_Ping_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_Ping_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorker::PingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("Ping");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerStubDispatch::Accept(
    ServiceWorker* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorker_InitializeGlobalScope_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::InitializeGlobalScope",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::InitializeGlobalScope");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorker_InitializeGlobalScope_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_InitializeGlobalScope_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<ServiceWorkerHost> p_service_worker_host{};
      ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr p_registration_info{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_service_worker_info{};
      FetchHandlerExistence p_fetch_handler_existence{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> p_reporting_observer_receiver{};
      ServiceWorker_InitializeGlobalScope_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_service_worker_host =
            input_data_view.TakeServiceWorkerHost<decltype(p_service_worker_host)>();
      }
      if (success && !input_data_view.ReadRegistrationInfo(&p_registration_info))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerInfo(&p_service_worker_info))
        success = false;
      if (success && !input_data_view.ReadFetchHandlerExistence(&p_fetch_handler_existence))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success) {
        p_reporting_observer_receiver =
            input_data_view.TakeReportingObserverReceiver<decltype(p_reporting_observer_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeGlobalScope(
std::move(p_service_worker_host), 
std::move(p_registration_info), 
std::move(p_service_worker_info), 
std::move(p_fetch_handler_existence), 
std::move(p_subresource_loader_factories), 
std::move(p_reporting_observer_receiver));
      return true;
    }
    case internal::kServiceWorker_DispatchInstallEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchActivateEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchAbortEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchClickEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchFailEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchSuccessEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchCookieChangeEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchFetchEventForMainResource_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchNotificationClickEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchNotificationCloseEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchPushEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchPushSubscriptionChangeEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchSyncEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchPeriodicSyncEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchAbortPaymentEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchCanMakePaymentEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchPaymentRequestEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchExtendableMessageEvent_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchContentDeleteEvent_Name: {
      break;
    }
    case internal::kServiceWorker_Ping_Name: {
      break;
    }
    case internal::kServiceWorker_SetIdleDelay_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::SetIdleDelay",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::SetIdleDelay");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorker_SetIdleDelay_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_SetIdleDelay_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_delay{};
      ServiceWorker_SetIdleDelay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDelay(&p_delay))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIdleDelay(
std::move(p_delay));
      return true;
    }
    case internal::kServiceWorker_AddMessageToConsole_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::AddMessageToConsole",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::AddMessageToConsole");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorker_AddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_AddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ConsoleMessageLevel p_level{};
      std::string p_message{};
      ServiceWorker_AddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMessageToConsole(
std::move(p_level), 
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerStubDispatch::AcceptWithResponder(
    ServiceWorker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorker_InitializeGlobalScope_Name: {
      break;
    }
    case internal::kServiceWorker_DispatchInstallEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchInstallEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchInstallEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchInstallEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchInstallEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorker_DispatchInstallEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 1, false);
        return false;
      }
      ServiceWorker::DispatchInstallEventCallback callback =
          ServiceWorker_DispatchInstallEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchInstallEvent(std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchActivateEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchActivateEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchActivateEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchActivateEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchActivateEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorker_DispatchActivateEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 2, false);
        return false;
      }
      ServiceWorker::DispatchActivateEventCallback callback =
          ServiceWorker_DispatchActivateEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchActivateEvent(std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchAbortEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 3, false);
        return false;
      }
      ServiceWorker::DispatchBackgroundFetchAbortEventCallback callback =
          ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchAbortEvent(
std::move(p_registration), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchClickEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 4, false);
        return false;
      }
      ServiceWorker::DispatchBackgroundFetchClickEventCallback callback =
          ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchClickEvent(
std::move(p_registration), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchFailEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 5, false);
        return false;
      }
      ServiceWorker::DispatchBackgroundFetchFailEventCallback callback =
          ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchFailEvent(
std::move(p_registration), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchBackgroundFetchSuccessEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 6, false);
        return false;
      }
      ServiceWorker::DispatchBackgroundFetchSuccessEventCallback callback =
          ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchSuccessEvent(
std::move(p_registration), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchCookieChangeEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchCookieChangeEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchCookieChangeEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::CookieChangeInfo p_change{};
      ServiceWorker_DispatchCookieChangeEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChange(&p_change))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 7, false);
        return false;
      }
      ServiceWorker::DispatchCookieChangeEventCallback callback =
          ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchCookieChangeEvent(
std::move(p_change), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchFetchEventForMainResource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchFetchEventForMainResource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchFetchEventForMainResource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::DispatchFetchEventParamsPtr p_params{};
      ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> p_response_callback{};
      ServiceWorker_DispatchFetchEventForMainResource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_response_callback =
            input_data_view.TakeResponseCallback<decltype(p_response_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 8, false);
        return false;
      }
      ServiceWorker::DispatchFetchEventForMainResourceCallback callback =
          ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchFetchEventForMainResource(
std::move(p_params), 
std::move(p_response_callback), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchNotificationClickEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchNotificationClickEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchNotificationClickEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_notification_id{};
      ::blink::PlatformNotificationData p_notification_data{};
      int32_t p_action_index{};
      absl::optional<::std::u16string> p_reply{};
      ServiceWorker_DispatchNotificationClickEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success && !input_data_view.ReadNotificationData(&p_notification_data))
        success = false;
      if (success)
        p_action_index = input_data_view.action_index();
      if (success && !input_data_view.ReadReply(&p_reply))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 9, false);
        return false;
      }
      ServiceWorker::DispatchNotificationClickEventCallback callback =
          ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNotificationClickEvent(
std::move(p_notification_id), 
std::move(p_notification_data), 
std::move(p_action_index), 
std::move(p_reply), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchNotificationCloseEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchNotificationCloseEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchNotificationCloseEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_notification_id{};
      ::blink::PlatformNotificationData p_notification_data{};
      ServiceWorker_DispatchNotificationCloseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success && !input_data_view.ReadNotificationData(&p_notification_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 10, false);
        return false;
      }
      ServiceWorker::DispatchNotificationCloseEventCallback callback =
          ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNotificationCloseEvent(
std::move(p_notification_id), 
std::move(p_notification_data), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchPushEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchPushEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchPushEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchPushEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPushEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      absl::optional<std::string> p_payload{};
      ServiceWorker_DispatchPushEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPayload(&p_payload))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 11, false);
        return false;
      }
      ServiceWorker::DispatchPushEventCallback callback =
          ServiceWorker_DispatchPushEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPushEvent(
std::move(p_payload), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchPushSubscriptionChangeEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::PushSubscriptionPtr p_old_subscription{};
      ::blink::mojom::PushSubscriptionPtr p_new_subscription{};
      ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldSubscription(&p_old_subscription))
        success = false;
      if (success && !input_data_view.ReadNewSubscription(&p_new_subscription))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 12, false);
        return false;
      }
      ServiceWorker::DispatchPushSubscriptionChangeEventCallback callback =
          ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPushSubscriptionChangeEvent(
std::move(p_old_subscription), 
std::move(p_new_subscription), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchSyncEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchSyncEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchSyncEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchSyncEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchSyncEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_tag{};
      bool p_last_chance{};
      ::base::TimeDelta p_timeout{};
      ServiceWorker_DispatchSyncEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTag(&p_tag))
        success = false;
      if (success)
        p_last_chance = input_data_view.last_chance();
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 13, false);
        return false;
      }
      ServiceWorker::DispatchSyncEventCallback callback =
          ServiceWorker_DispatchSyncEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchSyncEvent(
std::move(p_tag), 
std::move(p_last_chance), 
std::move(p_timeout), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchPeriodicSyncEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_tag{};
      ::base::TimeDelta p_timeout{};
      ServiceWorker_DispatchPeriodicSyncEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTag(&p_tag))
        success = false;
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 14, false);
        return false;
      }
      ServiceWorker::DispatchPeriodicSyncEventCallback callback =
          ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPeriodicSyncEvent(
std::move(p_tag), 
std::move(p_timeout), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchAbortPaymentEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchAbortPaymentEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchAbortPaymentEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> p_result_of_abort_payment{};
      ServiceWorker_DispatchAbortPaymentEvent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_result_of_abort_payment =
            input_data_view.TakeResultOfAbortPayment<decltype(p_result_of_abort_payment)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 15, false);
        return false;
      }
      ServiceWorker::DispatchAbortPaymentEventCallback callback =
          ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchAbortPaymentEvent(
std::move(p_result_of_abort_payment), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchCanMakePaymentEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::CanMakePaymentEventDataPtr p_event_data{};
      ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> p_result_of_can_make_payment{};
      ServiceWorker_DispatchCanMakePaymentEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventData(&p_event_data))
        success = false;
      if (success) {
        p_result_of_can_make_payment =
            input_data_view.TakeResultOfCanMakePayment<decltype(p_result_of_can_make_payment)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 16, false);
        return false;
      }
      ServiceWorker::DispatchCanMakePaymentEventCallback callback =
          ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchCanMakePaymentEvent(
std::move(p_event_data), 
std::move(p_result_of_can_make_payment), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchPaymentRequestEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchPaymentRequestEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchPaymentRequestEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::PaymentRequestEventDataPtr p_request_data{};
      ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> p_response_callback{};
      ServiceWorker_DispatchPaymentRequestEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestData(&p_request_data))
        success = false;
      if (success) {
        p_response_callback =
            input_data_view.TakeResponseCallback<decltype(p_response_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 17, false);
        return false;
      }
      ServiceWorker::DispatchPaymentRequestEventCallback callback =
          ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPaymentRequestEvent(
std::move(p_request_data), 
std::move(p_response_callback), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchExtendableMessageEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchExtendableMessageEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchExtendableMessageEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ExtendableMessageEventPtr p_event{};
      ServiceWorker_DispatchExtendableMessageEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 18, false);
        return false;
      }
      ServiceWorker::DispatchExtendableMessageEventCallback callback =
          ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchExtendableMessageEvent(
std::move(p_event), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_DispatchContentDeleteEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::DispatchContentDeleteEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::DispatchContentDeleteEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_id{};
      ServiceWorker_DispatchContentDeleteEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 19, false);
        return false;
      }
      ServiceWorker::DispatchContentDeleteEventCallback callback =
          ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchContentDeleteEvent(
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kServiceWorker_Ping_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorker::Ping",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorker::Ping");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorker_Ping_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_Ping_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorker_Ping_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 20, false);
        return false;
      }
      ServiceWorker::PingCallback callback =
          ServiceWorker_Ping_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ping(std::move(callback));
      return true;
    }
    case internal::kServiceWorker_SetIdleDelay_Name: {
      break;
    }
    case internal::kServiceWorker_AddMessageToConsole_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerValidationInfo[] = {
    {internal::kServiceWorker_InitializeGlobalScope_Name,
     {&internal::ServiceWorker_InitializeGlobalScope_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorker_DispatchInstallEvent_Name,
     {&internal::ServiceWorker_DispatchInstallEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchActivateEvent_Name,
     {&internal::ServiceWorker_DispatchActivateEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchBackgroundFetchAbortEvent_Name,
     {&internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchBackgroundFetchClickEvent_Name,
     {&internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchBackgroundFetchFailEvent_Name,
     {&internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchBackgroundFetchSuccessEvent_Name,
     {&internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchCookieChangeEvent_Name,
     {&internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchFetchEventForMainResource_Name,
     {&internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data::Validate,
      &internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchNotificationClickEvent_Name,
     {&internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchNotificationCloseEvent_Name,
     {&internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchPushEvent_Name,
     {&internal::ServiceWorker_DispatchPushEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchPushSubscriptionChangeEvent_Name,
     {&internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchSyncEvent_Name,
     {&internal::ServiceWorker_DispatchSyncEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchPeriodicSyncEvent_Name,
     {&internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchAbortPaymentEvent_Name,
     {&internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchCanMakePaymentEvent_Name,
     {&internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchPaymentRequestEvent_Name,
     {&internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchExtendableMessageEvent_Name,
     {&internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_DispatchContentDeleteEvent_Name,
     {&internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data::Validate,
      &internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_Ping_Name,
     {&internal::ServiceWorker_Ping_Params_Data::Validate,
      &internal::ServiceWorker_Ping_ResponseParams_Data::Validate}},
    {internal::kServiceWorker_SetIdleDelay_Name,
     {&internal::ServiceWorker_SetIdleDelay_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorker_AddMessageToConsole_Name,
     {&internal::ServiceWorker_AddMessageToConsole_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerValidationInfo);
}

bool ServiceWorkerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorker::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerValidationInfo);

}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ExtendableMessageEvent::DataView, ::blink::mojom::ExtendableMessageEventPtr>::Read(
    ::blink::mojom::ExtendableMessageEvent::DataView input,
    ::blink::mojom::ExtendableMessageEventPtr* output) {
  bool success = true;
  ::blink::mojom::ExtendableMessageEventPtr result(::blink::mojom::ExtendableMessageEvent::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
      if (success && !input.ReadSourceInfoForClient(&result->source_info_for_client))
        success = false;
      if (success && !input.ReadSourceInfoForServiceWorker(&result->source_info_for_service_worker))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif