// third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_FETCH_RESPONSE_CALLBACK_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_FETCH_RESPONSE_CALLBACK_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ServiceWorkerFetchEventTiming::ServiceWorkerFetchEventTiming()
    : dispatch_event_time(),
      respond_with_settled_time() {}

ServiceWorkerFetchEventTiming::ServiceWorkerFetchEventTiming(
    ::base::TimeTicks dispatch_event_time_in,
    ::base::TimeTicks respond_with_settled_time_in)
    : dispatch_event_time(std::move(dispatch_event_time_in)),
      respond_with_settled_time(std::move(respond_with_settled_time_in)) {}

ServiceWorkerFetchEventTiming::~ServiceWorkerFetchEventTiming() = default;

void ServiceWorkerFetchEventTiming::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dispatch_event_time"), this->dispatch_event_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "respond_with_settled_time"), this->respond_with_settled_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerFetchEventTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerFetchResponseCallback::Name_[] = "blink.mojom.ServiceWorkerFetchResponseCallback";

ServiceWorkerFetchResponseCallbackProxy::ServiceWorkerFetchResponseCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerFetchResponseCallbackProxy::OnResponse(
    ::blink::mojom::blink::FetchAPIResponsePtr in_response, ServiceWorkerFetchEventTimingPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ServiceWorkerFetchEventTimingPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerFetchResponseCallback_OnResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in ServiceWorkerFetchResponseCallback.OnResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchEventTimingDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in ServiceWorkerFetchResponseCallback.OnResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerFetchResponseCallback::Name_);
  message.set_method_name("OnResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerFetchResponseCallbackProxy::OnResponseStream(
    ::blink::mojom::blink::FetchAPIResponsePtr in_response, ::blink::mojom::blink::ServiceWorkerStreamHandlePtr in_body_as_stream, ServiceWorkerFetchEventTimingPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body_as_stream"), in_body_as_stream,
                        "<value of type ::blink::mojom::blink::ServiceWorkerStreamHandlePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ServiceWorkerFetchEventTimingPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerFetchResponseCallback_OnResponseStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in ServiceWorkerFetchResponseCallback.OnResponseStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->body_as_stream)::BaseType> body_as_stream_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerStreamHandleDataView>(
      in_body_as_stream, body_as_stream_fragment);
  params->body_as_stream.Set(
      body_as_stream_fragment.is_null() ? nullptr : body_as_stream_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->body_as_stream.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null body_as_stream in ServiceWorkerFetchResponseCallback.OnResponseStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchEventTimingDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in ServiceWorkerFetchResponseCallback.OnResponseStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerFetchResponseCallback::Name_);
  message.set_method_name("OnResponseStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerFetchResponseCallbackProxy::OnFallback(
    ServiceWorkerFetchEventTimingPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ServiceWorkerFetchEventTimingPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kServiceWorkerFetchResponseCallback_OnFallback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchEventTimingDataView>(
      in_timing, timing_fragment);
  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in ServiceWorkerFetchResponseCallback.OnFallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerFetchResponseCallback::Name_);
  message.set_method_name("OnFallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerFetchResponseCallbackStubDispatch::Accept(
    ServiceWorkerFetchResponseCallback* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerFetchResponseCallback_OnResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIResponsePtr p_response{};
      ServiceWorkerFetchEventTimingPtr p_timing{};
      ServiceWorkerFetchResponseCallback_OnResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerFetchResponseCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponse(
std::move(p_response), 
std::move(p_timing));
      return true;
    }
    case internal::kServiceWorkerFetchResponseCallback_OnResponseStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIResponsePtr p_response{};
      ::blink::mojom::blink::ServiceWorkerStreamHandlePtr p_body_as_stream{};
      ServiceWorkerFetchEventTimingPtr p_timing{};
      ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success && !input_data_view.ReadBodyAsStream(&p_body_as_stream))
        success = false;
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerFetchResponseCallback::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseStream(
std::move(p_response), 
std::move(p_body_as_stream), 
std::move(p_timing));
      return true;
    }
    case internal::kServiceWorkerFetchResponseCallback_OnFallback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerFetchEventTimingPtr p_timing{};
      ServiceWorkerFetchResponseCallback_OnFallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerFetchResponseCallback::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFallback(
std::move(p_timing));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerFetchResponseCallbackStubDispatch::AcceptWithResponder(
    ServiceWorkerFetchResponseCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerFetchResponseCallback_OnResponse_Name: {
      break;
    }
    case internal::kServiceWorkerFetchResponseCallback_OnResponseStream_Name: {
      break;
    }
    case internal::kServiceWorkerFetchResponseCallback_OnFallback_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kServiceWorkerFetchResponseCallbackValidationInfo[] = {
    {&internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerFetchResponseCallbackRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ServiceWorkerFetchResponseCallback::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kServiceWorkerFetchResponseCallbackValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerFetchEventTiming::DataView, ::blink::mojom::blink::ServiceWorkerFetchEventTimingPtr>::Read(
    ::blink::mojom::blink::ServiceWorkerFetchEventTiming::DataView input,
    ::blink::mojom::blink::ServiceWorkerFetchEventTimingPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerFetchEventTimingPtr result(::blink::mojom::blink::ServiceWorkerFetchEventTiming::New());
  
      if (success && !input.ReadDispatchEventTime(&result->dispatch_event_time))
        success = false;
      if (success && !input.ReadRespondWithSettledTime(&result->respond_with_settled_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif