// third_party/blink/public/mojom/sms/webotp_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/sms/webotp_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/sms/webotp_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SMS_WEBOTP_SERVICE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SMS_WEBOTP_SERVICE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char WebOTPService::Name_[] = "blink.mojom.WebOTPService";

class WebOTPService_Receive_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebOTPService_Receive_ForwardToCallback(
      WebOTPService::ReceiveCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebOTPService::ReceiveCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebOTPService_Receive_ForwardToCallback);
};

WebOTPServiceProxy::WebOTPServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebOTPServiceProxy::Receive(
    ReceiveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WebOTPService::Receive");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebOTPService_Receive_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebOTPService_Receive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebOTPService::Name_);
  message.set_method_name("Receive");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebOTPService_Receive_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebOTPServiceProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WebOTPService::Abort");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebOTPService_Abort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebOTPService_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebOTPService::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class WebOTPService_Receive_ProxyToResponder {
 public:
  static WebOTPService::ReceiveCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebOTPService_Receive_ProxyToResponder> proxy(
        new WebOTPService_Receive_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebOTPService_Receive_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebOTPService_Receive_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebOTPService_Receive_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebOTPService::ReceiveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmsStatus in_status, const absl::optional<std::string>& in_otp);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebOTPService_Receive_ProxyToResponder);
};

bool WebOTPService_Receive_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WebOTPService::ReceiveCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebOTPService_Receive_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebOTPService_Receive_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SmsStatus p_status{};
  absl::optional<std::string> p_otp{};
  WebOTPService_Receive_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadOtp(&p_otp))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebOTPService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_otp));
  return true;
}

void WebOTPService_Receive_ProxyToResponder::Run(
    SmsStatus in_status, const absl::optional<std::string>& in_otp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WebOTPService::ReceiveCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type SmsStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("otp"), in_otp,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebOTPService_Receive_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebOTPService_Receive_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::SmsStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->otp)::BaseType> otp_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_otp, otp_fragment);
  params->otp.Set(
      otp_fragment.is_null() ? nullptr : otp_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WebOTPService::ReceiveCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebOTPService::Name_);
  message.set_method_name("Receive");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebOTPServiceStubDispatch::Accept(
    WebOTPService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebOTPService_Receive_Name: {
      break;
    }
    case internal::kWebOTPService_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebOTPService::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebOTPService::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebOTPService_Abort_Params_Data* params =
          reinterpret_cast<internal::WebOTPService_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebOTPService_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebOTPService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort();
      return true;
    }
  }
  return false;
}

// static
bool WebOTPServiceStubDispatch::AcceptWithResponder(
    WebOTPService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebOTPService_Receive_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebOTPService::Receive",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebOTPService::Receive");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebOTPService_Receive_Params_Data* params =
          reinterpret_cast<
              internal::WebOTPService_Receive_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WebOTPService_Receive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebOTPService::Name_, 0, false);
        return false;
      }
      WebOTPService::ReceiveCallback callback =
          WebOTPService_Receive_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Receive(std::move(callback));
      return true;
    }
    case internal::kWebOTPService_Abort_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebOTPServiceValidationInfo[] = {
    {&internal::WebOTPService_Receive_Params_Data::Validate,
     &internal::WebOTPService_Receive_ResponseParams_Data::Validate},
    {&internal::WebOTPService_Abort_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebOTPServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebOTPService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebOTPServiceValidationInfo);
}

bool WebOTPServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebOTPService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWebOTPServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif