// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* SpeculationActionToStringHelper(SpeculationAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeculationAction::kPrefetch:
      return "kPrefetch";
    case SpeculationAction::kPrefetchWithSubresources:
      return "kPrefetchWithSubresources";
    case SpeculationAction::kPrerender:
      return "kPrerender";
    default:
      return nullptr;
  }
}

std::string SpeculationActionToString(SpeculationAction value) {
  const char *str = SpeculationActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeculationAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeculationAction value) {
  return os << SpeculationActionToString(value);
}

namespace internal {


// static
bool SpeculationCandidate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeculationCandidate_Data* object = static_cast<const SpeculationCandidate_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::SpeculationAction_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  return true;
}

SpeculationCandidate_Data::SpeculationCandidate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeculationHost_UpdateSpeculationCandidates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeculationHost_UpdateSpeculationCandidates_Params_Data* object = static_cast<const SpeculationHost_UpdateSpeculationCandidates_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->candidates, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams candidates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->candidates, validation_context,
                                         &candidates_validate_params)) {
    return false;
  }

  return true;
}

SpeculationHost_UpdateSpeculationCandidates_Params_Data::SpeculationHost_UpdateSpeculationCandidates_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SpeculationAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SpeculationAction value) {
  return std::move(context).WriteString(::blink::mojom::SpeculationActionToString(value));
}

} // namespace perfetto
