// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-params-data.h"
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
SpeculationCandidate::SpeculationCandidate()
    : url(),
      action(SpeculationAction::kPrefetch),
      referrer(),
      requires_anonymous_client_ip_when_cross_origin(false) {}

SpeculationCandidate::SpeculationCandidate(
    const ::GURL& url_in,
    SpeculationAction action_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    bool requires_anonymous_client_ip_when_cross_origin_in)
    : url(std::move(url_in)),
      action(std::move(action_in)),
      referrer(std::move(referrer_in)),
      requires_anonymous_client_ip_when_cross_origin(std::move(requires_anonymous_client_ip_when_cross_origin_in)) {}

SpeculationCandidate::~SpeculationCandidate() = default;

void SpeculationCandidate::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeculationAction>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requires_anonymous_client_ip_when_cross_origin"), this->requires_anonymous_client_ip_when_cross_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeculationCandidate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpeculationHost::Name_[] = "blink.mojom.SpeculationHost";

SpeculationHostProxy::SpeculationHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeculationHostProxy::UpdateSpeculationCandidates(
    std::vector<SpeculationCandidatePtr> in_candidates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeculationHost::UpdateSpeculationCandidates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("candidates"), in_candidates,
                        "<value of type std::vector<SpeculationCandidatePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeculationHost_UpdateSpeculationCandidates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->candidates)::BaseType>
      candidates_fragment(params.message());
  const mojo::internal::ContainerValidateParams candidates_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpeculationCandidateDataView>>(
      in_candidates, candidates_fragment, &candidates_validate_params);
  params->candidates.Set(
      candidates_fragment.is_null() ? nullptr : candidates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->candidates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null candidates in SpeculationHost.UpdateSpeculationCandidates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeculationHost::Name_);
  message.set_method_name("UpdateSpeculationCandidates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeculationHostStubDispatch::Accept(
    SpeculationHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeculationHost_UpdateSpeculationCandidates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeculationHost::UpdateSpeculationCandidates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeculationHost::UpdateSpeculationCandidates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data* params =
          reinterpret_cast<internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<SpeculationCandidatePtr> p_candidates{};
      SpeculationHost_UpdateSpeculationCandidates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCandidates(&p_candidates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeculationHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSpeculationCandidates(
std::move(p_candidates));
      return true;
    }
  }
  return false;
}

// static
bool SpeculationHostStubDispatch::AcceptWithResponder(
    SpeculationHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeculationHost_UpdateSpeculationCandidates_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeculationHostValidationInfo[] = {
    {&internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeculationHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeculationHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeculationHostValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::SpeculationCandidate::DataView, ::blink::mojom::SpeculationCandidatePtr>::Read(
    ::blink::mojom::SpeculationCandidate::DataView input,
    ::blink::mojom::SpeculationCandidatePtr* output) {
  bool success = true;
  ::blink::mojom::SpeculationCandidatePtr result(::blink::mojom::SpeculationCandidate::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success)
        result->requires_anonymous_client_ip_when_cross_origin = input.requires_anonymous_client_ip_when_cross_origin();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif