// third_party/blink/public/mojom/storage_access/storage_access_automation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/storage_access/storage_access_automation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/storage_access/storage_access_automation.mojom-params-data.h"
#include "third_party/blink/public/mojom/storage_access/storage_access_automation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/storage_access/storage_access_automation.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_ACCESS_STORAGE_ACCESS_AUTOMATION_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_ACCESS_STORAGE_ACCESS_AUTOMATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace test {
namespace mojom {
namespace blink {
const char StorageAccessAutomation::Name_[] = "blink.test.mojom.StorageAccessAutomation";

class StorageAccessAutomation_SetStorageAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageAccessAutomation_SetStorageAccess_ForwardToCallback(
      StorageAccessAutomation::SetStorageAccessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StorageAccessAutomation::SetStorageAccessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StorageAccessAutomation_SetStorageAccess_ForwardToCallback);
};

StorageAccessAutomationProxy::StorageAccessAutomationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageAccessAutomationProxy::SetStorageAccess(
    const WTF::String& in_origin, const WTF::String& in_embedding_origin, bool in_allowed, SetStorageAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::StorageAccessAutomation::SetStorageAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedding_origin"), in_embedding_origin,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAccessAutomation_SetStorageAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::StorageAccessAutomation_SetStorageAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in StorageAccessAutomation.SetStorageAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->embedding_origin)::BaseType> embedding_origin_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_embedding_origin, embedding_origin_fragment);
  params->embedding_origin.Set(
      embedding_origin_fragment.is_null() ? nullptr : embedding_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedding_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedding_origin in StorageAccessAutomation.SetStorageAccess request");
  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessAutomation::Name_);
  message.set_method_name("SetStorageAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageAccessAutomation_SetStorageAccess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class StorageAccessAutomation_SetStorageAccess_ProxyToResponder {
 public:
  static StorageAccessAutomation::SetStorageAccessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StorageAccessAutomation_SetStorageAccess_ProxyToResponder> proxy(
        new StorageAccessAutomation_SetStorageAccess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StorageAccessAutomation_SetStorageAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageAccessAutomation_SetStorageAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StorageAccessAutomation_SetStorageAccess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StorageAccessAutomation::SetStorageAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StorageAccessAutomation_SetStorageAccess_ProxyToResponder);
};

bool StorageAccessAutomation_SetStorageAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::StorageAccessAutomation::SetStorageAccessCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StorageAccessAutomation_SetStorageAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageAccessAutomation_SetStorageAccess_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  StorageAccessAutomation_SetStorageAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageAccessAutomation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void StorageAccessAutomation_SetStorageAccess_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::StorageAccessAutomation::SetStorageAccessCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAccessAutomation_SetStorageAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::StorageAccessAutomation_SetStorageAccess_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::StorageAccessAutomation::SetStorageAccessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessAutomation::Name_);
  message.set_method_name("SetStorageAccess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool StorageAccessAutomationStubDispatch::Accept(
    StorageAccessAutomation* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kStorageAccessAutomation_SetStorageAccess_Name: {
      break;
    }
  }
  return false;
}

// static
bool StorageAccessAutomationStubDispatch::AcceptWithResponder(
    StorageAccessAutomation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kStorageAccessAutomation_SetStorageAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::StorageAccessAutomation::SetStorageAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::StorageAccessAutomation::SetStorageAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StorageAccessAutomation_SetStorageAccess_Params_Data* params =
          reinterpret_cast<
              internal::StorageAccessAutomation_SetStorageAccess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_origin{};
      WTF::String p_embedding_origin{};
      bool p_allowed{};
      StorageAccessAutomation_SetStorageAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadEmbeddingOrigin(&p_embedding_origin))
        success = false;
      if (success)
        p_allowed = input_data_view.allowed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessAutomation::Name_, 0, false);
        return false;
      }
      StorageAccessAutomation::SetStorageAccessCallback callback =
          StorageAccessAutomation_SetStorageAccess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetStorageAccess(
std::move(p_origin), 
std::move(p_embedding_origin), 
std::move(p_allowed), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kStorageAccessAutomationValidationInfo[] = {
    {&internal::StorageAccessAutomation_SetStorageAccess_Params_Data::Validate,
     &internal::StorageAccessAutomation_SetStorageAccess_ResponseParams_Data::Validate},
};

bool StorageAccessAutomationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::blink::StorageAccessAutomation::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kStorageAccessAutomationValidationInfo);
}

bool StorageAccessAutomationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::blink::StorageAccessAutomation::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kStorageAccessAutomationValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace test
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif