// third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* AuthenticatorStatusToStringHelper(AuthenticatorStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuthenticatorStatus::SUCCESS:
      return "SUCCESS";
    case AuthenticatorStatus::PENDING_REQUEST:
      return "PENDING_REQUEST";
    case AuthenticatorStatus::NOT_ALLOWED_ERROR:
      return "NOT_ALLOWED_ERROR";
    case AuthenticatorStatus::INVALID_DOMAIN:
      return "INVALID_DOMAIN";
    case AuthenticatorStatus::INVALID_ICON_URL:
      return "INVALID_ICON_URL";
    case AuthenticatorStatus::CREDENTIAL_EXCLUDED:
      return "CREDENTIAL_EXCLUDED";
    case AuthenticatorStatus::CREDENTIAL_NOT_RECOGNIZED:
      return "CREDENTIAL_NOT_RECOGNIZED";
    case AuthenticatorStatus::NOT_IMPLEMENTED:
      return "NOT_IMPLEMENTED";
    case AuthenticatorStatus::NOT_FOCUSED:
      return "NOT_FOCUSED";
    case AuthenticatorStatus::RESIDENT_CREDENTIALS_UNSUPPORTED:
      return "RESIDENT_CREDENTIALS_UNSUPPORTED";
    case AuthenticatorStatus::USER_VERIFICATION_UNSUPPORTED:
      return "USER_VERIFICATION_UNSUPPORTED";
    case AuthenticatorStatus::ALGORITHM_UNSUPPORTED:
      return "ALGORITHM_UNSUPPORTED";
    case AuthenticatorStatus::EMPTY_ALLOW_CREDENTIALS:
      return "EMPTY_ALLOW_CREDENTIALS";
    case AuthenticatorStatus::ANDROID_NOT_SUPPORTED_ERROR:
      return "ANDROID_NOT_SUPPORTED_ERROR";
    case AuthenticatorStatus::PROTECTION_POLICY_INCONSISTENT:
      return "PROTECTION_POLICY_INCONSISTENT";
    case AuthenticatorStatus::ABORT_ERROR:
      return "ABORT_ERROR";
    case AuthenticatorStatus::OPAQUE_DOMAIN:
      return "OPAQUE_DOMAIN";
    case AuthenticatorStatus::INVALID_PROTOCOL:
      return "INVALID_PROTOCOL";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID:
      return "BAD_RELYING_PARTY_ID";
    case AuthenticatorStatus::CANNOT_READ_AND_WRITE_LARGE_BLOB:
      return "CANNOT_READ_AND_WRITE_LARGE_BLOB";
    case AuthenticatorStatus::INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB:
      return "INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB";
    case AuthenticatorStatus::FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION:
      return "FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION";
    case AuthenticatorStatus::UNKNOWN_ERROR:
      return "UNKNOWN_ERROR";
    default:
      return nullptr;
  }
}

std::string AuthenticatorStatusToString(AuthenticatorStatus value) {
  const char *str = AuthenticatorStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuthenticatorStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuthenticatorStatus value) {
  return os << AuthenticatorStatusToString(value);
}

static NOINLINE const char* AuthenticatorTransportToStringHelper(AuthenticatorTransport value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuthenticatorTransport::USB:
      return "USB";
    case AuthenticatorTransport::NFC:
      return "NFC";
    case AuthenticatorTransport::BLE:
      return "BLE";
    case AuthenticatorTransport::CABLE:
      return "CABLE";
    case AuthenticatorTransport::INTERNAL:
      return "INTERNAL";
    default:
      return nullptr;
  }
}

std::string AuthenticatorTransportToString(AuthenticatorTransport value) {
  const char *str = AuthenticatorTransportToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuthenticatorTransport value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuthenticatorTransport value) {
  return os << AuthenticatorTransportToString(value);
}

static NOINLINE const char* UserVerificationRequirementToStringHelper(UserVerificationRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserVerificationRequirement::REQUIRED:
      return "REQUIRED";
    case UserVerificationRequirement::PREFERRED:
      return "PREFERRED";
    case UserVerificationRequirement::DISCOURAGED:
      return "DISCOURAGED";
    default:
      return nullptr;
  }
}

std::string UserVerificationRequirementToString(UserVerificationRequirement value) {
  const char *str = UserVerificationRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserVerificationRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserVerificationRequirement value) {
  return os << UserVerificationRequirementToString(value);
}

static NOINLINE const char* AttestationConveyancePreferenceToStringHelper(AttestationConveyancePreference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AttestationConveyancePreference::NONE:
      return "NONE";
    case AttestationConveyancePreference::INDIRECT:
      return "INDIRECT";
    case AttestationConveyancePreference::DIRECT:
      return "DIRECT";
    case AttestationConveyancePreference::ENTERPRISE:
      return "ENTERPRISE";
    default:
      return nullptr;
  }
}

std::string AttestationConveyancePreferenceToString(AttestationConveyancePreference value) {
  const char *str = AttestationConveyancePreferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AttestationConveyancePreference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AttestationConveyancePreference value) {
  return os << AttestationConveyancePreferenceToString(value);
}

static NOINLINE const char* ResidentKeyRequirementToStringHelper(ResidentKeyRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResidentKeyRequirement::DISCOURAGED:
      return "DISCOURAGED";
    case ResidentKeyRequirement::PREFERRED:
      return "PREFERRED";
    case ResidentKeyRequirement::REQUIRED:
      return "REQUIRED";
    default:
      return nullptr;
  }
}

std::string ResidentKeyRequirementToString(ResidentKeyRequirement value) {
  const char *str = ResidentKeyRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResidentKeyRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResidentKeyRequirement value) {
  return os << ResidentKeyRequirementToString(value);
}

static NOINLINE const char* AuthenticatorAttachmentToStringHelper(AuthenticatorAttachment value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuthenticatorAttachment::NO_PREFERENCE:
      return "NO_PREFERENCE";
    case AuthenticatorAttachment::PLATFORM:
      return "PLATFORM";
    case AuthenticatorAttachment::CROSS_PLATFORM:
      return "CROSS_PLATFORM";
    default:
      return nullptr;
  }
}

std::string AuthenticatorAttachmentToString(AuthenticatorAttachment value) {
  const char *str = AuthenticatorAttachmentToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuthenticatorAttachment value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuthenticatorAttachment value) {
  return os << AuthenticatorAttachmentToString(value);
}

static NOINLINE const char* ProtectionPolicyToStringHelper(ProtectionPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProtectionPolicy::UNSPECIFIED:
      return "UNSPECIFIED";
    case ProtectionPolicy::NONE:
      return "NONE";
    case ProtectionPolicy::UV_OR_CRED_ID_REQUIRED:
      return "UV_OR_CRED_ID_REQUIRED";
    case ProtectionPolicy::UV_REQUIRED:
      return "UV_REQUIRED";
    default:
      return nullptr;
  }
}

std::string ProtectionPolicyToString(ProtectionPolicy value) {
  const char *str = ProtectionPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProtectionPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProtectionPolicy value) {
  return os << ProtectionPolicyToString(value);
}

static NOINLINE const char* LargeBlobSupportToStringHelper(LargeBlobSupport value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LargeBlobSupport::NOT_REQUESTED:
      return "NOT_REQUESTED";
    case LargeBlobSupport::REQUIRED:
      return "REQUIRED";
    case LargeBlobSupport::PREFERRED:
      return "PREFERRED";
    default:
      return nullptr;
  }
}

std::string LargeBlobSupportToString(LargeBlobSupport value) {
  const char *str = LargeBlobSupportToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LargeBlobSupport value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LargeBlobSupport value) {
  return os << LargeBlobSupportToString(value);
}

static NOINLINE const char* PublicKeyCredentialTypeToStringHelper(PublicKeyCredentialType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PublicKeyCredentialType::PUBLIC_KEY:
      return "PUBLIC_KEY";
    default:
      return nullptr;
  }
}

std::string PublicKeyCredentialTypeToString(PublicKeyCredentialType value) {
  const char *str = PublicKeyCredentialTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PublicKeyCredentialType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PublicKeyCredentialType value) {
  return os << PublicKeyCredentialTypeToString(value);
}

namespace internal {


// static
bool CommonCredentialInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CommonCredentialInfo_Data* object = static_cast<const CommonCredentialInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams raw_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->raw_id, validation_context,
                                         &raw_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_data_json, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams client_data_json_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->client_data_json, validation_context,
                                         &client_data_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->authenticator_data, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams authenticator_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->authenticator_data, validation_context,
                                         &authenticator_data_validate_params)) {
    return false;
  }

  return true;
}

CommonCredentialInfo_Data::CommonCredentialInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MakeCredentialAuthenticatorResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MakeCredentialAuthenticatorResponse_Data* object = static_cast<const MakeCredentialAuthenticatorResponse_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attestation_object, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams attestation_object_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->attestation_object, validation_context,
                                         &attestation_object_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transports, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transports_validate_params(
      0, ::blink::mojom::internal::AuthenticatorTransport_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->transports, validation_context,
                                         &transports_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams public_key_der_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->public_key_der, validation_context,
                                         &public_key_der_validate_params)) {
    return false;
  }

  return true;
}

MakeCredentialAuthenticatorResponse_Data::MakeCredentialAuthenticatorResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetAssertionAuthenticatorResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GetAssertionAuthenticatorResponse_Data* object = static_cast<const GetAssertionAuthenticatorResponse_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams user_handle_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_handle, validation_context,
                                         &user_handle_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->prf_results, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams large_blob_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->large_blob, validation_context,
                                         &large_blob_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams get_cred_blob_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->get_cred_blob, validation_context,
                                         &get_cred_blob_validate_params)) {
    return false;
  }

  return true;
}

GetAssertionAuthenticatorResponse_Data::GetAssertionAuthenticatorResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialRpEntity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PublicKeyCredentialRpEntity_Data* object = static_cast<const PublicKeyCredentialRpEntity_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  return true;
}

PublicKeyCredentialRpEntity_Data::PublicKeyCredentialRpEntity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialUserEntity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PublicKeyCredentialUserEntity_Data* object = static_cast<const PublicKeyCredentialUserEntity_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams display_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialUserEntity_Data::PublicKeyCredentialUserEntity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PublicKeyCredentialParameters_Data* object = static_cast<const PublicKeyCredentialParameters_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::PublicKeyCredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

PublicKeyCredentialParameters_Data::PublicKeyCredentialParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CableAuthentication_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CableAuthentication_Data* object = static_cast<const CableAuthentication_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams client_eid_validate_params(
      16, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->client_eid, validation_context,
                                         &client_eid_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams authenticator_eid_validate_params(
      16, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->authenticator_eid, validation_context,
                                         &authenticator_eid_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams session_pre_key_validate_params(
      32, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->session_pre_key, validation_context,
                                         &session_pre_key_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams server_link_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_link_data, validation_context,
                                         &server_link_data_validate_params)) {
    return false;
  }

  return true;
}

CableAuthentication_Data::CableAuthentication_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CableRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CableRegistration_Data* object = static_cast<const CableRegistration_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->versions, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams versions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->versions, validation_context,
                                         &versions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relying_party_public_key, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams relying_party_public_key_validate_params(
      65, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->relying_party_public_key, validation_context,
                                         &relying_party_public_key_validate_params)) {
    return false;
  }

  return true;
}

CableRegistration_Data::CableRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PRFValues_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PRFValues_Data* object = static_cast<const PRFValues_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->first, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams first_validate_params(
      32, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->first, validation_context,
                                         &first_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams second_validate_params(
      32, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->second, validation_context,
                                         &second_validate_params)) {
    return false;
  }

  return true;
}

PRFValues_Data::PRFValues_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaymentOptions_Data* object = static_cast<const PaymentOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;

  return true;
}

PaymentOptions_Data::PaymentOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialRequestOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PublicKeyCredentialRequestOptions_Data* object = static_cast<const PublicKeyCredentialRequestOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenge, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams challenge_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->challenge, validation_context,
                                         &challenge_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relying_party_id, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams relying_party_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->relying_party_id, validation_context,
                                         &relying_party_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allow_credentials, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams allow_credentials_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->allow_credentials, validation_context,
                                         &allow_credentials_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::UserVerificationRequirement_Data
        ::Validate(object->user_verification, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams appid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->appid, validation_context,
                                         &appid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cable_authentication_data, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cable_authentication_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cable_authentication_data, validation_context,
                                         &cable_authentication_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prf_inputs, 10, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams prf_inputs_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->prf_inputs, validation_context,
                                         &prf_inputs_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams large_blob_write_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->large_blob_write, validation_context,
                                         &large_blob_write_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialRequestOptions_Data::PublicKeyCredentialRequestOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticatorSelectionCriteria_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthenticatorSelectionCriteria_Data* object = static_cast<const AuthenticatorSelectionCriteria_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::AuthenticatorAttachment_Data
        ::Validate(object->authenticator_attachment, validation_context))
    return false;


  if (!::blink::mojom::internal::ResidentKeyRequirement_Data
        ::Validate(object->resident_key, validation_context))
    return false;


  if (!::blink::mojom::internal::UserVerificationRequirement_Data
        ::Validate(object->user_verification, validation_context))
    return false;

  return true;
}

AuthenticatorSelectionCriteria_Data::AuthenticatorSelectionCriteria_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialCreationOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PublicKeyCredentialCreationOptions_Data* object = static_cast<const PublicKeyCredentialCreationOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relying_party, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relying_party, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenge, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams challenge_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->challenge, validation_context,
                                         &challenge_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key_parameters, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams public_key_parameters_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->public_key_parameters, validation_context,
                                         &public_key_parameters_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclude_credentials, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams exclude_credentials_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->exclude_credentials, validation_context,
                                         &exclude_credentials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->authenticator_selection, validation_context))
    return false;


  if (!::blink::mojom::internal::AttestationConveyancePreference_Data
        ::Validate(object->attestation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cable_registration_data, validation_context))
    return false;


  if (!::blink::mojom::internal::ProtectionPolicy_Data
        ::Validate(object->protection_policy, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams appid_exclude_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->appid_exclude, validation_context,
                                         &appid_exclude_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::LargeBlobSupport_Data
        ::Validate(object->large_blob_enable, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams cred_blob_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cred_blob, validation_context,
                                         &cred_blob_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialCreationOptions_Data::PublicKeyCredentialCreationOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PublicKeyCredentialDescriptor_Data* object = static_cast<const PublicKeyCredentialDescriptor_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::PublicKeyCredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transports, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transports_validate_params(
      0, ::blink::mojom::internal::AuthenticatorTransport_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->transports, validation_context,
                                         &transports_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialDescriptor_Data::PublicKeyCredentialDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_MakeCredential_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_MakeCredential_Params_Data* object = static_cast<const Authenticator_MakeCredential_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

Authenticator_MakeCredential_Params_Data::Authenticator_MakeCredential_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_MakeCredential_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_MakeCredential_ResponseParams_Data* object = static_cast<const Authenticator_MakeCredential_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::AuthenticatorStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

Authenticator_MakeCredential_ResponseParams_Data::Authenticator_MakeCredential_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_GetAssertion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_GetAssertion_Params_Data* object = static_cast<const Authenticator_GetAssertion_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

Authenticator_GetAssertion_Params_Data::Authenticator_GetAssertion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_GetAssertion_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_GetAssertion_ResponseParams_Data* object = static_cast<const Authenticator_GetAssertion_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::AuthenticatorStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

Authenticator_GetAssertion_ResponseParams_Data::Authenticator_GetAssertion_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* object = static_cast<const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* object = static_cast<const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Authenticator_Cancel_Params_Data* object = static_cast<const Authenticator_Cancel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Authenticator_Cancel_Params_Data::Authenticator_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuthenticatorStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuthenticatorStatus value) {
  return std::move(context).WriteString(::blink::mojom::AuthenticatorStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuthenticatorTransport>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuthenticatorTransport value) {
  return std::move(context).WriteString(::blink::mojom::AuthenticatorTransportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::UserVerificationRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::UserVerificationRequirement value) {
  return std::move(context).WriteString(::blink::mojom::UserVerificationRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AttestationConveyancePreference>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AttestationConveyancePreference value) {
  return std::move(context).WriteString(::blink::mojom::AttestationConveyancePreferenceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ResidentKeyRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ResidentKeyRequirement value) {
  return std::move(context).WriteString(::blink::mojom::ResidentKeyRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuthenticatorAttachment>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuthenticatorAttachment value) {
  return std::move(context).WriteString(::blink::mojom::AuthenticatorAttachmentToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ProtectionPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ProtectionPolicy value) {
  return std::move(context).WriteString(::blink::mojom::ProtectionPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LargeBlobSupport>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::LargeBlobSupport value) {
  return std::move(context).WriteString(::blink::mojom::LargeBlobSupportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PublicKeyCredentialType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PublicKeyCredentialType value) {
  return std::move(context).WriteString(::blink::mojom::PublicKeyCredentialTypeToString(value));
}

} // namespace perfetto
