// third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-params-data.h"
#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace test {
namespace mojom {
VirtualAuthenticatorOptions::VirtualAuthenticatorOptions()
    : protocol(),
      ctap2_version(),
      transport(),
      attachment(),
      has_resident_key(),
      has_user_verification(),
      is_user_present(true),
      has_large_blob(),
      has_cred_blob() {}

VirtualAuthenticatorOptions::VirtualAuthenticatorOptions(
    ::device::ProtocolVersion protocol_in,
    ::device::Ctap2Version ctap2_version_in,
    ::device::FidoTransportProtocol transport_in,
    ::device::AuthenticatorAttachment attachment_in,
    bool has_resident_key_in,
    bool has_user_verification_in,
    bool is_user_present_in,
    bool has_large_blob_in,
    bool has_cred_blob_in)
    : protocol(std::move(protocol_in)),
      ctap2_version(std::move(ctap2_version_in)),
      transport(std::move(transport_in)),
      attachment(std::move(attachment_in)),
      has_resident_key(std::move(has_resident_key_in)),
      has_user_verification(std::move(has_user_verification_in)),
      is_user_present(std::move(is_user_present_in)),
      has_large_blob(std::move(has_large_blob_in)),
      has_cred_blob(std::move(has_cred_blob_in)) {}

VirtualAuthenticatorOptions::~VirtualAuthenticatorOptions() = default;

void VirtualAuthenticatorOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::ProtocolVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ctap2_version"), this->ctap2_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::Ctap2Version>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport"), this->transport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::FidoTransportProtocol>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attachment"), this->attachment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::AuthenticatorAttachment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_resident_key"), this->has_resident_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_verification"), this->has_user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_user_present"), this->is_user_present,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_large_blob"), this->has_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_cred_blob"), this->has_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VirtualAuthenticatorOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RegisteredKey::RegisteredKey()
    : key_handle(),
      rp_id(),
      private_key(),
      counter() {}

RegisteredKey::RegisteredKey(
    std::vector<uint8_t> key_handle_in,
    const std::string& rp_id_in,
    std::vector<uint8_t> private_key_in,
    int32_t counter_in)
    : key_handle(std::move(key_handle_in)),
      rp_id(std::move(rp_id_in)),
      private_key(std::move(private_key_in)),
      counter(std::move(counter_in)) {}

RegisteredKey::~RegisteredKey() = default;

void RegisteredKey::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_handle"), this->key_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rp_id"), this->rp_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_key"), this->private_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "counter"), this->counter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RegisteredKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char VirtualAuthenticator::Name_[] = "blink.test.mojom.VirtualAuthenticator";

class VirtualAuthenticator_GetUniqueId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_GetUniqueId_ForwardToCallback(
      VirtualAuthenticator::GetUniqueIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::GetUniqueIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetUniqueId_ForwardToCallback);
};

class VirtualAuthenticator_AddRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_AddRegistration_ForwardToCallback(
      VirtualAuthenticator::AddRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::AddRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_AddRegistration_ForwardToCallback);
};

class VirtualAuthenticator_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_GetRegistrations_ForwardToCallback(
      VirtualAuthenticator::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::GetRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetRegistrations_ForwardToCallback);
};

class VirtualAuthenticator_RemoveRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_RemoveRegistration_ForwardToCallback(
      VirtualAuthenticator::RemoveRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::RemoveRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_RemoveRegistration_ForwardToCallback);
};

class VirtualAuthenticator_ClearRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_ClearRegistrations_ForwardToCallback(
      VirtualAuthenticator::ClearRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::ClearRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_ClearRegistrations_ForwardToCallback);
};

class VirtualAuthenticator_GetLargeBlob_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_GetLargeBlob_ForwardToCallback(
      VirtualAuthenticator::GetLargeBlobCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::GetLargeBlobCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetLargeBlob_ForwardToCallback);
};

class VirtualAuthenticator_SetLargeBlob_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_SetLargeBlob_ForwardToCallback(
      VirtualAuthenticator::SetLargeBlobCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::SetLargeBlobCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_SetLargeBlob_ForwardToCallback);
};

class VirtualAuthenticator_SetUserVerified_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticator_SetUserVerified_ForwardToCallback(
      VirtualAuthenticator::SetUserVerifiedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticator::SetUserVerifiedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_SetUserVerified_ForwardToCallback);
};

VirtualAuthenticatorProxy::VirtualAuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VirtualAuthenticatorProxy::GetUniqueId(
    GetUniqueIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticator::GetUniqueId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetUniqueId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_GetUniqueId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetUniqueId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_GetUniqueId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::AddRegistration(
    RegisteredKeyPtr in_key, AddRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::AddRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type RegisteredKeyPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_AddRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_AddRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::test::mojom::RegisteredKeyDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in VirtualAuthenticator.AddRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("AddRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_AddRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::GetRegistrations(
    GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticator::GetRegistrations");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::RemoveRegistration(
    const std::vector<uint8_t>& in_key_handle, RemoveRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::RemoveRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_handle"), in_key_handle,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_RemoveRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_RemoveRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_handle)::BaseType>
      key_handle_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_handle_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key_handle, key_handle_fragment, &key_handle_validate_params);
  params->key_handle.Set(
      key_handle_fragment.is_null() ? nullptr : key_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_handle in VirtualAuthenticator.RemoveRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("RemoveRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_RemoveRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::ClearRegistrations(
    ClearRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticator::ClearRegistrations");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_ClearRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_ClearRegistrations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("ClearRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_ClearRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::GetLargeBlob(
    const std::vector<uint8_t>& in_key_handle, GetLargeBlobCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::GetLargeBlob", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_handle"), in_key_handle,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetLargeBlob_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_GetLargeBlob_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_handle)::BaseType>
      key_handle_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_handle_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key_handle, key_handle_fragment, &key_handle_validate_params);
  params->key_handle.Set(
      key_handle_fragment.is_null() ? nullptr : key_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_handle in VirtualAuthenticator.GetLargeBlob request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetLargeBlob");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_GetLargeBlob_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::SetLargeBlob(
    const std::vector<uint8_t>& in_key_handle, const std::vector<uint8_t>& in_blob, SetLargeBlobCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::SetLargeBlob", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_handle"), in_key_handle,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_SetLargeBlob_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_SetLargeBlob_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_handle)::BaseType>
      key_handle_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_handle_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key_handle, key_handle_fragment, &key_handle_validate_params);
  params->key_handle.Set(
      key_handle_fragment.is_null() ? nullptr : key_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_handle in VirtualAuthenticator.SetLargeBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType>
      blob_fragment(params.message());
  const mojo::internal::ContainerValidateParams blob_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_blob, blob_fragment, &blob_validate_params);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->blob.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blob in VirtualAuthenticator.SetLargeBlob request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("SetLargeBlob");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_SetLargeBlob_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorProxy::SetUserVerified(
    bool in_verified, SetUserVerifiedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticator::SetUserVerified", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("verified"), in_verified,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_SetUserVerified_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_SetUserVerified_Params_Data> params(
          message);
  params.Allocate();
  params->verified = in_verified;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("SetUserVerified");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticator_SetUserVerified_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VirtualAuthenticator_GetUniqueId_ProxyToResponder {
 public:
  static VirtualAuthenticator::GetUniqueIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_GetUniqueId_ProxyToResponder> proxy(
        new VirtualAuthenticator_GetUniqueId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_GetUniqueId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_GetUniqueId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_GetUniqueId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::GetUniqueIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetUniqueId_ProxyToResponder);
};

bool VirtualAuthenticator_GetUniqueId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::GetUniqueIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_id{};
  VirtualAuthenticator_GetUniqueId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_id));
  return true;
}

void VirtualAuthenticator_GetUniqueId_ProxyToResponder::Run(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetUniqueId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetUniqueId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_AddRegistration_ProxyToResponder {
 public:
  static VirtualAuthenticator::AddRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_AddRegistration_ProxyToResponder> proxy(
        new VirtualAuthenticator_AddRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_AddRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_AddRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_AddRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::AddRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_added);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_AddRegistration_ProxyToResponder);
};

bool VirtualAuthenticator_AddRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::AddRegistrationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_added{};
  VirtualAuthenticator_AddRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_added = input_data_view.added();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_added));
  return true;
}

void VirtualAuthenticator_AddRegistration_ProxyToResponder::Run(
    bool in_added) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistrationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("added"), in_added,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_AddRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->added = in_added;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("AddRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_GetRegistrations_ProxyToResponder {
 public:
  static VirtualAuthenticator::GetRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_GetRegistrations_ProxyToResponder> proxy(
        new VirtualAuthenticator_GetRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_GetRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::GetRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<RegisteredKeyPtr> in_keys);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetRegistrations_ProxyToResponder);
};

bool VirtualAuthenticator_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::GetRegistrationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<RegisteredKeyPtr> p_keys{};
  VirtualAuthenticator_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_keys));
  return true;
}

void VirtualAuthenticator_GetRegistrations_ProxyToResponder::Run(
    std::vector<RegisteredKeyPtr> in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrationsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type std::vector<RegisteredKeyPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::test::mojom::RegisteredKeyDataView>>(
      in_keys, keys_fragment, &keys_validate_params);
  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_RemoveRegistration_ProxyToResponder {
 public:
  static VirtualAuthenticator::RemoveRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_RemoveRegistration_ProxyToResponder> proxy(
        new VirtualAuthenticator_RemoveRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_RemoveRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_RemoveRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_RemoveRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::RemoveRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_removed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_RemoveRegistration_ProxyToResponder);
};

bool VirtualAuthenticator_RemoveRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::RemoveRegistrationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_removed{};
  VirtualAuthenticator_RemoveRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_removed = input_data_view.removed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_removed));
  return true;
}

void VirtualAuthenticator_RemoveRegistration_ProxyToResponder::Run(
    bool in_removed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistrationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed"), in_removed,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_RemoveRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->removed = in_removed;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("RemoveRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_ClearRegistrations_ProxyToResponder {
 public:
  static VirtualAuthenticator::ClearRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_ClearRegistrations_ProxyToResponder> proxy(
        new VirtualAuthenticator_ClearRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_ClearRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_ClearRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_ClearRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::ClearRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_ClearRegistrations_ProxyToResponder);
};

bool VirtualAuthenticator_ClearRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::ClearRegistrationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VirtualAuthenticator_ClearRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VirtualAuthenticator_ClearRegistrations_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrationsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_ClearRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("ClearRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_GetLargeBlob_ProxyToResponder {
 public:
  static VirtualAuthenticator::GetLargeBlobCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_GetLargeBlob_ProxyToResponder> proxy(
        new VirtualAuthenticator_GetLargeBlob_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_GetLargeBlob_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_GetLargeBlob_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_GetLargeBlob_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::GetLargeBlobCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<std::vector<uint8_t>>& in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_GetLargeBlob_ProxyToResponder);
};

bool VirtualAuthenticator_GetLargeBlob_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::GetLargeBlobCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_GetLargeBlob_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_GetLargeBlob_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<std::vector<uint8_t>> p_blob{};
  VirtualAuthenticator_GetLargeBlob_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void VirtualAuthenticator_GetLargeBlob_ProxyToResponder::Run(
    const absl::optional<std::vector<uint8_t>>& in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetLargeBlobCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type const absl::optional<std::vector<uint8_t>>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_GetLargeBlob_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_GetLargeBlob_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType>
      blob_fragment(params.message());
  const mojo::internal::ContainerValidateParams blob_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_blob, blob_fragment, &blob_validate_params);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::GetLargeBlobCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("GetLargeBlob");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_SetLargeBlob_ProxyToResponder {
 public:
  static VirtualAuthenticator::SetLargeBlobCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_SetLargeBlob_ProxyToResponder> proxy(
        new VirtualAuthenticator_SetLargeBlob_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_SetLargeBlob_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_SetLargeBlob_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_SetLargeBlob_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::SetLargeBlobCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_set);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_SetLargeBlob_ProxyToResponder);
};

bool VirtualAuthenticator_SetLargeBlob_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::SetLargeBlobCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_SetLargeBlob_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_SetLargeBlob_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_set{};
  VirtualAuthenticator_SetLargeBlob_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_set = input_data_view.set();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_set));
  return true;
}

void VirtualAuthenticator_SetLargeBlob_ProxyToResponder::Run(
    bool in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::SetLargeBlobCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_SetLargeBlob_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_SetLargeBlob_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->set = in_set;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::SetLargeBlobCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("SetLargeBlob");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticator_SetUserVerified_ProxyToResponder {
 public:
  static VirtualAuthenticator::SetUserVerifiedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticator_SetUserVerified_ProxyToResponder> proxy(
        new VirtualAuthenticator_SetUserVerified_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticator_SetUserVerified_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticator_SetUserVerified_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticator_SetUserVerified_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticator::SetUserVerifiedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticator_SetUserVerified_ProxyToResponder);
};

bool VirtualAuthenticator_SetUserVerified_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticator::SetUserVerifiedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VirtualAuthenticator_SetUserVerified_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticator::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VirtualAuthenticator_SetUserVerified_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerifiedCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticator_SetUserVerified_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerifiedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticator::Name_);
  message.set_method_name("SetUserVerified");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VirtualAuthenticatorStubDispatch::Accept(
    VirtualAuthenticator* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVirtualAuthenticator_GetUniqueId_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_AddRegistration_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_GetRegistrations_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_RemoveRegistration_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_ClearRegistrations_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_GetLargeBlob_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_SetLargeBlob_Name: {
      break;
    }
    case internal::kVirtualAuthenticator_SetUserVerified_Name: {
      break;
    }
  }
  return false;
}

// static
bool VirtualAuthenticatorStubDispatch::AcceptWithResponder(
    VirtualAuthenticator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVirtualAuthenticator_GetUniqueId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::GetUniqueId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_GetUniqueId_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_GetUniqueId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticator_GetUniqueId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 0, false);
        return false;
      }
      VirtualAuthenticator::GetUniqueIdCallback callback =
          VirtualAuthenticator_GetUniqueId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUniqueId(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_AddRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::AddRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_AddRegistration_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_AddRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RegisteredKeyPtr p_key{};
      VirtualAuthenticator_AddRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 1, false);
        return false;
      }
      VirtualAuthenticator::AddRegistrationCallback callback =
          VirtualAuthenticator_AddRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddRegistration(
std::move(p_key), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_GetRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::GetRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticator_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 2, false);
        return false;
      }
      VirtualAuthenticator::GetRegistrationsCallback callback =
          VirtualAuthenticator_GetRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_RemoveRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::RemoveRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_RemoveRegistration_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_RemoveRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key_handle{};
      VirtualAuthenticator_RemoveRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyHandle(&p_key_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 3, false);
        return false;
      }
      VirtualAuthenticator::RemoveRegistrationCallback callback =
          VirtualAuthenticator_RemoveRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveRegistration(
std::move(p_key_handle), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_ClearRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::ClearRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_ClearRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_ClearRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticator_ClearRegistrations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 4, false);
        return false;
      }
      VirtualAuthenticator::ClearRegistrationsCallback callback =
          VirtualAuthenticator_ClearRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearRegistrations(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_GetLargeBlob_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::GetLargeBlob",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::GetLargeBlob");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_GetLargeBlob_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_GetLargeBlob_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key_handle{};
      VirtualAuthenticator_GetLargeBlob_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyHandle(&p_key_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 5, false);
        return false;
      }
      VirtualAuthenticator::GetLargeBlobCallback callback =
          VirtualAuthenticator_GetLargeBlob_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLargeBlob(
std::move(p_key_handle), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_SetLargeBlob_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::SetLargeBlob",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::SetLargeBlob");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_SetLargeBlob_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_SetLargeBlob_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key_handle{};
      std::vector<uint8_t> p_blob{};
      VirtualAuthenticator_SetLargeBlob_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyHandle(&p_key_handle))
        success = false;
      if (success && !input_data_view.ReadBlob(&p_blob))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 6, false);
        return false;
      }
      VirtualAuthenticator::SetLargeBlobCallback callback =
          VirtualAuthenticator_SetLargeBlob_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLargeBlob(
std::move(p_key_handle), 
std::move(p_blob), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticator_SetUserVerified_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerified",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticator::SetUserVerified");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticator_SetUserVerified_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticator_SetUserVerified_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_verified{};
      VirtualAuthenticator_SetUserVerified_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_verified = input_data_view.verified();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticator::Name_, 7, false);
        return false;
      }
      VirtualAuthenticator::SetUserVerifiedCallback callback =
          VirtualAuthenticator_SetUserVerified_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserVerified(
std::move(p_verified), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kVirtualAuthenticatorValidationInfo[] = {
    {&internal::VirtualAuthenticator_GetUniqueId_Params_Data::Validate,
     &internal::VirtualAuthenticator_GetUniqueId_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_AddRegistration_Params_Data::Validate,
     &internal::VirtualAuthenticator_AddRegistration_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_GetRegistrations_Params_Data::Validate,
     &internal::VirtualAuthenticator_GetRegistrations_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_RemoveRegistration_Params_Data::Validate,
     &internal::VirtualAuthenticator_RemoveRegistration_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_ClearRegistrations_Params_Data::Validate,
     &internal::VirtualAuthenticator_ClearRegistrations_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_GetLargeBlob_Params_Data::Validate,
     &internal::VirtualAuthenticator_GetLargeBlob_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_SetLargeBlob_Params_Data::Validate,
     &internal::VirtualAuthenticator_SetLargeBlob_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticator_SetUserVerified_Params_Data::Validate,
     &internal::VirtualAuthenticator_SetUserVerified_ResponseParams_Data::Validate},
};

bool VirtualAuthenticatorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticator::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kVirtualAuthenticatorValidationInfo);
}

bool VirtualAuthenticatorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticator::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kVirtualAuthenticatorValidationInfo);
}
const char VirtualAuthenticatorManager::Name_[] = "blink.test.mojom.VirtualAuthenticatorManager";

class VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback(
      VirtualAuthenticatorManager::CreateAuthenticatorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::CreateAuthenticatorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback);
};

class VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback(
      VirtualAuthenticatorManager::GetAuthenticatorsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::GetAuthenticatorsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback);
};

class VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback(
      VirtualAuthenticatorManager::RemoveAuthenticatorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::RemoveAuthenticatorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback);
};

class VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback(
      VirtualAuthenticatorManager::ClearAuthenticatorsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VirtualAuthenticatorManager::ClearAuthenticatorsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback);
};

VirtualAuthenticatorManagerProxy::VirtualAuthenticatorManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VirtualAuthenticatorManagerProxy::CreateAuthenticator(
    VirtualAuthenticatorOptionsPtr in_options, CreateAuthenticatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type VirtualAuthenticatorOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::test::mojom::VirtualAuthenticatorOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in VirtualAuthenticatorManager.CreateAuthenticator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("CreateAuthenticator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorManagerProxy::GetAuthenticators(
    GetAuthenticatorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticators");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_GetAuthenticators_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("GetAuthenticators");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorManagerProxy::RemoveAuthenticator(
    const std::string& in_id, RemoveAuthenticatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in VirtualAuthenticatorManager.RemoveAuthenticator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("RemoveAuthenticator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VirtualAuthenticatorManagerProxy::ClearAuthenticators(
    ClearAuthenticatorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticators");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("ClearAuthenticators");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::CreateAuthenticatorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::CreateAuthenticatorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<VirtualAuthenticator> in_authenticator);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder);
};

bool VirtualAuthenticatorManager_CreateAuthenticator_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticatorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<VirtualAuthenticator> p_authenticator{};
  VirtualAuthenticatorManager_CreateAuthenticator_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_authenticator =
        input_data_view.TakeAuthenticator<decltype(p_authenticator)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_authenticator));
  return true;
}

void VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder::Run(
    ::mojo::PendingRemote<VirtualAuthenticator> in_authenticator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticatorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("authenticator"), in_authenticator,
                        "<value of type ::mojo::PendingRemote<VirtualAuthenticator>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::test::mojom::VirtualAuthenticatorInterfaceBase>>(
      in_authenticator, &params->authenticator, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->authenticator),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid authenticator in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticatorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("CreateAuthenticator");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::GetAuthenticatorsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::GetAuthenticatorsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::mojo::PendingRemote<VirtualAuthenticator>> in_authenticators);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder);
};

bool VirtualAuthenticatorManager_GetAuthenticators_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticatorsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::mojo::PendingRemote<VirtualAuthenticator>> p_authenticators{};
  VirtualAuthenticatorManager_GetAuthenticators_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAuthenticators(&p_authenticators))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_authenticators));
  return true;
}

void VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder::Run(
    std::vector<::mojo::PendingRemote<VirtualAuthenticator>> in_authenticators) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticatorsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("authenticators"), in_authenticators,
                        "<value of type std::vector<::mojo::PendingRemote<VirtualAuthenticator>>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_GetAuthenticators_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->authenticators)::BaseType>
      authenticators_fragment(params.message());
  const mojo::internal::ContainerValidateParams authenticators_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::test::mojom::VirtualAuthenticatorInterfaceBase>>>(
      in_authenticators, authenticators_fragment, &authenticators_validate_params);
  params->authenticators.Set(
      authenticators_fragment.is_null() ? nullptr : authenticators_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->authenticators.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null authenticators in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticatorsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("GetAuthenticators");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::RemoveAuthenticatorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::RemoveAuthenticatorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_removed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder);
};

bool VirtualAuthenticatorManager_RemoveAuthenticator_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticatorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_removed{};
  VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_removed = input_data_view.removed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_removed));
  return true;
}

void VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder::Run(
    bool in_removed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticatorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed"), in_removed,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->removed = in_removed;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticatorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("RemoveAuthenticator");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder {
 public:
  static VirtualAuthenticatorManager::ClearAuthenticatorsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder> proxy(
        new VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VirtualAuthenticatorManager::ClearAuthenticatorsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder);
};

bool VirtualAuthenticatorManager_ClearAuthenticators_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticatorsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VirtualAuthenticatorManager_ClearAuthenticators_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VirtualAuthenticatorManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticatorsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticatorsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VirtualAuthenticatorManager::Name_);
  message.set_method_name("ClearAuthenticators");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VirtualAuthenticatorManagerStubDispatch::Accept(
    VirtualAuthenticatorManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name: {
      break;
    }
    case internal::kVirtualAuthenticatorManager_GetAuthenticators_Name: {
      break;
    }
    case internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name: {
      break;
    }
    case internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name: {
      break;
    }
  }
  return false;
}

// static
bool VirtualAuthenticatorManagerStubDispatch::AcceptWithResponder(
    VirtualAuthenticatorManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVirtualAuthenticatorManager_CreateAuthenticator_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticator",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::CreateAuthenticator");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticatorOptionsPtr p_options{};
      VirtualAuthenticatorManager_CreateAuthenticator_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 0, false);
        return false;
      }
      VirtualAuthenticatorManager::CreateAuthenticatorCallback callback =
          VirtualAuthenticatorManager_CreateAuthenticator_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAuthenticator(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticatorManager_GetAuthenticators_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticators",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::GetAuthenticators");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticatorManager_GetAuthenticators_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 1, false);
        return false;
      }
      VirtualAuthenticatorManager::GetAuthenticatorsCallback callback =
          VirtualAuthenticatorManager_GetAuthenticators_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAuthenticators(std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticatorManager_RemoveAuthenticator_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticator",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::RemoveAuthenticator");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_id{};
      VirtualAuthenticatorManager_RemoveAuthenticator_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 2, false);
        return false;
      }
      VirtualAuthenticatorManager::RemoveAuthenticatorCallback callback =
          VirtualAuthenticatorManager_RemoveAuthenticator_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveAuthenticator(
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kVirtualAuthenticatorManager_ClearAuthenticators_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticators",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::VirtualAuthenticatorManager::ClearAuthenticators");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data* params =
          reinterpret_cast<
              internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VirtualAuthenticatorManager_ClearAuthenticators_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VirtualAuthenticatorManager::Name_, 3, false);
        return false;
      }
      VirtualAuthenticatorManager::ClearAuthenticatorsCallback callback =
          VirtualAuthenticatorManager_ClearAuthenticators_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearAuthenticators(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kVirtualAuthenticatorManagerValidationInfo[] = {
    {&internal::VirtualAuthenticatorManager_CreateAuthenticator_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_CreateAuthenticator_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticatorManager_GetAuthenticators_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_GetAuthenticators_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticatorManager_RemoveAuthenticator_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_RemoveAuthenticator_ResponseParams_Data::Validate},
    {&internal::VirtualAuthenticatorManager_ClearAuthenticators_Params_Data::Validate,
     &internal::VirtualAuthenticatorManager_ClearAuthenticators_ResponseParams_Data::Validate},
};

bool VirtualAuthenticatorManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticatorManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kVirtualAuthenticatorManagerValidationInfo);
}

bool VirtualAuthenticatorManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::VirtualAuthenticatorManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kVirtualAuthenticatorManagerValidationInfo);
}
}  // namespace mojom
}  // namespace test
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::test::mojom::VirtualAuthenticatorOptions::DataView, ::blink::test::mojom::VirtualAuthenticatorOptionsPtr>::Read(
    ::blink::test::mojom::VirtualAuthenticatorOptions::DataView input,
    ::blink::test::mojom::VirtualAuthenticatorOptionsPtr* output) {
  bool success = true;
  ::blink::test::mojom::VirtualAuthenticatorOptionsPtr result(::blink::test::mojom::VirtualAuthenticatorOptions::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadCtap2Version(&result->ctap2_version))
        success = false;
      if (success && !input.ReadTransport(&result->transport))
        success = false;
      if (success && !input.ReadAttachment(&result->attachment))
        success = false;
      if (success)
        result->has_resident_key = input.has_resident_key();
      if (success)
        result->has_user_verification = input.has_user_verification();
      if (success)
        result->is_user_present = input.is_user_present();
      if (success)
        result->has_large_blob = input.has_large_blob();
      if (success)
        result->has_cred_blob = input.has_cred_blob();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::test::mojom::RegisteredKey::DataView, ::blink::test::mojom::RegisteredKeyPtr>::Read(
    ::blink::test::mojom::RegisteredKey::DataView input,
    ::blink::test::mojom::RegisteredKeyPtr* output) {
  bool success = true;
  ::blink::test::mojom::RegisteredKeyPtr result(::blink::test::mojom::RegisteredKey::New());
  
      if (success && !input.ReadKeyHandle(&result->key_handle))
        success = false;
      if (success && !input.ReadRpId(&result->rp_id))
        success = false;
      if (success && !input.ReadPrivateKey(&result->private_key))
        success = false;
      if (success)
        result->counter = input.counter();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif