// third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* RequestIdTokenStatusToStringHelper(RequestIdTokenStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestIdTokenStatus::kSuccess:
      return "kSuccess";
    case RequestIdTokenStatus::kApprovalDeclined:
      return "kApprovalDeclined";
    case RequestIdTokenStatus::kErrorTooManyRequests:
      return "kErrorTooManyRequests";
    case RequestIdTokenStatus::kErrorWebIdNotSupportedByProvider:
      return "kErrorWebIdNotSupportedByProvider";
    case RequestIdTokenStatus::kErrorFetchingWellKnown:
      return "kErrorFetchingWellKnown";
    case RequestIdTokenStatus::kErrorInvalidWellKnown:
      return "kErrorInvalidWellKnown";
    case RequestIdTokenStatus::kErrorFetchingSignin:
      return "kErrorFetchingSignin";
    case RequestIdTokenStatus::kErrorInvalidSigninResponse:
      return "kErrorInvalidSigninResponse";
    case RequestIdTokenStatus::kErrorInvalidAccountsResponse:
      return "kErrorInvalidAccountsResponse";
    case RequestIdTokenStatus::kErrorInvalidTokenResponse:
      return "kErrorInvalidTokenResponse";
    case RequestIdTokenStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string RequestIdTokenStatusToString(RequestIdTokenStatus value) {
  const char *str = RequestIdTokenStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestIdTokenStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestIdTokenStatus value) {
  return os << RequestIdTokenStatusToString(value);
}

static NOINLINE const char* LogoutStatusToStringHelper(LogoutStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LogoutStatus::kSuccess:
      return "kSuccess";
    case LogoutStatus::kErrorTooManyRequests:
      return "kErrorTooManyRequests";
    case LogoutStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string LogoutStatusToString(LogoutStatus value) {
  const char *str = LogoutStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LogoutStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LogoutStatus value) {
  return os << LogoutStatusToString(value);
}

static NOINLINE const char* RequestModeToStringHelper(RequestMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestMode::kMediated:
      return "kMediated";
    case RequestMode::kPermission:
      return "kPermission";
    default:
      return nullptr;
  }
}

std::string RequestModeToString(RequestMode value) {
  const char *str = RequestModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestMode value) {
  return os << RequestModeToString(value);
}

namespace internal {


// static
bool FederatedAuthRequest_RequestIdToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthRequest_RequestIdToken_Params_Data* object = static_cast<const FederatedAuthRequest_RequestIdToken_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->provider, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams client_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->client_id, validation_context,
                                         &client_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonce, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams nonce_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->nonce, validation_context,
                                         &nonce_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::RequestMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_RequestIdToken_Params_Data::FederatedAuthRequest_RequestIdToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RequestIdToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthRequest_RequestIdToken_ResponseParams_Data* object = static_cast<const FederatedAuthRequest_RequestIdToken_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::RequestIdTokenStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams id_token_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id_token, validation_context,
                                         &id_token_validate_params)) {
    return false;
  }

  return true;
}

FederatedAuthRequest_RequestIdToken_ResponseParams_Data::FederatedAuthRequest_RequestIdToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_Logout_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthRequest_Logout_Params_Data* object = static_cast<const FederatedAuthRequest_Logout_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rp_logout_endpoints, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams rp_logout_endpoints_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->rp_logout_endpoints, validation_context,
                                         &rp_logout_endpoints_validate_params)) {
    return false;
  }

  return true;
}

FederatedAuthRequest_Logout_Params_Data::FederatedAuthRequest_Logout_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_Logout_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthRequest_Logout_ResponseParams_Data* object = static_cast<const FederatedAuthRequest_Logout_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::LogoutStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_Logout_ResponseParams_Data::FederatedAuthRequest_Logout_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestIdTokenStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RequestIdTokenStatus value) {
  return std::move(context).WriteString(::blink::mojom::RequestIdTokenStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LogoutStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::LogoutStatus value) {
  return std::move(context).WriteString(::blink::mojom::LogoutStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RequestMode value) {
  return std::move(context).WriteString(::blink::mojom::RequestModeToString(value));
}

} // namespace perfetto
