// third_party/blink/public/mojom/websockets/websocket_connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBSOCKETS_WEBSOCKET_CONNECTOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBSOCKETS_WEBSOCKET_CONNECTOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char WebSocketConnector::Name_[] = "blink.mojom.WebSocketConnector";

WebSocketConnectorProxy::WebSocketConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketConnectorProxy::Connect(
    const ::GURL& in_url, const std::vector<std::string>& in_requested_protocols, const ::net::SiteForCookies& in_site_for_cookies, const absl::optional<std::string>& in_user_agent, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> in_handshake_client, const absl::optional<::base::UnguessableToken>& in_throttling_profile_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebSocketConnector::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_protocols"), in_requested_protocols,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handshake_client"), in_handshake_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttling_profile_id"), in_throttling_profile_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketConnector_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebSocketConnector_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->requested_protocols)::BaseType>
      requested_protocols_fragment(params.message());
  const mojo::internal::ContainerValidateParams requested_protocols_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_requested_protocols, requested_protocols_fragment, &requested_protocols_validate_params);
  params->requested_protocols.Set(
      requested_protocols_fragment.is_null() ? nullptr : requested_protocols_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested_protocols.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_protocols in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, site_for_cookies_fragment);
  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, user_agent_fragment);
  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketHandshakeClientInterfaceBase>>(
      in_handshake_client, &params->handshake_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handshake_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handshake_client in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->throttling_profile_id)::BaseType> throttling_profile_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_throttling_profile_id, throttling_profile_id_fragment);
  params->throttling_profile_id.Set(
      throttling_profile_id_fragment.is_null() ? nullptr : throttling_profile_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketConnectorStubDispatch::Accept(
    WebSocketConnector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebSocketConnector_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebSocketConnector::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebSocketConnector::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::WebSocketConnector_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::vector<std::string> p_requested_protocols{};
      ::net::SiteForCookies p_site_for_cookies{};
      absl::optional<std::string> p_user_agent{};
      ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> p_handshake_client{};
      absl::optional<::base::UnguessableToken> p_throttling_profile_id{};
      WebSocketConnector_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadRequestedProtocols(&p_requested_protocols))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (success && !input_data_view.ReadThrottlingProfileId(&p_throttling_profile_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_url), 
std::move(p_requested_protocols), 
std::move(p_site_for_cookies), 
std::move(p_user_agent), 
std::move(p_handshake_client), 
std::move(p_throttling_profile_id));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketConnectorStubDispatch::AcceptWithResponder(
    WebSocketConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketConnector_Connect_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebSocketConnectorValidationInfo[] = {
    {&internal::WebSocketConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebSocketConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebSocketConnector::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebSocketConnectorValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif