// third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_DEDICATED_WORKER_HOST_FACTORY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_DEDICATED_WORKER_HOST_FACTORY_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char kNavigation_DedicatedWorkerSpec[] = "navigation:dedicated_worker";
const char DedicatedWorkerHostFactoryClient::Name_[] = "blink.mojom.DedicatedWorkerHostFactoryClient";

DedicatedWorkerHostFactoryClientProxy::DedicatedWorkerHostFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DedicatedWorkerHostFactoryClientProxy::OnWorkerHostCreated(
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> in_browser_interface_broker, ::mojo::PendingRemote<::blink::mojom::DedicatedWorkerHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_interface_broker"), in_browser_interface_broker,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::DedicatedWorkerHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_browser_interface_broker, &params->browser_interface_broker, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid browser_interface_broker in DedicatedWorkerHostFactoryClient.OnWorkerHostCreated request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DedicatedWorkerHostInterfaceBase>>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in DedicatedWorkerHostFactoryClient.OnWorkerHostCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactoryClient::Name_);
  message.set_method_name("OnWorkerHostCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DedicatedWorkerHostFactoryClientProxy::OnScriptLoadStarted(
    ::blink::mojom::ServiceWorkerContainerInfoForClientPtr in_service_worker_container_info, ::blink::mojom::WorkerMainScriptLoadParamsPtr in_main_script_load_params, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater> in_subresource_loader_updater, ::blink::mojom::ControllerServiceWorkerInfoPtr in_controller_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_container_info"), in_service_worker_container_info,
                        "<value of type ::blink::mojom::ServiceWorkerContainerInfoForClientPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_script_load_params"), in_main_script_load_params,
                        "<value of type ::blink::mojom::WorkerMainScriptLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_updater"), in_subresource_loader_updater,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_info"), in_controller_info,
                        "<value of type ::blink::mojom::ControllerServiceWorkerInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_container_info)::BaseType> service_worker_container_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
      in_service_worker_container_info, service_worker_container_info_fragment);
  params->service_worker_container_info.Set(
      service_worker_container_info_fragment.is_null() ? nullptr : service_worker_container_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->main_script_load_params)::BaseType> main_script_load_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WorkerMainScriptLoadParamsDataView>(
      in_main_script_load_params, main_script_load_params_fragment);
  params->main_script_load_params.Set(
      main_script_load_params_fragment.is_null() ? nullptr : main_script_load_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_script_load_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_script_load_params in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, subresource_loader_factories_fragment);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subresource_loader_factories.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subresource_loader_factories in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SubresourceLoaderUpdaterInterfaceBase>>(
      in_subresource_loader_updater, &params->subresource_loader_updater, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subresource_loader_updater),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subresource_loader_updater in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");
  mojo::internal::MessageFragment<
      typename decltype(params->controller_info)::BaseType> controller_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
      in_controller_info, controller_info_fragment);
  params->controller_info.Set(
      controller_info_fragment.is_null() ? nullptr : controller_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactoryClient::Name_);
  message.set_method_name("OnScriptLoadStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DedicatedWorkerHostFactoryClientProxy::OnScriptLoadStartFailed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactoryClient::Name_);
  message.set_method_name("OnScriptLoadStartFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DedicatedWorkerHostFactoryClientStubDispatch::Accept(
    DedicatedWorkerHostFactoryClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> p_browser_interface_broker{};
      ::mojo::PendingRemote<::blink::mojom::DedicatedWorkerHost> p_host{};
      DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactoryClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWorkerHostCreated(
std::move(p_browser_interface_broker), 
std::move(p_host));
      return true;
    }
    case internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ServiceWorkerContainerInfoForClientPtr p_service_worker_container_info{};
      ::blink::mojom::WorkerMainScriptLoadParamsPtr p_main_script_load_params{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater> p_subresource_loader_updater{};
      ::blink::mojom::ControllerServiceWorkerInfoPtr p_controller_info{};
      DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceWorkerContainerInfo(&p_service_worker_container_info))
        success = false;
      if (success && !input_data_view.ReadMainScriptLoadParams(&p_main_script_load_params))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success) {
        p_subresource_loader_updater =
            input_data_view.TakeSubresourceLoaderUpdater<decltype(p_subresource_loader_updater)>();
      }
      if (success && !input_data_view.ReadControllerInfo(&p_controller_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactoryClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadStarted(
std::move(p_service_worker_container_info), 
std::move(p_main_script_load_params), 
std::move(p_subresource_loader_factories), 
std::move(p_subresource_loader_updater), 
std::move(p_controller_info));
      return true;
    }
    case internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactoryClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadStartFailed();
      return true;
    }
  }
  return false;
}

// static
bool DedicatedWorkerHostFactoryClientStubDispatch::AcceptWithResponder(
    DedicatedWorkerHostFactoryClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Name: {
      break;
    }
    case internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Name: {
      break;
    }
    case internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDedicatedWorkerHostFactoryClientValidationInfo[] = {
    {internal::kDedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Name,
     {&internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Name,
     {&internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Name,
     {&internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DedicatedWorkerHostFactoryClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DedicatedWorkerHostFactoryClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDedicatedWorkerHostFactoryClientValidationInfo);
}

const char DedicatedWorkerHostFactory::Name_[] = "blink.mojom.DedicatedWorkerHostFactory";

class DedicatedWorkerHostFactory_CreateWorkerHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DedicatedWorkerHostFactory_CreateWorkerHost_ForwardToCallback(
      DedicatedWorkerHostFactory::CreateWorkerHostCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DedicatedWorkerHostFactory::CreateWorkerHostCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DedicatedWorkerHostFactory_CreateWorkerHost_ForwardToCallback);
};

DedicatedWorkerHostFactoryProxy::DedicatedWorkerHostFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DedicatedWorkerHostFactoryProxy::CreateWorkerHost(
    const ::blink::DedicatedWorkerToken& in_token, const ::GURL& in_script_url, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> in_browser_interface_broker, ::mojo::PendingReceiver<::blink::mojom::DedicatedWorkerHost> in_host, CreateWorkerHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::DedicatedWorkerToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_interface_broker"), in_browser_interface_broker,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::DedicatedWorkerHost>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDedicatedWorkerHostFactory_CreateWorkerHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DedicatedWorkerTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in DedicatedWorkerHostFactory.CreateWorkerHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_url, script_url_fragment);
  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_url in DedicatedWorkerHostFactory.CreateWorkerHost request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_browser_interface_broker, &params->browser_interface_broker, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid browser_interface_broker in DedicatedWorkerHostFactory.CreateWorkerHost request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DedicatedWorkerHostInterfaceBase>>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in DedicatedWorkerHostFactory.CreateWorkerHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactory::Name_);
  message.set_method_name("CreateWorkerHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DedicatedWorkerHostFactory_CreateWorkerHost_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DedicatedWorkerHostFactoryProxy::CreateWorkerHostAndStartScriptLoad(
    const ::blink::DedicatedWorkerToken& in_token, const ::GURL& in_script_url, ::network::mojom::CredentialsMode in_credentials_mode, ::blink::mojom::FetchClientSettingsObjectPtr in_outside_fetch_client_settings_object, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> in_blob_url_token, ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::DedicatedWorkerToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials_mode"), in_credentials_mode,
                        "<value of type ::network::mojom::CredentialsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outside_fetch_client_settings_object"), in_outside_fetch_client_settings_object,
                        "<value of type ::blink::mojom::FetchClientSettingsObjectPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_url_token"), in_blob_url_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DedicatedWorkerTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_url, script_url_fragment);
  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_url in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");
  mojo::internal::Serialize<::network::mojom::CredentialsMode>(
      in_credentials_mode, &params->credentials_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
      in_outside_fetch_client_settings_object, outside_fetch_client_settings_object_fragment);
  params->outside_fetch_client_settings_object.Set(
      outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->outside_fetch_client_settings_object.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outside_fetch_client_settings_object in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_blob_url_token, &params->blob_url_token, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DedicatedWorkerHostFactoryClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactory::Name_);
  message.set_method_name("CreateWorkerHostAndStartScriptLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder {
 public:
  static DedicatedWorkerHostFactory::CreateWorkerHostCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder> proxy(
        new DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DedicatedWorkerHostFactory::CreateWorkerHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::network::CrossOriginEmbedderPolicy& in_parent_coep);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder);
};

bool DedicatedWorkerHostFactory_CreateWorkerHost_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::network::CrossOriginEmbedderPolicy p_parent_coep{};
  DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParentCoep(&p_parent_coep))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DedicatedWorkerHostFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_parent_coep));
  return true;
}

void DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder::Run(
    const ::network::CrossOriginEmbedderPolicy& in_parent_coep) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_coep"), in_parent_coep,
                        "<value of type const ::network::CrossOriginEmbedderPolicy&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDedicatedWorkerHostFactory_CreateWorkerHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_coep)::BaseType> parent_coep_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
      in_parent_coep, parent_coep_fragment);
  params->parent_coep.Set(
      parent_coep_fragment.is_null() ? nullptr : parent_coep_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_coep.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_coep in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactory::Name_);
  message.set_method_name("CreateWorkerHost");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DedicatedWorkerHostFactoryStubDispatch::Accept(
    DedicatedWorkerHostFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDedicatedWorkerHostFactory_CreateWorkerHost_Name: {
      break;
    }
    case internal::kDedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::DedicatedWorkerToken p_token{};
      ::GURL p_script_url{};
      ::network::mojom::CredentialsMode p_credentials_mode{};
      ::blink::mojom::FetchClientSettingsObjectPtr p_outside_fetch_client_settings_object{};
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> p_blob_url_token{};
      ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient> p_client{};
      DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (success && !input_data_view.ReadCredentialsMode(&p_credentials_mode))
        success = false;
      if (success && !input_data_view.ReadOutsideFetchClientSettingsObject(&p_outside_fetch_client_settings_object))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWorkerHostAndStartScriptLoad(
std::move(p_token), 
std::move(p_script_url), 
std::move(p_credentials_mode), 
std::move(p_outside_fetch_client_settings_object), 
std::move(p_blob_url_token), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool DedicatedWorkerHostFactoryStubDispatch::AcceptWithResponder(
    DedicatedWorkerHostFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDedicatedWorkerHostFactory_CreateWorkerHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data* params =
          reinterpret_cast<
              internal::DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::DedicatedWorkerToken p_token{};
      ::GURL p_script_url{};
      ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> p_browser_interface_broker{};
      ::mojo::PendingReceiver<::blink::mojom::DedicatedWorkerHost> p_host{};
      DedicatedWorkerHostFactory_CreateWorkerHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactory::Name_, 0, false);
        return false;
      }
      DedicatedWorkerHostFactory::CreateWorkerHostCallback callback =
          DedicatedWorkerHostFactory_CreateWorkerHost_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWorkerHost(
std::move(p_token), 
std::move(p_script_url), 
std::move(p_browser_interface_broker), 
std::move(p_host), std::move(callback));
      return true;
    }
    case internal::kDedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDedicatedWorkerHostFactoryValidationInfo[] = {
    {internal::kDedicatedWorkerHostFactory_CreateWorkerHost_Name,
     {&internal::DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data::Validate,
      &internal::DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data::Validate}},
    {internal::kDedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Name,
     {&internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DedicatedWorkerHostFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DedicatedWorkerHostFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDedicatedWorkerHostFactoryValidationInfo);
}

bool DedicatedWorkerHostFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DedicatedWorkerHostFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDedicatedWorkerHostFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif