// third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CLIENT_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CLIENT_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char SharedWorkerClient::Name_[] = "blink.mojom.SharedWorkerClient";

SharedWorkerClientProxy::SharedWorkerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerClientProxy::OnCreated(
    ::blink::mojom::blink::SharedWorkerCreationContextType in_creation_context_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("creation_context_type"), in_creation_context_type,
                        "<value of type ::blink::mojom::blink::SharedWorkerCreationContextType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::SharedWorkerCreationContextType>(
      in_creation_context_type, &params->creation_context_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerClientProxy::OnConnected(
    const WTF::Vector<::blink::mojom::blink::WebFeature>& in_features_used) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features_used"), in_features_used,
                        "<value of type const WTF::Vector<::blink::mojom::blink::WebFeature>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnConnected_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnConnected_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features_used)::BaseType>
      features_used_fragment(params.message());
  const mojo::internal::ContainerValidateParams features_used_validate_params(
      0, ::blink::mojom::internal::WebFeature_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
      in_features_used, features_used_fragment, &features_used_validate_params);
  params->features_used.Set(
      features_used_fragment.is_null() ? nullptr : features_used_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features_used.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features_used in SharedWorkerClient.OnConnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerClientProxy::OnScriptLoadFailed(
    const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnScriptLoadFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnScriptLoadFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in SharedWorkerClient.OnScriptLoadFailed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnScriptLoadFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerClientProxy::OnFeatureUsed(
    ::blink::mojom::blink::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::blink::mojom::blink::WebFeature>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnFeatureUsed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnFeatureUsed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
      in_feature, &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SharedWorkerClientStubDispatch::Accept(
    SharedWorkerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSharedWorkerClient_OnCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnCreated_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::SharedWorkerCreationContextType p_creation_context_type{};
      SharedWorkerClient_OnCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCreationContextType(&p_creation_context_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCreated(
std::move(p_creation_context_type));
      return true;
    }
    case internal::kSharedWorkerClient_OnConnected_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnConnected",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnConnected");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnConnected_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnConnected_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::blink::mojom::blink::WebFeature> p_features_used{};
      SharedWorkerClient_OnConnected_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeaturesUsed(&p_features_used))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnected(
std::move(p_features_used));
      return true;
    }
    case internal::kSharedWorkerClient_OnScriptLoadFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnScriptLoadFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnScriptLoadFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_error_message{};
      SharedWorkerClient_OnScriptLoadFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadFailed(
std::move(p_error_message));
      return true;
    }
    case internal::kSharedWorkerClient_OnFeatureUsed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnFeatureUsed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnFeatureUsed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnFeatureUsed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::WebFeature p_feature{};
      SharedWorkerClient_OnFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFeatureUsed(
std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerClientStubDispatch::AcceptWithResponder(
    SharedWorkerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedWorkerClient_OnCreated_Name: {
      break;
    }
    case internal::kSharedWorkerClient_OnConnected_Name: {
      break;
    }
    case internal::kSharedWorkerClient_OnScriptLoadFailed_Name: {
      break;
    }
    case internal::kSharedWorkerClient_OnFeatureUsed_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSharedWorkerClientValidationInfo[] = {
    {&internal::SharedWorkerClient_OnCreated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerClient_OnConnected_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerClient_OnFeatureUsed_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::SharedWorkerClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSharedWorkerClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif