// third_party/blink/public/mojom/worker/shared_worker_connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CONNECTOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CONNECTOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char SharedWorkerConnector::Name_[] = "blink.mojom.SharedWorkerConnector";

SharedWorkerConnectorProxy::SharedWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerConnectorProxy::Connect(
    ::blink::mojom::SharedWorkerInfoPtr in_info, ::mojo::PendingRemote<::blink::mojom::SharedWorkerClient> in_client, ::blink::mojom::SharedWorkerCreationContextType in_creation_context_type, ::blink::MessagePortDescriptor in_message_port, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> in_blob_url_token, int64_t in_client_ukm_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerConnector::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::blink::mojom::SharedWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::SharedWorkerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("creation_context_type"), in_creation_context_type,
                        "<value of type ::blink::mojom::SharedWorkerCreationContextType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_port"), in_message_port,
                        "<value of type ::blink::MessagePortDescriptor>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_url_token"), in_blob_url_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_ukm_source_id"), in_client_ukm_source_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerConnector_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerConnector_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SharedWorkerInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in SharedWorkerConnector.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SharedWorkerClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SharedWorkerConnector.Connect request");
  mojo::internal::Serialize<::blink::mojom::SharedWorkerCreationContextType>(
      in_creation_context_type, &params->creation_context_type);
  mojo::internal::MessageFragment<
      typename decltype(params->message_port)::BaseType> message_port_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MessagePortDescriptorDataView>(
      in_message_port, message_port_fragment);
  params->message_port.Set(
      message_port_fragment.is_null() ? nullptr : message_port_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message_port.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message_port in SharedWorkerConnector.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_blob_url_token, &params->blob_url_token, &params.message());
  params->client_ukm_source_id = in_client_ukm_source_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SharedWorkerConnectorStubDispatch::Accept(
    SharedWorkerConnector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSharedWorkerConnector_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerConnector::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerConnector::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerConnector_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::SharedWorkerInfoPtr p_info{};
      ::mojo::PendingRemote<::blink::mojom::SharedWorkerClient> p_client{};
      ::blink::mojom::SharedWorkerCreationContextType p_creation_context_type{};
      ::blink::MessagePortDescriptor p_message_port{};
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> p_blob_url_token{};
      int64_t p_client_ukm_source_id{};
      SharedWorkerConnector_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadCreationContextType(&p_creation_context_type))
        success = false;
      if (success && !input_data_view.ReadMessagePort(&p_message_port))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success)
        p_client_ukm_source_id = input_data_view.client_ukm_source_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_info), 
std::move(p_client), 
std::move(p_creation_context_type), 
std::move(p_message_port), 
std::move(p_blob_url_token), 
std::move(p_client_ukm_source_id));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerConnectorStubDispatch::AcceptWithResponder(
    SharedWorkerConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedWorkerConnector_Connect_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedWorkerConnectorValidationInfo[] = {
    {internal::kSharedWorkerConnector_Connect_Name,
     {&internal::SharedWorkerConnector_Connect_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedWorkerConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SharedWorkerConnector::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedWorkerConnectorValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif