// ui/accessibility/mojom/ax_event_intent.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_event_intent.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_event_intent.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_event_intent.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_BLINK_JUMBO_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_BLINK_JUMBO_H_
#endif
namespace ax {
namespace mojom {
namespace blink {
EventIntent::EventIntent()
    : command(),
      input_event_type(),
      text_boundary(),
      move_direction() {}

EventIntent::EventIntent(
    ::ax::mojom::blink::Command command_in,
    ::ax::mojom::blink::InputEventType input_event_type_in,
    ::ax::mojom::blink::TextBoundary text_boundary_in,
    ::ax::mojom::blink::MoveDirection move_direction_in)
    : command(std::move(command_in)),
      input_event_type(std::move(input_event_type_in)),
      text_boundary(std::move(text_boundary_in)),
      move_direction(std::move(move_direction_in)) {}

EventIntent::~EventIntent() = default;
size_t EventIntent::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->command);
  seed = mojo::internal::WTFHash(seed, this->input_event_type);
  seed = mojo::internal::WTFHash(seed, this->text_boundary);
  seed = mojo::internal::WTFHash(seed, this->move_direction);
  return seed;
}

void EventIntent::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "command"), this->command,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::Command>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_event_type"), this->input_event_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::InputEventType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_boundary"), this->text_boundary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::TextBoundary>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "move_direction"), this->move_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::MoveDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventIntent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace ax

namespace mojo {


// static
bool StructTraits<::ax::mojom::blink::EventIntent::DataView, ::ax::mojom::blink::EventIntentPtr>::Read(
    ::ax::mojom::blink::EventIntent::DataView input,
    ::ax::mojom::blink::EventIntentPtr* output) {
  bool success = true;
  ::ax::mojom::blink::EventIntentPtr result(::ax::mojom::blink::EventIntent::New());
  
      if (success && !input.ReadCommand(&result->command))
        success = false;
      if (success && !input.ReadInputEventType(&result->input_event_type))
        success = false;
      if (success && !input.ReadTextBoundary(&result->text_boundary))
        success = false;
      if (success && !input.ReadMoveDirection(&result->move_direction))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif