// ui/display/mojom/screen_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/screen_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/screen_info.mojom-params-data.h"
namespace display {
namespace mojom {

namespace internal {


// static
bool ScreenInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScreenInfo_Data* object = static_cast<const ScreenInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_color_spaces, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_color_spaces, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->available_rect, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->available_rect, validation_context))
    return false;


  if (!::display::mojom::internal::ScreenOrientation_Data
        ::Validate(object->orientation_type, validation_context))
    return false;

  return true;
}

ScreenInfo_Data::ScreenInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace display
