// ui/ozone/public/mojom/gesture_properties_service.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "ui/ozone/public/mojom/gesture_properties_service.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_JUMBO_H_
#endif


namespace ui {
namespace ozone {
namespace mojom {


void GesturePropertiesServiceInterceptorForTesting::ListDevices(ListDevicesCallback callback) {
  GetForwardingInterface()->ListDevices(std::move(callback));
}
void GesturePropertiesServiceInterceptorForTesting::ListProperties(int32_t device_id, ListPropertiesCallback callback) {
  GetForwardingInterface()->ListProperties(std::move(device_id), std::move(callback));
}
void GesturePropertiesServiceInterceptorForTesting::GetProperty(int32_t device_id, const std::string& name, GetPropertyCallback callback) {
  GetForwardingInterface()->GetProperty(std::move(device_id), std::move(name), std::move(callback));
}
void GesturePropertiesServiceInterceptorForTesting::SetProperty(int32_t device_id, const std::string& name, GesturePropValuePtr value, SetPropertyCallback callback) {
  GetForwardingInterface()->SetProperty(std::move(device_id), std::move(name), std::move(value), std::move(callback));
}
GesturePropertiesServiceAsyncWaiter::GesturePropertiesServiceAsyncWaiter(
    GesturePropertiesService* proxy) : proxy_(proxy) {}

GesturePropertiesServiceAsyncWaiter::~GesturePropertiesServiceAsyncWaiter() = default;

void GesturePropertiesServiceAsyncWaiter::ListDevices(
    base::flat_map<int32_t, std::string>* out_result) {
  base::RunLoop loop;
  proxy_->ListDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<int32_t, std::string>* out_result
,
             const base::flat_map<int32_t, std::string>& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void GesturePropertiesServiceAsyncWaiter::ListProperties(
    int32_t device_id, std::vector<std::string>* out_properties) {
  base::RunLoop loop;
  proxy_->ListProperties(std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_properties
,
             const std::vector<std::string>& properties) {*out_properties = std::move(properties);
            loop->Quit();
          },
          &loop,
          out_properties));
  loop.Run();
}
void GesturePropertiesServiceAsyncWaiter::GetProperty(
    int32_t device_id, const std::string& name, bool* out_is_read_only, GesturePropValuePtr* out_value) {
  base::RunLoop loop;
  proxy_->GetProperty(std::move(device_id),std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_read_only
,
             GesturePropValuePtr* out_value
,
             bool is_read_only,
             GesturePropValuePtr value) {*out_is_read_only = std::move(is_read_only);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_is_read_only,
          out_value));
  loop.Run();
}
void GesturePropertiesServiceAsyncWaiter::SetProperty(
    int32_t device_id, const std::string& name, GesturePropValuePtr value, SetGesturePropErrorCode* out_error) {
  base::RunLoop loop;
  proxy_->SetProperty(std::move(device_id),std::move(name),std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             SetGesturePropErrorCode* out_error
,
             SetGesturePropErrorCode error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}





}  // namespace mojom
}  // namespace ozone
}  // namespace ui

#if defined(__clang__)
#pragma clang diagnostic pop
#endif