// ui/ozone/public/mojom/scenic_gpu_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/ozone/public/mojom/scenic_gpu_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/ozone/public/mojom/scenic_gpu_host.mojom-params-data.h"
#include "ui/ozone/public/mojom/scenic_gpu_host.mojom-shared-message-ids.h"

#include "ui/ozone/public/mojom/scenic_gpu_host.mojom-import-headers.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_SCENIC_GPU_HOST_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_SCENIC_GPU_HOST_MOJOM_JUMBO_H_
#endif
namespace ui {
namespace mojom {
const char ScenicGpuHost::Name_[] = "ui.mojom.ScenicGpuHost";

ScenicGpuHostProxy::ScenicGpuHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScenicGpuHostProxy::AttachSurfaceToWindow(
    int32_t in_window_id, ::mojo::PlatformHandle in_view_holder_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::mojom::ScenicGpuHost::AttachSurfaceToWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_holder_token"), in_view_holder_token,
                        "<value of type ::mojo::PlatformHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kScenicGpuHost_AttachSurfaceToWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::mojom::internal::ScenicGpuHost_AttachSurfaceToWindow_Params_Data> params(
          message);
  params.Allocate();
  params->window_id = in_window_id;
  mojo::internal::Serialize<mojo::PlatformHandle>(
      in_view_holder_token, &params->view_holder_token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->view_holder_token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid view_holder_token in ScenicGpuHost.AttachSurfaceToWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScenicGpuHost::Name_);
  message.set_method_name("AttachSurfaceToWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ScenicGpuHostStubDispatch::Accept(
    ScenicGpuHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kScenicGpuHost_AttachSurfaceToWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::mojom::ScenicGpuHost::AttachSurfaceToWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::mojom::ScenicGpuHost::AttachSurfaceToWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ScenicGpuHost_AttachSurfaceToWindow_Params_Data* params =
          reinterpret_cast<internal::ScenicGpuHost_AttachSurfaceToWindow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_window_id{};
      ::mojo::PlatformHandle p_view_holder_token{};
      ScenicGpuHost_AttachSurfaceToWindow_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_window_id = input_data_view.window_id();
      if (success)
        p_view_holder_token = input_data_view.TakeViewHolderToken();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScenicGpuHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachSurfaceToWindow(
std::move(p_window_id), 
std::move(p_view_holder_token));
      return true;
    }
  }
  return false;
}

// static
bool ScenicGpuHostStubDispatch::AcceptWithResponder(
    ScenicGpuHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kScenicGpuHost_AttachSurfaceToWindow_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kScenicGpuHostValidationInfo[] = {
    {internal::kScenicGpuHost_AttachSurfaceToWindow_Name,
     {&internal::ScenicGpuHost_AttachSurfaceToWindow_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ScenicGpuHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::mojom::ScenicGpuHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kScenicGpuHostValidationInfo);
}

}  // namespace mojom
}  // namespace ui

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif