/* bookmarks-headerbar.c generated by valac 0.56.2, the Vala compiler
 * generated from bookmarks-headerbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NIGHT_TIME_AWARE_HEADER_BAR (night_time_aware_header_bar_get_type ())
#define NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBar))
#define NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define NIGHT_TIME_AWARE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))

typedef struct _NightTimeAwareHeaderBar NightTimeAwareHeaderBar;
typedef struct _NightTimeAwareHeaderBarClass NightTimeAwareHeaderBarClass;
typedef struct _NightTimeAwareHeaderBarPrivate NightTimeAwareHeaderBarPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
typedef struct _BaseHeaderBarPrivate BaseHeaderBarPrivate;

#define TYPE_BROWSER_HEADER_BAR (browser_header_bar_get_type ())
#define BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar))
#define BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))
#define IS_BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_HEADER_BAR))
#define IS_BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_HEADER_BAR))
#define BROWSER_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))

typedef struct _BrowserHeaderBar BrowserHeaderBar;
typedef struct _BrowserHeaderBarClass BrowserHeaderBarClass;
typedef struct _BrowserHeaderBarPrivate BrowserHeaderBarPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BOOKMARKS_HEADER_BAR (bookmarks_header_bar_get_type ())
#define BOOKMARKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar))
#define BOOKMARKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBarClass))
#define IS_BOOKMARKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_HEADER_BAR))
#define IS_BOOKMARKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_HEADER_BAR))
#define BOOKMARKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBarClass))

typedef struct _BookmarksHeaderBar BookmarksHeaderBar;
typedef struct _BookmarksHeaderBarClass BookmarksHeaderBarClass;
typedef struct _BookmarksHeaderBarPrivate BookmarksHeaderBarPrivate;

#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;

#define TYPE_BOOKMARKS_CONTROLLER (bookmarks_controller_get_type ())
#define BOOKMARKS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_CONTROLLER, BookmarksController))
#define BOOKMARKS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_CONTROLLER, BookmarksControllerClass))
#define IS_BOOKMARKS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_CONTROLLER))
#define IS_BOOKMARKS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_CONTROLLER))
#define BOOKMARKS_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_CONTROLLER, BookmarksControllerClass))

typedef struct _BookmarksController BookmarksController;
typedef struct _BookmarksControllerClass BookmarksControllerClass;
enum  {
	BOOKMARKS_HEADER_BAR_0_PROPERTY,
	BOOKMARKS_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* bookmarks_header_bar_properties[BOOKMARKS_HEADER_BAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	BOOKMARK_ICON_VALID_FOLDER,
	BOOKMARK_ICON_SEARCH,
	BOOKMARK_ICON_DCONF_OBJECT,
	BOOKMARK_ICON_KEY_DEFAULTS,
	BOOKMARK_ICON_EDITED_VALUE,
	BOOKMARK_ICON_EMPTY_FOLDER,
	BOOKMARK_ICON_EMPTY_OBJECT
} BookmarkIcon;

#define TYPE_BOOKMARK_ICON (bookmark_icon_get_type ())
enum  {
	BOOKMARKS_HEADER_BAR_UPDATE_BOOKMARKS_ICONS_SIGNAL,
	BOOKMARKS_HEADER_BAR_NUM_SIGNALS
};
static guint bookmarks_header_bar_signals[BOOKMARKS_HEADER_BAR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NightTimeAwareHeaderBar {
	GtkHeaderBar parent_instance;
	NightTimeAwareHeaderBarPrivate * priv;
};

struct _NightTimeAwareHeaderBarClass {
	GtkHeaderBarClass parent_class;
	void (*update_hamburger_menu) (NightTimeAwareHeaderBar* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseHeaderBar {
	NightTimeAwareHeaderBar parent_instance;
	BaseHeaderBarPrivate * priv;
	GtkBox* center_box;
	gboolean disable_popovers;
	gboolean disable_action_bar;
};

struct _BaseHeaderBarClass {
	NightTimeAwareHeaderBarClass parent_class;
	void (*set_window_size) (BaseHeaderBar* self, AdaptativeWidgetWindowSize new_size);
	void (*populate_menu) (BaseHeaderBar* self, GMenu** menu);
	void (*toggle_view_menu) (BaseHeaderBar* self);
	void (*set_default_widgets_default_states) (BaseHeaderBar* self, BaseHeaderBar* _this);
	void (*close_popovers) (BaseHeaderBar* self);
	gboolean (*has_popover) (BaseHeaderBar* self);
};

struct _BrowserHeaderBar {
	BaseHeaderBar parent_instance;
	BrowserHeaderBarPrivate * priv;
};

struct _BrowserHeaderBarClass {
	BaseHeaderBarClass parent_class;
	void (*set_path) (BrowserHeaderBar* self, ViewType type, const gchar* path);
};

struct _BookmarksHeaderBar {
	BrowserHeaderBar parent_instance;
	BookmarksHeaderBarPrivate * priv;
};

struct _BookmarksHeaderBarClass {
	BrowserHeaderBarClass parent_class;
	gboolean (*next_match) (BookmarksHeaderBar* self);
	gboolean (*previous_match) (BookmarksHeaderBar* self);
};

struct _BookmarksHeaderBarPrivate {
	gchar* bookmark_name;
	GtkRevealer* bookmarks_revealer;
	Bookmarks* bookmarks_button;
	BookmarksController* bookmarks_controller;
	guint8 use_bookmarks_mode_id;
	gboolean use_bookmarks_mode_on;
	guint8 edit_bookmarks_mode_id;
	gboolean edit_bookmarks_mode_on;
};

static gint BookmarksHeaderBar_private_offset;
static gpointer bookmarks_header_bar_parent_class = NULL;
static AdaptativeWidgetIface * bookmarks_header_bar_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType night_time_aware_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightTimeAwareHeaderBar, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType browser_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserHeaderBar, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bookmarks_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksHeaderBar, g_object_unref)
VALA_EXTERN GType bookmarks_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bookmarks, g_object_unref)
VALA_EXTERN GType bookmarks_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksController, g_object_unref)
VALA_EXTERN void browser_header_bar_set_path (BrowserHeaderBar* self,
                                  ViewType type,
                                  const gchar* path);
VALA_EXTERN void base_header_bar_set_window_size (BaseHeaderBar* self,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void base_header_bar_populate_menu (BaseHeaderBar* self,
                                    GMenu** menu);
VALA_EXTERN gboolean bookmarks_header_bar_next_match (BookmarksHeaderBar* self);
VALA_EXTERN gboolean bookmarks_header_bar_previous_match (BookmarksHeaderBar* self);
VALA_EXTERN void base_header_bar_close_popovers (BaseHeaderBar* self);
VALA_EXTERN gboolean base_header_bar_has_popover (BaseHeaderBar* self);
static void bookmarks_header_bar_bookmark_current (BookmarksHeaderBar* self);
static void _bookmarks_header_bar_bookmark_current_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void bookmarks_header_bar_unbookmark_current (BookmarksHeaderBar* self);
static void _bookmarks_header_bar_unbookmark_current_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void bookmarks_header_bar_real_set_path (BrowserHeaderBar* base,
                                         ViewType type,
                                         const gchar* path);
VALA_EXTERN gchar* bookmarks_list_get_bookmark_name (ViewType type,
                                         const gchar* path);
VALA_EXTERN void bookmarks_set_path (Bookmarks* self,
                         ViewType type,
                         const gchar* path);
static void bookmarks_header_bar_real_set_window_size (AdaptativeWidget* base,
                                                AdaptativeWidgetWindowSize new_size);
static void bookmarks_header_bar_update_bookmarks_button_visibility (BookmarksHeaderBar* self,
                                                              gboolean transition);
static void bookmarks_header_bar_add_bookmarks_revealer (GtkRevealer** bookmarks_revealer,
                                                  Bookmarks** bookmarks_button,
                                                  GtkBox* center_box);
VALA_EXTERN Bookmarks* bookmarks_new (const gchar* _schema_path);
VALA_EXTERN Bookmarks* bookmarks_construct (GType object_type,
                                const gchar* _schema_path);
static void bookmarks_header_bar_add_bookmarks_controller (BookmarksController** bookmarks_controller,
                                                    BookmarksHeaderBar** _this);
VALA_EXTERN BookmarksController* bookmarks_controller_new (const gchar* _controller_action_prefix,
                                               gboolean _show_rows_size_button);
VALA_EXTERN BookmarksController* bookmarks_controller_construct (GType object_type,
                                                     const gchar* _controller_action_prefix,
                                                     gboolean _show_rows_size_button);
static inline void bookmarks_header_bar_connect_bookmarks_signals (BookmarksHeaderBar* self);
static void bookmarks_header_bar_update_bookmarks_icons_cb (BookmarksHeaderBar* self,
                                                     GVariant* bookmarks_variant);
static void _bookmarks_header_bar_update_bookmarks_icons_cb_bookmarks_update_bookmarks_icons (Bookmarks* _sender,
                                                                                       GVariant* bookmarks_variant,
                                                                                       gpointer self);
VALA_EXTERN gboolean base_header_bar_get_no_in_window_mode (BaseHeaderBar* self);
static inline void bookmarks_header_bar_set_bookmarks_button_visibility (gboolean visibility,
                                                           GtkRevealer** bookmarks_revealer,
                                                           Bookmarks** bookmarks_button);
VALA_EXTERN void bookmarks_header_bar_show_use_bookmarks_view (BookmarksHeaderBar* self);
static void bookmarks_header_bar_register_bookmarks_modes (BookmarksHeaderBar* self);
VALA_EXTERN guint8 base_header_bar_register_new_mode (BaseHeaderBar* self);
static void bookmarks_header_bar_mode_changed_bookmarks (BaseHeaderBar* _this,
                                                  guint8 requested_mode_id);
static void _bookmarks_header_bar_mode_changed_bookmarks_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                               guint8 mode_id,
                                                                               gpointer self);
static void bookmarks_header_bar_mode_changed_use_bookmarks (BookmarksHeaderBar* _this,
                                                      guint8 requested_mode_id);
static void bookmarks_header_bar_mode_changed_edit_bookmarks (BookmarksHeaderBar* _this,
                                                       guint8 requested_mode_id);
VALA_EXTERN gboolean base_header_bar_is_not_requested_mode (guint8 mode_id,
                                                guint8 requested_mode_id,
                                                gboolean* mode_is_active);
VALA_EXTERN void night_time_aware_header_bar_update_hamburger_menu (NightTimeAwareHeaderBar* self);
VALA_EXTERN void base_header_bar_set_default_widgets_states (BaseHeaderBar* self,
                                                 const gchar* title_label_text_or_null,
                                                 gboolean show_go_back_button,
                                                 gboolean show_ltr_left_separator,
                                                 gboolean show_info_button,
                                                 gboolean show_ltr_right_separator,
                                                 gboolean show_quit_button_stack);
VALA_EXTERN void bookmarks_header_bar_show_edit_bookmarks_view (BookmarksHeaderBar* self);
static void bookmarks_header_bar_install_action_entries (BookmarksHeaderBar* self);
VALA_EXTERN void bookmarks_header_bar_bookmark_current_path (BookmarksHeaderBar* self);
VALA_EXTERN void bookmarks_header_bar_unbookmark_current_path (BookmarksHeaderBar* self);
VALA_EXTERN gchar** bookmarks_header_bar_get_bookmarks (BookmarksHeaderBar* self,
                                            gint* result_length1);
VALA_EXTERN gchar** bookmarks_get_bookmarks (Bookmarks* self,
                                 gint* result_length1);
VALA_EXTERN GType bookmark_icon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void bookmarks_header_bar_update_bookmark_icon (BookmarksHeaderBar* self,
                                                const gchar* bookmark,
                                                BookmarkIcon icon);
VALA_EXTERN void bookmarks_update_bookmark_icon (Bookmarks* self,
                                     const gchar* bookmark,
                                     BookmarkIcon icon);
static void bookmarks_header_bar_real_populate_menu (BaseHeaderBar* base,
                                              GMenu** menu);
static void bookmarks_header_bar_append_bookmark_section (gboolean is_in_bookmarks,
                                                   gboolean bookmarks_mode_on,
                                                   GMenu** menu);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gboolean bookmarks_header_bar_real_next_match (BookmarksHeaderBar* self);
VALA_EXTERN gboolean bookmarks_next_match (Bookmarks* self);
static gboolean bookmarks_header_bar_real_previous_match (BookmarksHeaderBar* self);
VALA_EXTERN gboolean bookmarks_previous_match (Bookmarks* self);
VALA_EXTERN gboolean bookmarks_header_bar_handle_copy_text (BookmarksHeaderBar* self,
                                                gchar** copy_text);
VALA_EXTERN gboolean bookmarks_handle_copy_text (Bookmarks* self,
                                     gchar** copy_text);
VALA_EXTERN gboolean base_window_no_copy_text (gchar** copy_text);
VALA_EXTERN void bookmarks_header_bar_click_bookmarks_button (BookmarksHeaderBar* self);
VALA_EXTERN void base_header_bar_hide_hamburger_menu (BaseHeaderBar* self);
VALA_EXTERN void bookmarks_bookmark_current_path (Bookmarks* self);
VALA_EXTERN void bookmarks_unbookmark_current_path (Bookmarks* self);
static void bookmarks_header_bar_real_close_popovers (BaseHeaderBar* base);
static gboolean bookmarks_header_bar_real_has_popover (BaseHeaderBar* base);
VALA_EXTERN BookmarksHeaderBar* bookmarks_header_bar_construct (GType object_type);
VALA_EXTERN BrowserHeaderBar* browser_header_bar_construct (GType object_type);
static GObject * bookmarks_header_bar_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void bookmarks_header_bar_finalize (GObject * obj);
static GType bookmarks_header_bar_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry BOOKMARKS_HEADER_BAR_action_entries[2] = {{"bookmark-current", _bookmarks_header_bar_bookmark_current_gsimple_action_activate_callback}, {"unbookmark-current", _bookmarks_header_bar_unbookmark_current_gsimple_action_activate_callback}};

static inline gpointer
bookmarks_header_bar_get_instance_private (BookmarksHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, BookmarksHeaderBar_private_offset);
}

static void
_bookmarks_header_bar_bookmark_current_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	bookmarks_header_bar_bookmark_current ((BookmarksHeaderBar*) self);
}

static void
_bookmarks_header_bar_unbookmark_current_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	bookmarks_header_bar_unbookmark_current ((BookmarksHeaderBar*) self);
}

static void
bookmarks_header_bar_real_set_path (BrowserHeaderBar* base,
                                    ViewType type,
                                    const gchar* path)
{
	BookmarksHeaderBar * self;
	gchar* _tmp0_;
	Bookmarks* _tmp1_;
	self = (BookmarksHeaderBar*) base;
	g_return_if_fail (path != NULL);
	_tmp0_ = bookmarks_list_get_bookmark_name (type, path);
	_g_free0 (self->priv->bookmark_name);
	self->priv->bookmark_name = _tmp0_;
	_tmp1_ = self->priv->bookmarks_button;
	bookmarks_set_path (_tmp1_, type, path);
	BROWSER_HEADER_BAR_CLASS (bookmarks_header_bar_parent_class)->set_path (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar), type, path);
}

static void
bookmarks_header_bar_real_set_window_size (AdaptativeWidget* base,
                                           AdaptativeWidgetWindowSize new_size)
{
	BookmarksHeaderBar * self;
	gboolean _disable_popovers = FALSE;
	self = (BookmarksHeaderBar*) base;
	_disable_popovers = ((BaseHeaderBar*) self)->disable_popovers;
	BASE_HEADER_BAR_CLASS (bookmarks_header_bar_parent_class)->set_window_size ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar), new_size);
	if (((BaseHeaderBar*) self)->disable_popovers != _disable_popovers) {
		bookmarks_header_bar_update_bookmarks_button_visibility (self, TRUE);
	}
}

static void
bookmarks_header_bar_add_bookmarks_revealer (GtkRevealer** bookmarks_revealer,
                                             Bookmarks** bookmarks_button,
                                             GtkBox* center_box)
{
	GtkRevealer* _vala_bookmarks_revealer = NULL;
	Bookmarks* _vala_bookmarks_button = NULL;
	GtkRevealer* _tmp0_;
	GtkStyleContext* _tmp1_;
	Bookmarks* _tmp2_;
	GtkStyleContext* _tmp3_;
	g_return_if_fail (center_box != NULL);
	_tmp0_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_vala_bookmarks_revealer);
	_vala_bookmarks_revealer = _tmp0_;
	gtk_revealer_set_transition_type (_vala_bookmarks_revealer, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	gtk_revealer_set_reveal_child (_vala_bookmarks_revealer, TRUE);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _vala_bookmarks_revealer);
	gtk_style_context_add_class (_tmp1_, "headerbar-revealer");
	_tmp2_ = bookmarks_new ("/ca/desrt/dconf-editor/");
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (_vala_bookmarks_button);
	_vala_bookmarks_button = _tmp2_;
	gtk_widget_set_valign ((GtkWidget*) _vala_bookmarks_button, GTK_ALIGN_CENTER);
	gtk_widget_set_focus_on_click ((GtkWidget*) _vala_bookmarks_button, FALSE);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _vala_bookmarks_button);
	gtk_style_context_add_class (_tmp3_, "image-button");
	gtk_widget_set_visible ((GtkWidget*) _vala_bookmarks_button, TRUE);
	gtk_container_add ((GtkContainer*) _vala_bookmarks_revealer, (GtkWidget*) _vala_bookmarks_button);
	gtk_widget_set_visible ((GtkWidget*) _vala_bookmarks_revealer, TRUE);
	gtk_box_pack_end (center_box, (GtkWidget*) _vala_bookmarks_revealer, TRUE, TRUE, (guint) 0);
	if (bookmarks_revealer) {
		*bookmarks_revealer = _vala_bookmarks_revealer;
	} else {
		_g_object_unref0 (_vala_bookmarks_revealer);
	}
	if (bookmarks_button) {
		*bookmarks_button = _vala_bookmarks_button;
	} else {
		_g_object_unref0 (_vala_bookmarks_button);
	}
}

static void
bookmarks_header_bar_add_bookmarks_controller (BookmarksController** bookmarks_controller,
                                               BookmarksHeaderBar** _this)
{
	BookmarksController* _vala_bookmarks_controller = NULL;
	BookmarksController* _tmp0_;
	g_return_if_fail (*_this != NULL);
	_tmp0_ = bookmarks_controller_new ("bmk", FALSE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_vala_bookmarks_controller);
	_vala_bookmarks_controller = _tmp0_;
	gtk_widget_set_hexpand ((GtkWidget*) _vala_bookmarks_controller, TRUE);
	gtk_widget_set_visible ((GtkWidget*) _vala_bookmarks_controller, FALSE);
	gtk_header_bar_pack_start ((GtkHeaderBar*) (*_this), (GtkWidget*) _vala_bookmarks_controller);
	if (bookmarks_controller) {
		*bookmarks_controller = _vala_bookmarks_controller;
	} else {
		_g_object_unref0 (_vala_bookmarks_controller);
	}
}

static void
_bookmarks_header_bar_update_bookmarks_icons_cb_bookmarks_update_bookmarks_icons (Bookmarks* _sender,
                                                                                  GVariant* bookmarks_variant,
                                                                                  gpointer self)
{
	bookmarks_header_bar_update_bookmarks_icons_cb ((BookmarksHeaderBar*) self, bookmarks_variant);
}

static inline void
bookmarks_header_bar_connect_bookmarks_signals (BookmarksHeaderBar* self)
{
	Bookmarks* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_button;
	g_signal_connect_object (_tmp0_, "update-bookmarks-icons", (GCallback) _bookmarks_header_bar_update_bookmarks_icons_cb_bookmarks_update_bookmarks_icons, self, 0);
}

static void
bookmarks_header_bar_update_bookmarks_icons_cb (BookmarksHeaderBar* self,
                                                GVariant* bookmarks_variant)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmarks_variant != NULL);
	g_signal_emit (self, bookmarks_header_bar_signals[BOOKMARKS_HEADER_BAR_UPDATE_BOOKMARKS_ICONS_SIGNAL], 0, bookmarks_variant);
}

static void
bookmarks_header_bar_update_bookmarks_button_visibility (BookmarksHeaderBar* self,
                                                         gboolean transition)
{
	gint _tmp0_ = 0;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (transition) {
		_tmp0_ = 300;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = self->priv->bookmarks_revealer;
	gtk_revealer_set_transition_duration (_tmp1_, (guint) _tmp0_);
	if (!((BaseHeaderBar*) self)->disable_popovers) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = base_header_bar_get_no_in_window_mode ((BaseHeaderBar*) self);
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		bookmarks_header_bar_set_bookmarks_button_visibility (TRUE, &self->priv->bookmarks_revealer, &self->priv->bookmarks_button);
	} else {
		Bookmarks* _tmp5_;
		_tmp5_ = self->priv->bookmarks_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
		bookmarks_header_bar_set_bookmarks_button_visibility (FALSE, &self->priv->bookmarks_revealer, &self->priv->bookmarks_button);
	}
}

static inline void
bookmarks_header_bar_set_bookmarks_button_visibility (gboolean visibility,
                                                      GtkRevealer** bookmarks_revealer,
                                                      Bookmarks** bookmarks_button)
{
	g_return_if_fail (*bookmarks_revealer != NULL);
	g_return_if_fail (*bookmarks_button != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) (*bookmarks_button), visibility);
	gtk_revealer_set_reveal_child (*bookmarks_revealer, visibility);
}

void
bookmarks_header_bar_show_use_bookmarks_view (BookmarksHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (((gint) self->priv->use_bookmarks_mode_id) > 0, "use_bookmarks_mode_id > 0");
	g_signal_emit_by_name ((BaseHeaderBar*) self, "change-mode", self->priv->use_bookmarks_mode_id);
}

static void
_bookmarks_header_bar_mode_changed_bookmarks_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                          guint8 mode_id,
                                                                          gpointer self)
{
	bookmarks_header_bar_mode_changed_bookmarks (_sender, mode_id);
}

static void
bookmarks_header_bar_register_bookmarks_modes (BookmarksHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	self->priv->use_bookmarks_mode_id = base_header_bar_register_new_mode ((BaseHeaderBar*) self);
	self->priv->edit_bookmarks_mode_id = base_header_bar_register_new_mode ((BaseHeaderBar*) self);
	g_signal_connect ((BaseHeaderBar*) self, "change-mode", (GCallback) _bookmarks_header_bar_mode_changed_bookmarks_base_header_bar_change_mode, NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bookmarks_header_bar_mode_changed_bookmarks (BaseHeaderBar* _this,
                                             guint8 requested_mode_id)
{
	BookmarksHeaderBar* real_this = NULL;
	BookmarksHeaderBar* _tmp0_;
	g_return_if_fail (_this != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar));
	real_this = _tmp0_;
	bookmarks_header_bar_mode_changed_use_bookmarks (real_this, requested_mode_id);
	bookmarks_header_bar_mode_changed_edit_bookmarks (real_this, requested_mode_id);
	bookmarks_header_bar_update_bookmarks_button_visibility (real_this, FALSE);
	_g_object_unref0 (real_this);
}

static void
bookmarks_header_bar_mode_changed_use_bookmarks (BookmarksHeaderBar* _this,
                                                 guint8 requested_mode_id)
{
	gboolean _tmp0_;
	g_return_if_fail (_this != NULL);
	_vala_return_if_fail (((gint) _this->priv->use_bookmarks_mode_id) > 0, "_this.use_bookmarks_mode_id > 0");
	_tmp0_ = base_header_bar_is_not_requested_mode (_this->priv->use_bookmarks_mode_id, requested_mode_id, &_this->priv->use_bookmarks_mode_on);
	if (_tmp0_) {
		night_time_aware_header_bar_update_hamburger_menu ((NightTimeAwareHeaderBar*) _this);
		return;
	}
	base_header_bar_set_default_widgets_states ((BaseHeaderBar*) _this, _ ("Bookmarks"), TRUE, FALSE, FALSE, FALSE, TRUE);
}

void
bookmarks_header_bar_show_edit_bookmarks_view (BookmarksHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (((gint) self->priv->edit_bookmarks_mode_id) > 0, "edit_bookmarks_mode_id > 0");
	g_signal_emit_by_name ((BaseHeaderBar*) self, "change-mode", self->priv->edit_bookmarks_mode_id);
}

static void
bookmarks_header_bar_mode_changed_edit_bookmarks (BookmarksHeaderBar* _this,
                                                  guint8 requested_mode_id)
{
	gboolean _tmp0_;
	BookmarksController* _tmp2_;
	g_return_if_fail (_this != NULL);
	_vala_return_if_fail (((gint) _this->priv->edit_bookmarks_mode_id) > 0, "_this.edit_bookmarks_mode_id > 0");
	_tmp0_ = base_header_bar_is_not_requested_mode (_this->priv->edit_bookmarks_mode_id, requested_mode_id, &_this->priv->edit_bookmarks_mode_on);
	if (_tmp0_) {
		BookmarksController* _tmp1_;
		_tmp1_ = _this->priv->bookmarks_controller;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		night_time_aware_header_bar_update_hamburger_menu ((NightTimeAwareHeaderBar*) _this);
		return;
	}
	base_header_bar_set_default_widgets_states ((BaseHeaderBar*) _this, NULL, TRUE, TRUE, FALSE, FALSE, TRUE);
	_tmp2_ = _this->priv->bookmarks_controller;
	gtk_widget_show ((GtkWidget*) _tmp2_);
}

static void
bookmarks_header_bar_install_action_entries (BookmarksHeaderBar* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BOOKMARKS_HEADER_BAR_action_entries, (gint) G_N_ELEMENTS (BOOKMARKS_HEADER_BAR_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "headerbar", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
}

static void
bookmarks_header_bar_bookmark_current (BookmarksHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	bookmarks_header_bar_bookmark_current_path (self);
}

static void
bookmarks_header_bar_unbookmark_current (BookmarksHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	bookmarks_header_bar_unbookmark_current_path (self);
}

gchar**
bookmarks_header_bar_get_bookmarks (BookmarksHeaderBar* self,
                                    gint* result_length1)
{
	Bookmarks* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bookmarks_button;
	_tmp2_ = bookmarks_get_bookmarks (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

void
bookmarks_header_bar_update_bookmark_icon (BookmarksHeaderBar* self,
                                           const gchar* bookmark,
                                           BookmarkIcon icon)
{
	Bookmarks* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = self->priv->bookmarks_button;
	bookmarks_update_bookmark_icon (_tmp0_, bookmark, icon);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
bookmarks_header_bar_real_populate_menu (BaseHeaderBar* base,
                                         GMenu** menu)
{
	BookmarksHeaderBar * self;
	gboolean _tmp0_ = FALSE;
	gboolean bookmarks_mode_on = FALSE;
	self = (BookmarksHeaderBar*) base;
	g_return_if_fail (*menu != NULL);
	BASE_HEADER_BAR_CLASS (bookmarks_header_bar_parent_class)->populate_menu ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar), menu);
	if (self->priv->use_bookmarks_mode_on) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->edit_bookmarks_mode_on;
	}
	bookmarks_mode_on = _tmp0_;
	if (((BaseHeaderBar*) self)->disable_popovers) {
		const gchar* _tmp1_;
		gint _tmp2_ = 0;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = self->priv->bookmark_name;
		_tmp3_ = bookmarks_header_bar_get_bookmarks (self, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp2_;
		bookmarks_header_bar_append_bookmark_section (_vala_string_array_contains (_tmp4_, _tmp2_, _tmp1_), bookmarks_mode_on, menu);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
bookmarks_header_bar_append_bookmark_section (gboolean is_in_bookmarks,
                                              gboolean bookmarks_mode_on,
                                              GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	if (bookmarks_mode_on) {
		GMenu* _tmp1_;
		_tmp1_ = section;
		g_menu_append (_tmp1_, _ ("Hide bookmarks"), "ui.empty");
	} else {
		GMenu* _tmp4_;
		if (is_in_bookmarks) {
			GMenu* _tmp2_;
			_tmp2_ = section;
			g_menu_append (_tmp2_, _ ("Unbookmark"), "headerbar.unbookmark-current");
		} else {
			GMenu* _tmp3_;
			_tmp3_ = section;
			g_menu_append (_tmp3_, _ ("Bookmark"), "headerbar.bookmark-current");
		}
		_tmp4_ = section;
		g_menu_append (_tmp4_, _ ("Show bookmarks"), "bw.show-in-window-bookmarks");
	}
	_tmp5_ = section;
	g_menu_freeze (_tmp5_);
	_tmp6_ = section;
	g_menu_append_section (*menu, NULL, (GMenuModel*) _tmp6_);
	_g_object_unref0 (section);
}

static gboolean
bookmarks_header_bar_real_next_match (BookmarksHeaderBar* self)
{
	Bookmarks* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->bookmarks_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Bookmarks* _tmp3_;
		_tmp3_ = self->priv->bookmarks_button;
		result = bookmarks_next_match (_tmp3_);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
bookmarks_header_bar_next_match (BookmarksHeaderBar* self)
{
	BookmarksHeaderBarClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOOKMARKS_HEADER_BAR_GET_CLASS (self);
	if (_klass_->next_match) {
		return _klass_->next_match (self);
	}
	return FALSE;
}

static gboolean
bookmarks_header_bar_real_previous_match (BookmarksHeaderBar* self)
{
	Bookmarks* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->bookmarks_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Bookmarks* _tmp3_;
		_tmp3_ = self->priv->bookmarks_button;
		result = bookmarks_previous_match (_tmp3_);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
bookmarks_header_bar_previous_match (BookmarksHeaderBar* self)
{
	BookmarksHeaderBarClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOOKMARKS_HEADER_BAR_GET_CLASS (self);
	if (_klass_->previous_match) {
		return _klass_->previous_match (self);
	}
	return FALSE;
}

gboolean
bookmarks_header_bar_handle_copy_text (BookmarksHeaderBar* self,
                                       gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	Bookmarks* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bookmarks_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Bookmarks* _tmp3_;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp3_ = self->priv->bookmarks_button;
		_tmp5_ = bookmarks_handle_copy_text (_tmp3_, &_tmp4_);
		_g_free0 (_vala_copy_text);
		_vala_copy_text = _tmp4_;
		result = _tmp5_;
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	_tmp7_ = base_window_no_copy_text (&_tmp6_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp6_;
	result = _tmp7_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

void
bookmarks_header_bar_click_bookmarks_button (BookmarksHeaderBar* self)
{
	Bookmarks* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	base_header_bar_hide_hamburger_menu ((BaseHeaderBar*) self);
	_tmp0_ = self->priv->bookmarks_button;
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Bookmarks* _tmp3_;
		_tmp3_ = self->priv->bookmarks_button;
		gtk_button_clicked ((GtkButton*) _tmp3_);
	}
}

void
bookmarks_header_bar_bookmark_current_path (BookmarksHeaderBar* self)
{
	Bookmarks* _tmp0_;
	g_return_if_fail (self != NULL);
	base_header_bar_hide_hamburger_menu ((BaseHeaderBar*) self);
	_tmp0_ = self->priv->bookmarks_button;
	bookmarks_bookmark_current_path (_tmp0_);
	night_time_aware_header_bar_update_hamburger_menu ((NightTimeAwareHeaderBar*) self);
}

void
bookmarks_header_bar_unbookmark_current_path (BookmarksHeaderBar* self)
{
	Bookmarks* _tmp0_;
	g_return_if_fail (self != NULL);
	base_header_bar_hide_hamburger_menu ((BaseHeaderBar*) self);
	_tmp0_ = self->priv->bookmarks_button;
	bookmarks_unbookmark_current_path (_tmp0_);
	night_time_aware_header_bar_update_hamburger_menu ((NightTimeAwareHeaderBar*) self);
}

static void
bookmarks_header_bar_real_close_popovers (BaseHeaderBar* base)
{
	BookmarksHeaderBar * self;
	Bookmarks* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (BookmarksHeaderBar*) base;
	BASE_HEADER_BAR_CLASS (bookmarks_header_bar_parent_class)->close_popovers ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar));
	_tmp0_ = self->priv->bookmarks_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Bookmarks* _tmp3_;
		_tmp3_ = self->priv->bookmarks_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, FALSE);
	}
}

static gboolean
bookmarks_header_bar_real_has_popover (BaseHeaderBar* base)
{
	BookmarksHeaderBar * self;
	gboolean _tmp0_ = FALSE;
	Bookmarks* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = (BookmarksHeaderBar*) base;
	_tmp1_ = self->priv->bookmarks_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = BASE_HEADER_BAR_CLASS (bookmarks_header_bar_parent_class)->has_popover ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar));
	}
	result = _tmp0_;
	return result;
}

BookmarksHeaderBar*
bookmarks_header_bar_construct (GType object_type)
{
	BookmarksHeaderBar * self = NULL;
	self = (BookmarksHeaderBar*) browser_header_bar_construct (object_type);
	return self;
}

static GObject *
bookmarks_header_bar_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BookmarksHeaderBar * self;
	GtkBox* _tmp0_;
	GtkRevealer* _tmp1_ = NULL;
	Bookmarks* _tmp2_ = NULL;
	BookmarksController* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (bookmarks_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar);
	bookmarks_header_bar_install_action_entries (self);
	_tmp0_ = ((BaseHeaderBar*) self)->center_box;
	bookmarks_header_bar_add_bookmarks_revealer (&_tmp1_, &_tmp2_, _tmp0_);
	_g_object_unref0 (self->priv->bookmarks_revealer);
	self->priv->bookmarks_revealer = _tmp1_;
	_g_object_unref0 (self->priv->bookmarks_button);
	self->priv->bookmarks_button = _tmp2_;
	bookmarks_header_bar_connect_bookmarks_signals (self);
	bookmarks_header_bar_add_bookmarks_controller (&_tmp3_, &self);
	_g_object_unref0 (self->priv->bookmarks_controller);
	self->priv->bookmarks_controller = _tmp3_;
	bookmarks_header_bar_register_bookmarks_modes (self);
	return obj;
}

static void
bookmarks_header_bar_class_init (BookmarksHeaderBarClass * klass,
                                 gpointer klass_data)
{
	bookmarks_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BookmarksHeaderBar_private_offset);
	((BrowserHeaderBarClass *) klass)->set_path = (void (*) (BrowserHeaderBar*, ViewType, const gchar*)) bookmarks_header_bar_real_set_path;
	((BaseHeaderBarClass *) klass)->set_window_size = (void (*) (BaseHeaderBar*, AdaptativeWidgetWindowSize)) bookmarks_header_bar_real_set_window_size;
	((BaseHeaderBarClass *) klass)->populate_menu = (void (*) (BaseHeaderBar*, GMenu**)) bookmarks_header_bar_real_populate_menu;
	((BookmarksHeaderBarClass *) klass)->next_match = (gboolean (*) (BookmarksHeaderBar*)) bookmarks_header_bar_real_next_match;
	((BookmarksHeaderBarClass *) klass)->previous_match = (gboolean (*) (BookmarksHeaderBar*)) bookmarks_header_bar_real_previous_match;
	((BaseHeaderBarClass *) klass)->close_popovers = (void (*) (BaseHeaderBar*)) bookmarks_header_bar_real_close_popovers;
	((BaseHeaderBarClass *) klass)->has_popover = (gboolean (*) (BaseHeaderBar*)) bookmarks_header_bar_real_has_popover;
	G_OBJECT_CLASS (klass)->constructor = bookmarks_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = bookmarks_header_bar_finalize;
	bookmarks_header_bar_signals[BOOKMARKS_HEADER_BAR_UPDATE_BOOKMARKS_ICONS_SIGNAL] = g_signal_new ("update-bookmarks-icons", TYPE_BOOKMARKS_HEADER_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
}

static void
bookmarks_header_bar_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                       gpointer iface_data)
{
	bookmarks_header_bar_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) bookmarks_header_bar_real_set_window_size;
}

static void
bookmarks_header_bar_instance_init (BookmarksHeaderBar * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = bookmarks_header_bar_get_instance_private (self);
	_tmp0_ = g_strdup ("/");
	self->priv->bookmark_name = _tmp0_;
	self->priv->use_bookmarks_mode_id = (guint8) 0;
	self->priv->use_bookmarks_mode_on = FALSE;
	self->priv->edit_bookmarks_mode_id = (guint8) 0;
	self->priv->edit_bookmarks_mode_on = FALSE;
}

static void
bookmarks_header_bar_finalize (GObject * obj)
{
	BookmarksHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar);
	_g_free0 (self->priv->bookmark_name);
	_g_object_unref0 (self->priv->bookmarks_revealer);
	_g_object_unref0 (self->priv->bookmarks_button);
	_g_object_unref0 (self->priv->bookmarks_controller);
	G_OBJECT_CLASS (bookmarks_header_bar_parent_class)->finalize (obj);
}

static GType
bookmarks_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookmarksHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmarks_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookmarksHeaderBar), 0, (GInstanceInitFunc) bookmarks_header_bar_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) bookmarks_header_bar_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType bookmarks_header_bar_type_id;
	bookmarks_header_bar_type_id = g_type_register_static (TYPE_BROWSER_HEADER_BAR, "BookmarksHeaderBar", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (bookmarks_header_bar_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BookmarksHeaderBar_private_offset = g_type_add_instance_private (bookmarks_header_bar_type_id, sizeof (BookmarksHeaderBarPrivate));
	return bookmarks_header_bar_type_id;
}

GType
bookmarks_header_bar_get_type (void)
{
	static volatile gsize bookmarks_header_bar_type_id__once = 0;
	if (g_once_init_enter (&bookmarks_header_bar_type_id__once)) {
		GType bookmarks_header_bar_type_id;
		bookmarks_header_bar_type_id = bookmarks_header_bar_get_type_once ();
		g_once_init_leave (&bookmarks_header_bar_type_id__once, bookmarks_header_bar_type_id);
	}
	return bookmarks_header_bar_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

