/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJrt;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJsr199;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileObject;
import org.eclipse.jdt.internal.compiler.tool.ExceptionDiagnostic;
import org.eclipse.jdt.internal.compiler.tool.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class EclipseCompilerImpl
extends Main {
    private static final CompilationUnit[] NO_UNITS = new CompilationUnit[0];
    private static final String RELEASE_FILE = "release";
    private static final String JAVA_VERSION = "JAVA_VERSION";
    private HashMap<CompilationUnit, JavaFileObject> javaFileObjectMap;
    Iterable<? extends JavaFileObject> compilationUnits;
    public JavaFileManager fileManager;
    protected Processor[] processors;
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;

    public EclipseCompilerImpl(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        super(printWriter, printWriter2, bl, null, null);
    }

    public boolean call() {
        try {
            this.handleLocations();
            if (this.proceed) {
                this.globalProblemsCount = 0;
                this.globalErrorsCount = 0;
                this.globalWarningsCount = 0;
                this.globalTasksCount = 0;
                this.exportedClassFilesCounter = 0;
                this.performCompilation();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.diagnosticListener.report(new ExceptionDiagnostic(illegalArgumentException));
            this.logger.logException(illegalArgumentException);
            if (this.systemExitWhenFinished) {
                this.cleanup();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.diagnosticListener.report(new ExceptionDiagnostic(runtimeException));
            this.logger.logException(runtimeException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup();
        }
        if (this.failOnWarning && this.globalWarningsCount > 0) {
            return false;
        }
        return this.globalErrorsCount == 0;
    }

    private void cleanup() {
        this.logger.flush();
        this.logger.close();
        this.processors = null;
        try {
            if (this.fileManager != null) {
                this.fileManager.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        if (this.compilationUnits == null) {
            return NO_UNITS;
        }
        HashtableOfObject hashtableOfObject = new HashtableOfObject();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (final JavaFileObject javaFileObject : this.compilationUnits) {
                String string = javaFileObject.getName();
                char[] cArray = string.toCharArray();
                boolean bl = CharOperation.endsWith(cArray, TypeConstants.MODULE_INFO_FILE_NAME);
                if (bl == (i == 0)) {
                    Object object;
                    if (hashtableOfObject.get(cArray) != null) {
                        throw new IllegalArgumentException(this.bind("unit.more", string));
                    }
                    hashtableOfObject.put(cArray, cArray);
                    boolean bl2 = false;
                    try {
                        if (this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                            bl2 = this.fileManager.contains(StandardLocation.SOURCE_PATH, javaFileObject);
                        }
                        if (!bl2 && this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                            bl2 = this.fileManager.contains(StandardLocation.MODULE_SOURCE_PATH, javaFileObject);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!bl2 && !((File)(object = new File(string))).exists()) {
                        throw new IllegalArgumentException(this.bind("unit.missing", string));
                    }
                    object = new CompilationUnit(null, string, null, this.destinationPaths[n], EclipseCompilerImpl.shouldIgnoreOptionalProblems(this.ignoreOptionalProblemsFromFolders, string.toCharArray()), this.modNames[n]){

                        @Override
                        public char[] getContents() {
                            try {
                                return javaFileObject.getCharContent(true).toString().toCharArray();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                throw new AbortCompilationUnit(null, iOException, null);
                            }
                        }
                    };
                    arrayList.add(object);
                    this.javaFileObjectMap.put((CompilationUnit)object, javaFileObject);
                }
                ++n;
            }
        }
        CompilationUnit[] compilationUnitArray = new CompilationUnit[arrayList.size()];
        arrayList.toArray(compilationUnitArray);
        return compilationUnitArray;
    }

    @Override
    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return false;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    @Override
    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(){

            @Override
            public CategorizedProblem createProblem(final char[] cArray, final int n, final String[] stringArray, String[] stringArray2, final int n2, final int n3, final int n4, final int n5, final int n6) {
                CategorizedProblem categorizedProblem;
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompilerImpl.this.diagnosticListener;
                Diagnostic<JavaFileObject> diagnostic = null;
                if (diagnosticListener != null) {
                    diagnostic = new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(n);
                        }

                        @Override
                        public long getColumnNumber() {
                            return n6;
                        }

                        @Override
                        public long getEndPosition() {
                            return n4;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((n2 & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((n2 & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if ((n2 & 0) != 0) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return n5;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(n, stringArray);
                        }

                        @Override
                        public long getPosition() {
                            return n3;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File file = new File(new String(cArray));
                            if (file.exists()) {
                                return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return n3;
                        }
                    };
                }
                if ((categorizedProblem = super.createProblem(cArray, n, stringArray, stringArray2, n2, n3, n4, n5, n6)) instanceof DefaultProblem && diagnostic != null) {
                    return new Jsr199ProblemWrapper((DefaultProblem)categorizedProblem, diagnostic, diagnosticListener);
                }
                return categorizedProblem;
            }

            @Override
            public CategorizedProblem createProblem(final char[] cArray, final int n, final String[] stringArray, int n2, String[] stringArray2, final int n3, final int n4, final int n5, final int n6, final int n7) {
                CategorizedProblem categorizedProblem;
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompilerImpl.this.diagnosticListener;
                Diagnostic<JavaFileObject> diagnostic = null;
                if (diagnosticListener != null) {
                    diagnostic = new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(n);
                        }

                        @Override
                        public long getColumnNumber() {
                            return n7;
                        }

                        @Override
                        public long getEndPosition() {
                            return n5;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((n3 & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((n3 & 0x400) != 0) {
                                return Diagnostic.Kind.NOTE;
                            }
                            if ((n3 & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if ((n3 & 0) != 0) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return n6;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(n, stringArray);
                        }

                        @Override
                        public long getPosition() {
                            return n4;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File file = new File(new String(cArray));
                            if (file.exists()) {
                                return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return n4;
                        }
                    };
                }
                if ((categorizedProblem = super.createProblem(cArray, n, stringArray, n2, stringArray2, n3, n4, n5, n6, n7)) instanceof DefaultProblem && diagnostic != null) {
                    return new Jsr199ProblemWrapper((DefaultProblem)categorizedProblem, diagnostic, diagnosticListener);
                }
                return categorizedProblem;
            }
        };
    }

    @Override
    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map<String, String> map, CompilationProgress compilationProgress) {
        super.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.javaFileObjectMap = new HashMap();
    }

    @Override
    protected void initializeAnnotationProcessorManager() {
        super.initializeAnnotationProcessorManager();
        if (this.batchCompiler.annotationProcessorManager != null && this.processors != null) {
            this.batchCompiler.annotationProcessorManager.setProcessors(this.processors);
        } else if (this.processors != null) {
            throw new UnsupportedOperationException("Cannot handle annotation processing");
        }
    }

    @Override
    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            boolean bl = this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT);
            File file = null;
            String string = compilationResult.getCompilationUnit().getDestinationPath();
            if (string == null) {
                string = this.destinationPath;
            }
            if (string != null) {
                file = new File(string);
                file.mkdirs();
            }
            int n = classFileArray.length;
            for (int i = 0; i < n; ++i) {
                ClassFile classFile = classFileArray[i];
                char[] cArray = classFile.fileName();
                int n2 = cArray.length;
                char[] cArray2 = new char[n2 + 6];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n2, 6);
                CharOperation.replace(cArray2, '/', File.separatorChar);
                String string2 = new String(cArray2);
                if (this.compilerOptions.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                }
                try {
                    Object object;
                    Object object2;
                    char[] cArray3 = compilationResult.compilationUnit.getModuleName();
                    JavaFileManager.Location location = null;
                    location = cArray3 == null ? StandardLocation.CLASS_OUTPUT : this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, new String(cArray3));
                    JavaFileObject javaFileObject = this.fileManager.getJavaFileForOutput(location, new String(cArray), JavaFileObject.Kind.CLASS, this.javaFileObjectMap.get(compilationResult.compilationUnit));
                    if (bl) {
                        if (string != null) {
                            int n3 = CharOperation.lastIndexOf(File.separatorChar, cArray2);
                            if (n3 != -1) {
                                object2 = new File(string, string2.substring(0, n3));
                                ((File)object2).mkdirs();
                            }
                        } else {
                            int n4;
                            object = javaFileObject.toUri();
                            if ((((URI)object).getScheme() == null || ((URI)object).getScheme().equals("file")) && (n4 = ((String)(object2 = ((URI)object).getPath())).lastIndexOf(47)) != -1) {
                                File file2 = new File(((String)object2).substring(0, n4));
                                file2.mkdirs();
                            }
                        }
                    }
                    object = javaFileObject.openOutputStream();
                    try {
                        object2 = new BufferedOutputStream((OutputStream)object);
                        try {
                            ((BufferedOutputStream)object2).write(classFile.header, 0, classFile.headerOffset);
                            ((BufferedOutputStream)object2).write(classFile.contents, 0, classFile.contentsOffset);
                            ((BufferedOutputStream)object2).flush();
                        }
                        finally {
                            ((FilterOutputStream)object2).close();
                        }
                    }
                    finally {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.logger.logNoClassFileCreated(string, string2, iOException);
                }
                this.logger.logClassFile(bl, string, string2);
                ++this.exportedClassFilesCounter;
            }
            this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
        }
    }

    @Override
    protected void setPaths(ArrayList<String> arrayList, String string, ArrayList<String> arrayList2, ArrayList<String> arrayList3, String string2, String string3, ArrayList<String> arrayList4, ArrayList<String> arrayList5, String string4) {
        this.validateClasspathOptions(arrayList, arrayList5, arrayList4);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleLocations() {
        block52: {
            block53: {
                block51: {
                    var1_1 = new ArrayList<FileSystem.Classpath>();
                    var2_2 = null;
                    var3_3 = null;
                    var4_4 = null;
                    var5_5 = false;
                    var6_6 = false;
                    if (this.fileManager instanceof EclipseFileManager) {
                        var2_2 = (EclipseFileManager)this.fileManager;
                    }
                    if (this.fileManager instanceof StandardJavaFileManager) {
                        var3_3 = (StandardJavaFileManager)this.fileManager;
                    }
                    var4_4 = this.fileManager;
                    if (var2_2 != null && (var2_2.flags & 4) == 0 && (var2_2.flags & 2) != 0) {
                        var1_1.addAll(this.handleEndorseddirs(null));
                    }
                    var7_7 = null;
                    if (var3_3 == null) break block51;
                    var7_7 = var3_3.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                    if (var7_7 == null) break block52;
                    var8_8 = var7_7.iterator();
                    break block53;
                }
                if (var4_4 == null) break block52;
                var8_8 = Util.getJavaHome();
                var9_17 = Util.getJDKLevel((File)var8_8);
                if (var9_17 >= 0x350000L) {
                    var11_34 = this.getSystemClasspath((File)var8_8, var9_17);
                    var12_40 = new ClasspathJsr199(var11_34, this.fileManager, (JavaFileManager.Location)StandardLocation.SYSTEM_MODULES);
                    var1_1.add(var12_40);
                    var12_40 = new ClasspathJsr199(var11_34, this.fileManager, (JavaFileManager.Location)StandardLocation.PLATFORM_CLASS_PATH);
                    var1_1.add(var12_40);
                } else {
                    var11_34 = new ClasspathJsr199(this.fileManager, StandardLocation.PLATFORM_CLASS_PATH);
                    var1_1.add(var11_34);
                }
                var5_5 = true;
                break block52;
            }
            while (var8_8.hasNext()) {
                var9_16 = (File)var8_8.next();
                if (var9_16.isDirectory()) {
                    var10_32 = this.getPlatformLocations(var9_16);
                    if (var3_3 instanceof EclipseFileManager && var10_32.size() == 1 && (var11_34 = (FileSystem.Classpath)var10_32.get(0)) instanceof ClasspathJrt) {
                        var12_40 = (ClasspathJrt)var11_34;
                        try {
                            var13_41 = (EclipseFileManager)var3_3;
                            var14_43 = var13_41.getJrtFileSystem(var12_40.file);
                            var13_41.locationHandler.newSystemLocation(StandardLocation.SYSTEM_MODULES, (JrtFileSystem)var14_43);
                        }
                        catch (IOException var13_42) {
                            var13_42.printStackTrace();
                        }
                    }
                    var1_1.addAll((Collection<FileSystem.Classpath>)var10_32);
                    break;
                }
                var10_32 = FileSystem.getClasspath(var9_16.getAbsolutePath(), null, null, this.options, this.releaseVersion);
                if (var10_32 == null) continue;
                var1_1.add((FileSystem.Classpath)var10_32);
                var5_5 = true;
            }
        }
        if (var2_2 != null && (var2_2.flags & 1) == 0 && (var2_2.flags & 2) != 0) {
            var1_1.addAll(this.handleExtdirs(null));
        }
        if (var3_3 != null) {
            var7_7 = var3_3.getLocation(StandardLocation.SOURCE_PATH);
            if (var7_7 != null) {
                for (File var9_19 : var7_7) {
                    var10_32 = FileSystem.getClasspath(var9_19.getAbsolutePath(), null, null, this.options, this.releaseVersion);
                    if (var10_32 == null) continue;
                    var1_1.add((FileSystem.Classpath)var10_32);
                }
            }
            if ((var7_7 = var3_3.getLocation(StandardLocation.CLASS_PATH)) != null) {
                for (File var9_21 : var7_7) {
                    var10_32 = FileSystem.getClasspath(var9_21.getAbsolutePath(), null, null, this.options, this.releaseVersion);
                    if (var10_32 == null) continue;
                    var1_1.add((FileSystem.Classpath)var10_32);
                    var6_6 = true;
                }
            }
            if ((var7_7 = var3_3.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) != null) {
                for (File var9_23 : var7_7) {
                    if (!var9_23.isDirectory()) continue;
                    var10_32 = this.getJavaVersion(var9_23);
                    var11_35 = var10_32.equals("") != false ? this.complianceLevel : CompilerOptions.versionToJdkLevel(var10_32);
                    var13_41 = this.getSystemClasspath(var9_23, var11_35);
                    var14_43 = new ClasspathJsr199((FileSystem.Classpath)var13_41, this.fileManager, (JavaFileManager.Location)StandardLocation.PLATFORM_CLASS_PATH);
                    var1_1.add((FileSystem.Classpath)var14_43);
                    if (var3_3.getLocation(StandardLocation.SYSTEM_MODULES) == null) {
                        var14_43 = new ClasspathJsr199((FileSystem.Classpath)var13_41, this.fileManager, (JavaFileManager.Location)StandardLocation.SYSTEM_MODULES);
                        var1_1.add((FileSystem.Classpath)var14_43);
                    }
                    var6_6 = true;
                    break;
                }
            }
            if ((var7_7 = var3_3.getLocation(StandardLocation.SYSTEM_MODULES)) != null) {
                for (File var9_25 : var7_7) {
                    if (!var9_25.isDirectory()) continue;
                    var10_32 = this.getJavaVersion(var9_25);
                    var11_36 = var10_32.equals("") != false ? this.complianceLevel : CompilerOptions.versionToJdkLevel(var10_32);
                    var13_41 = this.getSystemClasspath(var9_25, var11_36);
                    var14_43 = new ClasspathJsr199((FileSystem.Classpath)var13_41, this.fileManager, (JavaFileManager.Location)StandardLocation.SYSTEM_MODULES);
                    var1_1.add((FileSystem.Classpath)var14_43);
                    if (var3_3.getLocation(StandardLocation.PLATFORM_CLASS_PATH) == null) {
                        var14_43 = new ClasspathJsr199((FileSystem.Classpath)var13_41, this.fileManager, (JavaFileManager.Location)StandardLocation.PLATFORM_CLASS_PATH);
                        var1_1.add((FileSystem.Classpath)var14_43);
                    }
                    var6_6 = true;
                    break;
                }
            }
            try {
                var8_8 = var3_3.getLocationAsPaths(StandardLocation.MODULE_SOURCE_PATH);
                if (var8_8 != null) {
                    var9_26 = new StringBuilder();
                    var10_32 = var8_8.iterator();
                    while (var10_32.hasNext()) {
                        var11_37 = (Path)var10_32.next();
                        var9_26.append(var11_37.toFile().getCanonicalPath());
                        var9_26.append(File.pathSeparator);
                    }
                    var10_32 = this.handleModuleSourcepath(var9_26.toString());
                    var11_38 = var10_32.iterator();
                    while (var11_38.hasNext()) {
                        var12_40 = var11_38.next();
                        var13_41 = var12_40.getModuleNames(null);
                        for (String var15_44 : var13_41) {
                            var16_45 = Paths.get(var12_40.getPath(), new String[0]);
                            var3_3.setLocationForModule(StandardLocation.MODULE_SOURCE_PATH, var15_44, Collections.singletonList(var16_45));
                            var16_45 = Paths.get(var12_40.getDestinationPath(), new String[0]);
                        }
                    }
                    var1_1.addAll((Collection<FileSystem.Classpath>)var10_32);
                }
            }
            catch (IllegalStateException var8_9) {
            }
            catch (IllegalArgumentException var8_10) {
                throw var8_10;
            }
            catch (Exception var8_11) {
                this.logger.logException(var8_11);
            }
            try {
                var7_7 = var3_3.getLocation(StandardLocation.MODULE_PATH);
                if (var7_7 == null) ** GOTO lbl197
                for (File var9_29 : var7_7) {
                    try {
                        var10_32 = this.handleModulepath(var9_29.getCanonicalPath());
                        var11_39 = var10_32.iterator();
                        while (var11_39.hasNext()) {
                            var12_40 = var11_39.next();
                            var13_41 = var12_40.getModuleNames(null);
                            for (String var15_44 : var13_41) {
                                var16_45 = Paths.get(var12_40.getPath(), new String[0]);
                                var3_3.setLocationForModule(StandardLocation.MODULE_PATH, var15_44, Collections.singletonList(var16_45));
                            }
                        }
                        var1_1.addAll((Collection<FileSystem.Classpath>)var10_32);
                    }
                    catch (IOException var10_33) {
                        throw new AbortCompilationUnit(null, var10_33, null);
                    }
                }
            }
            catch (IllegalStateException var8_12) {
            }
            catch (IllegalArgumentException var8_13) {
                throw var8_13;
            }
            catch (Exception var8_14) {
                this.logger.logException(var8_14);
            }
        } else if (var4_4 != null) {
            var8_8 = null;
            if (this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.SOURCE_PATH);
                var1_1.add((FileSystem.Classpath)var8_8);
            }
            if (this.fileManager.hasLocation(StandardLocation.UPGRADE_MODULE_PATH)) {
                var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.UPGRADE_MODULE_PATH);
            }
            if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
                var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.PATCH_MODULE_PATH);
                var1_1.add((FileSystem.Classpath)var8_8);
            }
            if (this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.MODULE_SOURCE_PATH);
                var1_1.add((FileSystem.Classpath)var8_8);
            }
            if (this.fileManager.hasLocation(StandardLocation.MODULE_PATH)) {
                var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.MODULE_PATH);
                var1_1.add((FileSystem.Classpath)var8_8);
            }
            var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.CLASS_PATH);
            var1_1.add((FileSystem.Classpath)var8_8);
            var6_6 = true;
        }
lbl197:
        // 7 sources

        if (this.checkedClasspaths == null) {
            if (!var5_5) {
                var1_1.addAll(this.handleBootclasspath(null, null));
            }
            if (!var6_6) {
                var1_1.addAll(this.handleClasspath(null, null));
            }
        }
        if ((var8_15 = (var1_1 = FileSystem.ClasspathNormalizer.normalize(var1_1)).size()) != 0) {
            this.checkedClasspaths = new FileSystem.Classpath[var8_15];
            var9_30 = false;
            for (FileSystem.Classpath var11_34 : var1_1) {
                this.checkedClasspaths[++var9_31] = var11_34;
            }
        }
    }

    private String getJavaVersion(File file) {
        String string2 = "";
        if (Files.notExists(Paths.get(file.getAbsolutePath(), RELEASE_FILE), new LinkOption[0])) {
            return string2;
        }
        try (Stream<String> stream = Files.lines(Paths.get(file.getAbsolutePath(), RELEASE_FILE), Charset.defaultCharset()).filter(string -> string.contains(JAVA_VERSION));){
            Optional<String> optional = stream.findFirst();
            if (optional.isPresent()) {
                String string3 = optional.get();
                string2 = string3.substring(14, string3.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private FileSystem.Classpath getSystemClasspath(File file, long l) {
        FileSystem.Classpath classpath;
        if (this.releaseVersion != null && this.complianceLevel < l) {
            String string = CompilerOptions.versionFromJdkLevel(this.complianceLevel);
            if (string.length() >= 3) {
                string = string.substring(2);
            }
            classpath = FileSystem.getOlderSystemRelease(file.getAbsolutePath(), string, null);
        } else {
            classpath = FileSystem.getJrtClasspath(file.toString(), null, null, null);
        }
        return classpath;
    }

    protected List<FileSystem.Classpath> getPlatformLocations(File file) {
        List<FileSystem.Classpath> list = Util.collectPlatformLibraries(file);
        return list;
    }

    @Override
    protected void loggingExtraProblems() {
        super.loggingExtraProblems();
        for (final CategorizedProblem categorizedProblem : this.extraProblems) {
            if (this.diagnosticListener == null || this.isIgnored(categorizedProblem)) continue;
            Diagnostic<JavaFileObject> diagnostic = new Diagnostic<JavaFileObject>(){

                @Override
                public String getCode() {
                    return null;
                }

                @Override
                public long getColumnNumber() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).column;
                    }
                    return -1L;
                }

                @Override
                public long getEndPosition() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceEnd();
                    }
                    return -1L;
                }

                @Override
                public Diagnostic.Kind getKind() {
                    if (categorizedProblem.isError()) {
                        return Diagnostic.Kind.ERROR;
                    }
                    if (categorizedProblem.isWarning()) {
                        return Diagnostic.Kind.WARNING;
                    }
                    if (categorizedProblem instanceof DefaultProblem && ((DefaultProblem)categorizedProblem).isInfo()) {
                        return Diagnostic.Kind.NOTE;
                    }
                    return Diagnostic.Kind.OTHER;
                }

                @Override
                public long getLineNumber() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceLineNumber();
                    }
                    return -1L;
                }

                @Override
                public String getMessage(Locale locale) {
                    return categorizedProblem.getMessage();
                }

                @Override
                public long getPosition() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceStart();
                    }
                    return -1L;
                }

                @Override
                public JavaFileObject getSource() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        char[] cArray = ((DefaultProblem)categorizedProblem).getOriginatingFileName();
                        if (cArray == null) {
                            return null;
                        }
                        File file = new File(new String(cArray));
                        if (file.exists()) {
                            Charset charset = EclipseCompilerImpl.this.fileManager instanceof EclipseFileManager ? ((EclipseFileManager)EclipseCompilerImpl.this.fileManager).charset : Charset.defaultCharset();
                            return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, charset);
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public long getStartPosition() {
                    return this.getPosition();
                }
            };
            this.diagnosticListener.report((Diagnostic<? super JavaFileObject>)diagnostic);
        }
    }

    class Jsr199ProblemWrapper
    extends DefaultProblem {
        DefaultProblem original;
        DiagnosticListener<? super JavaFileObject> listener;
        Diagnostic<JavaFileObject> diagnostic;

        public Jsr199ProblemWrapper(DefaultProblem defaultProblem, Diagnostic<JavaFileObject> diagnostic, DiagnosticListener<? super JavaFileObject> diagnosticListener) {
            super(defaultProblem.getOriginatingFileName(), defaultProblem.getMessage(), defaultProblem.getID(), defaultProblem.getArguments(), defaultProblem.severity, defaultProblem.getSourceStart(), defaultProblem.getSourceEnd(), defaultProblem.getSourceLineNumber(), defaultProblem.column);
            this.original = defaultProblem;
            this.listener = diagnosticListener;
            this.diagnostic = diagnostic;
        }

        @Override
        public void reportError() {
            this.listener.report(this.diagnostic);
        }

        @Override
        public String[] getArguments() {
            return this.original.getArguments();
        }

        @Override
        public int getID() {
            return this.original.getID();
        }

        @Override
        public String getMessage() {
            return this.original.getMessage();
        }

        @Override
        public char[] getOriginatingFileName() {
            return this.original.getOriginatingFileName();
        }

        @Override
        public int getSourceEnd() {
            return this.original.getSourceEnd();
        }

        @Override
        public int getSourceLineNumber() {
            return this.original.getSourceLineNumber();
        }

        @Override
        public int getSourceStart() {
            return this.original.getSourceStart();
        }

        @Override
        public boolean isError() {
            return this.original.isError();
        }

        @Override
        public boolean isWarning() {
            return this.original.isWarning();
        }

        @Override
        public boolean isInfo() {
            return this.original.isInfo();
        }

        @Override
        public void setSourceEnd(int n) {
            this.original.setSourceEnd(n);
        }

        @Override
        public void setSourceLineNumber(int n) {
            this.original.setSourceLineNumber(n);
        }

        @Override
        public void setSourceStart(int n) {
            this.original.setSourceStart(n);
        }

        @Override
        public int getCategoryID() {
            return this.original.getCategoryID();
        }

        @Override
        public String getMarkerType() {
            return this.original.getMarkerType();
        }
    }
}

