// Generated by gmmproc 2.74.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/tlscertificate.h>
#include <giomm/private/tlscertificate_p.h>


/* Copyright (C) 2012 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glibmm/bytearray.h>
#include <giomm/socketconnectable.h>

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::TlsCertificate> wrap(GTlsCertificate* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gio::TlsCertificate>( dynamic_cast<Gio::TlsCertificate*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& TlsCertificate_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &TlsCertificate_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_tls_certificate_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void TlsCertificate_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->verify = &verify_vfunc_callback;

}

GTlsCertificateFlags TlsCertificate_Class::verify_vfunc_callback(GTlsCertificate* self, GSocketConnectable* identity, GTlsCertificate* trusted_ca)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<GTlsCertificateFlags>(obj->verify_vfunc(Glib::wrap(identity, true)
, Glib::wrap(trusted_ca, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->verify)
    return (*base->verify)(self, identity, trusted_ca);

  using RType = GTlsCertificateFlags;
  return RType();
}


Glib::ObjectBase* TlsCertificate_Class::wrap_new(GObject* object)
{
  return new TlsCertificate((GTlsCertificate*)object);
}


/* The implementation: */

GTlsCertificate* TlsCertificate::gobj_copy()
{
  reference();
  return gobj();
}

TlsCertificate::TlsCertificate(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

TlsCertificate::TlsCertificate(GTlsCertificate* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


TlsCertificate::TlsCertificate(TlsCertificate&& src) noexcept
: Glib::Object(std::move(src))
{}

TlsCertificate& TlsCertificate::operator=(TlsCertificate&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


TlsCertificate::~TlsCertificate() noexcept
{}


TlsCertificate::CppClassType TlsCertificate::tlscertificate_class_; // initialize static member

GType TlsCertificate::get_type()
{
  return tlscertificate_class_.init().get_type();
}


GType TlsCertificate::get_base_type()
{
  return g_tls_certificate_get_type();
}


TlsCertificate::TlsCertificate(const std::string& data, gssize length)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(tlscertificate_class_.init(), "data", data.c_str(), "length", length, nullptr))
{
  

}

TlsCertificate::TlsCertificate(const std::string& file)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(tlscertificate_class_.init(), "file", file.c_str(), nullptr))
{
  

}

TlsCertificate::TlsCertificate(const std::string& cert_file, const std::string& key_file)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(tlscertificate_class_.init(), "cert_file", cert_file.c_str(), "key_file", key_file.c_str(), nullptr))
{
  

}

Glib::RefPtr<TlsCertificate> TlsCertificate::create_from_pem(const std::string& data, gssize length)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_tls_certificate_new_from_pem(data.c_str(), length, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<TlsCertificate> TlsCertificate::create(const std::string& file)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_tls_certificate_new_from_file(file.c_str(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<TlsCertificate> TlsCertificate::create(const std::string& cert_file, const std::string& key_file)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_tls_certificate_new_from_files(cert_file.c_str(), key_file.c_str(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

std::vector< Glib::RefPtr<TlsCertificate> > TlsCertificate::create_list_from_file(const std::string& file)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::ListHandler< Glib::RefPtr<TlsCertificate> >::list_to_vector(g_tls_certificate_list_new_from_file(file.c_str(), &(gerror)), Glib::OWNERSHIP_DEEP);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<TlsCertificate> TlsCertificate::get_issuer()
{
  auto retvalue = Glib::wrap(g_tls_certificate_get_issuer(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const TlsCertificate> TlsCertificate::get_issuer() const
{
  return const_cast<TlsCertificate*>(this)->get_issuer();
}

TlsCertificateFlags TlsCertificate::verify(const Glib::RefPtr<const SocketConnectable>& identity, const Glib::RefPtr<const TlsCertificate>& trusted_ca) const
{
  return static_cast<TlsCertificateFlags>(g_tls_certificate_verify(const_cast<GTlsCertificate*>(gobj()), const_cast<GSocketConnectable*>(Glib::unwrap(identity)), const_cast<GTlsCertificate*>(Glib::unwrap(trusted_ca))));
}

TlsCertificateFlags TlsCertificate::verify(const Glib::RefPtr<const SocketConnectable>& identity) const
{
  return static_cast<TlsCertificateFlags>(g_tls_certificate_verify(const_cast<GTlsCertificate*>(gobj()), const_cast<GSocketConnectable*>(Glib::unwrap(identity)), nullptr));
}

TlsCertificateFlags TlsCertificate::verify(const Glib::RefPtr<const TlsCertificate>& trusted_ca) const
{
  return static_cast<TlsCertificateFlags>(g_tls_certificate_verify(const_cast<GTlsCertificate*>(gobj()), nullptr, const_cast<GTlsCertificate*>(Glib::unwrap(trusted_ca))));
}

TlsCertificateFlags TlsCertificate::verify() const
{
  return static_cast<TlsCertificateFlags>(g_tls_certificate_verify(const_cast<GTlsCertificate*>(gobj()), nullptr, nullptr));
}

bool TlsCertificate::is_same(const Glib::RefPtr<const TlsCertificate>& cert_two) const
{
  return g_tls_certificate_is_same(const_cast<GTlsCertificate*>(gobj()), const_cast<GTlsCertificate*>(Glib::unwrap(cert_two)));
}

Glib::DateTime TlsCertificate::get_not_valid_before() const
{
  return Glib::wrap(g_tls_certificate_get_not_valid_before(const_cast<GTlsCertificate*>(gobj())));
}

Glib::DateTime TlsCertificate::get_not_valid_after() const
{
  return Glib::wrap(g_tls_certificate_get_not_valid_after(const_cast<GTlsCertificate*>(gobj())));
}

Glib::ustring TlsCertificate::get_subject_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_tls_certificate_get_subject_name(const_cast<GTlsCertificate*>(gobj())));
}

Glib::ustring TlsCertificate::get_issuer_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_tls_certificate_get_issuer_name(const_cast<GTlsCertificate*>(gobj())));
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Glib::ByteArray>>::value,
  "Type Glib::RefPtr<Glib::ByteArray> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::ByteArray> > TlsCertificate::property_certificate() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::ByteArray> >(this, "certificate");
}

Glib::PropertyProxy_ReadOnly< std::string > TlsCertificate::property_certificate_pem() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "certificate-pem");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Glib::ByteArray>>::value,
  "Type Glib::RefPtr<Glib::ByteArray> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::ByteArray> > TlsCertificate::property_private_key() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::ByteArray> >(this, "private-key");
}

Glib::PropertyProxy_ReadOnly< std::string > TlsCertificate::property_private_key_pem() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "private-key-pem");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<TlsCertificate>>::value,
  "Type Glib::RefPtr<TlsCertificate> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TlsCertificate> > TlsCertificate::property_issuer() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TlsCertificate> >(this, "issuer");
}

Glib::PropertyProxy_ReadOnly< std::string > TlsCertificate::property_pkcs11_uri() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "pkcs11-uri");
}

Glib::PropertyProxy_ReadOnly< std::string > TlsCertificate::property_private_key_pkcs11_uri() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "private-key-pkcs11-uri");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::DateTime>::value,
  "Type Glib::DateTime cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::DateTime > TlsCertificate::property_not_valid_before() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::DateTime >(this, "not-valid-before");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::DateTime>::value,
  "Type Glib::DateTime cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::DateTime > TlsCertificate::property_not_valid_after() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::DateTime >(this, "not-valid-after");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > TlsCertificate::property_subject_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "subject-name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > TlsCertificate::property_issuer_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "issuer-name");
}


TlsCertificateFlags Gio::TlsCertificate::verify_vfunc(const Glib::RefPtr<const SocketConnectable>& identity, const Glib::RefPtr<const TlsCertificate>& trusted_ca) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->verify)
  {
    TlsCertificateFlags retval(static_cast<TlsCertificateFlags>((*base->verify)(const_cast<GTlsCertificate*>(gobj()),const_cast<GSocketConnectable*>(Glib::unwrap(identity)),const_cast<GTlsCertificate*>(Glib::unwrap(trusted_ca)))));
    return retval;
  }

  using RType = TlsCertificateFlags;
  return RType();
}


} // namespace Gio


