// Generated by gmmproc 2.72.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/treepath.h>
#include <gtkmm/private/treepath_p.h>


/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/treemodel.h>
#include <glibmm/utility.h>
#include <gtk/gtk.h>


namespace Gtk
{

TreePath::TreePath(GtkTreePath* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ (gobject ? (make_a_copy ? gtk_tree_path_copy(gobject) : gobject) : gtk_tree_path_new())
{}

TreePath::TreePath(TreePath::size_type n, TreePath::value_type value)
:
  gobject_(gtk_tree_path_new())
{
  for(; n > 0; --n)
    gtk_tree_path_append_index(gobject_, value);
}

TreePath::TreePath(const Glib::ustring& path)
:
  gobject_ (gtk_tree_path_new_from_string(path.c_str()))
{
  if (!gobject_)
    gobject_ = gtk_tree_path_new();
}

TreePath::TreePath(const TreeModel::iterator& iter)
:
  // The GtkTreePath* is always newly created.
  gobject_(gtk_tree_model_get_path(
    const_cast<GtkTreeModel*>(iter.get_model_gobject()),
    const_cast<GtkTreeIter*>(iter.gobj())))
{
  if (!gobject_)
    gobject_ = gtk_tree_path_new();
}

TreePath& TreePath::operator=(const TreeModel::iterator& iter)
{
  TreePath temp(iter);
  swap(temp);
  return *this;
}

void TreePath::clear()
{
  TreePath empty_path;
  swap(empty_path);
}

TreePath::size_type TreePath::size() const
{
  return gtk_tree_path_get_depth(gobject_);
}

TreePath::operator bool() const
{
  return !empty();
}

bool TreePath::empty() const
{
  return (gtk_tree_path_get_depth(gobject_) == 0);
}

TreePath::reference TreePath::operator[](TreePath::size_type i)
{
  int *const indices = gtk_tree_path_get_indices(gobject_);
  return indices[i];
}

TreePath::const_reference TreePath::operator[](TreePath::size_type i) const
{
  const int *const indices = gtk_tree_path_get_indices(gobject_);
  return indices[i];
}

TreePath::iterator TreePath::begin()
{
  return gtk_tree_path_get_indices(gobject_);
}

TreePath::iterator TreePath::end()
{
  return gtk_tree_path_get_indices(gobject_) + gtk_tree_path_get_depth(gobject_);
}

TreePath::const_iterator TreePath::begin() const
{
  return gtk_tree_path_get_indices(gobject_);
}

TreePath::const_iterator TreePath::end() const
{
  return gtk_tree_path_get_indices(gobject_) + gtk_tree_path_get_depth(gobject_);
}

//static
bool TreePath::get_row_drag_data(const Glib::ValueBase& value, Glib::RefPtr<const TreeModel>& model, TreePath& path)
{
  GtkTreeModel* src_model = nullptr;
  GtkTreePath* src_path = nullptr;
  gboolean result = gtk_tree_get_row_drag_data(value.gobj(), &src_model, &src_path);

  model = Glib::wrap(src_model, true /* take_copy=true */);

  //gtk_tree_get_row_drag_data gives us ownership of src_path.
  path = Glib::wrap(src_path, false /* take_copy=false */);

  return result;
}

//static
bool TreePath::get_row_drag_data(const Glib::ValueBase& value, TreePath& path)
{
  GtkTreePath* src_path = nullptr;
  gboolean result = gtk_tree_get_row_drag_data(value.gobj(), nullptr, &src_path);

  //gtk_tree_get_row_drag_data gives us ownership of src_path.
  path = Glib::wrap(src_path, false /* take_copy=false */);

  return result;
}

Glib::RefPtr<Gdk::ContentProvider> TreePath::create_row_drag_content(
  const Glib::RefPtr<const TreeModel>& model) const
{
  // gtk_tree_create_row_drag_content() creates a new GdkContentProvider.
  return Glib::wrap(gtk_tree_create_row_drag_content(
    const_cast<GtkTreeModel*>(model->gobj()), const_cast<GtkTreePath*>(gobj())));
}

} // namespace Gtk

namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::TreePath wrap(GtkTreePath* object, bool take_copy)
{
  return Gtk::TreePath(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType TreePath::get_type()
{
  return gtk_tree_path_get_type();
}

TreePath::TreePath()
:
  gobject_ (gtk_tree_path_new())
{}

TreePath::TreePath(const TreePath& other)
:
  gobject_ ((other.gobject_) ? gtk_tree_path_copy(other.gobject_) : nullptr)
{}

TreePath::TreePath(TreePath&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

TreePath& TreePath::operator=(TreePath&& other) noexcept
{
  TreePath temp (std::move(other));
  swap(temp);
  return *this;
}


TreePath& TreePath::operator=(const TreePath& other)
{
  TreePath temp (other);
  swap(temp);
  return *this;
}

TreePath::~TreePath() noexcept
{
  if(gobject_)
    gtk_tree_path_free(gobject_);
}

void TreePath::swap(TreePath& other) noexcept
{
  std::swap(gobject_, other.gobject_);
}

GtkTreePath* TreePath::gobj_copy() const
{
  return gtk_tree_path_copy(gobject_);
}


void TreePath::push_back(int index)
{
  gtk_tree_path_append_index(gobj(), index);
}

void TreePath::push_front(int index)
{
  gtk_tree_path_prepend_index(gobj(), index);
}

void TreePath::next()
{
  gtk_tree_path_next(gobj());
}

bool TreePath::prev()
{
  return gtk_tree_path_prev(gobj());
}

bool TreePath::up()
{
  return gtk_tree_path_up(gobj());
}

void TreePath::down()
{
  gtk_tree_path_down(gobj());
}

bool TreePath::is_ancestor(const TreePath& descendant) const
{
  return gtk_tree_path_is_ancestor(const_cast<GtkTreePath*>(gobj()), const_cast<GtkTreePath*>((descendant).gobj()));
}

bool TreePath::is_descendant(const TreePath& ancestor) const
{
  return gtk_tree_path_is_descendant(const_cast<GtkTreePath*>(gobj()), const_cast<GtkTreePath*>((ancestor).gobj()));
}

Glib::ustring TreePath::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_tree_path_to_string(const_cast<GtkTreePath*>(gobj())));
}


bool operator==(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) == 0);
}

bool operator!=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator<(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) < 0);
}

bool operator>(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) > 0);
}

bool operator<=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) <= 0);
}

bool operator>=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) >= 0);
}


} // namespace Gtk


