/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;

public class ChunkedOutputFilter
implements OutputFilter {
    private static final byte[] LAST_CHUNK_BYTES = new byte[]{48, 13, 10};
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private static final byte[] END_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
    private static final Set<String> disallowedTrailerFieldNames = new HashSet<String>();
    protected HttpOutputBuffer buffer;
    protected final ByteBuffer chunkHeader = ByteBuffer.allocate(10);
    protected final ByteBuffer lastChunk = ByteBuffer.wrap(LAST_CHUNK_BYTES);
    protected final ByteBuffer crlfChunk = ByteBuffer.wrap(CRLF_BYTES);
    protected final ByteBuffer endChunk = ByteBuffer.wrap(END_CHUNK_BYTES);
    private Response response;

    public ChunkedOutputFilter() {
        this.chunkHeader.put(8, (byte)13);
        this.chunkHeader.put(9, (byte)10);
    }

    @Override
    public int doWrite(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return 0;
        }
        int n2 = this.calculateChunkHeader(n);
        this.chunkHeader.position(n2).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(byteBuffer);
        this.chunkHeader.position(8).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        return n;
    }

    private int calculateChunkHeader(int n) {
        int n2 = 8;
        for (int i = n; i > 0; i /= 16) {
            int n3 = i % 16;
            this.chunkHeader.put(--n2, HexUtils.getHex((int)n3));
        }
        return n2;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public void setBuffer(HttpOutputBuffer httpOutputBuffer) {
        this.buffer = httpOutputBuffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        Supplier<Map<String, String>> supplier = this.response.getTrailerFields();
        Map<String, String> map = null;
        if (supplier != null) {
            map = supplier.get();
        }
        if (map == null) {
            this.buffer.doWrite(this.endChunk);
            this.endChunk.position(0).limit(this.endChunk.capacity());
        } else {
            this.buffer.doWrite(this.lastChunk);
            this.lastChunk.position(0).limit(this.lastChunk.capacity());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.ISO_8859_1);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (disallowedTrailerFieldNames.contains(entry.getKey().toLowerCase(Locale.ENGLISH))) continue;
                outputStreamWriter.write(entry.getKey());
                outputStreamWriter.write(58);
                outputStreamWriter.write(32);
                outputStreamWriter.write(entry.getValue());
                outputStreamWriter.write("\r\n");
            }
            outputStreamWriter.close();
            this.buffer.doWrite(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.buffer.doWrite(this.crlfChunk);
            this.crlfChunk.position(0).limit(this.crlfChunk.capacity());
        }
        this.buffer.end();
    }

    @Override
    public void recycle() {
        this.response = null;
    }

    static {
        disallowedTrailerFieldNames.add("age");
        disallowedTrailerFieldNames.add("cache-control");
        disallowedTrailerFieldNames.add("content-length");
        disallowedTrailerFieldNames.add("content-encoding");
        disallowedTrailerFieldNames.add("content-range");
        disallowedTrailerFieldNames.add("content-type");
        disallowedTrailerFieldNames.add("date");
        disallowedTrailerFieldNames.add("expires");
        disallowedTrailerFieldNames.add("location");
        disallowedTrailerFieldNames.add("retry-after");
        disallowedTrailerFieldNames.add("trailer");
        disallowedTrailerFieldNames.add("transfer-encoding");
        disallowedTrailerFieldNames.add("vary");
        disallowedTrailerFieldNames.add("warning");
    }
}

