/* PowerIndicator.c generated by valac 0.56.3, the Vala compiler
 * generated from PowerIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "statusapplet.h"
#include <upower.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "plugin.h"
#include <gio/gdesktopappinfo.h>

enum  {
	BATTERY_ICON_0_PROPERTY,
	BATTERY_ICON_BATTERY_PROPERTY,
	BATTERY_ICON_LABEL_VISIBLE_PROPERTY,
	BATTERY_ICON_NUM_PROPERTIES
};
static GParamSpec* battery_icon_properties[BATTERY_ICON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	POWER_INDICATOR_0_PROPERTY,
	POWER_INDICATOR_CLIENT_PROPERTY,
	POWER_INDICATOR_LABEL_VISIBLE_PROPERTY,
	POWER_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* power_indicator_properties[POWER_INDICATOR_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _BatteryIconPrivate {
	UpDevice* _battery;
	gboolean changing;
	gboolean emitted_warning;
	GtkImage* image;
	GtkLabel* percent_label;
};

struct _PowerIndicatorPrivate {
	GtkBox* widget;
	UpClient* _client;
	GHashTable* devices;
	gboolean _label_visible;
	GtkCheckButton* check_percent;
	GSettings* battery_settings;
};

static gint BatteryIcon_private_offset;
static gpointer battery_icon_parent_class = NULL;
static GType battery_icon_type_id = 0;
static gint PowerIndicator_private_offset;
static gpointer power_indicator_parent_class = NULL;
static GType power_indicator_type_id = 0;

static void battery_icon_on_battery_change (BatteryIcon* self,
                                     GObject* o,
                                     GParamSpec* sp);
static void _battery_icon_on_battery_change_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void battery_icon_finalize (GObject * obj);
static void _vala_battery_icon_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_battery_icon_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void power_indicator_update_labels (PowerIndicator* self);
static void _power_indicator_update_labels_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void power_indicator_open_power_settings (PowerIndicator* self);
static void _power_indicator_open_power_settings_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void power_indicator_sync_devices (PowerIndicator* self);
static void power_indicator_on_device_added (PowerIndicator* self,
                                      UpDevice* device);
static void _power_indicator_on_device_added_up__client_device_added (UpClient* _sender,
                                                               UpDevice* device,
                                                               gpointer self);
static void power_indicator_on_device_removed (PowerIndicator* self,
                                        const gchar* object_path);
static void _power_indicator_on_device_removed_up__client_device_removed (UpClient* _sender,
                                                                   const gchar* object_path,
                                                                   gpointer self);
static void power_indicator_toggle_show (PowerIndicator* self);
static gboolean power_indicator_is_interesting (PowerIndicator* self,
                                         UpDevice* device);
static void __lambda10_ (PowerIndicator* self,
                  UpDevice* device);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
static void power_indicator_finalize (GObject * obj);
static void _vala_power_indicator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_power_indicator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
battery_icon_get_instance_private (BatteryIcon* self)
{
	return G_STRUCT_MEMBER_P (self, BatteryIcon_private_offset);
}

static void
_battery_icon_on_battery_change_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	battery_icon_on_battery_change ((BatteryIcon*) self, _sender, pspec);
}

BatteryIcon*
battery_icon_construct (GType object_type,
                        UpDevice* battery)
{
	BatteryIcon * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	g_return_val_if_fail (battery != NULL, NULL);
	self = (BatteryIcon*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "battery-icon");
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->percent_label);
	self->priv->percent_label = _tmp1_;
	_tmp2_ = self->priv->percent_label;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "percent-label");
	_tmp4_ = self->priv->percent_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	_tmp5_ = self->priv->percent_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 4);
	_tmp6_ = self->priv->percent_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
	_tmp7_ = self->priv->percent_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp8_;
	_tmp9_ = self->priv->image;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	_tmp10_ = self->priv->image;
	gtk_image_set_pixel_size (_tmp10_, 0);
	_tmp11_ = self->priv->image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	battery_icon_update_ui (self, battery);
	g_signal_connect_object ((GObject*) battery, "notify", (GCallback) _battery_icon_on_battery_change_g_object_notify, self, 0);
	return self;
}

BatteryIcon*
battery_icon_new (UpDevice* battery)
{
	return battery_icon_construct (TYPE_BATTERY_ICON, battery);
}

static void
battery_icon_on_battery_change (BatteryIcon* self,
                                GObject* o,
                                GParamSpec* sp)
{
	UpDevice* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (sp != NULL);
	if (self->priv->changing) {
		return;
	}
	self->priv->changing = TRUE;
	{
		UpDevice* _tmp0_;
		_tmp0_ = self->priv->_battery;
		up_device_refresh_sync (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (!self->priv->emitted_warning) {
			GError* _tmp1_;
			const gchar* _tmp2_;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_warning ("PowerIndicator.vala:68: Failed to refresh battery: %s", _tmp2_);
			self->priv->emitted_warning = TRUE;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->_battery;
	battery_icon_update_ui (self, _tmp3_);
	self->priv->changing = FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
battery_icon_update_ui (BatteryIcon* self,
                        UpDevice* battery)
{
	gchar* tip = NULL;
	gchar* image_name = NULL;
	gint rounded = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gchar* image_fallback = NULL;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gchar* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	gchar* labe = NULL;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gchar* _tmp46_;
	gchar* old = NULL;
	GtkLabel* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp54_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp55_;
	GtkIconTheme* _tmp56_;
	GtkIconInfo* _result_ = NULL;
	GtkIconTheme* _tmp57_;
	const gchar* _tmp58_;
	GtkIconInfo* _tmp59_;
	GtkIconInfo* _tmp60_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (battery != NULL);
	battery_icon_set_battery (self, battery);
	g_object_get (battery, "percentage", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	rounded = ((gint) round (_tmp1_ / 10)) * 10;
	g_object_get (battery, "percentage", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= ((gdouble) 10)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("battery-empty");
		_g_free0 (image_fallback);
		image_fallback = _tmp4_;
	} else {
		gdouble _tmp5_;
		gdouble _tmp6_;
		g_object_get (battery, "percentage", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		if (_tmp6_ <= ((gdouble) 35)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("battery-low");
			_g_free0 (image_fallback);
			image_fallback = _tmp7_;
		} else {
			gdouble _tmp8_;
			gdouble _tmp9_;
			g_object_get (battery, "percentage", &_tmp8_, NULL);
			_tmp9_ = _tmp8_;
			if (_tmp9_ <= ((gdouble) 75)) {
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("battery-good");
				_g_free0 (image_fallback);
				image_fallback = _tmp10_;
			} else {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("battery-full");
				_g_free0 (image_fallback);
				image_fallback = _tmp11_;
			}
		}
	}
	_tmp12_ = g_strdup_printf ("battery-level-%d", rounded);
	_g_free0 (image_name);
	image_name = _tmp12_;
	g_object_get (battery, "state", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == ((guint) 4)) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = g_strdup ("battery-full-charged-symbolic");
		_g_free0 (image_name);
		image_name = _tmp15_;
		_tmp16_ = g_strdup (_ ("Battery fully charged."));
		_g_free0 (tip);
		tip = _tmp16_;
	} else {
		guint _tmp17_;
		guint _tmp18_;
		g_object_get (battery, "state", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == ((guint) 1)) {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* time_to_full_str = NULL;
			gchar* _tmp23_;
			gint time_to_full = 0;
			gint64 _tmp24_;
			gint64 _tmp25_;
			gdouble _tmp27_;
			gdouble _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp19_ = image_name;
			_tmp20_ = g_strconcat (_tmp19_, "-charging-symbolic", NULL);
			_g_free0 (image_name);
			image_name = _tmp20_;
			_tmp21_ = image_fallback;
			_tmp22_ = g_strconcat (_tmp21_, "-charging-symbolic", NULL);
			_g_free0 (image_fallback);
			image_fallback = _tmp22_;
			_tmp23_ = g_strdup (_ ("Unknown"));
			time_to_full_str = _tmp23_;
			g_object_get (battery, "time-to-full", &_tmp24_, NULL);
			_tmp25_ = _tmp24_;
			time_to_full = (gint) _tmp25_;
			if (time_to_full > 0) {
				gint hours = 0;
				gint minutes = 0;
				gchar* _tmp26_;
				hours = time_to_full / (60 * 60);
				minutes = (time_to_full / 60) - (hours * 60);
				_tmp26_ = g_strdup_printf ("%d:%02d", hours, minutes);
				_g_free0 (time_to_full_str);
				time_to_full_str = _tmp26_;
			}
			g_object_get (battery, "percentage", &_tmp27_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = time_to_full_str;
			_tmp30_ = g_strdup_printf (": %d%% (%s)", (gint) _tmp28_, _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_ ("Battery charging"), _tmp31_, NULL);
			_g_free0 (tip);
			tip = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (time_to_full_str);
		} else {
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gint hours = 0;
			gint64 _tmp35_;
			gint64 _tmp36_;
			gint minutes = 0;
			gint64 _tmp37_;
			gint64 _tmp38_;
			gdouble _tmp39_;
			gdouble _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp33_ = image_name;
			_tmp34_ = g_strconcat (_tmp33_, "-symbolic", NULL);
			_g_free0 (image_name);
			image_name = _tmp34_;
			g_object_get (battery, "time-to-empty", &_tmp35_, NULL);
			_tmp36_ = _tmp35_;
			hours = ((gint) _tmp36_) / (60 * 60);
			g_object_get (battery, "time-to-empty", &_tmp37_, NULL);
			_tmp38_ = _tmp37_;
			minutes = (((gint) _tmp38_) / 60) - (hours * 60);
			g_object_get (battery, "percentage", &_tmp39_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf (": %d%% (%d:%02d)", (gint) _tmp40_, hours, minutes);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_ ("Battery remaining"), _tmp42_, NULL);
			_g_free0 (tip);
			tip = _tmp43_;
			_g_free0 (_tmp42_);
		}
	}
	g_object_get (battery, "percentage", &_tmp44_, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf ("%d%%", (gint) _tmp45_);
	labe = _tmp46_;
	_tmp47_ = self->priv->percent_label;
	_tmp48_ = gtk_label_get_label (_tmp47_);
	_tmp49_ = g_strdup (_tmp48_);
	old = _tmp49_;
	_tmp50_ = old;
	_tmp51_ = labe;
	if (g_strcmp0 (_tmp50_, _tmp51_) != 0) {
		GtkLabel* _tmp52_;
		const gchar* _tmp53_;
		_tmp52_ = self->priv->percent_label;
		_tmp53_ = labe;
		gtk_label_set_text (_tmp52_, _tmp53_);
	}
	_tmp54_ = tip;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp54_);
	_tmp55_ = gtk_icon_theme_get_default ();
	_tmp56_ = _g_object_ref0 (_tmp55_);
	theme = _tmp56_;
	_tmp57_ = theme;
	_tmp58_ = image_name;
	_tmp59_ = gtk_icon_theme_lookup_icon (_tmp57_, _tmp58_, (gint) GTK_ICON_SIZE_MENU, 0);
	_result_ = _tmp59_;
	_tmp60_ = _result_;
	if (_tmp60_ == NULL) {
		GtkImage* _tmp61_;
		const gchar* _tmp62_;
		_tmp61_ = self->priv->image;
		_tmp62_ = image_fallback;
		gtk_image_set_from_icon_name (_tmp61_, _tmp62_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp63_;
		const gchar* _tmp64_;
		_tmp63_ = self->priv->image;
		_tmp64_ = image_name;
		gtk_image_set_from_icon_name (_tmp63_, _tmp64_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (_result_);
	_g_object_unref0 (theme);
	_g_free0 (old);
	_g_free0 (labe);
	_g_free0 (image_fallback);
	_g_free0 (image_name);
	_g_free0 (tip);
}

UpDevice*
battery_icon_get_battery (BatteryIcon* self)
{
	UpDevice* result;
	UpDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_battery;
	result = _tmp0_;
	return result;
}

void
battery_icon_set_battery (BatteryIcon* self,
                          UpDevice* value)
{
	UpDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = battery_icon_get_battery (self);
	if (old_value != value) {
		self->priv->_battery = value;
		g_object_notify_by_pspec ((GObject *) self, battery_icon_properties[BATTERY_ICON_BATTERY_PROPERTY]);
	}
}

gboolean
battery_icon_get_label_visible (BatteryIcon* self)
{
	gboolean result;
	GtkLabel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->percent_label;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
battery_icon_set_label_visible (BatteryIcon* self,
                                gboolean value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->percent_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, battery_icon_properties[BATTERY_ICON_LABEL_VISIBLE_PROPERTY]);
}

static void
battery_icon_class_init (BatteryIconClass * klass,
                         gpointer klass_data)
{
	battery_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BatteryIcon_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_battery_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_battery_icon_set_property;
	G_OBJECT_CLASS (klass)->finalize = battery_icon_finalize;
	/** The battery associated with this icon */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BATTERY_ICON_BATTERY_PROPERTY, battery_icon_properties[BATTERY_ICON_BATTERY_PROPERTY] = g_param_spec_object ("battery", "battery", "battery", up_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Expose a simple property so the UI can update whether we show
	 * labels or not
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BATTERY_ICON_LABEL_VISIBLE_PROPERTY, battery_icon_properties[BATTERY_ICON_LABEL_VISIBLE_PROPERTY] = g_param_spec_boolean ("label-visible", "label-visible", "label-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
battery_icon_instance_init (BatteryIcon * self,
                            gpointer klass)
{
	self->priv = battery_icon_get_instance_private (self);
	self->priv->changing = FALSE;
	self->priv->emitted_warning = FALSE;
}

static void
battery_icon_finalize (GObject * obj)
{
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATTERY_ICON, BatteryIcon);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->percent_label);
	G_OBJECT_CLASS (battery_icon_parent_class)->finalize (obj);
}

GType
battery_icon_get_type (void)
{
	return battery_icon_type_id;
}

GType
battery_icon_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BatteryIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) battery_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatteryIcon), 0, (GInstanceInitFunc) battery_icon_instance_init, NULL };
	battery_icon_type_id = g_type_module_register_type (module, gtk_box_get_type (), "BatteryIcon", &g_define_type_info, 0);
	BatteryIcon_private_offset = sizeof (BatteryIconPrivate);
	return battery_icon_type_id;
}

static void
_vala_battery_icon_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BATTERY_ICON, BatteryIcon);
	switch (property_id) {
		case BATTERY_ICON_BATTERY_PROPERTY:
		g_value_set_object (value, battery_icon_get_battery (self));
		break;
		case BATTERY_ICON_LABEL_VISIBLE_PROPERTY:
		g_value_set_boolean (value, battery_icon_get_label_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_battery_icon_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BATTERY_ICON, BatteryIcon);
	switch (property_id) {
		case BATTERY_ICON_BATTERY_PROPERTY:
		battery_icon_set_battery (self, g_value_get_object (value));
		break;
		case BATTERY_ICON_LABEL_VISIBLE_PROPERTY:
		battery_icon_set_label_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
power_indicator_get_instance_private (PowerIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, PowerIndicator_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_power_indicator_update_labels_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	power_indicator_update_labels ((PowerIndicator*) self);
}

static void
_power_indicator_open_power_settings_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	power_indicator_open_power_settings ((PowerIndicator*) self);
}

static void
_power_indicator_on_device_added_up__client_device_added (UpClient* _sender,
                                                          UpDevice* device,
                                                          gpointer self)
{
	power_indicator_on_device_added ((PowerIndicator*) self, device);
}

static void
_power_indicator_on_device_removed_up__client_device_removed (UpClient* _sender,
                                                              const gchar* object_path,
                                                              gpointer self)
{
	power_indicator_on_device_removed ((PowerIndicator*) self, object_path);
}

PowerIndicator*
power_indicator_construct (GType object_type)
{
	PowerIndicator * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkEventBox* _tmp8_;
	BudgiePopover* _tmp9_;
	GtkBox* box = NULL;
	GtkBox* _tmp10_;
	BudgiePopover* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GtkCheckButton* _tmp14_;
	GtkCheckButton* _tmp15_;
	GtkWidget* _tmp16_;
	GValue _tmp17_ = {0};
	GtkCheckButton* _tmp18_;
	GSettings* _tmp19_;
	GtkCheckButton* _tmp20_;
	GtkSeparator* sep = NULL;
	GtkSeparator* _tmp21_;
	GtkButton* button = NULL;
	GtkButton* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkWidget* _tmp24_;
	UpClient* _tmp25_;
	UpClient* _tmp26_;
	UpClient* _tmp27_;
	UpClient* _tmp28_;
	self = (PowerIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->devices);
	self->priv->devices = _tmp2_;
	_tmp3_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp3_;
	_tmp4_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp5_;
	_tmp6_ = self->ebox;
	_tmp7_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->ebox;
	_tmp9_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp10_);
	box = _tmp10_;
	gtk_container_set_border_width ((GtkContainer*) box, (guint) 6);
	_tmp11_ = self->popover;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) box);
	_tmp12_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->battery_settings);
	self->priv->battery_settings = _tmp12_;
	_tmp13_ = self->priv->battery_settings;
	g_settings_bind (_tmp13_, "show-battery-percentage", (GObject*) self, "label-visible", G_SETTINGS_BIND_GET);
	g_signal_connect_object ((GObject*) self, "notify::label-visible", (GCallback) _power_indicator_update_labels_g_object_notify, self, G_CONNECT_AFTER);
	_tmp14_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Show battery percentage"));
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->check_percent);
	self->priv->check_percent = _tmp14_;
	_tmp15_ = self->priv->check_percent;
	_tmp16_ = gtk_bin_get_child ((GtkBin*) _tmp15_);
	g_value_init (&_tmp17_, G_TYPE_INT);
	g_value_set_int (&_tmp17_, 4);
	g_object_set_property ((GObject*) _tmp16_, "margin", &_tmp17_);
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	_tmp18_ = self->priv->check_percent;
	gtk_box_pack_start (box, (GtkWidget*) _tmp18_, FALSE, FALSE, (guint) 0);
	_tmp19_ = self->priv->battery_settings;
	_tmp20_ = self->priv->check_percent;
	g_settings_bind (_tmp19_, "show-battery-percentage", (GObject*) _tmp20_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp21_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp21_);
	sep = _tmp21_;
	gtk_box_pack_start (box, (GtkWidget*) sep, FALSE, FALSE, (guint) 1);
	_tmp22_ = (GtkButton*) gtk_button_new_with_label (_ ("Power settings"));
	g_object_ref_sink (_tmp22_);
	button = _tmp22_;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) button);
	gtk_style_context_add_class (_tmp23_, GTK_STYLE_CLASS_FLAT);
	g_signal_connect_object (button, "clicked", (GCallback) _power_indicator_open_power_settings_gtk_button_clicked, self, 0);
	_tmp24_ = gtk_bin_get_child ((GtkBin*) button);
	gtk_widget_set_halign (_tmp24_, GTK_ALIGN_START);
	gtk_box_pack_start (box, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) box);
	_tmp25_ = up_client_new ();
	_tmp26_ = _tmp25_;
	power_indicator_set_client (self, _tmp26_);
	_g_object_unref0 (_tmp26_);
	power_indicator_sync_devices (self);
	_tmp27_ = self->priv->_client;
	g_signal_connect_object (_tmp27_, "device-added", (GCallback) _power_indicator_on_device_added_up__client_device_added, self, 0);
	_tmp28_ = self->priv->_client;
	g_signal_connect_object (_tmp28_, "device-removed", (GCallback) _power_indicator_on_device_removed_up__client_device_removed, self, 0);
	power_indicator_toggle_show (self);
	_g_object_unref0 (button);
	_g_object_unref0 (sep);
	_g_object_unref0 (box);
	return self;
}

PowerIndicator*
power_indicator_new (void)
{
	return power_indicator_construct (TYPE_POWER_INDICATOR);
}

void
power_indicator_change_orientation (PowerIndicator* self,
                                    GtkOrientation orient)
{
	gint spacing = 0;
	BatteryIcon* icon = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	spacing = 0;
	if (orient == GTK_ORIENTATION_VERTICAL) {
		spacing = 5;
	}
	icon = NULL;
	_tmp0_ = self->priv->devices;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		BatteryIcon* _tmp3_;
		BatteryIcon* _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		icon = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = icon;
		gtk_box_set_spacing ((GtkBox*) _tmp3_, spacing);
		_tmp4_ = icon;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp4_, orient);
	}
}

static void
power_indicator_update_labels (PowerIndicator* self)
{
	BatteryIcon* icon = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	icon = NULL;
	_tmp0_ = self->priv->devices;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		BatteryIcon* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		icon = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = icon;
		_tmp4_ = self->priv->_label_visible;
		battery_icon_set_label_visible (_tmp3_, _tmp4_);
	}
	_tmp5_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_queue_draw (_tmp5_);
}

static gboolean
power_indicator_is_interesting (PowerIndicator* self,
                                UpDevice* device)
{
	guint _tmp0_;
	guint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	g_object_get (device, "kind", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != ((guint) UP_DEVICE_KIND_BATTERY)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
power_indicator_open_power_settings (PowerIndicator* self)
{
	BudgiePopover* _tmp0_;
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_desktop_app_info_new ("budgie-power-panel.desktop");
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp3_;
		_tmp3_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("PowerIndicator.vala:248: Unable to launch gnome-power-panel.desktop: %" \
"s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

/**
 * Add a new device to the tree
 */
static void
power_indicator_on_device_added (PowerIndicator* self,
                                 UpDevice* device)
{
	gchar* object_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	BatteryIcon* icon = NULL;
	BatteryIcon* _tmp7_;
	BatteryIcon* _tmp8_;
	gboolean _tmp9_;
	GHashTable* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	BatteryIcon* _tmp13_;
	BatteryIcon* _tmp14_;
	GtkBox* _tmp15_;
	BatteryIcon* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = up_device_get_object_path (device);
	_tmp1_ = g_strdup (_tmp0_);
	object_path = _tmp1_;
	_tmp2_ = self->priv->devices;
	_tmp3_ = object_path;
	if (g_hash_table_contains (_tmp2_, _tmp3_)) {
		GHashTable* _tmp4_;
		const gchar* _tmp5_;
		gconstpointer _tmp6_;
		_tmp4_ = self->priv->devices;
		_tmp5_ = object_path;
		_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
		battery_icon_update_ui ((BatteryIcon*) _tmp6_, device);
		_g_free0 (object_path);
		return;
	}
	if (!power_indicator_is_interesting (self, device)) {
		_g_free0 (object_path);
		return;
	}
	_tmp7_ = battery_icon_new (device);
	g_object_ref_sink (_tmp7_);
	icon = _tmp7_;
	_tmp8_ = icon;
	_tmp9_ = self->priv->_label_visible;
	battery_icon_set_label_visible (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->devices;
	_tmp11_ = object_path;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = icon;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
	_tmp15_ = self->priv->widget;
	_tmp16_ = icon;
	gtk_box_pack_start (_tmp15_, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	power_indicator_toggle_show (self);
	_g_object_unref0 (icon);
	_g_free0 (object_path);
}

static void
power_indicator_toggle_show (PowerIndicator* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	if (g_hash_table_size (_tmp0_) < ((guint) 1)) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_show_all ((GtkWidget*) self);
	}
}

/**
 * Remove a device from our display
 */
static void
power_indicator_on_device_removed (PowerIndicator* self,
                                   const gchar* object_path)
{
	GHashTable* _tmp0_;
	BatteryIcon* icon = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	GtkBox* _tmp3_;
	BatteryIcon* _tmp4_;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = self->priv->devices;
	if (!g_hash_table_contains (_tmp0_, object_path)) {
		return;
	}
	_tmp1_ = self->priv->devices;
	_tmp2_ = g_hash_table_lookup (_tmp1_, object_path);
	icon = (BatteryIcon*) _tmp2_;
	_tmp3_ = self->priv->widget;
	_tmp4_ = icon;
	gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->devices;
	g_hash_table_remove (_tmp5_, object_path);
	power_indicator_toggle_show (self);
}

static void
__lambda10_ (PowerIndicator* self,
             UpDevice* device)
{
	g_return_if_fail (device != NULL);
	power_indicator_on_device_added (self, device);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ ((PowerIndicator*) self, (UpDevice*) data);
}

static void
power_indicator_sync_devices (PowerIndicator* self)
{
	GPtrArray* devices = NULL;
	UpClient* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_client;
	_tmp1_ = up_client_get_devices (_tmp0_);
	devices = _tmp1_;
	g_ptr_array_foreach (devices, ___lambda10__gfunc, self);
	power_indicator_toggle_show (self);
	_g_ptr_array_unref0 (devices);
}

UpClient*
power_indicator_get_client (PowerIndicator* self)
{
	UpClient* result;
	UpClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_client;
	result = _tmp0_;
	return result;
}

void
power_indicator_set_client (PowerIndicator* self,
                            UpClient* value)
{
	UpClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_client (self);
	if (old_value != value) {
		UpClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_client);
		self->priv->_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_CLIENT_PROPERTY]);
	}
}

gboolean
power_indicator_get_label_visible (PowerIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_label_visible;
	return result;
}

void
power_indicator_set_label_visible (PowerIndicator* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_label_visible (self);
	if (old_value != value) {
		self->priv->_label_visible = value;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_LABEL_VISIBLE_PROPERTY]);
	}
}

static void
power_indicator_class_init (PowerIndicatorClass * klass,
                            gpointer klass_data)
{
	power_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerIndicator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = power_indicator_finalize;
	/** Our upower client */
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_CLIENT_PROPERTY, power_indicator_properties[POWER_INDICATOR_CLIENT_PROPERTY] = g_param_spec_object ("client", "client", "client", up_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_LABEL_VISIBLE_PROPERTY, power_indicator_properties[POWER_INDICATOR_LABEL_VISIBLE_PROPERTY] = g_param_spec_boolean ("label-visible", "label-visible", "label-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
power_indicator_instance_init (PowerIndicator * self,
                               gpointer klass)
{
	self->priv = power_indicator_get_instance_private (self);
	self->ebox = NULL;
	self->popover = NULL;
	self->priv->widget = NULL;
	self->priv->_label_visible = FALSE;
}

static void
power_indicator_finalize (GObject * obj)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POWER_INDICATOR, PowerIndicator);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->_client);
	_g_hash_table_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->check_percent);
	_g_object_unref0 (self->priv->battery_settings);
	G_OBJECT_CLASS (power_indicator_parent_class)->finalize (obj);
}

GType
power_indicator_get_type (void)
{
	return power_indicator_type_id;
}

GType
power_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerIndicator), 0, (GInstanceInitFunc) power_indicator_instance_init, NULL };
	power_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "PowerIndicator", &g_define_type_info, 0);
	PowerIndicator_private_offset = sizeof (PowerIndicatorPrivate);
	return power_indicator_type_id;
}

static void
_vala_power_indicator_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POWER_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_CLIENT_PROPERTY:
		g_value_set_object (value, power_indicator_get_client (self));
		break;
		case POWER_INDICATOR_LABEL_VISIBLE_PROPERTY:
		g_value_set_boolean (value, power_indicator_get_label_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_indicator_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POWER_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_CLIENT_PROPERTY:
		power_indicator_set_client (self, g_value_get_object (value));
		break;
		case POWER_INDICATOR_LABEL_VISIBLE_PROPERTY:
		power_indicator_set_label_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

