/* uuid.c generated by valac 0.56.3, the Vala compiler
 * generated from uuid.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <uuid.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	UUID_UUID_FLAGS_LOWER_CASE = 1 << 0,
	UUID_UUID_FLAGS_UPPER_CASE = 1 << 1,
	UUID_UUID_FLAGS_DEFAULT_CASE = 1 << 2,
	UUID_UUID_FLAGS_RANDOM_TYPE = 1 << 3,
	UUID_UUID_FLAGS_DEFAULT_TYPE = 1 << 4,
	UUID_UUID_FLAGS_TIME_TYPE = 1 << 5,
	UUID_UUID_FLAGS_TIME_SAFE_TYPE = 1 << 6
} LibUUIDUUIDFlags;

#define UUID_TYPE_UUID_FLAGS (uuid_uuid_flags_get_type ())

VALA_EXTERN GType uuid_uuid_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* uuid_new (LibUUIDUUIDFlags flags);

static GType
uuid_uuid_flags_get_type_once (void)
{
	static const GEnumValue values[] = {{UUID_UUID_FLAGS_LOWER_CASE, "UUID_UUID_FLAGS_LOWER_CASE", "lower-case"}, {UUID_UUID_FLAGS_UPPER_CASE, "UUID_UUID_FLAGS_UPPER_CASE", "upper-case"}, {UUID_UUID_FLAGS_DEFAULT_CASE, "UUID_UUID_FLAGS_DEFAULT_CASE", "default-case"}, {UUID_UUID_FLAGS_RANDOM_TYPE, "UUID_UUID_FLAGS_RANDOM_TYPE", "random-type"}, {UUID_UUID_FLAGS_DEFAULT_TYPE, "UUID_UUID_FLAGS_DEFAULT_TYPE", "default-type"}, {UUID_UUID_FLAGS_TIME_TYPE, "UUID_UUID_FLAGS_TIME_TYPE", "time-type"}, {UUID_UUID_FLAGS_TIME_SAFE_TYPE, "UUID_UUID_FLAGS_TIME_SAFE_TYPE", "time-safe-type"}, {0, NULL, NULL}};
	GType uuid_uuid_flags_type_id;
	uuid_uuid_flags_type_id = g_enum_register_static ("LibUUIDUUIDFlags", values);
	return uuid_uuid_flags_type_id;
}

GType
uuid_uuid_flags_get_type (void)
{
	static volatile gsize uuid_uuid_flags_type_id__once = 0;
	if (g_once_init_enter (&uuid_uuid_flags_type_id__once)) {
		GType uuid_uuid_flags_type_id;
		uuid_uuid_flags_type_id = uuid_uuid_flags_get_type_once ();
		g_once_init_leave (&uuid_uuid_flags_type_id__once, uuid_uuid_flags_type_id);
	}
	return uuid_uuid_flags_type_id__once;
}

gchar*
uuid_new (LibUUIDUUIDFlags flags)
{
	guint8 time[16] = {0};
	gchar uuid[37] = {0};
	gchar* _tmp0_;
	gchar* result;
	if ((flags & UUID_UUID_FLAGS_RANDOM_TYPE) != 0) {
		uuid_generate_random (time);
	} else {
		if ((flags & UUID_UUID_FLAGS_TIME_TYPE) != 0) {
			uuid_generate_time (time);
		} else {
			if ((flags & UUID_UUID_FLAGS_TIME_SAFE_TYPE) != 0) {
				uuid_generate_time_safe (time);
			} else {
				uuid_generate (time);
			}
		}
	}
	if ((flags & UUID_UUID_FLAGS_UPPER_CASE) != 0) {
		uuid_unparse_upper (time, uuid);
	} else {
		if ((flags & UUID_UUID_FLAGS_LOWER_CASE) != 0) {
			uuid_unparse_lower (time, uuid);
		} else {
			uuid_unparse (time, uuid);
		}
	}
	_tmp0_ = g_strdup ((const gchar*) uuid);
	result = _tmp0_;
	return result;
}

