/* powerstrip.c generated by valac 0.56.3, the Vala compiler
 * generated from powerstrip.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>

typedef GDBusProxy BudgieScreenSaverProxy;
typedef GDBusProxyClass BudgieScreenSaverProxyClass;
typedef GDBusProxy BudgieSessionManagerProxy;
typedef GDBusProxyClass BudgieSessionManagerProxyClass;
typedef struct _budgie_session_manager_LogoutReadyData budgie_session_manager_LogoutReadyData;

#define BUDGIE_TYPE_POWER_STRIP (budgie_power_strip_get_type ())
#define BUDGIE_POWER_STRIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStrip))
#define BUDGIE_POWER_STRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStripClass))
#define BUDGIE_IS_POWER_STRIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_POWER_STRIP))
#define BUDGIE_IS_POWER_STRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_POWER_STRIP))
#define BUDGIE_POWER_STRIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStripClass))

typedef struct _BudgiePowerStrip BudgiePowerStrip;
typedef struct _BudgiePowerStripClass BudgiePowerStripClass;
typedef struct _BudgiePowerStripPrivate BudgiePowerStripPrivate;
enum  {
	BUDGIE_POWER_STRIP_0_PROPERTY,
	BUDGIE_POWER_STRIP_NUM_PROPERTIES
};
static GParamSpec* budgie_power_strip_properties[BUDGIE_POWER_STRIP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgiePowerStripSetupDbusData BudgiePowerStripSetupDbusData;
typedef struct _Block6Data Block6Data;

struct _budgie_session_manager_LogoutReadyData {
	GDBusMethodInvocation* _invocation_;
	guint mode;
};

struct _BudgiePowerStrip {
	GtkEventBox parent_instance;
	BudgiePowerStripPrivate * priv;
};

struct _BudgiePowerStripClass {
	GtkEventBoxClass parent_class;
};

struct _BudgiePowerStripPrivate {
	BudgieScreenSaver* saver;
	BudgieSessionManager* session;
	GtkButton* lock_btn;
	GtkButton* power_btn;
};

struct _BudgiePowerStripSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgiePowerStrip* self;
	BudgieScreenSaver* _tmp0_;
	BudgieScreenSaver* _tmp1_;
	BudgieScreenSaver* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	BudgieSessionManager* _tmp5_;
	BudgieSessionManager* _tmp6_;
	BudgieSessionManager* _tmp7_;
	GError* _vala1_e;
	GtkButton* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	BudgiePowerStrip* self;
	BudgieRaven* raven;
};

static gint BudgiePowerStrip_private_offset;
static gpointer budgie_power_strip_parent_class = NULL;

static GType budgie_screen_saver_get_type_once (void);
static void budgie_screen_saver_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void budgie_screen_saver_proxy_lock (BudgieScreenSaver* self,
                                     GError** error);
static void budgie_screen_saver_proxy_budgie_screen_saver_interface_init (BudgieScreenSaverIface* iface);
static void _dbus_budgie_screen_saver_lock (BudgieScreenSaver* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void budgie_screen_saver_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_screen_saver_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_screen_saver_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_screen_saver_unregister_object (gpointer user_data);
static GType budgie_session_manager_get_type_once (void);
static void budgie_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void budgie_session_manager_proxy_Logout_async (BudgieSessionManager* self,
                                                guint mode,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void budgie_session_manager_proxy_Logout_finish (BudgieSessionManager* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static void budgie_session_manager_proxy_budgie_session_manager_interface_init (BudgieSessionManagerIface* iface);
static void _dbus_budgie_session_manager_Logout (BudgieSessionManager* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_budgie_session_manager_Logout_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void budgie_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* budgie_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean budgie_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _budgie_session_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_power_strip_get_type (void) G_GNUC_CONST ;
static void budgie_power_strip_setup_dbus_data_free (gpointer _data);
static void budgie_power_strip_setup_dbus (BudgiePowerStrip* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void budgie_power_strip_setup_dbus_finish (BudgiePowerStrip* self,
                                           GAsyncResult* _res_);
static gboolean budgie_power_strip_setup_dbus_co (BudgiePowerStripSetupDbusData* _data_);
static void budgie_power_strip_setup_dbus_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN BudgiePowerStrip* budgie_power_strip_new (BudgieRaven* raven);
VALA_EXTERN BudgiePowerStrip* budgie_power_strip_construct (GType object_type,
                                                BudgieRaven* raven);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda33_ (Block6Data* _data6_);
static void ___lambda33__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda34_ (Block6Data* _data6_);
static void budgie_power_strip_lock_screen (BudgiePowerStrip* self);
static void ___lambda34__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda35_ (Block6Data* _data6_);
static void __lambda36_ (BudgiePowerStrip* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda36__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda35__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda37_ (BudgiePowerStrip* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda37__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void budgie_power_strip_finalize (GObject * obj);
static GType budgie_power_strip_get_type_once (void);

static const GDBusArgInfo * const _budgie_screen_saver_dbus_arg_info_lock_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screen_saver_dbus_arg_info_lock_out[] = {NULL};
static const GDBusMethodInfo _budgie_screen_saver_dbus_method_info_lock = {-1, "Lock", (GDBusArgInfo **) (&_budgie_screen_saver_dbus_arg_info_lock_in), (GDBusArgInfo **) (&_budgie_screen_saver_dbus_arg_info_lock_out), NULL};
static const GDBusMethodInfo * const _budgie_screen_saver_dbus_method_info[] = {&_budgie_screen_saver_dbus_method_info_lock, NULL};
static const GDBusSignalInfo * const _budgie_screen_saver_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_screen_saver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_screen_saver_dbus_interface_info = {-1, "org.gnome.ScreenSaver", (GDBusMethodInfo **) (&_budgie_screen_saver_dbus_method_info), (GDBusSignalInfo **) (&_budgie_screen_saver_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_screen_saver_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_screen_saver_dbus_interface_vtable = {budgie_screen_saver_dbus_interface_method_call, budgie_screen_saver_dbus_interface_get_property, budgie_screen_saver_dbus_interface_set_property};
static const GDBusArgInfo _budgie_session_manager_dbus_arg_info_Logout_mode = {-1, "mode", "u", NULL};
static const GDBusArgInfo * const _budgie_session_manager_dbus_arg_info_Logout_in[] = {&_budgie_session_manager_dbus_arg_info_Logout_mode, NULL};
static const GDBusArgInfo * const _budgie_session_manager_dbus_arg_info_Logout_out[] = {NULL};
static const GDBusMethodInfo _budgie_session_manager_dbus_method_info_Logout = {-1, "Logout", (GDBusArgInfo **) (&_budgie_session_manager_dbus_arg_info_Logout_in), (GDBusArgInfo **) (&_budgie_session_manager_dbus_arg_info_Logout_out), NULL};
static const GDBusMethodInfo * const _budgie_session_manager_dbus_method_info[] = {&_budgie_session_manager_dbus_method_info_Logout, NULL};
static const GDBusSignalInfo * const _budgie_session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_budgie_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_session_manager_dbus_interface_vtable = {budgie_session_manager_dbus_interface_method_call, budgie_session_manager_dbus_interface_get_property, budgie_session_manager_dbus_interface_set_property};

void
budgie_screen_saver_lock (BudgieScreenSaver* self,
                          GError** error)
{
	BudgieScreenSaverIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_SCREEN_SAVER_GET_INTERFACE (self);
	if (_iface_->lock) {
		_iface_->lock (self, error);
	}
}

static void
budgie_screen_saver_default_init (BudgieScreenSaverIface * iface,
                                  gpointer iface_data)
{
}

static GType
budgie_screen_saver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenSaverIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screen_saver_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_screen_saver_type_id;
	budgie_screen_saver_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieScreenSaver", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_screen_saver_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_screen_saver_proxy_get_type);
	g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.ScreenSaver");
	g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_screen_saver_dbus_interface_info));
	g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_screen_saver_register_object);
	return budgie_screen_saver_type_id;
}

GType
budgie_screen_saver_get_type (void)
{
	static volatile gsize budgie_screen_saver_type_id__once = 0;
	if (g_once_init_enter (&budgie_screen_saver_type_id__once)) {
		GType budgie_screen_saver_type_id;
		budgie_screen_saver_type_id = budgie_screen_saver_get_type_once ();
		g_once_init_leave (&budgie_screen_saver_type_id__once, budgie_screen_saver_type_id);
	}
	return budgie_screen_saver_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieScreenSaverProxy, budgie_screen_saver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SCREEN_SAVER, budgie_screen_saver_proxy_budgie_screen_saver_interface_init) )
static void
budgie_screen_saver_proxy_class_init (BudgieScreenSaverProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_screen_saver_proxy_g_signal;
}

static void
budgie_screen_saver_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
budgie_screen_saver_proxy_init (BudgieScreenSaverProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_screen_saver_dbus_interface_info));
}

static void
budgie_screen_saver_proxy_lock (BudgieScreenSaver* self,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.ScreenSaver", "Lock");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_screen_saver_proxy_budgie_screen_saver_interface_init (BudgieScreenSaverIface* iface)
{
	iface->lock = budgie_screen_saver_proxy_lock;
}

static void
_dbus_budgie_screen_saver_lock (BudgieScreenSaver* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_screen_saver_lock (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_screen_saver_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Lock") == 0) {
		_dbus_budgie_screen_saver_lock (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_screen_saver_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_screen_saver_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_screen_saver_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_screen_saver_dbus_interface_info), &_budgie_screen_saver_dbus_interface_vtable, data, _budgie_screen_saver_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_screen_saver_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
budgie_session_manager_Logout (BudgieSessionManager* self,
                               guint mode,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BudgieSessionManagerIface* _iface_;
	_iface_ = BUDGIE_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Logout) {
		_iface_->Logout (self, mode, _callback_, _user_data_);
	}
}

void
budgie_session_manager_Logout_finish (BudgieSessionManager* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	BudgieSessionManagerIface* _iface_;
	_iface_ = BUDGIE_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Logout_finish) {
		_iface_->Logout_finish (self, _res_, error);
	}
}

static void
budgie_session_manager_default_init (BudgieSessionManagerIface * iface,
                                     gpointer iface_data)
{
}

static GType
budgie_session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_session_manager_type_id;
	budgie_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieSessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_session_manager_proxy_get_type);
	g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_session_manager_dbus_interface_info));
	g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_session_manager_register_object);
	return budgie_session_manager_type_id;
}

GType
budgie_session_manager_get_type (void)
{
	static volatile gsize budgie_session_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_session_manager_type_id__once)) {
		GType budgie_session_manager_type_id;
		budgie_session_manager_type_id = budgie_session_manager_get_type_once ();
		g_once_init_leave (&budgie_session_manager_type_id__once, budgie_session_manager_type_id);
	}
	return budgie_session_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieSessionManagerProxy, budgie_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SESSION_MANAGER, budgie_session_manager_proxy_budgie_session_manager_interface_init) )
static void
budgie_session_manager_proxy_class_init (BudgieSessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_session_manager_proxy_g_signal;
}

static void
budgie_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
}

static void
budgie_session_manager_proxy_init (BudgieSessionManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_session_manager_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
budgie_session_manager_proxy_Logout_async (BudgieSessionManager* self,
                                           guint mode,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Logout");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (mode));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_session_manager_proxy_Logout_finish (BudgieSessionManager* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_session_manager_proxy_budgie_session_manager_interface_init (BudgieSessionManagerIface* iface)
{
	iface->Logout = budgie_session_manager_proxy_Logout_async;
	iface->Logout_finish = budgie_session_manager_proxy_Logout_finish;
}

static void
_dbus_budgie_session_manager_Logout (BudgieSessionManager* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_session_manager_LogoutReadyData* _ready_data;
	GVariant* _tmp107_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_session_manager_LogoutReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp107_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->mode = g_variant_get_uint32 (_tmp107_);
	g_variant_unref (_tmp107_);
	budgie_session_manager_Logout (self, _ready_data->mode, (GAsyncReadyCallback) _dbus_budgie_session_manager_Logout_ready, _ready_data);
}

static void
_dbus_budgie_session_manager_Logout_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	budgie_session_manager_LogoutReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_session_manager_Logout_finish ((BudgieSessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_session_manager_LogoutReadyData, _ready_data);
}

static void
budgie_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Logout") == 0) {
		_dbus_budgie_session_manager_Logout (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_session_manager_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_session_manager_dbus_interface_info), &_budgie_session_manager_dbus_interface_vtable, data, _budgie_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_power_strip_get_instance_private (BudgiePowerStrip* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePowerStrip_private_offset);
}

static void
budgie_power_strip_setup_dbus_data_free (gpointer _data)
{
	BudgiePowerStripSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgiePowerStripSetupDbusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_power_strip_setup_dbus (BudgiePowerStrip* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BudgiePowerStripSetupDbusData* _data_;
	BudgiePowerStrip* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgiePowerStripSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_power_strip_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_power_strip_setup_dbus_co (_data_);
}

static void
budgie_power_strip_setup_dbus_finish (BudgiePowerStrip* self,
                                      GAsyncResult* _res_)
{
	BudgiePowerStripSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
budgie_power_strip_setup_dbus_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	BudgiePowerStripSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_power_strip_setup_dbus_co (_data_);
}

static gboolean
budgie_power_strip_setup_dbus_co (BudgiePowerStripSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (BUDGIE_TYPE_SCREEN_SAVER_PROXY, 0, NULL, budgie_power_strip_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.ScreenSaver", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/ScreenSaver", "g-interface-name", "org.gnome.ScreenSaver", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (BudgieScreenSaver*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (BudgieScreenSaver*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->saver);
		_data_->self->priv->saver = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("powerstrip.vala:34: Unable to contact login manager: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 2;
		g_async_initable_new_async (BUDGIE_TYPE_SESSION_MANAGER_PROXY, 0, NULL, budgie_power_strip_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = (BudgieSessionManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = (BudgieSessionManager*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_object_unref0 (_data_->self->priv->session);
		_data_->self->priv->session = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->power_btn;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp8_, FALSE);
		_data_->_tmp9_ = _data_->_vala1_e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("powerstrip.vala:41: Unable to contact GNOME Session: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BudgiePowerStrip* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->raven);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda33_ (Block6Data* _data6_)
{
	BudgiePowerStrip* self;
	self = _data6_->self;
	budgie_raven_set_expanded (_data6_->raven, FALSE);
	g_signal_emit_by_name (_data6_->raven, "request-settings-ui");
}

static void
___lambda33__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda33_ (self);
}

static void
__lambda34_ (Block6Data* _data6_)
{
	BudgiePowerStrip* self;
	self = _data6_->self;
	budgie_raven_set_expanded (_data6_->raven, FALSE);
	budgie_power_strip_lock_screen (self);
}

static void
___lambda34__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda34_ (self);
}

static void
__lambda36_ (BudgiePowerStrip* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		BudgieSessionManager* _tmp0_;
		_tmp0_ = self->priv->session;
		budgie_session_manager_Logout_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_message ("powerstrip.vala:89: Error invoking end session dialog: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda36__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda36_ ((BudgiePowerStrip*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda35_ (Block6Data* _data6_)
{
	BudgiePowerStrip* self;
	BudgieSessionManager* _tmp0_;
	BudgieSessionManager* _tmp1_;
	self = _data6_->self;
	budgie_raven_set_expanded (_data6_->raven, FALSE);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->session;
	budgie_session_manager_Logout (_tmp1_, (guint) 0, ___lambda36__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda35__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda35_ (self);
}

static void
__lambda37_ (BudgiePowerStrip* self,
             GObject* obj,
             GAsyncResult* res)
{
	BudgieScreenSaver* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->saver;
	if (_tmp0_ != NULL) {
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		_tmp1_ = self->priv->lock_btn;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, FALSE);
		_tmp2_ = self->priv->lock_btn;
		gtk_widget_show_all ((GtkWidget*) _tmp2_);
	}
}

static void
___lambda37__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda37_ ((BudgiePowerStrip*) self, source_object, res);
	g_object_unref (self);
}

BudgiePowerStrip*
budgie_power_strip_construct (GType object_type,
                              BudgieRaven* raven)
{
	BudgiePowerStrip * self = NULL;
	Block6Data* _data6_;
	BudgieRaven* _tmp0_;
	GtkBox* bottom = NULL;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkButton* btn = NULL;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (raven);
	_g_object_unref0 (_data6_->raven);
	_data6_->raven = _tmp0_;
	self = (BudgiePowerStrip*) g_object_new (object_type, NULL);
	_data6_->self = g_object_ref (self);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 20);
	g_object_ref_sink (_tmp1_);
	bottom = _tmp1_;
	gtk_widget_set_margin_top ((GtkWidget*) self, 10);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "raven-header");
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, "powerstrip");
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp4_, "bottom");
	gtk_widget_set_halign ((GtkWidget*) bottom, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) bottom, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) bottom, 5);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) bottom);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp5_, "primary-control");
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("preferences-system-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp6_);
	btn = _tmp6_;
	_tmp7_ = btn;
	g_signal_connect_data (_tmp7_, "clicked", (GCallback) ___lambda33__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp8_ = btn;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = btn;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, "flat");
	_tmp11_ = btn;
	gtk_box_pack_start (bottom, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = (GtkButton*) gtk_button_new_from_icon_name ("system-lock-screen-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (btn);
	btn = _tmp12_;
	_tmp13_ = btn;
	g_signal_connect_data (_tmp13_, "clicked", (GCallback) ___lambda34__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp14_ = btn;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->lock_btn);
	self->priv->lock_btn = _tmp15_;
	_tmp16_ = btn;
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	_tmp17_ = btn;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "flat");
	_tmp19_ = btn;
	gtk_box_pack_start (bottom, (GtkWidget*) _tmp19_, FALSE, FALSE, (guint) 0);
	_tmp20_ = (GtkButton*) gtk_button_new_from_icon_name ("system-log-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (btn);
	btn = _tmp20_;
	_tmp21_ = btn;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->power_btn);
	self->priv->power_btn = _tmp22_;
	_tmp23_ = btn;
	g_signal_connect_data (_tmp23_, "clicked", (GCallback) ___lambda35__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp24_ = btn;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
	_tmp25_ = btn;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "flat");
	_tmp27_ = btn;
	gtk_box_pack_start (bottom, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
	_tmp28_ = self->priv->lock_btn;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp28_, TRUE);
	_tmp29_ = self->priv->lock_btn;
	gtk_widget_hide ((GtkWidget*) _tmp29_);
	budgie_power_strip_setup_dbus (self, ___lambda37__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (btn);
	_g_object_unref0 (bottom);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

BudgiePowerStrip*
budgie_power_strip_new (BudgieRaven* raven)
{
	return budgie_power_strip_construct (BUDGIE_TYPE_POWER_STRIP, raven);
}

static void
budgie_power_strip_lock_screen (BudgiePowerStrip* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieScreenSaver* _tmp0_;
		_tmp0_ = self->priv->saver;
		budgie_screen_saver_lock (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("powerstrip.vala:111: Cannot lock screen: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_power_strip_class_init (BudgiePowerStripClass * klass,
                               gpointer klass_data)
{
	budgie_power_strip_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgiePowerStrip_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_power_strip_finalize;
}

static void
budgie_power_strip_instance_init (BudgiePowerStrip * self,
                                  gpointer klass)
{
	self->priv = budgie_power_strip_get_instance_private (self);
	self->priv->saver = NULL;
	self->priv->session = NULL;
	self->priv->lock_btn = NULL;
	self->priv->power_btn = NULL;
}

static void
budgie_power_strip_finalize (GObject * obj)
{
	BudgiePowerStrip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_POWER_STRIP, BudgiePowerStrip);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->lock_btn);
	_g_object_unref0 (self->priv->power_btn);
	G_OBJECT_CLASS (budgie_power_strip_parent_class)->finalize (obj);
}

static GType
budgie_power_strip_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePowerStripClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_power_strip_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePowerStrip), 0, (GInstanceInitFunc) budgie_power_strip_instance_init, NULL };
	GType budgie_power_strip_type_id;
	budgie_power_strip_type_id = g_type_register_static (gtk_event_box_get_type (), "BudgiePowerStrip", &g_define_type_info, 0);
	BudgiePowerStrip_private_offset = g_type_add_instance_private (budgie_power_strip_type_id, sizeof (BudgiePowerStripPrivate));
	return budgie_power_strip_type_id;
}

GType
budgie_power_strip_get_type (void)
{
	static volatile gsize budgie_power_strip_type_id__once = 0;
	if (g_once_init_enter (&budgie_power_strip_type_id__once)) {
		GType budgie_power_strip_type_id;
		budgie_power_strip_type_id = budgie_power_strip_get_type_once ();
		g_once_init_leave (&budgie_power_strip_type_id__once, budgie_power_strip_type_id);
	}
	return budgie_power_strip_type_id__once;
}

