/* KeyboardManager.c generated by valac 0.56.2, the Vala compiler
 * generated from KeyboardManager.vala, do not modify */

/**/
/*  Copyright (C) 2016 Santiago León*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <meta/display.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-backend.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER (greeter_compositor_keyboard_manager_get_type ())
#define GREETER_COMPOSITOR_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager))
#define GREETER_COMPOSITOR_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManagerClass))
#define GREETER_COMPOSITOR_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER))
#define GREETER_COMPOSITOR_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER))
#define GREETER_COMPOSITOR_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManagerClass))

typedef struct _GreeterCompositorKeyboardManager GreeterCompositorKeyboardManager;
typedef struct _GreeterCompositorKeyboardManagerClass GreeterCompositorKeyboardManagerClass;
typedef struct _GreeterCompositorKeyboardManagerPrivate GreeterCompositorKeyboardManagerPrivate;
enum  {
	GREETER_COMPOSITOR_KEYBOARD_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_KEYBOARD_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_keyboard_manager_properties[GREETER_COMPOSITOR_KEYBOARD_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _GreeterCompositorKeyboardManager {
	GObject parent_instance;
	GreeterCompositorKeyboardManagerPrivate * priv;
};

struct _GreeterCompositorKeyboardManagerClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorKeyboardManagerPrivate {
	GSettings* settings;
};

static gint GreeterCompositorKeyboardManager_private_offset;
static gpointer greeter_compositor_keyboard_manager_parent_class = NULL;
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_instance;
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_instance = NULL;
static GVariantType* greeter_compositor_keyboard_manager_sources_variant_type;
static GVariantType* greeter_compositor_keyboard_manager_sources_variant_type = NULL;

VALA_EXTERN GType greeter_compositor_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorKeyboardManager, g_object_unref)
VALA_EXTERN void greeter_compositor_keyboard_manager_init (MetaDisplay* display);
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_new (void);
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_construct (GType object_type);
static gboolean greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated (MetaDisplay* display,
                                                                                     GreeterCompositorKeyboardManager* self);
static gboolean _greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated_meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                                                                                   gpointer self);
static void greeter_compositor_keyboard_manager_set_keyboard_layout (GSettings* settings,
                                                              const gchar* key,
                                                              GreeterCompositorKeyboardManager* self);
static GObject * greeter_compositor_keyboard_manager_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void greeter_compositor_keyboard_manager_finalize (GObject * obj);
static GType greeter_compositor_keyboard_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
greeter_compositor_keyboard_manager_get_instance_private (GreeterCompositorKeyboardManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorKeyboardManager_private_offset);
}

static gboolean
_greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated_meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                                                                          gpointer self)
{
	gboolean result;
	result = greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated (_sender, (GreeterCompositorKeyboardManager*) self);
	return result;
}

void
greeter_compositor_keyboard_manager_init (MetaDisplay* display)
{
	GreeterCompositorKeyboardManager* _tmp0_;
	GreeterCompositorKeyboardManager* _tmp1_;
	GreeterCompositorKeyboardManager* _tmp2_;
	g_return_if_fail (display != NULL);
	_tmp0_ = greeter_compositor_keyboard_manager_instance;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = greeter_compositor_keyboard_manager_new ();
	_g_object_unref0 (greeter_compositor_keyboard_manager_instance);
	greeter_compositor_keyboard_manager_instance = _tmp1_;
	_tmp2_ = greeter_compositor_keyboard_manager_instance;
	g_signal_connect_object (display, "modifiers-accelerator-activated", (GCallback) _greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated_meta_display_modifiers_accelerator_activated, _tmp2_, 0);
}

static GreeterCompositorKeyboardManager*
greeter_compositor_keyboard_manager_construct (GType object_type)
{
	GreeterCompositorKeyboardManager * self = NULL;
	self = (GreeterCompositorKeyboardManager*) g_object_new (object_type, NULL);
	return self;
}

static GreeterCompositorKeyboardManager*
greeter_compositor_keyboard_manager_new (void)
{
	return greeter_compositor_keyboard_manager_construct (GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER);
}

static gboolean
greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated (MetaDisplay* display,
                                                                            GreeterCompositorKeyboardManager* self)
{
	GVariant* sources = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	const GVariantType* _tmp3_;
	guint n_sources = 0U;
	GVariant* _tmp4_;
	guint current = 0U;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	meta_display_ungrab_keyboard (display, meta_display_get_current_time (display));
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "sources");
	sources = _tmp1_;
	_tmp2_ = sources;
	_tmp3_ = greeter_compositor_keyboard_manager_sources_variant_type;
	if (!g_variant_is_of_type (_tmp2_, _tmp3_)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp4_ = sources;
	n_sources = (guint) g_variant_n_children (_tmp4_);
	if (n_sources < ((guint) 2)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp5_ = self->priv->settings;
	current = g_settings_get_uint (_tmp5_, "current");
	_tmp6_ = self->priv->settings;
	g_settings_set_uint (_tmp6_, "current", (current + 1) % n_sources);
	result = TRUE;
	_g_variant_unref0 (sources);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
greeter_compositor_keyboard_manager_set_keyboard_layout (GSettings* settings,
                                                         const gchar* key,
                                                         GreeterCompositorKeyboardManager* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* layout = NULL;
	gchar* _tmp2_;
	gchar* variant = NULL;
	gchar* _tmp3_;
	gchar* options = NULL;
	gchar* _tmp4_;
	GVariant* sources = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const GVariantType* _tmp7_;
	GVariant* _tmp8_;
	guint current = 0U;
	const gchar* type = NULL;
	const gchar* name = NULL;
	GVariant* _tmp9_;
	const gchar* _tmp13_;
	gchar** xkb_options = NULL;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint xkb_options_length1;
	gint _xkb_options_size_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	MetaBackend* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "current") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, "sources") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, "xkb-options") == 0;
	}
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = g_strdup ("us");
	layout = _tmp2_;
	_tmp3_ = g_strdup ("");
	variant = _tmp3_;
	_tmp4_ = g_strdup ("");
	options = _tmp4_;
	_tmp5_ = g_settings_get_value (settings, "sources");
	sources = _tmp5_;
	_tmp6_ = sources;
	_tmp7_ = greeter_compositor_keyboard_manager_sources_variant_type;
	if (!g_variant_is_of_type (_tmp6_, _tmp7_)) {
		_g_variant_unref0 (sources);
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	_tmp8_ = sources;
	if (g_variant_n_children (_tmp8_) == ((gsize) 0)) {
		_g_variant_unref0 (sources);
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	current = g_settings_get_uint (settings, "current");
	type = NULL;
	name = NULL;
	_tmp9_ = sources;
	if (g_variant_n_children (_tmp9_) > ((gsize) current)) {
		GVariant* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp10_ = sources;
		g_variant_get_child (_tmp10_, (gsize) current, "(&s&s)", &_tmp11_, &_tmp12_, NULL);
		type = _tmp11_;
		name = _tmp12_;
	}
	_tmp13_ = type;
	if (g_strcmp0 (_tmp13_, "xkb") == 0) {
		gchar** arr = NULL;
		const gchar* _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint arr_length1;
		gint _arr_size_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp14_ = name;
		_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "+", 2);
		arr = _tmp16_;
		arr_length1 = _vala_array_length (_tmp15_);
		_arr_size_ = arr_length1;
		_tmp17_ = arr;
		_tmp17__length1 = arr_length1;
		_tmp18_ = _tmp17_[0];
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (layout);
		layout = _tmp19_;
		_tmp21_ = arr;
		_tmp21__length1 = arr_length1;
		_tmp22_ = _tmp21_[1];
		_tmp20_ = _tmp22_;
		if (_tmp20_ == NULL) {
			_tmp20_ = "";
		}
		_tmp23_ = g_strdup (_tmp20_);
		_g_free0 (variant);
		variant = _tmp23_;
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	} else {
		_g_variant_unref0 (sources);
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	_tmp25_ = _tmp24_ = g_settings_get_strv (settings, "xkb-options");
	xkb_options = _tmp25_;
	xkb_options_length1 = _vala_array_length (_tmp24_);
	_xkb_options_size_ = xkb_options_length1;
	_tmp26_ = xkb_options;
	_tmp26__length1 = xkb_options_length1;
	if (_tmp26__length1 > 0) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		_tmp27_ = xkb_options;
		_tmp27__length1 = xkb_options_length1;
		_tmp28_ = _vala_g_strjoinv (",", _tmp27_, (gint) _tmp27__length1);
		_g_free0 (options);
		options = _tmp28_;
	}
	_tmp30_ = layout;
	if (g_strcmp0 (_tmp30_, "us") != 0) {
		_tmp29_ = TRUE;
	} else {
		const gchar* _tmp31_;
		_tmp31_ = variant;
		_tmp29_ = g_strcmp0 (_tmp31_, "") != 0;
	}
	if (_tmp29_) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp32_ = layout;
		_tmp33_ = g_strconcat (_tmp32_, ",us", NULL);
		_g_free0 (layout);
		layout = _tmp33_;
		_tmp34_ = variant;
		_tmp35_ = g_strconcat (_tmp34_, ",", NULL);
		_g_free0 (variant);
		variant = _tmp35_;
	}
	_tmp36_ = meta_get_backend ();
	_tmp37_ = layout;
	_tmp38_ = variant;
	_tmp39_ = options;
	meta_backend_set_keymap (_tmp36_, _tmp37_, _tmp38_, _tmp39_);
	xkb_options = (_vala_array_free (xkb_options, xkb_options_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (sources);
	_g_free0 (options);
	_g_free0 (variant);
	_g_free0 (layout);
}

static GObject *
greeter_compositor_keyboard_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorKeyboardManager * self;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_keyboard_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "org.gnome.desktop.input-sources", TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		_g_settings_schema_unref0 (schema);
		return obj;
	}
	_tmp3_ = schema;
	_tmp4_ = g_settings_new_full (_tmp3_, NULL, NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = self->priv->settings;
	g_signal_connect (_tmp5_, "changed", (GCallback) greeter_compositor_keyboard_manager_set_keyboard_layout, self);
	_tmp6_ = self->priv->settings;
	greeter_compositor_keyboard_manager_set_keyboard_layout (_tmp6_, "current", self);
	_g_settings_schema_unref0 (schema);
	return obj;
}

static void
greeter_compositor_keyboard_manager_class_init (GreeterCompositorKeyboardManagerClass * klass,
                                                gpointer klass_data)
{
	GVariantType* _tmp0_;
	greeter_compositor_keyboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorKeyboardManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_keyboard_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_keyboard_manager_finalize;
	_tmp0_ = g_variant_type_new ("a(ss)");
	_g_variant_type_free0 (greeter_compositor_keyboard_manager_sources_variant_type);
	greeter_compositor_keyboard_manager_sources_variant_type = _tmp0_;
}

static void
greeter_compositor_keyboard_manager_instance_init (GreeterCompositorKeyboardManager * self,
                                                   gpointer klass)
{
	self->priv = greeter_compositor_keyboard_manager_get_instance_private (self);
}

static void
greeter_compositor_keyboard_manager_finalize (GObject * obj)
{
	GreeterCompositorKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (greeter_compositor_keyboard_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_keyboard_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorKeyboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_keyboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorKeyboardManager), 0, (GInstanceInitFunc) greeter_compositor_keyboard_manager_instance_init, NULL };
	GType greeter_compositor_keyboard_manager_type_id;
	greeter_compositor_keyboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorKeyboardManager", &g_define_type_info, 0);
	GreeterCompositorKeyboardManager_private_offset = g_type_add_instance_private (greeter_compositor_keyboard_manager_type_id, sizeof (GreeterCompositorKeyboardManagerPrivate));
	return greeter_compositor_keyboard_manager_type_id;
}

GType
greeter_compositor_keyboard_manager_get_type (void)
{
	static volatile gsize greeter_compositor_keyboard_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_keyboard_manager_type_id__once)) {
		GType greeter_compositor_keyboard_manager_type_id;
		greeter_compositor_keyboard_manager_type_id = greeter_compositor_keyboard_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_keyboard_manager_type_id__once, greeter_compositor_keyboard_manager_type_id);
	}
	return greeter_compositor_keyboard_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

