/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;

public class SFile
implements Comparable<SFile> {
    public static String separator = File.separator;
    public static String pathSeparator = File.pathSeparator;
    public static char separatorChar = File.separatorChar;
    private final File internal;

    public String toString() {
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            try {
                return this.internal.getCanonicalPath();
            }
            catch (IOException e) {
                return this.internal.getAbsolutePath();
            }
        }
        return super.toString();
    }

    public SFile(String nameOrPath) {
        this(new File(nameOrPath));
    }

    public SFile(String dirname, String name) {
        this(new File(dirname, name));
    }

    public SFile(SFile basedir, String name) {
        this(new File(basedir.internal, name));
    }

    public SFile(URI uri) {
        this(new File(uri));
    }

    private SFile(File internal) {
        this.internal = internal;
    }

    public static SFile fromFile(File internal) {
        if (internal == null) {
            return null;
        }
        return new SFile(internal);
    }

    public SFile file(String name) {
        return new SFile(this, name);
    }

    public boolean exists() {
        if (this.internal != null && this.isFileOk()) {
            return this.internal.exists();
        }
        return false;
    }

    public SFile getCanonicalFile() throws IOException {
        return new SFile(this.internal.getCanonicalFile());
    }

    public boolean isAbsolute() {
        return this.internal != null && this.internal.isAbsolute();
    }

    public boolean isDirectory() {
        return this.internal != null && this.internal.exists() && this.internal.isDirectory();
    }

    public String getName() {
        return this.internal.getName();
    }

    public boolean isFile() {
        return this.internal != null && this.internal.isFile();
    }

    public long lastModified() {
        return this.internal.lastModified();
    }

    @Override
    public int compareTo(SFile other) {
        return this.internal.compareTo(other.internal);
    }

    public String getPath() {
        return this.internal.getPath();
    }

    public long length() {
        return this.internal.length();
    }

    public boolean canWrite() {
        return this.internal.canWrite();
    }

    public void setWritable(boolean b) {
        this.internal.setWritable(b);
    }

    public void delete() {
        this.internal.delete();
    }

    public Collection<SFile> listFiles() {
        File[] tmp = this.internal.listFiles();
        if (tmp == null) {
            return Collections.emptyList();
        }
        ArrayList<SFile> result = new ArrayList<SFile>(tmp.length);
        for (File f : tmp) {
            result.add(new SFile(f));
        }
        return Collections.unmodifiableCollection(result);
    }

    public String[] list() {
        return this.internal.list();
    }

    public SFile getAbsoluteFile() {
        return new SFile(this.internal.getAbsoluteFile());
    }

    public SFile getParentFile() {
        return new SFile(this.internal.getParentFile());
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public boolean equals(Object obj) {
        return this.internal.equals(((SFile)obj).internal);
    }

    public String getAbsolutePath() {
        return this.internal.getAbsolutePath();
    }

    public String getPrintablePath() {
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            try {
                return this.internal.getCanonicalPath();
            }
            catch (IOException e) {
                Logme.error(e);
            }
        }
        return "";
    }

    public boolean canRead() {
        return this.internal.canRead();
    }

    public void deleteOnExit() {
        this.internal.deleteOnExit();
    }

    public void mkdirs() {
        this.internal.mkdirs();
    }

    public static SFile createTempFile(String prefix, String suffix) throws IOException {
        return new SFile(File.createTempFile(prefix, suffix));
    }

    public URI toURI() {
        return this.internal.toURI();
    }

    public boolean renameTo(SFile dest) {
        return this.internal.renameTo(dest.internal);
    }

    private boolean isFileOk() {
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.SANDBOX) {
            return false;
        }
        try {
            if (this.isDenied()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (this.isInAllowList(SecurityUtils.getPath("plantuml.include.path"))) {
            return true;
        }
        if (this.isInAllowList(SecurityUtils.getPath("plantuml.allowlist.path"))) {
            return true;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.INTERNET) {
            return false;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.ALLOWLIST) {
            return false;
        }
        if (SecurityUtils.getSecurityProfile() != SecurityProfile.UNSECURE) {
            String path = this.getCleanPathSecure();
            if (path.startsWith("/etc/") || path.startsWith("/dev/") || path.startsWith("/boot/") || path.startsWith("/proc/") || path.startsWith("/sys/")) {
                return false;
            }
            if (path.startsWith("//")) {
                return false;
            }
        }
        return true;
    }

    private boolean isInAllowList(List<SFile> allowlist) {
        String path = this.getCleanPathSecure();
        for (SFile allow : allowlist) {
            if (!path.startsWith(allow.getCleanPathSecure())) continue;
            return true;
        }
        return false;
    }

    private boolean isDenied() throws IOException {
        SFile securityPath = SecurityUtils.getSecurityPath();
        if (securityPath == null) {
            return false;
        }
        return this.getSanitizedPath().startsWith(securityPath.getSanitizedPath());
    }

    private Path getSanitizedPath() throws IOException {
        return Paths.get(new File(this.getCleanPathSecure()).getCanonicalPath(), new String[0]).normalize();
    }

    private String getCleanPathSecure() {
        String result = this.internal.getAbsolutePath();
        result = result.replace("\u0000", "");
        result = result.replace("\\\\", "/");
        return result;
    }

    public BufferedImage readRasterImageFromFile() {
        if (this.isFileOk()) {
            try {
                return SecurityUtils.readRasterImage(new ImageIcon(this.getAbsolutePath()));
            }
            catch (Exception e) {
                Logme.error(e);
            }
        }
        return null;
    }

    public BufferedReader openBufferedReader() {
        if (this.isFileOk()) {
            try {
                return new BufferedReader(new FileReader(this.internal));
            }
            catch (FileNotFoundException e) {
                Logme.error(e);
            }
        }
        return null;
    }

    public File conv() {
        return this.internal;
    }

    public InputStream openFile() {
        if (this.isFileOk()) {
            try {
                return new BufferedInputStream(new FileInputStream(this.internal));
            }
            catch (FileNotFoundException e) {
                Logme.error(e);
            }
        }
        return null;
    }

    public BufferedOutputStream createBufferedOutputStream() throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(this.internal));
    }

    public PrintWriter createPrintWriter() throws FileNotFoundException {
        return new PrintWriter(this.internal);
    }

    public PrintWriter createPrintWriter(String charset) throws FileNotFoundException, UnsupportedEncodingException {
        return new PrintWriter(this.internal, charset);
    }

    public FileOutputStream createFileOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.internal);
    }

    public FileOutputStream createFileOutputStream(boolean append) throws FileNotFoundException {
        return new FileOutputStream(this.internal, append);
    }

    public PrintStream createPrintStream() throws FileNotFoundException {
        return new PrintStream(this.internal);
    }

    public PrintStream createPrintStream(String charset) throws FileNotFoundException, UnsupportedEncodingException {
        return new PrintStream(this.internal, charset);
    }

    public PrintStream createPrintStream(Charset charset) throws FileNotFoundException, UnsupportedEncodingException {
        return new PrintStream(this.internal, charset.name());
    }
}

